/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools.sm4fpe;

import com.palacesun.masking.tools.sm4fpe.SM4FPEBase;
import com.palacesun.masking.tools.sm4fpe.SM4FPEEntity;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.regex.Pattern;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4FPEName
extends SM4FPEBase {
    static ArrayList<SM4FPEEntity> nameEntities;
    static ArrayList firstnameChars;
    static char[] lastnameChars;
    static String[] lastnameDuplicateStr;
    static ArrayList otherChinese;
    static HashMap firstnameCharsMap;
    static HashMap lastnameCharsMap;
    static HashMap lastnameDuplicateStrMap;
    static HashMap otherChineseMap;
    private static Pattern allChinesePattern;

    @Override
    public String encryptEcb(String hexKey, String a) throws Exception {
        String out = this.encrypt(hexKey, a, nameEntities);
        return out;
    }

    @Override
    public String decryptEcb(String hexKey, String input) throws Exception {
        String out = this.decrypt(hexKey, input, nameEntities);
        return out;
    }

    public static boolean isPersonName(String name) {
        boolean result = false;
        int length = name.length();
        if (length >= 2 && length <= 50) {
            if (null == allChinesePattern) {
                allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
            }
            if (allChinesePattern.matcher(name).matches()) {
                char[] tmp = name.toCharArray();
                int i = 1;
                if (nameEntities.get(0).getCharsMap().get(name.substring(0, 2)) == null) {
                    if (nameEntities.get(1).getCharsMap().get(Character.valueOf(tmp[0])) == null) {
                        return result;
                    }
                    i = 1;
                } else {
                    i = 2;
                }
                while (i < tmp.length) {
                    if (nameEntities.get(1).getCharsMap().get(Character.valueOf(tmp[i])) == null && nameEntities.get(2).getCharsMap().get(Character.valueOf(tmp[i])) == null && nameEntities.get(3).getCharsMap().get(Character.valueOf(tmp[i])) == null) {
                        return result;
                    }
                    ++i;
                }
                result = true;
            }
        }
        return result;
    }

    @Override
    String generateInputRandom(String input) {
        Random random = new Random();
        input = input + nameEntities.get(1).getList().get(random.nextInt(nameEntities.get(1).getList().size()));
        input = input + nameEntities.get(2).getList().get(random.nextInt(nameEntities.get(2).getList().size()));
        input = input + nameEntities.get(2).getList().get(random.nextInt(nameEntities.get(2).getList().size()));
        return input;
    }

    public static boolean check(String input) {
        return SM4FPEName.isPersonName(input);
    }

    public static ArrayList<SM4FPEEntity> getSm4FPEEntities() {
        return nameEntities;
    }

    static {
        int i;
        nameEntities = new ArrayList();
        Security.addProvider((Provider)new BouncyCastleProvider());
        lastnameDuplicateStr = new String[0];
        lastnameChars = SM4FPEName.readCharFile("lastname_usual.txt", "UTF-8");
        firstnameChars = SM4FPEName.excludeChars(SM4FPEName.toArrayList(chineseChars), lastnameChars);
        otherChinese = SM4FPEName.excludeChars(otherChineseChars, lastnameChars);
        firstnameCharsMap = new HashMap();
        for (i = 0; i < firstnameChars.size(); ++i) {
            firstnameCharsMap.put(firstnameChars.get(i), i);
        }
        lastnameCharsMap = new HashMap();
        for (i = 0; i < lastnameChars.length; ++i) {
            lastnameCharsMap.put(Character.valueOf(lastnameChars[i]), i);
        }
        lastnameDuplicateStrMap = new HashMap();
        for (i = 0; i < lastnameDuplicateStr.length; ++i) {
            lastnameDuplicateStrMap.put(lastnameDuplicateStr[i], i);
        }
        otherChineseMap = new HashMap();
        for (i = 0; i < otherChinese.size(); ++i) {
            otherChineseMap.put(otherChinese.get(i), i);
        }
        nameEntities.add(new SM4FPEEntity(0, SM4FPEName.toArrayList(lastnameDuplicateStr), lastnameDuplicateStrMap, SM4FPEBase.MatchType.ONCE));
        nameEntities.add(new SM4FPEEntity(1, SM4FPEName.toArrayList(lastnameChars), lastnameCharsMap));
        nameEntities.add(new SM4FPEEntity(2, firstnameChars, firstnameCharsMap));
        nameEntities.add(new SM4FPEEntity(3, otherChinese, otherChineseMap));
        SM4FPEName.checkDuplicate(nameEntities);
    }
}

