/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAddCookies
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        RouteInfo route;
        HttpHost targetHost;
        Lookup<CookieSpecProvider> registry;
        HttpClientContext clientContext;
        CookieStore cookieStore;
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        String method = request.getRequestLine().getMethod();
        if (!method.equalsIgnoreCase("CONNECT") && (cookieStore = (clientContext = HttpClientContext.adapt(context)).getCookieStore()) != null && (registry = clientContext.getCookieSpecRegistry()) != null && (targetHost = clientContext.getTargetHost()) != null && (route = clientContext.getHttpRoute()) != null) {
            RequestConfig config = clientContext.getRequestConfig();
            String policy = config.getCookieSpec();
            if (policy == null) {
                policy = "default";
            }
            URI requestURI = null;
            if (request instanceof HttpUriRequest) {
                requestURI = ((HttpUriRequest)request).getURI();
            } else {
                try {
                    requestURI = new URI(request.getRequestLine().getUri());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            String path = requestURI != null ? requestURI.getPath() : null;
            String hostName = targetHost.getHostName();
            int port = targetHost.getPort();
            if (port < 0) {
                port = route.getTargetHost().getPort();
            }
            CookieOrigin cookieOrigin = new CookieOrigin(hostName, port >= 0 ? port : 0, !TextUtils.isEmpty(path) ? path : "/", route.isSecure());
            CookieSpecProvider provider = registry.lookup(policy);
            if (provider != null) {
                int ver;
                Header header2;
                CookieSpec cookieSpec = provider.create(clientContext);
                List<Cookie> cookies = cookieStore.getCookies();
                ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
                Date now = new Date();
                boolean expired = false;
                for (Cookie cookie : cookies) {
                    if (!cookie.isExpired(now)) {
                        if (!cookieSpec.match(cookie, cookieOrigin)) continue;
                        matchedCookies.add(cookie);
                        continue;
                    }
                    expired = true;
                }
                if (expired) {
                    cookieStore.clearExpired(now);
                }
                if (!matchedCookies.isEmpty()) {
                    for (Header header2 : cookieSpec.formatCookies(matchedCookies)) {
                        request.addHeader(header2);
                    }
                }
                if ((ver = cookieSpec.getVersion()) > 0 && (header2 = cookieSpec.getVersionHeader()) != null) {
                    request.addHeader(header2);
                }
                context.setAttribute("http.cookie-spec", cookieSpec);
                context.setAttribute("http.cookie-origin", cookieOrigin);
            }
        }
    }
}

