/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;

public class GPTest {
    public static void main(String[] args) {
        GPTest.parseTestLty();
    }

    static void parseGrant() {
        GPTest.testGram("GRANT INSERT(c1,c2) ON mytable TO PUBLIC;");
        GPTest.testGram("GRANT ALL PRIVILEGES(c1,c2) ON topten TO sally;");
        GPTest.testGram("GRANT SELECT(c1,c2),insert(c1,c2)  on  mytable1 TO sally  with grant option;");
        GPTest.testGram("GRANT SELECT(c1,c2),insert(c1,c2)  on  mytable1 TO sally;");
        GPTest.testGram("GRANT SELECT(c1,c2),insert(c1,c2)  on  TB1,tb2 TO sally;");
        GPTest.testGram("GRANT SELECT(c1,c2),insert(c1,c2)  on  ALL TABLES IN SCHEMA myschema TO sally;");
    }

    static void parseDdl() {
        GPTest.testGram("alter schema myschema rename to myschema1");
        GPTest.testGram("alter schema myschema owner to myuser");
    }

    static void parseAlterTable() {
        GPTest.testGram("alter table if exists only mytable OWNER to root ");
        GPTest.testGram("alter table if exists only mytable set tablespace my_new_tablespace ");
        GPTest.testGram("alter table if exists only mytable OWNER to root ,set tablespace my_new_tablespace ");
    }

    static void parseCreateDatabase() {
        GPTest.testGram("create database mydb with owner=root template mytemp encoding=utf8 CONNECTION LIMIT =1");
    }

    static void parseCreateSchema() {
        GPTest.testGram("create schema IF NOT EXISTS my_schema_name");
        GPTest.testGram("create schema IF NOT EXISTS my_schema_name AUTHORIZATION  root");
        GPTest.testGram("CREATE SCHEMA IF NOT EXISTS AUTHORIZATION root");
    }

    static void parseSelect() {
        GPTest.testGram("SELECT varchar 'Hello World', '1' AS hello;");
        GPTest.testGram("SELECT CHARACTER 'Hello World', '1' AS hello;");
        GPTest.testGram("SELECT CHAR 'Hello World', '1' AS hello;");
        GPTest.testGram("SELECT text 'Hello World' hello;");
        GPTest.testGram("select integer '1' as hello;");
        GPTest.testGram("select SMALLINT '1' as hello;");
        GPTest.testGram("select BIGINT '1' as hello;");
        GPTest.testGram("select float '1' as hello;");
        GPTest.testGram("select DECIMAL '1' as hello;");
        GPTest.testGram("select NUMERIC '1' as hello;");
        GPTest.testGram("select NUMERIC(38,0) '1' as hello;");
        GPTest.testGram("select DOUBLE PRECISION '1' as hello;");
        GPTest.testGram("select int '1' as hello;");
        GPTest.testGram("select json '1' as hello;");
        GPTest.testGram("select  DATE '2023/4/26' as hello;");
        GPTest.testGram("select  TIME '14:05' as hello;");
        GPTest.testGram("select  TIMESTAMP '2023.4.26 14:05' as hello;");
        GPTest.testGram("select  INTERVAL '1 year' as hello;");
        GPTest.testGram("select  BOOLEAN 'true' as hello;");
        GPTest.testGram("select  POINT '(1,5)' as hello;");
        GPTest.testGram("select * into temporary person_temp  from public.person ");
        GPTest.testGram("select * into xxx from t1 as t(xx,n1,n2,n3)");
        GPTest.testGram("select * into temporary person_temp1  from public.person ;");
        GPTest.testGram("select * into temp person_temp2  from public.person ;");
        GPTest.testGram("select * into UNLOGGED person_temp3  from public.person ;");
        GPTest.testGram("select * into temporary table person_temp1  from public.person ;");
        GPTest.testGram("select * into temp table person_temp2  from public.person ;");
        GPTest.testGram("select * into UNLOGGED table person_temp3  from public.person ;");
        GPTest.testGram("select * into UNLOGGED table person_temp3  from public.person for update;");
    }

    static void parseCreateTable() {
        GPTest.testGram("CREATE TABLE baby.rank (id int, rank int, year smallint, \ngender char(1), count int ) DISTRIBUTED BY (rank, gender, \nyear);");
        GPTest.testGram("CREATE TABLE films (\ncode        char(5) CONSTRAINT firstkey PRIMARY KEY,\ntitle       varchar(40) NOT NULL,\ndid         integer NOT NULL,\ndate_prod   date,\nkind        varchar(10)\n);");
        GPTest.testGram("CREATE TABLE distributors (\ndid    integer PRIMARY KEY DEFAULT nextval('serial'),\nname   varchar(40) NOT NULL CHECK (name <> '')\n);");
        GPTest.testGram("CREATE TABLE sales (txn_id int, qty int, date date) \nWITH (appendoptimized=true, compresslevel=5) \nDISTRIBUTED BY (txn_id);");
        GPTest.testGram("");
        GPTest.testGram("");
        GPTest.testGram("");
        GPTest.testGram("");
        GPTest.testGram("");
        GPTest.testGram("");
        GPTest.testGram("");
        GPTest.testGram("");
        GPTest.testGram("");
    }

    static void testGram(String sql) {
        if (sql != null && sql.length() != 0) {
            for (SQLStatement statement : SQLUtils.parseStatements(sql, DbType.greenplum)) {
                System.out.println("-----------------------------------");
                String s = statement.toString();
                System.out.println(s);
            }
        }
    }

    static void parseTest() {
        GPTest.testGram("SELECT f.title, f.did, d.name, f.date_prod, f.kind FROM distributors d, films f WHERE f.did = d.did");
    }

    static void parseTestLty() {
        GPTest.testGram("ALTER INDEX distributors RENAME TO suppliers;");
        GPTest.testGram("ALTER INDEX distributors SET TABLESPACE fasttablespace;");
        GPTest.testGram("ALTER INDEX IF EXISTS distributors SET TABLESPACE fasttablespace;");
        GPTest.testGram("ALTER INDEX distributors SET (fillfactor = 75);");
        GPTest.testGram("ALTER INDEX distributors SET (fillfactor = 75, param1 =1, param2 =2);");
        GPTest.testGram("ALTER INDEX distributors RESET (fillfactor, param1, param2);");
        GPTest.testGram("ALTER INDEX ALL IN TABLESPACE distributors  OWNED BY own1,own2,own3 SET TABLESPACE space1 NOWAIT;");
        GPTest.testGram("ALTER INDEX ALL IN TABLESPACE distributors  SET TABLESPACE space1;");
        GPTest.testGram("ALTER SEQUENCE serial RESTART WITH 105 ;");
        GPTest.testGram("ALTER SEQUENCE serial RESTART WITH 105 OWNED BY NONE;");
        GPTest.testGram("ALTER SEQUENCE IF EXISTS serial INCREMENT BY 1 MINVALUE 1 MAXVALUE 10000 START WITH 1 RESTART WITH 105 CACHE 20 NO CYCLE OWNED BY table.column ;");
        GPTest.testGram("ALTER SEQUENCE IF EXISTS serial START WITH 1 RESTART WITH 105 CACHE 10 NO CYCLE OWNED BY table.column ;");
        GPTest.testGram("ALTER SEQUENCE IF EXISTS serial NO MINVALUE NO MAXVALUE START WITH 1 RESTART WITH 105 CACHE  20 CYCLE NONE;");
        GPTest.testGram("ALTER SEQUENCE serial OWNER TO new_owner;");
        GPTest.testGram("ALTER SEQUENCE IF EXISTS serial RENAME TO new_name;");
        GPTest.testGram("ALTER SEQUENCE IF EXISTS serial SET SCHEMA new_SCHEMA;");
        GPTest.testGram("ALTER SEQUENCE  serial INCREMENT BY 1  MAXVALUE 10000 START WITH 1 RESTART WITH 105 CACHE 20 NO CYCLE;");
        GPTest.testGram("ALTER SEQUENCE IF EXISTS serial INCREMENT BY 1  NO MINVALUE START WITH 1 RESTART WITH 105 CACHE 20 NO CYCLE;");
        GPTest.testGram("ALTER SEQUENCE IF EXISTS serial INCREMENT BY 1  NO MAXVALUE START WITH 1 RESTART WITH 105 CACHE 20 NO CYCLE;");
        GPTest.testGram("ALTER SEQUENCE IF EXISTS serial INCREMENT BY 1  NO MAXVALUE START WITH 1 RESTART  105 CACHE 20 NO CYCLE;");
        GPTest.testGram("ALTER VIEW myview RENAME TO newview;");
        GPTest.testGram("ALTER VIEW foo RENAME TO bar;");
        GPTest.testGram("ALTER VIEW IF EXISTS a_view ALTER COLUMN ts SET DEFAULT now(); ");
        GPTest.testGram("ALTER VIEW a_view ALTER COLUMN ts SET DEFAULT 1; ");
        GPTest.testGram("ALTER VIEW a_view ALTER COLUMN ts DROP DEFAULT; ");
        GPTest.testGram("ALTER VIEW a_view OWNER TO new_owner; ");
        GPTest.testGram("ALTER VIEW a_view SET SCHEMA  new_schema; ");
        GPTest.testGram("ALTER VIEW a_view SET(fillfactor = 75, param1 =1, param2 =2);");
        GPTest.testGram("ALTER VIEW a_view SET(fillfactor , param1 , param2);");
        GPTest.testGram("ALTER VIEW a_view RESET(fillfactor , param1 , param2);");
        GPTest.testGram("CREATE UNIQUE INDEX title_idx ON films (title int4_ops asc);");
        GPTest.testGram("CREATE INDEX gender_bmp_idx ON employee USING bitmap (gender);");
        GPTest.testGram("CREATE INDEX ON films ((lower(title)));");
        GPTest.testGram("CREATE INDEX title_idx_german ON films (title COLLATE \"de_DE\" int4_ops,kind asc);");
        GPTest.testGram("CREATE UNIQUE INDEX title_idx ON films (title) WITH (fillfactor = 70);");
        GPTest.testGram("CREATE INDEX gin_idx ON documents_table USING gin (locations) WITH (fastupdate = off);");
        GPTest.testGram("CREATE INDEX code_idx ON films(code) TABLESPACE indexspace;");
        GPTest.testGram("CREATE INDEX pointloc ON points USING gist (box(location,location)); ");
        GPTest.testGram("CREATE UNIQUE INDEX title_idx ON films (title COLLATE \"de_DE\" asc NULLS FIRST) WITH (fillfactor = 70,param2=80) where comune1=1;");
        GPTest.testGram("CREATE UNIQUE INDEX title_idx ON films (title int4_ops asc,kind desc nulls last);");
        GPTest.testGram("CREATE SEQUENCE myseq INCREMENT 1;");
        GPTest.testGram("CREATE SEQUENCE myseq START 101;");
        GPTest.testGram("CREATE TEMPORARY SEQUENCE myseq INCREMENT BY 1 ;");
        GPTest.testGram("CREATE TEMP SEQUENCE myseq MINVALUE 1 NO MAXVALUE START WITH 1;");
        GPTest.testGram("CREATE TEMP SEQUENCE myseq  NO MAXVALUE START WITH 1;");
        GPTest.testGram("CREATE TEMP SEQUENCE myseq  NO MINVALUE START WITH 1;");
        GPTest.testGram("CREATE TEMP SEQUENCE myseq  MINVALUE 1 NO MAXVALUE START WITH 1;");
        GPTest.testGram("CREATE TEMP SEQUENCE myseq  MINVALUE 1  MAXVALUE 10000 START WITH 1;");
        GPTest.testGram("CREATE TEMP SEQUENCE myseq  MINVALUE 1  START WITH 1;");
        GPTest.testGram("CREATE TEMP SEQUENCE myseq START 1 CACHE 5 NO CYCLE;");
        GPTest.testGram("CREATE TEMP SEQUENCE myseq START 1 CACHE 5 CYCLE;");
        GPTest.testGram("CREATE SEQUENCE myseq START WITH 1 OWNED BY userinfo.id;");
        GPTest.testGram("CREATE SEQUENCE myseq START 1 OWNED BY NONE;");
        GPTest.testGram("CREATE TABLESPACE mytblspace LOCATION '/gpdbtspc/mytestspace';");
        GPTest.testGram("CREATE TABLESPACE mytblspace LOCATION '/gpdbtspc/mytestspace' WITH (content0='/temp/mytest',seq_page_cost=2,random_page_cost=200);");
        GPTest.testGram("CREATE TABLESPACE mytblspace OWNER OWNER1 LOCATION '/gpdbtspc/mytestspace' WITH (content0='/temp/mytest', content1='/temp/mytest')");
        GPTest.testGram("CREATE VIEW vista AS SELECT 'Hello World';");
        GPTest.testGram("CREATE OR REPLACE VIEW vista AS SELECT 'Hello World';");
        GPTest.testGram("CREATE OR REPLACE TEMP VIEW vista with (check_option=CASCADED) AS SELECT 'Hello World';");
        GPTest.testGram("CREATE TEMP VIEW vista AS SELECT 'Hello World';");
        GPTest.testGram("CREATE TEMPORARY VIEW vista with (security_barrier=true) AS SELECT 'Hello World';");
        GPTest.testGram("CREATE TEMP VIEW vista AS SELECT 'Hello World' WITH CASCADED CHECK OPTION;");
        GPTest.testGram("CREATE VIEW vista AS SELECT text 'Hello World' AS hello;");
        GPTest.testGram("CREATE VIEW comedies AS SELECT * FROM films WHERE kind = 'comedy';");
        GPTest.testGram("CREATE VIEW comedies AS SELECT * FROM films WHERE kind = 'comedy' WITH LOCAL CHECK OPTION;");
        GPTest.testGram("CREATE VIEW topten AS SELECT name, rank, gender, year FROM names, rank WHERE rank < '11' AND names.id=rank.id;");
        GPTest.testGram("CREATE RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
        GPTest.testGram("CREATE VIEW public.foo AS WITH RECURSIVE foo(i) AS (SELECT 1 UNION ALL SELECT i+1 from (SELECT * FROM foo UNION SELECT 0) bar ) SELECT * FROM foo LIMIT 5;");
        GPTest.testGram("WITH RECURSIVE foo(i) AS (SELECT 1 UNION ALL SELECT i+1 from (SELECT * FROM foo UNION SELECT 0) bar ) SELECT * FROM foo LIMIT 5;");
        GPTest.testGram("CREATE OR REPLACE RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
        GPTest.testGram("CREATE OR REPLACE TEMP RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
        GPTest.testGram("CREATE TEMP RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
        GPTest.testGram("CREATE TEMPORARY RECURSIVE VIEW public.nums_1_100 (n) AS VALUES (1) UNION ALL SELECT n+1 FROM nums_1_100 WHERE n < 100;");
        GPTest.testGram("DROP DATABASE testdb;");
        GPTest.testGram("DROP DATABASE IF EXISTS testdb;");
        GPTest.testGram("DROP SCHEMA IF EXISTS mystuff CASCADE;");
        GPTest.testGram("DROP SCHEMA mystuff,public RESTRICT;");
        GPTest.testGram("DROP SEQUENCE IF EXISTS myserial RESTRICT;");
        GPTest.testGram("DROP SEQUENCE myserial,public CASCADE;");
        GPTest.testGram("DROP TABLE IF EXISTS mytable RESTRICT;");
        GPTest.testGram("DROP TABLE mytable,mystuff CASCADE;");
        GPTest.testGram("DROP TABLESPACE mystuff;");
        GPTest.testGram("DROP TABLESPACE IF EXISTS mystuff;");
        GPTest.testGram("DROP VIEW topten;");
        GPTest.testGram("DROP VIEW IF EXISTS topten RESTRICT;");
        GPTest.testGram("DROP VIEW topten,myview CASCADE;");
        GPTest.testGram("COMMIT; ");
        GPTest.testGram("COMMIT WORK;");
        GPTest.testGram("COMMIT TRANSACTION;");
        GPTest.testGram("ROLLBACK;");
        GPTest.testGram("ROLLBACK TO my_savepoint;");
        GPTest.testGram("ROLLBACK  WORK  TO SAVEPOINT my_savepoint;");
        GPTest.testGram("ROLLBACK  TRANSACTION  TO SAVEPOINT my_savepoint;");
        GPTest.testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY RANGE (id) ( PARTITION p1  start (int '60') inclusive end (80) inclusive, PARTITION p2  start (80) inclusive end (90) exclusive );");
        GPTest.testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY RANGE (id) ( PARTITION p1  start ( '60') inclusive end (80) , PARTITION p2  start ( '60') inclusive end (80) every(1));");
        GPTest.testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY RANGE (id) ( PARTITION p1  start ( '60') inclusive end (80) , PARTITION p2  start ( '60') inclusive end (80) every(int 1));");
        GPTest.testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY RANGE (id) ( PARTITION p1  start ( '60') inclusive end (80) , PARTITION p2  start ( '60') inclusive end (80) every(interval '1 day'));");
        GPTest.testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY LIST (code) ( PARTITION sales VALUES ('S'), PARTITION returns VALUES ('R')  WITH (checksum =true)  TABLESPACE my_space;");
        GPTest.testGram("CREATE TABLE sales1 (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY LIST (code) SUBPARTITION BY RANGE (c_rank) SUBPARTITION TEMPLATE ( SUBPARTITION cr1 START (1) END (2), SUBPARTITION cr2 START (3) END (4) ) SUBPARTITION BY LIST (region) SUBPARTITION TEMPLATE ( SUBPARTITION ca VALUES ('CA') ) ( PARTITION sales VALUES ('S'), PARTITION returns VALUES ('R') );");
        GPTest.testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY LIST (code) SUBPARTITION BY RANGE (c_rank) SUBPARTITION by LIST (region) ( PARTITION sales VALUES ('S') ( SUBPARTITION cr1 START (1) END (2) ( SUBPARTITION ca VALUES ('CA') ), SUBPARTITION cr2 START (3) END (4) ( SUBPARTITION ca VALUES ('CA') ) ), PARTITION returns VALUES ('R') ( SUBPARTITION cr1 START (1) END (2) ( SUBPARTITION ca VALUES ('CA') ), SUBPARTITION cr2 START (3) END (4) ( SUBPARTITION ca VALUES ('CA') ) ) );");
        GPTest.testGram("CREATE TABLE sales (id int, year int, qtr int, c_rank int, code char(1), region text) DISTRIBUTED BY (id) PARTITION BY RANGE (year) SUBPARTITION BY RANGE (qtr) SUBPARTITION TEMPLATE ( START (1) END (5) EVERY (1), DEFAULT SUBPARTITION bad_qtr ) SUBPARTITION BY LIST (region) SUBPARTITION TEMPLATE ( SUBPARTITION usa VALUES ('usa'), SUBPARTITION europe VALUES ('europe'), SUBPARTITION asia VALUES ('asia'), DEFAULT SUBPARTITION other_regions) ( START (2009) END (2011) EVERY (1), DEFAULT PARTITION outlying_years);");
    }
}

