/*
 * Decompiled with CFR 0.152.
 */
package util.getdata;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Synonym;
import bean.Table;
import bean.View;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import util.JdbcCacheUtil;
import util.getdata.CacheData;

public class CacheGauss
extends CacheData {
    public CacheGauss(DataBase dataBase, CountDownLatch cdl) {
        super(dataBase, cdl);
    }

    @Override
    public void run() {
        System.out.println("gauss\u5f00\u59cb\u7f13\u5b58");
        try {
            this.cacheWriteToRedis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                JdbcCacheUtil.closeConnection(this.connection);
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            this.getCdl().countDown();
            System.out.println("gauss\u7ed3\u675f\u7f13\u5b58");
        }
    }

    @Override
    public List<Schema> cacheToMemory() throws SQLException, ClassNotFoundException {
        this.connection = JdbcCacheUtil.getGaussConnection(this.DataBase.getUrl(), this.DataBase.getUsername(), this.DataBase.getPassword());
        this.statement = this.connection.createStatement();
        List<Schema> schemaList = this.getSchema(this.statement);
        for (Schema schema : schemaList) {
            String schemaName = schema.getRealName();
            if (this.DataBase.getExcludeSchema().contains(schemaName)) continue;
            List<Table> tableList = this.getTable(this.statement, schemaName);
            schema.setTableList(tableList);
            for (Table table : tableList) {
                List<Column> columnList = this.getColumn(this.statement, schemaName, table.getRealName());
                table.setColumnList(columnList);
            }
            List<View> viewList = this.getView(this.statement, schemaName);
            schema.setViewList(viewList);
            schema.setSynonymList(new ArrayList<Synonym>());
        }
        return schemaList;
    }

    @Override
    public List<Schema> getSchema(Statement statement) throws SQLException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        String sql = "select SCHEMA_NAME from information_schema.schemata";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            Schema schema = new Schema(resultSet.getString("SCHEMA_NAME"));
            schema.setRealName(resultSet.getString("SCHEMA_NAME"));
            schemas.add(schema);
        }
        resultSet.close();
        return schemas;
    }

    @Override
    public List<Table> getTable(Statement statement, String schema) throws SQLException {
        ArrayList<Table> tables = new ArrayList<Table>();
        String sql = "select TABLE_NAME from information_schema.tables where TABLE_TYPE = 'BASE TABLE' AND table_schema='" + schema + "'";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            Table table = new Table(resultSet.getString("TABLE_NAME"), schema);
            table.setRealName(resultSet.getString("TABLE_NAME"));
            tables.add(table);
        }
        resultSet.close();
        return tables;
    }

    @Override
    public List<Column> getColumn(Statement statement, String schema, String table) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        String sql = "select COLUMN_NAME,DATA_TYPE from information_schema.columns where TABLE_SCHEMA = '" + schema + "' and TABLE_NAME = '" + table + "'";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            columns.add(new Column(resultSet.getString("COLUMN_NAME"), schema, table, resultSet.getString("DATA_TYPE")));
        }
        resultSet.close();
        return columns;
    }

    @Override
    public List<View> getView(Statement statement, String schema) throws SQLException {
        ArrayList<View> views = new ArrayList<View>();
        String sql = "select TABLE_NAME,VIEW_DEFINITION from information_schema.VIEWS where TABLE_SCHEMA = '" + schema + "'";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            String table_name = resultSet.getString("TABLE_NAME");
            String view_definition_tmp = resultSet.getString("VIEW_DEFINITION");
            if (view_definition_tmp == null) continue;
            String view_definition = view_definition_tmp.replaceAll("(?i)[():]|text", "");
            views.add(new View(table_name, view_definition));
        }
        resultSet.close();
        return views;
    }
}

