/*
 * Decompiled with CFR 0.152.
 */
package util.getdata;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Synonym;
import bean.Table;
import bean.View;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import util.JdbcCacheUtil;
import util.getdata.CacheData;

public class CacheGbase8S
extends CacheData {
    private String urlTemplate = "jdbc:gbasedbt-sqli://{ip_port}/{schema}:GBASEDBTSERVER={servername}";

    public CacheGbase8S(DataBase dataBase, CountDownLatch cdl) {
        super(dataBase, cdl);
    }

    @Override
    public void run() {
        System.out.println("gbase8s\u5f00\u59cb\u7f13\u5b58");
        try {
            this.cacheWriteToRedis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                JdbcCacheUtil.closeConnection(this.connection);
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            this.getCdl().countDown();
            System.out.println("gbase8s\u7ed3\u675f\u7f13\u5b58");
        }
    }

    @Override
    public List<Schema> cacheToMemory() throws ClassNotFoundException, SQLException {
        Class.forName("com.gbasedbt.jdbc.Driver");
        this.connection = JdbcCacheUtil.getConnection(this.DataBase.getUrl(), this.DataBase.getUsername(), this.DataBase.getPassword());
        this.statement = this.connection.createStatement();
        List<Schema> schemaList = this.getSchema(this.statement);
        for (Schema schema : schemaList) {
            try {
                String schemaName = schema.getRealName();
                if (this.DataBase.getExcludeSchema().contains(schemaName)) continue;
                List<Table> tableList = this.getTable(this.statement, schemaName);
                schema.setTableList(tableList);
                for (Table table : tableList) {
                    List<Column> columnList = this.getColumn(this.statement, schemaName, table.getRealName());
                    table.setColumnList(columnList);
                }
                List<View> viewList = this.getView(this.statement, schemaName);
                schema.setViewList(viewList);
                schema.setSynonymList(new ArrayList<Synonym>());
            }
            catch (Exception exception) {}
        }
        return schemaList;
    }

    @Override
    public List<Schema> getSchema(Statement statement) throws SQLException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        String sql = "select  distinct trim(name) as SCHEMA_NAME from sysmaster:sysdatabases";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            Schema schema = new Schema(resultSet.getString("SCHEMA_NAME"));
            schema.setRealName(resultSet.getString("SCHEMA_NAME"));
            schemas.add(schema);
        }
        resultSet.close();
        return schemas;
    }

    @Override
    public List<Table> getTable(Statement statement, String schema) throws SQLException {
        ArrayList<Table> tables = new ArrayList<Table>();
        String sql = "select t.tabname, c.comments from " + schema + ":systables t left join " + schema + ":syscomms c on t.tabid= c.tabid   where t.statlevel = 'A' and t.tabtype = 'T'";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            Table table = new Table(resultSet.getString("tabname"), schema);
            table.setRealName(resultSet.getString("tabname"));
            tables.add(table);
        }
        resultSet.close();
        return tables;
    }

    @Override
    public List<Column> getColumn(Statement statement, String schema, String table) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        String sql = "select sc.colname as COLUMN_NAME  from " + schema + ":syscolumns sc," + schema + ":systables t where sc.tabid = t.tabid and t.tabname = '" + table + "'";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            columns.add(new Column(resultSet.getString("COLUMN_NAME"), schema, table, ""));
        }
        resultSet.close();
        return columns;
    }

    @Override
    public List<View> getView(Statement statement, String schema) throws SQLException {
        ArrayList<View> views = new ArrayList<View>();
        String sql = "select t.tabname,s.viewtext from " + schema + ":systables t  left join " + schema + ":sysviews s on t.tabid = s.tabid where t.tabtype = 'V' and t.statlevel = 'A'";
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            String table_name = resultSet.getString("tabname");
            String view_definition = resultSet.getString("viewtext").replaceAll("`", "");
            views.add(new View(table_name, view_definition));
        }
        resultSet.close();
        return views;
    }
}

