/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse;

import bean.Column;
import bean.DataBase;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import util.JdbcUtil;
import util.sqlparse.visitor.common.Context;
import util.sqlparse.visitor.common.bean.FieldInfo;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.StatementType;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.greenplum.visitor.FieldVisitor;
import util.sqlparse.visitor.greenplum.visitor.ScopeVisitor;
import util.sqlparse.visitor.spark.SQLParser;
import util.sqlparse.visitor.spark.SparkNameWrapper;
import util.sqlparse.visitor.spark.visitor.Desensitization;
import util.sqlparse.visitor.spark.visitor.SparkScopeDialector;

public class SparkSQLParse {
    public static final String DB_TYPE = "spark";
    public HashMap<String, List<Column>> tableList = new HashMap();
    public List<Column> columnList = new ArrayList<Column>();
    public Map<String, Object> whereMap = new HashMap<String, Object>();
    public List<Map<String, Object>> whereValueList = new ArrayList<Map<String, Object>>();
    public Map<String, String> tableMap = new HashMap<String, String>();
    public Map<String, String> schemaMap = new HashMap<String, String>();
    public Map<String, String> params;
    public List<Map<String, Object>> whereList = new ArrayList<Map<String, Object>>();

    public SparkSQLParse(Map<String, String> params) {
        this.params = params;
    }

    public SparkSQLParse() {
    }

    public String rowVisitControl(Map<String, Object> param) throws SQLException {
        Desensitization desensitization = new Desensitization();
        Map map = desensitization.parseRowVisit(param);
        return (String)map.get("newSql");
    }

    public String parseSql() {
        Desensitization desensitization = new Desensitization();
        Map map = desensitization.parseData(this.params);
        return (String)map.get("newSql");
    }

    public String parseSql_column() {
        Desensitization desensitization = new Desensitization();
        Map map = desensitization.parseColumn(this.params);
        return (String)map.get("newSql");
    }

    public String parseSql_table() {
        try {
            Desensitization desensitization = new Desensitization();
            desensitization.parseTable(this.params);
        }
        catch (Exception throwables) {
            throwables.printStackTrace();
        }
        return this.params.get("newSql");
    }

    public String parseSql_data() {
        Desensitization desensitization = new Desensitization();
        Map map = desensitization.parseData(this.params);
        return (String)map.get("newSql");
    }

    public void parseSqlStructureAndReplace(Map<String, Object> paramMap, Map<String, String> repalceMap) throws SQLException {
        String dbType;
        String sql = this.params.get("sql");
        String sqlType = JdbcUtil.getSqlType(sql, dbType = this.params.get("dbType"));
        if ("select".equals(sqlType) || "union".equals(sqlType) || "update".equals(sqlType) || "insert".equals(sqlType) || "delete".equals(sqlType)) {
            String permission = this.params.get("permission");
            String url = this.params.get("url");
            String schema = this.params.get("schema");
            String ip_port = url.split("/")[2];
            SQLParser sqlParser = new SQLParser();
            DataBase dataBase = new DataBase();
            for (DataBase db : JdbcUtil.dataBaseList) {
                if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
                dataBase = db;
                break;
            }
            SQLResult parse = sqlParser.parse(sql, dataBase, schema);
            List<Object> columnlist = new ArrayList();
            if ("masking".equalsIgnoreCase(permission)) {
                columnlist = parse.outputs;
            } else if ("full".equalsIgnoreCase(permission)) {
                columnlist = parse.fields;
            } else if (!"insert".equalsIgnoreCase(sqlType) && !"update".equalsIgnoreCase(sqlType)) {
                columnlist = parse.outputs;
            }
            for (FieldInfo fieldInfo : columnlist) {
                List<Object> fieldInfoList = new ArrayList<FieldInfo>();
                if (fieldInfo.getRelations().size() > 1) {
                    fieldInfoList = fieldInfo.getRelations();
                } else {
                    fieldInfoList.add(fieldInfo);
                }
                for (FieldInfo fieldInfo2 : fieldInfoList) {
                    String name = fieldInfo2.getName();
                    Map<String, TableInfo> tables = fieldInfo2.getTables();
                    String tableName = "";
                    for (String s : tables.keySet()) {
                        tableName = s.split("\\.")[1];
                    }
                    Column column = new Column();
                    column.setColumnName(tableName + "." + name);
                    column.setColumnAlisa(fieldInfo2.getAlias());
                    column.setSubQuery(false);
                    this.columnList.add(column);
                }
            }
            SparkNameWrapper wrapper = new SparkNameWrapper(dataBase.simpleCache);
            for (TableInfo table : parse.tables) {
                TableMemo tb = table.getTable();
                String string = wrapper.unwrapSchema(tb.schema);
                String tbName = wrapper.unwrapTable(string, tb.name);
                this.tableMap.put(tbName, tbName);
                this.schemaMap.put(tbName, string);
            }
            for (ValueInfo value : parse.values) {
                FieldMemo field = value.field;
                this.whereMap.put(field.name, value.value.toString());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("column", field.getAtomName());
                hashMap.put("columnValue", value.value.toString());
                hashMap.put("type", value.operator);
                this.whereList.add(hashMap);
            }
            sqlParser.replace(parse.values, repalceMap);
            paramMap.put("whereList", this.whereList);
            paramMap.put("statement", parse.statement);
            paramMap.put("type", parse.sqlType.name().toLowerCase());
            paramMap.put("sql", parse.statement.toString());
            wrapper.unwrapFullColumns(this.columnList);
        }
        paramMap.put("tableMap", this.tableMap);
        paramMap.put("columnList", this.columnList);
        paramMap.put("schemaMap", this.schemaMap);
        paramMap.put("whereMap", this.whereMap);
        paramMap.put("whereList", this.whereList);
    }

    public void parseSqlStructure(Map<String, Object> paramMap) throws SQLException {
        String sql = this.params.get("sql");
        String dbType = this.params.get("dbType");
        boolean isEncryption = this.params.containsKey("encryption");
        List<SQLStatement> statements = SQLUtils.parseStatements(sql, DB_TYPE);
        if (statements != null && statements.size() != 0) {
            StatementType statementType = SQLParser.getStatementType(statements.get(0));
            String sqlType = JdbcUtil.getSqlType(sql, dbType);
            if (statementType != StatementType.other) {
                String permission = this.params.get("permission");
                String url = this.params.get("url");
                String schema = this.params.get("schema");
                String ip_port = url.split("/")[2];
                SQLParser sqlParser = new SQLParser();
                DataBase dataBase = new DataBase();
                for (DataBase db : JdbcUtil.dataBaseList) {
                    if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
                    dataBase = db;
                    break;
                }
                SQLResult parse = sqlParser.parse(statements.get(0), dataBase, schema);
                List<FieldInfo> columnlist = "masking".equalsIgnoreCase(permission) ? parse.outputs : ("full".equalsIgnoreCase(permission) ? parse.fields : (isEncryption ? (!"insert".equalsIgnoreCase(sqlType) && !"update".equalsIgnoreCase(sqlType) ? parse.outputs : parse.fields) : parse.outputs));
                SparkNameWrapper wrapper = new SparkNameWrapper(dataBase.simpleCache);
                HashSet<String> tabSet = new HashSet<String>();
                for (FieldInfo fieldInfo : columnlist) {
                    List<Object> fieldInfoList = new ArrayList<FieldInfo>();
                    if (fieldInfo.getRelations().size() > 0) {
                        fieldInfoList = fieldInfo.getRelations();
                    } else {
                        fieldInfoList.add(fieldInfo);
                    }
                    for (FieldInfo fieldInfo2 : fieldInfoList) {
                        String name = fieldInfo2.getName();
                        if (StringUtils.isEmpty(name)) continue;
                        Map<String, TableInfo> tables = fieldInfo2.getTables();
                        String tableName = "";
                        String schemaName = "";
                        for (String string : tables.keySet()) {
                            String[] segment = string.split("\\.");
                            if (StringUtils.isEmpty(segment[0]) || StringUtils.isEmpty(segment[1])) continue;
                            schemaName = segment[0];
                            tableName = segment[1];
                            break;
                        }
                        if (tableName.length() == 0 && fieldInfo2.getTables().size() > 0) {
                            for (Map.Entry entry : fieldInfo2.getTables().entrySet()) {
                                TableInfo tbInfo = (TableInfo)entry.getValue();
                                if (tbInfo == null || tbInfo.getTable() == null || StringUtils.isEmpty(tbInfo.getTable().schema) || StringUtils.isEmpty(tbInfo.getTable().name)) continue;
                                tableName = tbInfo.getTable().name;
                                schemaName = tbInfo.getTable().schema;
                                break;
                            }
                        }
                        schemaName = wrapper.unwrapSchema(schemaName);
                        tableName = wrapper.unwrapTable(schemaName, tableName);
                        tabSet.add(tableName);
                        Column column = new Column();
                        column.setColumnName(tableName + "." + name);
                        column.setTable(tableName);
                        column.setSchema(schemaName);
                        column.setColumnAlisa(fieldInfo2.getAlias());
                        column.setSubQuery(false);
                        this.columnList.add(column);
                    }
                }
                for (TableInfo table : parse.tables) {
                    TableMemo tb = table.getTable();
                    String schName = wrapper.unwrapSchema(tb.schema);
                    String string = wrapper.unwrapTable(schName, tb.name);
                    if (!tabSet.contains(string)) continue;
                    this.tableMap.put(string, string);
                    this.schemaMap.put(string, schName);
                }
                String type = this.getStatementType(parse.statementType);
                paramMap.put("type", type);
                for (ValueInfo value : parse.values) {
                    FieldMemo field = value.field;
                    this.whereMap.put(field.name, value.value.toString());
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("column", value.getValueNames());
                    hashMap.put("columnValue", value.value.toString());
                    hashMap.put("type", value.operator);
                    hashMap.put("value", value);
                    this.whereList.add(hashMap);
                }
                paramMap.put("whereList", this.whereList);
                paramMap.put("statement", parse.statement);
                paramMap.put("type", statementType.toString().toLowerCase());
                paramMap.put("sql", parse.statement.toString());
                wrapper.unwrapFullColumns(this.columnList);
                paramMap.put("tableMap", this.tableMap);
                paramMap.put("columnList", this.columnList);
                paramMap.put("schemaMap", this.schemaMap);
                paramMap.put("whereMap", this.whereMap);
            }
        }
    }

    private String getStatementType(StatementType stmtType) {
        String type = "OTHER";
        switch (stmtType) {
            case select: {
                type = "SELECT";
                break;
            }
            case insert: {
                type = "INSERT";
                break;
            }
            case update: {
                type = "UPDATE";
                break;
            }
            case delete: {
                type = "DELETE";
                break;
            }
            case replace: {
                type = "REPLACE";
                break;
            }
            case grant: {
                type = "GRANT";
                break;
            }
            case revoke: {
                type = "REVOKE";
                break;
            }
            case alterView: {
                type = "ALTERVIEW";
                break;
            }
            case createView: {
                type = "CREATEVIEW";
                break;
            }
            case dropView: {
                type = "DROPVIEW";
                break;
            }
            case truncate: {
                type = "TRUNCATE";
                break;
            }
            case createIndex: {
                type = "CREATEINDEX";
                break;
            }
            case dropIndex: {
                type = "DROPINDEX";
                break;
            }
            case dropEvent: 
            case dropFunction: 
            case dropTable: 
            case dropProc: 
            case dropSequence: {
                type = "DROP";
                break;
            }
            case alterFunction: 
            case alterEvent: 
            case alterTable: 
            case alterProc: 
            case alterSequence: 
            case alterIndex: {
                type = "ALTER";
                break;
            }
            case createEvent: 
            case createTable: 
            case createFunction: 
            case createProc: 
            case createSequence: {
                type = "CREATE";
            }
        }
        return type;
    }

    public List<String> parseWheres(String sql) {
        SQLParser parser = new SQLParser();
        return parser.where(sql);
    }

    public String formatSQL(String sql) {
        SQLParser parser = new SQLParser();
        return parser.format(sql);
    }

    public Scope getScope(String ip_port, String schema, List<SQLStatement> statements) {
        Context context = new Context();
        DataBase dataBase = new DataBase();
        for (DataBase db : JdbcUtil.dataBaseList) {
            if (!ip_port.equalsIgnoreCase(db.getIp_port())) continue;
            dataBase = db;
            break;
        }
        context.initialize(dataBase, schema, DB_TYPE);
        Scope scope = new Scope();
        scope.dialector = new SparkScopeDialector(scope);
        scope.context = context;
        scope.isCheckIsolated = true;
        ScopeVisitor scopeVisitor = new ScopeVisitor(scope);
        scopeVisitor.perform(statements);
        FieldVisitor fieldVisitor = new FieldVisitor(scope);
        fieldVisitor.perform(statements);
        return scope;
    }
}

