/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.dm.test;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import util.StringJoin;
import util.sqlparse.visitor.common.bean.FieldInfo;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.TableInfo;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.dm.test.CompareStruct;
import util.sqlparse.visitor.dm.test.JsonUtil;

public class TestSet {
    public static final String TABLES_INFO = "TABLES-INFO";
    public static final String TABLES_MEMO = "TABLES-MEMO";
    public static final String FIELDS_INFO = "FIELDS-INFO";
    public static final String FIELDS_MEMO = "FIELDS-MEMO";
    public static final String OUTPUT_INFO = "OUTPUT-INFO";
    public static final String OUTPUT_MEMO = "OUTPUT-MEMO";
    public static final String VALUES_INFO = "VALUES-INFO";
    public static final String STATEMENT_STRING = "STATEMENT-STRING";
    public static final String DELIMITER = "<----delimiter---->";

    static List<String> getValuesInfo(SQLResult result) {
        ArrayList<String> list = new ArrayList<String>();
        for (ValueInfo x : result.values) {
            list.add(x.value.toString() + " -> " + x.field.getQualifiedName());
        }
        return list;
    }

    static List<String> getOutputInfo(SQLResult result) {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldInfo x : result.outputs) {
            list.add(x.getFullName() + "->" + TestSet.getString(x.getMemo()));
        }
        return list;
    }

    static List<String> getFiledsInfo(SQLResult result) {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldInfo x : result.fields) {
            list.add(x.getAtomName().toString());
        }
        return list;
    }

    static List<String> getTableINfo(SQLResult result) {
        ArrayList<String> list = new ArrayList<String>();
        for (TableInfo x : result.tables) {
            list.add(x.getTable().getAtomName());
        }
        return list;
    }

    static void saveToJson(SQLResult result, String inputSql, JSONObject json) {
        List<String> tableInfos = TestSet.getTableINfo(result);
        JSONObject tableInfoJson = new JSONObject();
        tableInfoJson.put(TABLES_INFO, (Object)StringJoin.join(tableInfos, DELIMITER));
        List<String> tableMemos = TestSet.getTableMemos(result);
        tableInfoJson.put(TABLES_MEMO, (Object)StringJoin.join(tableMemos, DELIMITER));
        List<String> fieldsInfo = TestSet.getFiledsInfo(result);
        tableInfoJson.put(FIELDS_INFO, (Object)StringJoin.join(fieldsInfo, DELIMITER));
        List<String> fieldMemos = TestSet.getFieldMemos(result);
        tableInfoJson.put(FIELDS_MEMO, (Object)StringJoin.join(fieldMemos, DELIMITER));
        List<String> outputs = TestSet.getOutputInfo(result);
        tableInfoJson.put(OUTPUT_INFO, (Object)StringJoin.join(outputs, DELIMITER));
        List<String> outputMemos = TestSet.getOutputMemos(result);
        tableInfoJson.put(OUTPUT_MEMO, (Object)StringJoin.join(outputMemos, DELIMITER));
        List<String> values = TestSet.getValuesInfo(result);
        tableInfoJson.put(VALUES_INFO, (Object)StringJoin.join(values, DELIMITER));
        tableInfoJson.put(STATEMENT_STRING, (Object)result.statement.toString());
        json.put(inputSql, (Object)tableInfoJson);
    }

    static List<String> getOutputMemos(SQLResult result) {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldMemo x : result.outputMemos) {
            list.add(x.getQualifiedName().replace("[\r  ]+", " ") + " " + TestSet.getString(x));
        }
        return list;
    }

    static List<String> getFieldMemos(SQLResult result) {
        ArrayList<String> list = new ArrayList<String>();
        for (FieldMemo x : result.fieldMemos) {
            list.add(x.getAtomName() + "{ as " + x.getQualifiedName() + "}->" + TestSet.getString(x));
        }
        return list;
    }

    static List<String> getTableMemos(SQLResult result) {
        ArrayList<String> list = new ArrayList<String>();
        for (TableMemo x : result.tableMemos) {
            ArrayList<String> nameList = new ArrayList<String>();
            for (TableMemo z : x.getChildren()) {
                nameList.add(z.getQualifiedName());
            }
            list.add(x.getAtomName() + "->" + StringJoin.join(nameList, ","));
        }
        return list;
    }

    static String getString(FieldMemo memo) {
        StringBuffer s = new StringBuffer();
        s.append(memo.getAtomName());
        if (memo.children.size() > 0) {
            s.append(" [ ");
            if (memo.children != null) {
                for (FieldMemo child : memo.children) {
                    s.append(TestSet.getString(child));
                    s.append(",");
                }
                s.deleteCharAt(s.length() - 1);
            }
            s.append(" ] ");
        }
        return s.toString();
    }

    static JSONObject test(SQLResult result, String inputSql, String path, JSONObject jsonObject) throws Exception {
        if (jsonObject == null) {
            jsonObject = TestSet.readFromJson(path);
        }
        JSONObject json = (JSONObject)jsonObject.get(inputSql);
        String tableInfo = (String)json.get(TABLES_INFO);
        List<String> tableInfos = TestSet.toStringList(tableInfo);
        TestSet.compare(TestSet.getTableINfo(result), tableInfos, TABLES_INFO);
        String tableMemosStr = (String)json.get(TABLES_MEMO);
        List<String> tableMemos = TestSet.toStringList(tableMemosStr);
        TestSet.compare(TestSet.getTableMemos(result), tableMemos, TABLES_MEMO);
        String fieldInfoStr = (String)json.get(FIELDS_INFO);
        List<String> fieldInfo = TestSet.toStringList(fieldInfoStr);
        TestSet.compare(TestSet.getFiledsInfo(result), fieldInfo, FIELDS_INFO);
        String fieldMemoStr = (String)json.get(FIELDS_MEMO);
        List<String> fieldMemo = TestSet.toStringList(fieldMemoStr);
        TestSet.compare(TestSet.getFieldMemos(result), fieldMemo, FIELDS_MEMO);
        String outputInfoStr = (String)json.get(OUTPUT_INFO);
        List<String> outputInfo = TestSet.toStringList(outputInfoStr);
        TestSet.compare(TestSet.getOutputInfo(result), outputInfo, OUTPUT_INFO);
        String outputMemoStr = (String)json.get(OUTPUT_MEMO);
        List<String> outputMemo = TestSet.toStringList(outputMemoStr);
        TestSet.compare(TestSet.getOutputMemos(result), outputMemo, OUTPUT_MEMO);
        String ValueInfoStr = (String)json.get(VALUES_INFO);
        List<String> ValueInfo2 = TestSet.toStringList(ValueInfoStr);
        TestSet.compare(TestSet.getValuesInfo(result), ValueInfo2, VALUES_INFO);
        String statementString = (String)json.get(STATEMENT_STRING);
        if (!statementString.equalsIgnoreCase(result.statement.toString())) {
            throw new Exception(STATEMENT_STRING);
        }
        return jsonObject;
    }

    private static List<String> toStringList(String valueInfoStr) {
        return valueInfoStr != null && !valueInfoStr.equals("") ? Arrays.asList(valueInfoStr.split(DELIMITER)) : new ArrayList<String>(0);
    }

    private static void compare(List<String> src, List<String> tableInfos, String tag) throws Exception {
        ArrayList<CompareStruct> listCompares = new ArrayList<CompareStruct>();
        for (String tableinfo : tableInfos) {
            listCompares.add(new CompareStruct(tableinfo));
        }
        if (src.size() != listCompares.size()) {
            String error = "ERROR, " + tag + "size error.";
            throw new Exception(error);
        }
        TestSet.compareTo(listCompares, src, tag);
    }

    private static JSONObject readFromJson(String path) {
        String jsonString = JsonUtil.readJson(path);
        JSONObject json = JSON.parseObject(jsonString);
        return json;
    }

    private static void compareTo(List<CompareStruct> listCompares, List<String> tableInfos2, String tag) throws Exception {
        block0: for (String string : tableInfos2) {
            for (CompareStruct target : listCompares) {
                if (target.find || !string.equalsIgnoreCase((String)target.object)) continue;
                target.find = true;
                continue block0;
            }
        }
        ArrayList<CompareStruct> notHitList = new ArrayList<CompareStruct>();
        for (CompareStruct x : listCompares) {
            if (x.find) continue;
            notHitList.add(x);
        }
        if (notHitList.size() > 0) {
            String string = "ERROR,  " + tag + "not hit. \n" + ((Object)notHitList).toString();
            throw new Exception(string);
        }
    }
}

