/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.kingbase;

import bean.Column;
import bean.Schema;
import bean.Table;
import bean.View;
import com.alibaba.druid.util.StringUtils;
import java.util.Locale;
import java.util.Map;
import util.getdata.DatabaseCache;
import util.sqlparse.visitor.common.names.NameWrapper;

public class KingbaseNameWrapper
extends NameWrapper {
    public static final String PLACE_HOLDER = "\"";

    public KingbaseNameWrapper(DatabaseCache cache) {
        super(cache);
    }

    @Override
    public String unwrapSchema(String schema) {
        if (schema != null && schema.length() != 0) {
            if (this.isCaseSensitive && schema.startsWith(PLACE_HOLDER)) {
                return this.raw(schema);
            }
            Schema sch = this.getSchema(schema);
            return sch != null ? sch.getName() : this.unwrapName(schema);
        }
        return schema;
    }

    @Override
    public String unwrapTable(String schema, String table) {
        if (schema != null && schema.length() != 0) {
            if (table != null && table.length() != 0) {
                if (this.isCaseSensitive && table.startsWith(PLACE_HOLDER)) {
                    return this.raw(table);
                }
                Table tb = this.getTable(schema, table);
                return tb != null ? tb.getName() : this.unwrapName(table);
            }
            return table;
        }
        return this.raw(table);
    }

    @Override
    public String unwrapFullColumn(Column c) {
        if (c == null) {
            return null;
        }
        String column = c.getColumnName();
        if (column != null && column.length() != 0) {
            NameWrapper.ColInfo colInfo = this.getColumnInfo(c);
            this.unwrapColumn(colInfo);
            return colInfo.unwrap(PLACE_HOLDER);
        }
        return column;
    }

    private Schema getSchema(String schema) {
        if (schema != null && schema.length() != 0) {
            if (this.cache.getDataBase().isRedis()) {
                return this.getSchemaFromRedis(schema, this.isSensitive(schema));
            }
            Map<String, Schema> schemas = this.cache.getSchemas();
            if (this.isSensitive(schema)) {
                schema = this.raw(schema);
                return schemas.get(schema);
            }
            schema = schema.trim();
            Schema sch = schemas.get(schema = this.unwrapName(schema));
            if (sch != null) {
                return sch;
            }
            for (Map.Entry<String, Schema> pair : schemas.entrySet()) {
                if (!pair.getKey().equalsIgnoreCase(schema)) continue;
                return pair.getValue();
            }
            return null;
        }
        return null;
    }

    @Override
    public Table getTable(String schema, String table) {
        Schema sch = this.getSchema(schema);
        return sch == null ? null : this.getTable(sch, table);
    }

    private Table getTable(Schema sch, String table) {
        if (sch == null) {
            return null;
        }
        if (this.cache.getDataBase().isRedis()) {
            return this.getTableFromRedis(sch, table, this.isSensitive(table));
        }
        table = table.trim();
        Map<String, Table> tables = this.cache.getTables();
        if (this.isSensitive(table)) {
            table = this.unwrapName(table);
            String id = this.cache.getSchemaTableId(sch.getName(), table);
            return tables.get(id);
        }
        table = this.unwrapName(table);
        String id = this.cache.getSchemaTableId(sch.getName(), table);
        Table tb = tables.get(id);
        if (tb != null) {
            return tb;
        }
        for (Map.Entry<String, Table> pair : tables.entrySet()) {
            if (!pair.getKey().equalsIgnoreCase(id)) continue;
            return pair.getValue();
        }
        return null;
    }

    private boolean isSensitive(String symbol) {
        return symbol.startsWith(PLACE_HOLDER) && this.isCaseSensitive;
    }

    @Override
    public View getView(String schema, String viewName) {
        Schema sch = this.getSchema(schema);
        return sch == null ? null : this.getView(sch, viewName);
    }

    public View getView(Schema sch, String viewName) {
        if (sch == null) {
            return null;
        }
        return this.cache.getDataBase().isRedis() ? this.getViewFromRedis(sch, viewName, this.isSensitive(viewName)) : null;
    }

    private void unwrapColumn(NameWrapper.ColInfo colInfo) {
        String schema = colInfo.schema;
        String table = colInfo.table;
        String col = colInfo.column;
        if (colInfo.isValid()) {
            Table tb;
            Schema sch = this.getSchema(schema);
            if (sch != null) {
                colInfo.schema = sch.getName();
            }
            if ((tb = this.getTable(sch, table)) != null) {
                colInfo.table = tb.getName();
            }
            if (tb != null && tb.getColumnList() != null && tb.getColumnList().size() > 0) {
                col = col.trim();
                boolean isCase = col.startsWith(PLACE_HOLDER);
                col = this.raw(col);
                for (Column column : tb.getColumnList()) {
                    if (!this.isCaseSensitive) {
                        if (!column.getColumnName().equalsIgnoreCase(col)) continue;
                        colInfo.column = column.getColumnName();
                        break;
                    }
                    if (isCase) {
                        if (!column.getColumnName().equals(col)) continue;
                        colInfo.column = column.getColumnName();
                        break;
                    }
                    if (!column.getColumnName().equalsIgnoreCase(col)) continue;
                    colInfo.column = column.getColumnName();
                    break;
                }
            }
        }
    }

    @Override
    protected String unwrapName(String name) {
        return name != null && name.length() != 0 ? name.replaceAll(PLACE_HOLDER, "") : name;
    }

    private String wrapName(String name) {
        return name != null && name.length() != 0 ? PLACE_HOLDER + name + PLACE_HOLDER : name;
    }

    public String wrapTable(String schema, String table) {
        if (schema != null && schema.length() != 0) {
            if (table != null && table.length() != 0) {
                return this.isCaseSensitive && !table.startsWith(PLACE_HOLDER) ? this.wrapName(table) : table;
            }
            return table;
        }
        return table;
    }

    public String wrapColumn(String Column2) {
        if (Column2 != null && Column2.length() != 0) {
            return this.isCaseSensitive && !Column2.startsWith(PLACE_HOLDER) ? this.wrapName(Column2) : Column2;
        }
        return Column2;
    }

    public static String normalize(String str, boolean isCaseSensitive) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (str.startsWith(PLACE_HOLDER)) {
            String trim = str.replaceAll(PLACE_HOLDER, "").trim();
            return !isCaseSensitive ? trim.toLowerCase(Locale.ROOT) : trim;
        }
        return str.toLowerCase(Locale.ROOT).trim();
    }

    private String raw(String name) {
        if (name != null && name.length() != 0) {
            String nameRaw = this.unwrapName(name);
            return this.isCaseSensitive && nameRaw.toUpperCase().equals(name) ? nameRaw.toLowerCase() : nameRaw;
        }
        return name;
    }
}

