/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo;

import com.alibaba.druid.sql.dialect.mongo.parser.ApiTreeParser;
import util.sqlparse.visitor.mongo.BsonArrayNode;
import util.sqlparse.visitor.mongo.BsonNode;
import util.sqlparse.visitor.mongo.BsonObjectNode;
import util.sqlparse.visitor.mongo.Encoder;
import util.sqlparse.visitor.mongo.Identifier;
import util.sqlparse.visitor.mongo.MongoNode;
import util.sqlparse.visitor.mongo.MongoVisitor;

public class MongoParser {
    private final MongoVisitor visitor;

    public MongoParser(MongoVisitor visitor) {
        this.visitor = visitor;
    }

    public void parse(MongoNode ctx) {
        if (ctx.type() != BsonNode.BsonNodeType.Basic) {
            BsonArrayNode array;
            Object node;
            if (ctx.type() == BsonNode.BsonNodeType.Object) {
                this.parse((BsonObjectNode)ctx, ctx);
            } else if (ctx.type() == BsonNode.BsonNodeType.Array && (node = (array = (BsonArrayNode)ctx).get(array.size() - 1)).type() == BsonNode.BsonNodeType.Object) {
                this.parse((BsonObjectNode)node, ctx);
            }
        }
    }

    private void parse(BsonObjectNode judge, MongoNode entry) {
        if (judge.contains(Identifier.FindAndModify.code)) {
            this.visitor.visitFindAndModify(entry);
        } else if (judge.contains(Identifier.Find.code)) {
            this.visitor.visitFind(entry);
        } else if (judge.contains(Identifier.UpdateUser.code)) {
            this.visitor.visitUpdateUser(entry);
        } else if (judge.contains(Identifier.Insert.code)) {
            this.visitor.visitInsert(entry);
        } else if (judge.contains(Identifier.Update.code)) {
            this.visitor.visitUpdate(entry);
        } else if (judge.contains(Identifier.Delete.code)) {
            this.visitor.visitDelete(entry);
        } else if (judge.contains(Identifier.Count.code)) {
            this.visitor.visitCount(entry);
        } else if (judge.contains(Identifier.Aggregate.code)) {
            this.visitor.visitAggregate(entry);
        } else if (judge.contains(Identifier.Distinct.code)) {
            this.visitor.visitDistinct(entry);
        } else if (judge.contains(Identifier.DropUser.code)) {
            this.visitor.visitDropUser(entry);
        } else if (judge.contains(Identifier.CreateIndexes.code)) {
            this.visitor.visitCreateIndexes(entry);
        } else if (judge.contains(Identifier.DropIndexes.code)) {
            this.visitor.visitDropIndexes(entry);
        } else if (judge.contains(Identifier.ReIndex.code)) {
            this.visitor.visitReIndex(entry);
        } else if (judge.contains(Identifier.RenameCollection.code)) {
            this.visitor.visitRenameCollection(entry);
        } else if (judge.contains(Identifier.Mapreduce.code)) {
            this.visitor.visitMapreduce(entry);
        } else if (judge.contains(Identifier.CreateUser.code)) {
            this.visitor.visitCreateUser(entry);
        } else if (judge.contains(Identifier.SaslSupportedMechs.code)) {
            this.visitor.visitSaslSupportedMechs(entry);
        } else if (judge.contains(Identifier.UsersInfo.code)) {
            this.visitor.visitUsersInfo(entry);
        } else if (judge.contains(Identifier.GrantRolesToUser.code)) {
            this.visitor.visitGrantRolesToUser(entry);
        } else if (judge.contains(Identifier.RevokeRolesFromUser.code)) {
            this.visitor.visitRevokeRolesFromUser(entry);
        } else if (judge.contains(Identifier.Drop.code)) {
            this.visitor.visitDrop(entry);
        } else if (judge.contains(Identifier.Create.code)) {
            this.visitor.visitCreate(entry);
        }
    }

    public String encode() {
        BsonNode out;
        Encoder visitor = (Encoder)this.visitor;
        String api = visitor.getApi();
        ApiTreeParser apiTreeParser = new ApiTreeParser(api);
        apiTreeParser.parse();
        visitor.setApiTreeParser(apiTreeParser);
        new BsonObjectNode();
        String methodName = apiTreeParser.getMethod().getName();
        if (apiTreeParser.getCollection() != null) {
            if (Identifier.Find.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitFind(out);
            } else if (Identifier.FindOne.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitFindOne(out);
            } else if (Identifier.Insert.code.equals(methodName)) {
                out = new BsonArrayNode();
                visitor.visitInsert(out);
            } else if (Identifier.InsertOne.code.equals(methodName)) {
                out = new BsonArrayNode();
                visitor.visitInsertOne(out);
            } else if (Identifier.InsertMany.code.equals(methodName)) {
                out = new BsonArrayNode();
                visitor.visitInsertMany(out);
            } else if (Identifier.Distinct.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitDistinct(out);
            } else if (Identifier.Update.code.equals(methodName)) {
                out = new BsonArrayNode();
                visitor.visitUpdate(out);
            } else if (Identifier.UpdateOne.code.equals(methodName)) {
                out = new BsonArrayNode();
                visitor.visitUpdateOne(out);
            } else if (Identifier.UpdateMany.code.equals(methodName)) {
                out = new BsonArrayNode();
                visitor.visitUpdateMany(out);
            } else if (Identifier.Save.code.equals(methodName)) {
                out = new BsonArrayNode();
                visitor.visitSave(out);
            } else if (Identifier.Remove.code.equals(methodName)) {
                out = new BsonArrayNode();
                visitor.visitDelete(out);
            } else if (Identifier.DeleteOne.code.equals(methodName)) {
                out = new BsonArrayNode();
                visitor.visitDeleteOne(out);
            } else if (Identifier.DeleteMany.code.equals(methodName)) {
                out = new BsonArrayNode();
                visitor.visitDeleteMany(out);
            } else if (Identifier.Aggregate.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitAggregate(out);
            } else if (Identifier.Count.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitCount(out);
            } else if (Identifier.findAndModify.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitFindAndModify(out);
            } else if (Identifier.FindOneAndUpdate.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.findOneAndUpdate(out);
            } else if (Identifier.FindOneAndReplace.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.findOneAndReplace(out);
            } else if (Identifier.FindOneAndDelete.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.findOneAndDelete(out);
            } else if (Identifier.MapReduce.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitMapreduce(out);
            } else if (Identifier.CreateIndexes.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitCreateIndexes(out);
            } else if (Identifier.CreateIndex.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitCreateIndexes(out);
            } else if (Identifier.DropIndex.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitDropIndexes(out);
            } else if (Identifier.DropIndexes.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitDropIndexes(out);
            } else if (Identifier.ReIndex.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitReIndex(out);
            } else if (Identifier.GetIndexes.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitGetIndexes(out);
            } else if (Identifier.RenameCollection.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitRenameCollection(out);
            } else if (Identifier.Drop.code.equals(methodName)) {
                out = new BsonObjectNode();
                visitor.visitDrop(out);
            } else {
                if (!Identifier.CountDocuments.code.equals(methodName)) {
                    return "";
                }
                out = new BsonObjectNode();
                visitor.visitCountDocuments(out);
            }
        } else if (Identifier.CreateCollection.code.equals(methodName)) {
            out = new BsonObjectNode();
            visitor.visitCreateCollection(out);
        } else if (Identifier.CreateUser.code.equals(methodName)) {
            out = new BsonObjectNode();
            visitor.visitCreateUser(out);
        } else if (Identifier.ChangeUserPassword.code.equals(methodName)) {
            out = new BsonObjectNode();
            visitor.visitChangeUserPassword(out);
        } else if (Identifier.GetUser.code.equals(methodName)) {
            out = new BsonObjectNode();
            visitor.visitUsersInfo(out);
        } else if (Identifier.GrantRolesToUser.code.equals(methodName)) {
            out = new BsonObjectNode();
            visitor.visitGrantRolesToUser(out);
        } else if (Identifier.RemoveUser.code.equals(methodName)) {
            out = new BsonObjectNode();
            visitor.visitDropUser(out);
        } else if (Identifier.DropUser.code.equals(methodName)) {
            out = new BsonObjectNode();
            visitor.visitDropUser(out);
        } else if (Identifier.UpdateUser.code.equals(methodName)) {
            out = new BsonObjectNode();
            visitor.visitUpdateUser(out);
        } else if (Identifier.RevokeRolesFromUser.code.equals(methodName)) {
            out = new BsonObjectNode();
            visitor.visitRevokeRolesFromUser(out);
        } else {
            if (!Identifier.RunCommand.code.equals(methodName)) {
                return "";
            }
            out = new BsonObjectNode();
            visitor.visitRunCommand(out);
        }
        return ((Object)out).toString();
    }
}

