/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo;

import java.util.UUID;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class MongoTools {
    public static BsonDocument generateIdDoc() {
        UUID uuid4 = UUID.randomUUID();
        byte[] bytes2 = new byte[16];
        MongoTools.writeLongToArrayLittleEndian(bytes2, 0, uuid4.getMostSignificantBits());
        MongoTools.writeLongToArrayLittleEndian(bytes2, 8, uuid4.getLeastSignificantBits());
        BsonDocument id = new BsonDocument();
        id.append("id", (BsonValue)new BsonBinary(BsonBinarySubType.UUID_STANDARD, bytes2));
        return id;
    }

    public static void writeLongToArrayLittleEndian(byte[] bytes, int offset, long x) {
        bytes[offset + 7] = (byte)(0xFFL & x);
        bytes[offset + 6] = (byte)(0xFFL & x >> 8);
        bytes[offset + 5] = (byte)(0xFFL & x >> 16);
        bytes[offset + 4] = (byte)(0xFFL & x >> 24);
        bytes[offset + 3] = (byte)(0xFFL & x >> 32);
        bytes[offset + 2] = (byte)(0xFFL & x >> 40);
        bytes[offset + 1] = (byte)(0xFFL & x >> 48);
        bytes[offset + 0] = (byte)(0xFFL & x >> 56);
    }
}

