/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo;

import com.alibaba.druid.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import util.sqlparse.visitor.common.bean.ValueInfo;
import util.sqlparse.visitor.mongo.MongoNode;

public class ParseResult {
    public String sqlType;
    public Set<String> schemas = new HashSet<String>();
    public Set<String> collections = new HashSet<String>();
    public ConcurrentHashMap<String, Column> columns = new ConcurrentHashMap();
    public Map<String, List<RoleDb>> user = new HashMap<String, List<RoleDb>>();
    public MongoNode statement;
    public String api;
    public boolean isMatched;
    public MongoNode newMongoNode;
    public List<ValueInfo> values = new ArrayList<ValueInfo>();

    public void addCollection(String collection) {
        this.collections.add(collection);
    }

    public void addSchema(String schema) {
        this.schemas.add(schema);
    }

    public void addColumn(String colName) {
        Column column = new Column();
        column.name = colName;
        this.columns.put(colName, column);
    }

    public void addColumn(String collection, String colName, MongoNode ref) {
        this.addColumn(collection, colName, false, ref);
    }

    public void addColumn(String collection, String colName, boolean isOutput, MongoNode ref) {
        String name = String.format("%s.%s.%s", collection, colName, isOutput);
        Column column = new Column();
        column.collection = collection;
        column.name = colName;
        column.isOutput = isOutput;
        this.columns.put(name, column);
    }

    public void removeColumn(String collection, String colName, boolean isOutput, MongoNode ref) {
        String name = String.format("%s.%s.%s", collection, colName, isOutput);
        this.columns.remove(name);
    }

    public void removeCollectionAllColumn(String collection, String isOutput) {
        for (Map.Entry<String, Column> entry : this.columns.entrySet()) {
            String k = entry.getKey();
            Column v = entry.getValue();
            if (StringUtils.isEmpty(k)) {
                this.columns.remove(k);
                return;
            }
            String[] split = k.split("\\.");
            if (split.length != 3) {
                this.columns.remove(k);
                return;
            }
            if (!StringUtils.equals(split[0], collection) || !StringUtils.equals(split[2], isOutput)) continue;
            this.columns.remove(k);
        }
    }

    public void addUser(String userName, List<RoleDb> dbList) {
        this.user.put(userName, dbList);
    }

    public static RoleDb addRoleDb(String role, String db) {
        RoleDb roleDb = new RoleDb();
        roleDb.role = role;
        roleDb.db = db;
        return roleDb;
    }

    public static class RoleDb {
        public String role;
        public String db;
    }

    public static class Column {
        public String name;
        public String collection;
        public boolean isOutput;
        public List<MongoNode> refs = new ArrayList<MongoNode>();
    }
}

