/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import com.alibaba.druid.DbType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonValue;
import util.StringJoin;
import util.sqlparse.visitor.common.Objects;
import util.sqlparse.visitor.common.names.NameWrapper;
import util.sqlparse.visitor.mongo.BsonArrayNode;
import util.sqlparse.visitor.mongo.BsonBasicNode;
import util.sqlparse.visitor.mongo.BsonKeyNode;
import util.sqlparse.visitor.mongo.BsonNode;
import util.sqlparse.visitor.mongo.BsonObjectNode;
import util.sqlparse.visitor.mongo.Identifier;
import util.sqlparse.visitor.mongo.MongoNode;
import util.sqlparse.visitor.mongo.MongoVisitor;
import util.sqlparse.visitor.mongo.ParseResult;

public class ScopeVisitor
implements MongoVisitor<ParseResult> {
    private ParseResult result;
    private DataBase dataBase;
    private String schema;

    public ParseResult getResult() {
        return this.result;
    }

    public ScopeVisitor(DataBase dataBase, String schema) {
        this.dataBase = dataBase;
        this.schema = schema;
        this.result = new ParseResult();
    }

    @Override
    public ParseResult visitFind(MongoNode context) {
        this.loadSchema(context);
        this.result.sqlType = "select";
        BsonObjectNode ctx = (BsonObjectNode)context;
        Object find = ctx.get(Identifier.Find.code);
        String collection = find.value().toString();
        if (!this.checkCollection(collection)) {
            return new ParseResult();
        }
        this.result.addCollection(collection);
        BsonObjectNode filter = (BsonObjectNode)ctx.get(Identifier.Filter.code);
        this.visitFilter(collection, filter, false);
        BsonObjectNode projection = (BsonObjectNode)ctx.get(Identifier.Projection.code);
        if (projection == null || projection.size() == 0) {
            this.expandProjection(collection, ctx);
            projection = (BsonObjectNode)ctx.get(Identifier.Projection.code);
        }
        this.visitProjection(collection, projection);
        BsonObjectNode sort = (BsonObjectNode)ctx.get(Identifier.Sort.code);
        this.visitSort(collection, sort);
        return this.result;
    }

    private void expandProjection(String collection, BsonObjectNode ctx) {
        Table table = null;
        if (!this.dataBase.isRedis()) {
            Map<String, Table> tables = this.dataBase.simpleCache.getTables();
            String id = this.dataBase.simpleCache.getSchemaTableId(this.schema, collection);
            table = tables.get(id);
        } else {
            NameWrapper nameWrapper = NameWrapper.create(DbType.of(this.dataBase.getDbType()), this.dataBase.simpleCache);
            Schema schemaFromRedis = nameWrapper.getSchemaFromRedis(this.schema, this.dataBase.isCaseSensitive());
            table = nameWrapper.getTableFromRedis(schemaFromRedis, collection, this.dataBase.isCaseSensitive());
        }
        if (table != null && table.getColumnList() != null && table.getColumnList().size() > 0) {
            BsonObjectNode projection = new BsonObjectNode(Identifier.Projection.code, new BsonDocument());
            ctx.put(Identifier.Projection.code, projection);
            BsonDouble data = new BsonDouble(1.0);
            for (Column column : table.getColumnList()) {
                projection.put(column.getColumnName(), new BsonBasicNode(column.getColumnName(), (BsonValue)data));
            }
        }
    }

    private void visitSort(String collection, BsonObjectNode fields) {
        if (fields != null) {
            for (Map.Entry<String, MongoNode> entry : fields.children().entrySet()) {
                String key = entry.getKey();
                MongoNode value = entry.getValue();
                if (value.isKeyword()) continue;
                this.result.addColumn(collection, key, false, value);
            }
        }
    }

    private void visitProjection(String collection, BsonObjectNode fields) {
        block11: {
            if (fields == null) break block11;
            this.result.removeCollectionAllColumn(collection, "true");
            boolean _idShow = true;
            ArrayList<String> columnListTemp = new ArrayList<String>();
            boolean columnShow = true;
            List<Column> columnList = this.getColumns(collection);
            if (!CollectionUtils.isEmpty(columnList)) {
                for (Map.Entry<String, MongoNode> entry : fields.children().entrySet()) {
                    String key = entry.getKey();
                    MongoNode value = entry.getValue();
                    if (value.isKeyword()) continue;
                    if (value.value() instanceof Double) {
                        double show = (Double)value.value();
                        if (StringUtils.equals((String)key, (String)"_id")) {
                            if (show != 0.0) continue;
                            _idShow = false;
                            continue;
                        }
                        if (show == 0.0) {
                            columnShow = false;
                        }
                        columnListTemp.add(key);
                        continue;
                    }
                    if (!(value.value() instanceof String)) continue;
                    String name = value.value().toString();
                    if (name.substring(0, 1).equals("$")) {
                        name = name.substring(1);
                    }
                    columnListTemp.add(name);
                }
                if (_idShow && columnShow || !_idShow && !columnShow) {
                    columnListTemp.add("_id");
                }
                if (columnShow) {
                    for (String columnKey : columnListTemp) {
                        this.result.addColumn(collection, columnKey, true, fields);
                    }
                } else {
                    ArrayList<Column> filteredColumns = new ArrayList<Column>();
                    for (Column column : columnList) {
                        if (columnListTemp.contains(column.getColumnName())) continue;
                        this.result.addColumn(collection, column.getColumnName(), true, fields);
                        filteredColumns.add(column);
                    }
                }
            }
        }
    }

    private List<Column> getColumns(String collection) {
        Table table = null;
        List<Column> columnList = new ArrayList<Column>();
        if (!this.dataBase.isRedis()) {
            String id = this.dataBase.simpleCache.getSchemaTableId(this.schema, collection);
            table = this.dataBase.simpleCache.getTables().get(id);
        } else {
            NameWrapper nameWrapper = NameWrapper.create(DbType.of(this.dataBase.getDbType()), this.dataBase.simpleCache);
            Schema schemaFromRedis = nameWrapper.getSchemaFromRedis(this.schema, this.dataBase.isCaseSensitive());
            table = nameWrapper.getTableFromRedis(schemaFromRedis, collection, this.dataBase.isCaseSensitive());
        }
        if (Objects.nonNull(table) && CollectionUtils.isNotEmpty(table.getColumnList())) {
            columnList = table.getColumnList();
        }
        return columnList;
    }

    private boolean checkCollection(String collection) {
        Table table = null;
        if (!this.dataBase.isRedis()) {
            String id = this.dataBase.simpleCache.getSchemaTableId(this.schema, collection);
            table = this.dataBase.simpleCache.getTables().get(id);
        } else {
            NameWrapper nameWrapper = NameWrapper.create(DbType.of(this.dataBase.getDbType()), this.dataBase.simpleCache);
            Schema schemaFromRedis = nameWrapper.getSchemaFromRedis(this.schema, this.dataBase.isCaseSensitive());
            table = nameWrapper.getTableFromRedis(schemaFromRedis, collection, this.dataBase.isCaseSensitive());
        }
        return Objects.nonNull(table);
    }

    private int visitAggregateGroup(String collection, MongoNode json, boolean isOutput) {
        if (json != null && !StringUtils.equals((String)json.toString(), (String)"{}")) {
            if (json.type() == BsonNode.BsonNodeType.Basic) {
                String name;
                BsonBasicNode bfilter = (BsonBasicNode)json;
                if (bfilter.value() instanceof String && (name = (String)bfilter.value()) != null && name.length() > 0) {
                    if ("$$ROOT".equals(name)) {
                        return 1;
                    }
                    if (name.substring(0, 1).equals("$")) {
                        name = name.substring(1);
                    }
                    this.result.addColumn(collection, name, isOutput, json);
                }
            } else if (json.type() == BsonNode.BsonNodeType.Array) {
                BsonArrayNode afilter = (BsonArrayNode)json;
                for (MongoNode child : afilter.children) {
                    this.visitAggregateGroup(collection, child, isOutput);
                }
            } else {
                BsonObjectNode ofilter = (BsonObjectNode)json;
                if (ofilter.size() == 0) {
                    return 0;
                }
                Map<String, MongoNode> children = ofilter.children();
                for (Map.Entry<String, MongoNode> entry : children.entrySet()) {
                    int i = this.visitAggregateGroup(collection, entry.getValue(), isOutput);
                    if (i != 1) continue;
                    return 1;
                }
            }
            return 0;
        }
        return 0;
    }

    private void visitJsonValue(String collection, MongoNode json, boolean isOutput) {
        block6: {
            block7: {
                String name;
                if (json == null || StringUtils.equals((String)json.toString(), (String)"{}")) break block6;
                if (json.type() != BsonNode.BsonNodeType.Basic) break block7;
                BsonBasicNode bfilter = (BsonBasicNode)json;
                if (!(bfilter.value() instanceof String) || !StringUtils.isNotBlank((String)(name = (String)bfilter.value())) || name.length() <= 0) break block6;
                if (name.substring(0, 1).equals("$")) {
                    name = name.substring(1);
                }
                if (!this.checkColumn(collection, name)) break block6;
                this.result.addColumn(collection, name, isOutput, json);
                break block6;
            }
            if (json.type() == BsonNode.BsonNodeType.Array) {
                BsonArrayNode afilter = (BsonArrayNode)json;
                for (MongoNode child : afilter.children) {
                    this.visitJsonValue(collection, child, isOutput);
                }
            } else {
                BsonObjectNode ofilter = (BsonObjectNode)json;
                if (ofilter.size() == 0) {
                    return;
                }
                Map<String, MongoNode> children = ofilter.children();
                for (Map.Entry<String, MongoNode> entry : children.entrySet()) {
                    this.visitJsonValue(collection, entry.getValue(), isOutput);
                }
            }
        }
    }

    private boolean checkColumn(String collection, String columnName) {
        List<Column> columns = this.getColumns(collection);
        if (CollectionUtils.isEmpty(columns)) {
            return false;
        }
        for (Column column : columns) {
            if (!StringUtils.equals((String)columnName, (String)column.getColumnName())) continue;
            return true;
        }
        return false;
    }

    private void visitProject(String collection, BsonObjectNode json, boolean isOutput) {
        if (json != null && !StringUtils.equals((String)json.toString(), (String)"{}")) {
            this.visitProjection(collection, json);
        }
    }

    private void visitFilter(String collection, MongoNode filter, boolean isOutput) {
        block5: {
            block6: {
                if (filter == null || StringUtils.equals((String)filter.toString(), (String)"{}")) break block5;
                if (filter.type() != BsonNode.BsonNodeType.Basic) break block6;
                BsonBasicNode bfilter = (BsonBasicNode)filter;
                String name = bfilter.name;
                if (name == null || name.length() <= 0 || filter.isKeyword()) break block5;
                this.result.addColumn(collection, name, isOutput, filter);
                break block5;
            }
            if (filter.type() == BsonNode.BsonNodeType.Array) {
                BsonArrayNode afilter = (BsonArrayNode)filter;
                for (MongoNode child : afilter.children) {
                    this.visitFilter(collection, child, isOutput);
                }
            } else {
                BsonObjectNode ofilter = (BsonObjectNode)filter;
                if (ofilter.size() == 0) {
                    return;
                }
                Map<String, MongoNode> children = ofilter.children();
                for (Map.Entry<String, MongoNode> entry : children.entrySet()) {
                    this.visitFilter(collection, entry.getValue(), isOutput);
                }
            }
        }
    }

    @Override
    public ParseResult visitInsert(MongoNode ctx) {
        this.result.sqlType = "insert";
        this.loadSchema(ctx);
        BsonArrayNode array = (BsonArrayNode)ctx;
        BsonObjectNode insert = (BsonObjectNode)array.get(array.size() - 1);
        Object collectionCtx = insert.get(Identifier.Insert.code);
        String collection = collectionCtx.value().toString();
        if (!this.checkCollection(collection)) {
            return new ParseResult();
        }
        this.result.addCollection(collection);
        for (int i = 0; i < array.children.size() - 1; ++i) {
            this.visitObject(collection, (MongoNode)array.get(i), this.result, (List<String>)new ArrayList<String>());
        }
        return this.result;
    }

    private void visitObject(String collection, MongoNode node, ParseResult result, List<String> foots) {
        block5: {
            block7: {
                block6: {
                    if (node == null) break block5;
                    if (node.type() != BsonNode.BsonNodeType.Basic) break block6;
                    String colName = StringJoin.join(foots, ".") + node.getName();
                    result.addColumn(collection, colName, true, node);
                    break block5;
                }
                if (node.type() != BsonNode.BsonNodeType.Object) break block7;
                BsonObjectNode obj = (BsonObjectNode)node;
                for (Map.Entry<String, MongoNode> entry : obj.children().entrySet()) {
                    String name = entry.getKey();
                    MongoNode value = entry.getValue();
                    foots.add(name);
                    if (value.type() != BsonNode.BsonNodeType.Basic) {
                        this.visitObject(collection, value, result, foots);
                    }
                    result.addColumn(collection, name, true, node);
                    foots.remove(foots.size() - 1);
                }
                break block5;
            }
            if (node.type() != BsonNode.BsonNodeType.Array) break block5;
            BsonArrayNode array = (BsonArrayNode)node;
            if (array.children.size() > 0) {
                for (MongoNode child : array.children) {
                    if (child.type() == BsonNode.BsonNodeType.Basic) {
                        String colName = StringJoin.join(foots, ".");
                        result.addColumn(collection, colName, true, array);
                        continue;
                    }
                    this.visitObject(collection, child, result, foots);
                }
            }
        }
    }

    @Override
    public ParseResult visitUpdate(MongoNode ctx) {
        this.result.sqlType = "update";
        this.loadSchema(ctx);
        BsonArrayNode array = (BsonArrayNode)ctx;
        BsonObjectNode dataCtx = (BsonObjectNode)array.get(0);
        BsonObjectNode updateCtx = (BsonObjectNode)array.get(array.size() - 1);
        Object collectionCtx = updateCtx.get(Identifier.Update.code);
        String collection = collectionCtx.value().toString();
        if (this.checkCollection(collection)) {
            this.result.addCollection(collection);
            BsonObjectNode filter = (BsonObjectNode)dataCtx.get(Identifier.Query.code);
            this.visitFilter(collection, filter, false);
            BsonObjectNode update = (BsonObjectNode)dataCtx.get(Identifier.U.code);
            this.visitFilter(collection, update, true);
            List<MongoNode> sets = this.matchNodes(Identifier.Set.code, dataCtx);
            this.visitUpdateSets(collection, sets);
            MongoNode mergeObjects = this.matchNode(Identifier.MergeObjects.code, dataCtx);
            if (mergeObjects != null) {
                BsonObjectNode mergeCtx = (BsonObjectNode)mergeObjects;
                this.visitFilter(collection, mergeCtx, true);
            }
            return this.result;
        }
        return new ParseResult();
    }

    @Override
    public ParseResult visitFindAndModify(MongoNode ctx) {
        BsonObjectNode fieldsCtx;
        BsonObjectNode sortCtx;
        BsonObjectNode filter;
        this.loadSchema(ctx);
        BsonObjectNode objCtx = (BsonObjectNode)ctx;
        Object mongoNode = objCtx.get(Identifier.FindAndModify.code);
        String collection = mongoNode.value().toString();
        if (!this.checkCollection(collection)) {
            this.result.sqlType = "update";
            return new ParseResult();
        }
        this.result.addCollection(collection);
        Object update = objCtx.get(Identifier.Update.code);
        Object remove = objCtx.get(Identifier.Remove.code);
        Object var7 = objCtx.get(Identifier.Upsert.code);
        if (update != null) {
            this.result.sqlType = "update";
            BsonObjectNode updateSet = (BsonObjectNode)update;
            ArrayList<MongoNode> sets = new ArrayList<MongoNode>();
            for (Map.Entry<String, MongoNode> entry : updateSet.children().entrySet()) {
                sets.add(entry.getValue());
            }
            this.visitUpdateSets(collection, sets);
        }
        if (remove != null) {
            this.result.sqlType = "delete";
            this.expandProjection(collection, objCtx);
            this.visitProjection(collection, (BsonObjectNode)objCtx.get(Identifier.Projection.code));
        }
        if (Objects.nonNull(filter = (BsonObjectNode)objCtx.get(Identifier.Query.code))) {
            this.visitFilter(collection, filter, false);
        }
        if (Objects.nonNull(sortCtx = (BsonObjectNode)objCtx.get(Identifier.Sort.code))) {
            this.visitSort(collection, sortCtx);
        }
        if (Objects.nonNull(fieldsCtx = (BsonObjectNode)objCtx.get(Identifier.Fields.code))) {
            this.visitFields(collection, fieldsCtx, true);
        } else {
            this.expandProjection(collection, objCtx);
            this.visitProjection(collection, (BsonObjectNode)objCtx.get(Identifier.Projection.code));
        }
        return this.result;
    }

    private void visitFields(String collection, BsonObjectNode fieldsCtx, boolean isOutput) {
        for (Map.Entry<String, MongoNode> entry : fieldsCtx.children().entrySet()) {
            this.result.addColumn(collection, entry.getKey(), isOutput, fieldsCtx);
        }
    }

    private void visitUpdateSets(String collection, List<MongoNode> sets) {
        if (sets != null && sets.size() != 0) {
            for (MongoNode set : sets) {
                BsonNode setCtx;
                if (set.type() == BsonNode.BsonNodeType.Object) {
                    setCtx = (BsonObjectNode)set;
                    for (Map.Entry<String, MongoNode> entry : setCtx.children().entrySet()) {
                        String key = entry.getKey();
                        this.result.addColumn(collection, key, true, new BsonKeyNode(key, (BsonObjectNode)setCtx));
                    }
                    continue;
                }
                if (set.type() != BsonNode.BsonNodeType.Basic) continue;
                setCtx = (BsonBasicNode)set;
                String key = ((BsonBasicNode)setCtx).name;
                this.result.addColumn(collection, key, true, null);
            }
        }
    }

    @Override
    public ParseResult visitDelete(MongoNode ctx) {
        String id;
        this.loadSchema(ctx);
        this.result.sqlType = "delete";
        BsonArrayNode array = (BsonArrayNode)ctx;
        BsonObjectNode collectionCtx = (BsonObjectNode)array.get(array.size() - 1);
        String collection = collectionCtx.get(Identifier.Delete.code).value().toString();
        if (!this.checkCollection(collection)) {
            return new ParseResult();
        }
        this.result.addCollection(collection);
        for (int i = 0; i < array.children.size() - 1; ++i) {
            BsonObjectNode dataCtx = (BsonObjectNode)array.get(i);
            BsonObjectNode filter = (BsonObjectNode)dataCtx.get("q");
            this.visitFilter(collection, filter, false);
        }
        Map<String, Table> tables = this.dataBase.simpleCache.getTables();
        Table table = tables.get(id = this.dataBase.simpleCache.getSchemaTableId(this.schema, collection));
        if (table != null && table.getColumnList() != null && table.getColumnList().size() > 0) {
            for (Column column : table.getColumnList()) {
                this.result.addColumn(collection, column.getColumnName(), true, null);
            }
        }
        return this.result;
    }

    @Override
    public ParseResult visitCount(MongoNode ctx) {
        this.loadSchema(ctx);
        this.result.sqlType = "select";
        BsonObjectNode objCtx = (BsonObjectNode)ctx;
        Object collectionCtx = objCtx.get(Identifier.Count.code);
        String collection = collectionCtx.value().toString();
        if (this.checkCollection(collection)) {
            this.result.addCollection(collection);
            Object mongoNode = objCtx.get(Identifier.Query.code);
            this.visitFilter(collection, (MongoNode)mongoNode, false);
            return this.result;
        }
        return new ParseResult();
    }

    @Override
    public ParseResult visitAggregate(MongoNode ctx) {
        this.loadSchema(ctx);
        this.result.sqlType = "select";
        BsonObjectNode objNode = (BsonObjectNode)ctx;
        Object collectionCtx = objNode.get(Identifier.Aggregate.code);
        String collection = collectionCtx.value().toString();
        if (this.checkCollection(collection)) {
            this.result.addCollection(collection);
            BsonArrayNode pipeCtx = (BsonArrayNode)objNode.get(Identifier.Pipeline.code);
            int allColumn = 1;
            allColumn = this.visitPipeline(collection, pipeCtx, allColumn);
            if (allColumn == 1) {
                this.expandProjection(collection, objNode);
                this.visitProjection(collection, (BsonObjectNode)objNode.get(Identifier.Projection.code));
            }
            return this.result;
        }
        return new ParseResult();
    }

    private int visitPipeline(String collection, BsonArrayNode pipeCtx, int allColumn) {
        for (int i = 0; i < pipeCtx.children.size(); ++i) {
            BsonObjectNode pCtx = (BsonObjectNode)pipeCtx.get(i);
            BsonObjectNode facetCtx = (BsonObjectNode)pCtx.get(Identifier.Facet.code);
            if (facetCtx != null) {
                this.visitFacet(collection, facetCtx, true);
                allColumn = 0;
                continue;
            }
            BsonObjectNode unionWithCtx = (BsonObjectNode)pCtx.get(Identifier.UnionWith.code);
            if (unionWithCtx != null) {
                this.visitUnionWith(unionWithCtx, true);
                continue;
            }
            BsonObjectNode matchCtx = (BsonObjectNode)pCtx.get(Identifier.Match.code);
            if (matchCtx != null) {
                this.visitFilter(collection, matchCtx, false);
                continue;
            }
            BsonObjectNode groupCtx = (BsonObjectNode)pCtx.get(Identifier.Group.code);
            if (groupCtx != null) {
                allColumn = this.visitAggregateGroup(collection, groupCtx, true);
                continue;
            }
            BsonObjectNode bucketCtx = (BsonObjectNode)pCtx.get(Identifier.Bucket.code);
            if (bucketCtx != null) {
                this.visitBucket(collection, bucketCtx, true);
                allColumn = 0;
                continue;
            }
            BsonObjectNode bucketAuto = (BsonObjectNode)pCtx.get(Identifier.BucketAuto.code);
            if (bucketAuto != null) {
                this.visitBucketAuto(collection, bucketAuto, true);
                allColumn = 0;
                continue;
            }
            BsonObjectNode lookupCtx = (BsonObjectNode)pCtx.get(Identifier.Lookup.code);
            if (lookupCtx != null) {
                this.visitLookUp(lookupCtx, true);
                continue;
            }
            BsonObjectNode projectCtx = (BsonObjectNode)pCtx.get(Identifier.Project.code);
            if (projectCtx != null) {
                this.visitProject(collection, projectCtx, true);
                allColumn = 0;
                continue;
            }
            BsonObjectNode sortCtx = (BsonObjectNode)pCtx.get(Identifier.SORT.code);
            if (sortCtx != null) {
                this.visitSort(collection, sortCtx);
                continue;
            }
            Object sortByCountCtx = pCtx.get(Identifier.SortByCount.code);
            if (sortByCountCtx != null) {
                this.visitJsonValue(collection, (MongoNode)sortByCountCtx, true);
                allColumn = 0;
                continue;
            }
            Object outCtx = pCtx.get(Identifier.Out.code);
            if (outCtx != null) {
                this.visitOut((MongoNode)outCtx, true);
                continue;
            }
            Object replaceRootCtx = pCtx.get(Identifier.ReplaceRoot.code);
            if (replaceRootCtx != null) {
                this.visitJsonValue(collection, (MongoNode)replaceRootCtx, true);
                allColumn = 0;
                continue;
            }
            Object mergeCtx = pCtx.get(Identifier.Merge.code);
            if (mergeCtx != null) {
                this.visitMerge(collection, (MongoNode)mergeCtx, true);
                allColumn = 0;
                continue;
            }
            Object unsetCtx = pCtx.get(Identifier.Unset.code);
            if (unsetCtx != null) {
                this.visitUnset(collection, (MongoNode)unsetCtx, true);
                allColumn = 0;
                continue;
            }
            BsonObjectNode graphLookupCtx = (BsonObjectNode)pCtx.get(Identifier.GraphLookup.code);
            if (graphLookupCtx == null) continue;
            this.visitGraphLookupCtx(graphLookupCtx, true);
        }
        return allColumn;
    }

    private void visitGraphLookupCtx(BsonObjectNode graphLookupCtx, boolean isOutput) {
        Object from = graphLookupCtx.get(Identifier.From.code);
        String collection = from.value().toString();
        if (this.checkCollection(collection)) {
            this.result.addCollection(collection);
            this.resultAddAllColumn(collection, isOutput);
        }
    }

    private void resultAddAllColumn(String collection, boolean isOutput) {
        if (!StringUtils.isEmpty((String)collection)) {
            for (Column column : this.getColumns(collection)) {
                this.result.addColumn(collection, column.getColumnName(), isOutput, null);
            }
        }
    }

    private void visitUnset(String collection, MongoNode unsetCtx, boolean isOutput) {
        block3: {
            List<Column> columns;
            block4: {
                columns = this.getColumns(collection);
                if (CollectionUtils.isEmpty(columns)) break block3;
                if (unsetCtx.type() != BsonNode.BsonNodeType.Basic) break block4;
                BsonBasicNode columnBasic = (BsonBasicNode)unsetCtx;
                String columnName = columnBasic.value().toString();
                for (Column column : columns) {
                    if (StringUtils.equals((String)columnName, (String)column.getColumnName())) continue;
                    this.result.addColumn(collection, column.getColumnName(), true, columnBasic);
                }
                break block3;
            }
            if (unsetCtx.type() != BsonNode.BsonNodeType.Array) break block3;
            BsonArrayNode columnArray = (BsonArrayNode)unsetCtx;
            int size = columnArray.size();
            ArrayList<String> excludeList = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                BsonBasicNode mongoNode = (BsonBasicNode)columnArray.get(i);
                excludeList.add(mongoNode.value().toString());
            }
            for (Column column : columns) {
                if (excludeList.contains(column.getColumnName())) continue;
                this.result.addColumn(collection, column.getColumnName(), true, unsetCtx);
            }
        }
    }

    private void visitUnionWith(BsonObjectNode unionWithCtx, boolean isOutput) {
        BsonArrayNode pipeCtx;
        int allColumn = 1;
        Map<String, MongoNode> map = unionWithCtx.children();
        MongoNode mongoNode = map.get(Identifier.Coll.code);
        String collection = mongoNode.value().toString();
        if (this.checkCollection(collection)) {
            this.result.addCollection(mongoNode.value().toString());
        }
        if ((pipeCtx = (BsonArrayNode)map.get(Identifier.Pipeline.code)) != null) {
            allColumn = this.visitPipeline(collection, pipeCtx, allColumn);
        }
        if (allColumn == 1) {
            this.expandProjection(collection, unionWithCtx);
            this.visitProjection(collection, (BsonObjectNode)unionWithCtx.get(Identifier.Projection.code));
        }
    }

    private void visitMerge(String collection, MongoNode mergeCtx, boolean isOutput) {
        if (mergeCtx != null && !StringUtils.equals((String)mergeCtx.toString(), (String)"{}")) {
            BsonObjectNode ofilter = (BsonObjectNode)mergeCtx;
            Map<String, MongoNode> map = ofilter.children();
            MongoNode mongoNode = map.get(Identifier.Into.code);
            String newCollection = null;
            if (mongoNode.type() == BsonNode.BsonNodeType.Basic) {
                newCollection = mongoNode.value().toString();
                this.result.addCollection(newCollection);
            } else if (mongoNode.type() == BsonNode.BsonNodeType.Object) {
                BsonObjectNode value = (BsonObjectNode)mongoNode;
                Map<String, MongoNode> children = value.children();
                BsonBasicNode db = (BsonBasicNode)children.get(Identifier.Db.code);
                this.result.addSchema(db.value().toString());
                BsonBasicNode coll = (BsonBasicNode)children.get(Identifier.Coll.code);
                newCollection = coll.value().toString();
                this.result.addCollection(newCollection);
            }
            MongoNode on = map.get(Identifier.On.code);
            if (on != null) {
                if (on.type() == BsonNode.BsonNodeType.Basic) {
                    BsonBasicNode bfilter = (BsonBasicNode)on;
                    String name = (String)bfilter.value();
                    this.result.addColumn(newCollection, name, isOutput, bfilter);
                } else if (on.type() == BsonNode.BsonNodeType.Array) {
                    BsonArrayNode afilter = (BsonArrayNode)on;
                    for (MongoNode child : afilter.children) {
                        BsonBasicNode node = (BsonBasicNode)child;
                        String name = (String)node.value();
                        this.result.addColumn(newCollection, name, isOutput, node);
                    }
                }
            }
        }
    }

    private void visitOut(MongoNode outCtx, boolean isOutput) {
        if (outCtx.type() == BsonNode.BsonNodeType.Basic) {
            BsonBasicNode mongoNodeCtx = (BsonBasicNode)outCtx;
            this.result.addCollection(mongoNodeCtx.value().toString());
        } else if (outCtx.type() == BsonNode.BsonNodeType.Object) {
            BsonObjectNode mongoNodeCtx = (BsonObjectNode)outCtx;
            Map<String, MongoNode> map = mongoNodeCtx.children();
            BsonBasicNode db = (BsonBasicNode)map.get(Identifier.Db.code);
            this.result.addSchema(db.value().toString());
            BsonBasicNode collection = (BsonBasicNode)map.get(Identifier.Coll.code);
            this.result.addCollection(collection.value().toString());
        }
    }

    private void visitFacet(String collection, BsonObjectNode facetCtx, boolean isOutput) {
        Map<String, MongoNode> children = facetCtx.children();
        for (Map.Entry<String, MongoNode> entry : children.entrySet()) {
            BsonArrayNode arrayNode = (BsonArrayNode)entry.getValue();
            for (MongoNode mongoNode : arrayNode.children()) {
                BsonObjectNode mongoNodeObject = (BsonObjectNode)mongoNode;
                Map<String, MongoNode> childrenNodeLast = mongoNodeObject.children();
                for (Map.Entry<String, MongoNode> nodeLast : childrenNodeLast.entrySet()) {
                    MongoNode value = nodeLast.getValue();
                    if (value.type() == BsonNode.BsonNodeType.Basic) {
                        BsonBasicNode basicCtx = (BsonBasicNode)value;
                        this.visitJsonValue(collection, basicCtx, true);
                        continue;
                    }
                    if (StringUtils.equals((String)nodeLast.getKey(), (String)Identifier.Match.code)) {
                        this.visitFilter(collection, (BsonObjectNode)value, false);
                        continue;
                    }
                    if (StringUtils.equals((String)nodeLast.getKey(), (String)Identifier.BucketAuto.code)) {
                        this.visitBucketAuto(collection, (BsonObjectNode)value, true);
                        continue;
                    }
                    if (!StringUtils.equals((String)nodeLast.getKey(), (String)Identifier.Bucket.code)) continue;
                    this.visitBucket(collection, (BsonObjectNode)value, true);
                }
            }
        }
    }

    private void visitSet(String collection, BsonObjectNode setCtx, boolean isOutput) {
        this.visitJsonValue(collection, setCtx, true);
    }

    private void visitBucketAuto(String collection, BsonObjectNode bucketAutoCtx, boolean isOutput) {
        BsonObjectNode outputCtx;
        Map<String, MongoNode> children = bucketAutoCtx.children();
        BsonBasicNode groupByCtx = (BsonBasicNode)children.get(Identifier.GroupBy.code);
        if (groupByCtx != null) {
            this.visitJsonValue(collection, groupByCtx, true);
        }
        if ((outputCtx = (BsonObjectNode)bucketAutoCtx.get(Identifier.Output.code)) != null) {
            this.visitBucketOutput(collection, outputCtx, true);
        }
    }

    private void visitBucket(String collection, BsonObjectNode bucketCtx, boolean isOutput) {
        BsonObjectNode outputCtx;
        Map<String, MongoNode> children = bucketCtx.children();
        BsonBasicNode groupByCtx = (BsonBasicNode)children.get(Identifier.GroupBy.code);
        if (groupByCtx != null) {
            this.visitFilter(collection, groupByCtx, false);
        }
        if ((outputCtx = (BsonObjectNode)bucketCtx.get(Identifier.Output.code)) != null) {
            this.visitBucketOutput(collection, outputCtx, true);
        }
    }

    private void visitBucketOutput(String collection, BsonObjectNode outputCtx, boolean isOutput) {
        if (outputCtx != null && !StringUtils.equals((String)outputCtx.toString(), (String)"{}")) {
            Map<String, MongoNode> children = outputCtx.children();
            for (Map.Entry<String, MongoNode> entry : children.entrySet()) {
                this.visitJsonValue(collection, entry.getValue(), true);
            }
        }
    }

    private void visitLookUp(BsonObjectNode lookupCtx, boolean isOutput) {
        Object from = lookupCtx.get(Identifier.From.code);
        String collection = from.value().toString();
        if (this.checkCollection(collection)) {
            this.result.addCollection(collection);
            BsonArrayNode pipeCtx = (BsonArrayNode)lookupCtx.get(Identifier.Pipeline.code);
            if (pipeCtx == null) {
                this.expandProjection(collection, lookupCtx);
                this.visitProjection(collection, (BsonObjectNode)lookupCtx.get(Identifier.Projection.code));
            } else {
                int allColumn = 1;
                for (int i = 0; i < pipeCtx.children.size(); ++i) {
                    BsonObjectNode pCtx = (BsonObjectNode)pipeCtx.get(i);
                    BsonObjectNode matchCtx = (BsonObjectNode)pCtx.get(Identifier.Match.code);
                    if (matchCtx != null) {
                        this.visitFilter(collection, matchCtx, false);
                        continue;
                    }
                    BsonObjectNode groupCtx = (BsonObjectNode)pCtx.get(Identifier.Group.code);
                    if (groupCtx != null) {
                        allColumn = this.visitAggregateGroup(collection, groupCtx, true);
                        continue;
                    }
                    BsonObjectNode projectCtx = (BsonObjectNode)pCtx.get(Identifier.Project.code);
                    if (projectCtx != null) {
                        allColumn = 0;
                        this.visitProject(collection, projectCtx, true);
                        continue;
                    }
                    BsonObjectNode sortCtx = (BsonObjectNode)pCtx.get(Identifier.SORT.code);
                    if (sortCtx == null) continue;
                    this.visitSort(collection, sortCtx);
                }
                if (allColumn == 1) {
                    this.expandProjection(collection, lookupCtx);
                    this.visitProjection(collection, (BsonObjectNode)lookupCtx.get(Identifier.Projection.code));
                }
            }
        }
    }

    @Override
    public ParseResult visitDistinct(MongoNode ctx) {
        this.loadSchema(ctx);
        this.result.sqlType = "select";
        BsonObjectNode objNode = (BsonObjectNode)ctx;
        Object collectionCtx = objNode.get(Identifier.Distinct.code);
        String collection = collectionCtx.value().toString();
        if (this.checkCollection(collection)) {
            this.result.addCollection(collection);
            Object keyCtx = objNode.get(Identifier.Key.code);
            if (keyCtx.type() == BsonNode.BsonNodeType.Basic) {
                this.result.addColumn(collection, keyCtx.value().toString(), true, (MongoNode)keyCtx);
            }
            BsonObjectNode queryCtx = (BsonObjectNode)objNode.get(Identifier.Query.code);
            this.visitFilter(collection, queryCtx, false);
            return this.result;
        }
        return new ParseResult();
    }

    @Override
    public ParseResult visitDrop(MongoNode ctx) {
        this.loadSchema(ctx);
        this.result.sqlType = "drop";
        BsonObjectNode objNode = (BsonObjectNode)ctx;
        Object collectionCtx = objNode.get(Identifier.Drop.code);
        String collection = collectionCtx.value().toString();
        if (this.checkCollection(collection)) {
            this.result.addCollection(collection);
            return this.result;
        }
        return new ParseResult();
    }

    @Override
    public ParseResult visitCreate(MongoNode ctx) {
        return null;
    }

    @Override
    public ParseResult visitCreateIndexes(MongoNode ctx) {
        this.loadSchema(ctx);
        this.result.sqlType = "createIndexes";
        BsonObjectNode createIndexesCtx = (BsonObjectNode)ctx;
        Object indexNode = createIndexesCtx.get(Identifier.CreateIndexes.code);
        String collection = indexNode.value().toString();
        if (!this.checkCollection(collection)) {
            return new ParseResult();
        }
        this.result.addCollection(collection);
        BsonArrayNode indexes = (BsonArrayNode)createIndexesCtx.get(Identifier.Indexes.code);
        for (int i = 0; i < indexes.size(); ++i) {
            BsonObjectNode mongoNode = (BsonObjectNode)indexes.get(i);
            this.visitIndexAddColumn(collection, mongoNode);
        }
        return this.result;
    }

    private void visitIndexAddColumn(String collection, BsonObjectNode indexKey) {
        BsonObjectNode keys = (BsonObjectNode)indexKey.get(Identifier.Key.code);
        Map<String, MongoNode> children = keys.children();
        if (children.containsKey(Identifier.AllColumnsIndex.code)) {
            this.resultAddAllColumn(collection, false);
        } else {
            this.visitFilter(collection, keys, false);
        }
    }

    @Override
    public ParseResult visitDropIndexes(MongoNode ctx) {
        this.loadSchema(ctx);
        this.result.sqlType = "dropIndexes";
        BsonObjectNode dropIndexesCtx = (BsonObjectNode)ctx;
        Object indexNode = dropIndexesCtx.get(Identifier.DropIndexes.code);
        String collection = indexNode.value().toString();
        if (this.checkCollection(collection)) {
            this.result.addCollection(collection);
            Object keys = dropIndexesCtx.get(Identifier.Index.code);
            if (keys.type() == BsonNode.BsonNodeType.Object) {
                this.visitFilter(collection, (MongoNode)keys, false);
            }
            return this.result;
        }
        return new ParseResult();
    }

    @Override
    public ParseResult visitReIndex(MongoNode ctx) {
        this.loadSchema(ctx);
        this.result.sqlType = "reIndex";
        BsonObjectNode dropIndexesCtx = (BsonObjectNode)ctx;
        Object indexNode = dropIndexesCtx.get(Identifier.ReIndex.code);
        String collection = indexNode.value().toString();
        if (this.checkCollection(collection)) {
            this.result.addCollection(collection);
            return this.result;
        }
        return new ParseResult();
    }

    @Override
    public ParseResult visitRenameCollection(MongoNode ctx) {
        this.result.sqlType = "renameCollection";
        BsonObjectNode renameCollectionCtx = (BsonObjectNode)ctx;
        Object name = renameCollectionCtx.get(Identifier.RenameCollection.code);
        String dbAndCollection = name.value().toString();
        String[] split = dbAndCollection.split("\\.");
        String db = split[0];
        this.result.addSchema(db);
        String collection = split[1];
        if (this.checkCollection(collection)) {
            this.result.addCollection(collection);
            return this.result;
        }
        return new ParseResult();
    }

    @Override
    public ParseResult visitMapreduce(MongoNode ctx) {
        this.loadSchema(ctx);
        this.result.sqlType = "select";
        BsonObjectNode mapreduceCtx = (BsonObjectNode)ctx;
        Object mapreduce = mapreduceCtx.get(Identifier.Mapreduce.code);
        String collection = mapreduce.value().toString();
        if (this.checkCollection(collection)) {
            BsonObjectNode sortCtx;
            BsonObjectNode query;
            this.result.addCollection(collection);
            BsonBasicNode map = (BsonBasicNode)mapreduceCtx.get(Identifier.Map.code);
            String mapString = map.getValue().toString();
            String[] split = mapString.split("this.");
            int length = split.length;
            String column = split[1].substring(0, split[1].indexOf(","));
            this.result.addColumn(collection, column, true, ctx);
            if (length == 3) {
                String columnTwo = split[2].substring(0, split[2].indexOf(")"));
                this.result.addColumn(collection, columnTwo, true, ctx);
            }
            if ((query = (BsonObjectNode)mapreduceCtx.get(Identifier.Query.code)) != null) {
                this.visitFilter(collection, query, false);
            }
            if ((sortCtx = (BsonObjectNode)mapreduceCtx.get(Identifier.Sort.code)) != null) {
                this.visitSort(collection, sortCtx);
            }
            return this.result;
        }
        return new ParseResult();
    }

    @Override
    public ParseResult visitCreateUser(MongoNode ctx) {
        this.result.sqlType = "user";
        BsonObjectNode createUserCtx = (BsonObjectNode)ctx;
        Object createUser = createUserCtx.get(Identifier.CreateUser.code);
        String userName = createUser.value().toString();
        List<ParseResult.RoleDb> roleDbList = this.getRoleDbs(createUserCtx);
        this.result.addUser(userName, roleDbList);
        return this.result;
    }

    @Override
    public ParseResult visitSaslSupportedMechs(MongoNode ctx) {
        this.result.sqlType = "user";
        BsonObjectNode loginCtx = (BsonObjectNode)ctx;
        Object loginUser = loginCtx.get(Identifier.SaslSupportedMechs.code);
        String userName = loginUser.value().toString().split("\\.")[1];
        this.result.addUser(userName, null);
        return this.result;
    }

    @Override
    public ParseResult visitUpdateUser(MongoNode ctx) {
        this.result.sqlType = "user";
        BsonObjectNode loginCtx = (BsonObjectNode)ctx;
        Object updateUser = loginCtx.get(Identifier.UpdateUser.code);
        String userName = updateUser.value().toString();
        List<ParseResult.RoleDb> roleDbList = this.getRoleDbs(loginCtx);
        if (CollectionUtils.isEmpty(roleDbList)) {
            this.result.addUser(userName, null);
        } else {
            this.result.addUser(userName, roleDbList);
        }
        return this.result;
    }

    @Override
    public ParseResult visitUsersInfo(MongoNode ctx) {
        this.result.sqlType = "user";
        BsonObjectNode loginCtx = (BsonObjectNode)ctx;
        Object usersInfo = loginCtx.get(Identifier.UsersInfo.code);
        String userName = usersInfo.value().toString();
        this.result.addUser(userName, null);
        return this.result;
    }

    @Override
    public ParseResult visitGrantRolesToUser(MongoNode ctx) {
        this.result.sqlType = "user";
        BsonObjectNode grantCtx = (BsonObjectNode)ctx;
        Object usersInfo = grantCtx.get(Identifier.GrantRolesToUser.code);
        String userName = usersInfo.value().toString();
        List<ParseResult.RoleDb> roleDbList = this.getRoleDbs(grantCtx);
        this.result.addUser(userName, roleDbList);
        return this.result;
    }

    @Override
    public ParseResult visitRevokeRolesFromUser(MongoNode ctx) {
        this.result.sqlType = "user";
        BsonObjectNode grantCtx = (BsonObjectNode)ctx;
        Object usersInfo = grantCtx.get(Identifier.RevokeRolesFromUser.code);
        String userName = usersInfo.value().toString();
        List<ParseResult.RoleDb> roleDbList = this.getRoleDbs(grantCtx);
        this.result.addUser(userName, roleDbList);
        return this.result;
    }

    @Override
    public ParseResult visitDropUser(MongoNode ctx) {
        this.result.sqlType = "user";
        BsonObjectNode grantCtx = (BsonObjectNode)ctx;
        Object usersInfo = grantCtx.get(Identifier.DropUser.code);
        String userName = usersInfo.value().toString();
        this.result.addUser(userName, null);
        return this.result;
    }

    @Override
    public ParseResult visitCreateCollection(MongoNode ctx) {
        return null;
    }

    private List<ParseResult.RoleDb> getRoleDbs(BsonObjectNode grantCtx) {
        BsonArrayNode roles = (BsonArrayNode)grantCtx.get(Identifier.Roles.code);
        ArrayList<ParseResult.RoleDb> roleDbList = new ArrayList<ParseResult.RoleDb>();
        if (Objects.nonNull(roles)) {
            for (int i = 0; i < roles.size(); ++i) {
                if (roles.get(i).type() == BsonNode.BsonNodeType.Basic) continue;
                BsonObjectNode roleAndDb = (BsonObjectNode)roles.get(i);
                ParseResult.RoleDb roleDb = ParseResult.addRoleDb(roleAndDb.get(Identifier.Role.code).value().toString(), roleAndDb.get(Identifier.Db.code).value().toString());
                roleDbList.add(roleDb);
            }
        }
        return roleDbList;
    }

    @Override
    public ParseResult visitCommand(MongoNode ctx) {
        this.loadSchema(ctx);
        return null;
    }

    private MongoNode matchNode(String match, MongoNode from) {
        List<MongoNode> mongoNodes = this.matchNodes(match, from);
        return mongoNodes != null && mongoNodes.size() != 0 ? mongoNodes.get(0) : null;
    }

    private List<MongoNode> matchNodes(String match, MongoNode from) {
        ArrayList<MongoNode> list;
        block6: {
            block5: {
                if (from == null) {
                    return new ArrayList<MongoNode>();
                }
                list = new ArrayList<MongoNode>();
                if (from.type() == BsonNode.BsonNodeType.Basic) {
                    return list;
                }
                if (from.type() != BsonNode.BsonNodeType.Object) break block5;
                BsonObjectNode ctx = (BsonObjectNode)from;
                for (Map.Entry<String, MongoNode> entry : ctx.children().entrySet()) {
                    if (entry.getKey().equals(match)) {
                        list.add(entry.getValue());
                    }
                    list.addAll(this.matchNodes(match, entry.getValue()));
                }
                break block6;
            }
            if (from.type() != BsonNode.BsonNodeType.Array) break block6;
            BsonArrayNode ctx = (BsonArrayNode)from;
            for (MongoNode child : ctx.children()) {
                list.addAll(this.matchNodes(match, child));
            }
        }
        return list;
    }

    private void loadSchema(MongoNode ctx) {
        BsonObjectNode objCtx;
        Object node;
        if (this.result.statement != null) {
            this.result.statement = ctx;
        }
        if (ctx.type() == BsonNode.BsonNodeType.Array) {
            BsonArrayNode array = (BsonArrayNode)ctx;
            Object last = array.get(array.size() - 1);
            this.loadSchema((MongoNode)last);
        } else if (ctx.type() == BsonNode.BsonNodeType.Object && (node = (objCtx = (BsonObjectNode)ctx).get(Identifier.DB.code)) != null) {
            this.schema = node.value().toString();
            this.result.schemas.add(this.schema);
        }
    }
}

