/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.mongo.test;

import com.alibaba.fastjson.JSONObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinarySubType;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.bson.json.JsonMode;
import org.bson.json.JsonReader;
import org.bson.json.JsonWriterSettings;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

public class BsonTest {
    public static void main(String[] args) throws DecoderException {
        BsonTest.bsonDecode();
    }

    public static void main2() {
        MongoClient client = new MongoClient("127.0.0.1", 27017);
        MongoDatabase database = client.getDatabase("test");
        MongoCollection collection = database.getCollection("te");
        System.out.println(collection.find().first());
        try {
            BsonDocument command = new BsonDocument("dbStats", (BsonValue)new BsonInt64(1L));
            Document commandResult = database.runCommand((Bson)command);
            System.out.println("dbStats: " + commandResult.toJson());
            String hex = "007b0000000266696e64000a000000696e76656e746f7279000366696c74657200280000000474616773001d000000023000040000007265640002310006000000626c616e6b000000036c736964001e000000056964001000000004d12a705c73d44ea8980ddec55dd75d7300022464620005000000746573740000";
            byte[] bytes = Hex.decodeHex((char[])hex.toCharArray());
            BsonDocument test2 = new BsonDocumentCodec().decode((BsonReader)new BsonBinaryReader(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN)), DecoderContext.builder().build());
            test2.remove((Object)"$db");
            commandResult = database.runCommand((Bson)test2);
            System.out.println("result: " + commandResult.toJson());
            BasicOutputBuffer output = new BasicOutputBuffer();
            new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter((BsonOutput)output), test2, EncoderContext.builder().build());
            List ob = output.getByteBuffers();
            byte[] bytes3 = output.toByteArray();
            System.out.println(Hex.encodeHex((byte[])bytes3));
            BsonDocument test3 = new BsonDocumentCodec().decode((BsonReader)new BsonBinaryReader(ByteBuffer.wrap(bytes3).order(ByteOrder.LITTLE_ENDIAN)), DecoderContext.builder().build());
            System.out.println(test3);
        }
        catch (MongoException me) {
            System.err.println("An error occurred: " + (Object)((Object)me));
        }
        catch (DecoderException me) {
            System.err.println("An error occurred: " + (Object)((Object)me));
        }
    }

    private static void bsonDecode() throws DecoderException {
        String hex = "e70000000261676772656761746500070000006f72646572730004706970656c696e6500830000000330007b00000003246d61746368006e00000003246578707200620000000424616e6400570000000330002400000004246774001a0000000230000700000024707269636500103100640000000000033100280000000424677465001d0000000230000a000000247175616e7469747900103100050000000000000000000003637572736f72000500000000036c736964001e000000056964001000000004425309d427094734b76eb480aa4c253f00022464620005000000746573740000";
        byte[] bytes = Hex.decodeHex((char[])hex.toCharArray());
        BSONObject decode = BSON.decode((byte[])bytes);
        System.out.println(decode.toString());
        Bson bson = Filters.gt((String)"a", (Object)10);
        BsonDocument bsonDocument = bson.toBsonDocument(BsonDocument.class, MongoClient.getDefaultCodecRegistry());
        System.out.println(bsonDocument.toString());
        byte[] array = new BigInteger("130000001069734d6173746572000100000000", 16).toByteArray();
        BasicBSONDecoder decoder = new BasicBSONDecoder();
        BSONObject bsonObject = decoder.readObject(array);
        System.out.println(bsonObject.toString());
        JSONObject json = new JSONObject(decode.toMap());
        System.out.println(json);
        BsonDocument test2 = new BsonDocumentCodec().decode((BsonReader)new BsonBinaryReader(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN)), DecoderContext.builder().build());
        System.out.println(test2.toString());
        BsonDocument test22 = new BsonDocumentCodec().decode((BsonReader)new JsonReader(test2.toString()), DecoderContext.builder().build());
        System.out.println(test22.toString());
        Document myDoc = new Document();
        try {
            myDoc.append("_id", (Object)new ObjectId("507f1f77bcf86cd799439012")).append("myNumber", (Object)11223344).append("id", (Object)new Binary(BsonBinarySubType.UUID_STANDARD, "ox8E0sqfQzW4ULnhWahC8A==".getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JsonWriterSettings settings = JsonWriterSettings.builder().outputMode(JsonMode.EXTENDED).build();
        System.out.println(myDoc.toJson(settings));
        UUID uuid4 = UUID.randomUUID();
        System.out.println(uuid4);
        byte[] bytes2 = new byte[16];
        BsonTest.writeLongToArrayLittleEndian(bytes2, 0, uuid4.getMostSignificantBits());
        BsonTest.writeLongToArrayLittleEndian(bytes2, 8, uuid4.getLeastSignificantBits());
        Document myDoc2 = new Document();
        myDoc2.append("_id", (Object)new ObjectId("507f1f77bcf86cd799439012")).append("myNumber", (Object)11223344).append("id", (Object)new Binary(BsonBinarySubType.UUID_STANDARD, bytes2));
        System.out.println(myDoc2.toJson(settings));
        Document myDoc3 = new Document();
        myDoc3.append("id", (Object)new Binary(BsonBinarySubType.UUID_STANDARD, bytes2));
        System.out.println(myDoc3.toJson(settings));
        BsonDocument myDoc4 = new BsonDocument();
        myDoc4.append("id", (BsonValue)new BsonJavaScript("function() {emit(this.cust_id, this.price);"));
        System.out.println(myDoc4.toJson(settings));
    }

    private static void writeLongToArrayLittleEndian(byte[] bytes, int offset, long x) {
        bytes[offset + 7] = (byte)(0xFFL & x);
        bytes[offset + 6] = (byte)(0xFFL & x >> 8);
        bytes[offset + 5] = (byte)(0xFFL & x >> 16);
        bytes[offset + 4] = (byte)(0xFFL & x >> 24);
        bytes[offset + 3] = (byte)(0xFFL & x >> 32);
        bytes[offset + 2] = (byte)(0xFFL & x >> 40);
        bytes[offset + 1] = (byte)(0xFFL & x >> 48);
        bytes[offset + 0] = (byte)(0xFFL & x >> 56);
    }
}

