/*
 * Decompiled with CFR 0.152.
 */
package util.sqlparse.visitor.oracle.visitor;

import bean.Column;
import bean.Synonym;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLPartition;
import com.alibaba.druid.sql.ast.SQLWindow;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLDbLinkExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleWithSubqueryEntry;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleJsonArrayAggExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleJsonObjectExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleSysdateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectJoin;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivotBase;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectUnPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.stat.TableStat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import util.sqlparse.visitor.common.Owner;
import util.sqlparse.visitor.common.memo.AliasField;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.ClauseScope;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.common.scope.TableScope;
import util.sqlparse.visitor.common.utils.Alias;
import util.sqlparse.visitor.oracle.visitor.ParseVisitor;

public class ScopeVisitor
extends ParseVisitor {
    private final Alias alias = new Alias();
    private boolean debug = false;

    public ScopeVisitor(Scope scope) {
        super(scope);
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        if (this.scope.context.sqlType == null) {
            this.scope.context.sqlType = TableStat.Mode.Select;
        }
        if (this.debug) {
            System.out.println("enter SQLSelectStatement " + x.toString());
        }
        this.enterClauseScope(x);
        return true;
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        if (this.scope.context.sqlType == null) {
            this.scope.context.sqlType = TableStat.Mode.Insert;
        }
        this.enterClauseScope(x);
        if (x.getWith() != null) {
            x.getWith().accept(this);
        }
        if (x.getTableSource() != null) {
            x.getTableSource().accept(this);
        }
        if (x.getColumns().size() == 0) {
            String schema = null;
            String table = null;
            OracleInsertStatement stmt = (OracleInsertStatement)x;
            if (stmt.getSelect() != null) {
                stmt.getSelect().accept(this);
            } else {
                List<Column> columns;
                SQLExprImpl expr;
                SQLName tableName = x.getTableName();
                if (tableName instanceof SQLIdentifierExpr) {
                    expr = (SQLIdentifierExpr)tableName;
                    table = ((SQLIdentifierExpr)expr).getName();
                    schema = this.scope.context.getSchema();
                } else if (tableName instanceof SQLPropertyExpr) {
                    expr = (SQLPropertyExpr)tableName;
                    table = ((SQLPropertyExpr)expr).getName();
                    schema = ((SQLPropertyExpr)expr).getOwnerName();
                }
                if (table != null && schema != null && (columns = this.scope.context.getColumns(schema, table)) != null && columns.size() > 0) {
                    for (Column column : columns) {
                        String name = this.scope.dialector.wrap(column.getColumnName());
                        SQLIdentifierExpr expr2 = new SQLIdentifierExpr(name);
                        x.getColumns().add(expr2);
                        expr2.setParent(x);
                    }
                }
            }
        }
        for (SQLExpr column : x.getColumns()) {
            column.accept(this);
            FieldMemo field = (FieldMemo)column.getAttribute("field");
            if (field == null) continue;
            field.isSelectItem = true;
        }
        if (x.getValuesList() != null) {
            for (SQLInsertStatement.ValuesClause clause : x.getValuesList()) {
                clause.accept(this);
            }
        }
        if (x.getQuery() != null) {
            x.getQuery().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleInsertStatement x) {
        return this.visit((SQLInsertStatement)x);
    }

    @Override
    public boolean visit(OracleMultiInsertStatement x) {
        if (this.scope.context.sqlType == null) {
            this.scope.context.sqlType = TableStat.Mode.Insert;
        }
        this.enterClauseScope(x);
        if (x.getSubQuery() != null) {
            x.getSubQuery().accept(this);
        }
        for (OracleMultiInsertStatement.Entry entry : x.getEntries()) {
            entry.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleMultiInsertStatement.InsertIntoClause x) {
        x.getTableSource().accept(this);
        Scope current = this.scope.getCurrent();
        TableMemo table = current.getTable(x.getTableSource().getExpr());
        List<FieldMemo> fields = current.expandAllColumns(table, false);
        if (x.getColumns() != null && x.getColumns().size() != 0) {
            for (SQLExpr column : x.getColumns()) {
                this.visitChild(column);
                FieldMemo field = (FieldMemo)column.getAttribute("field");
                if (field == null) continue;
                FieldMemo fieldCopy = field.copy();
                fieldCopy.isSelectItem = true;
                fieldCopy.table = table;
                fieldCopy.alias = field.name;
                current.addField(fieldCopy);
            }
        } else {
            for (FieldMemo field : fields) {
                SQLIdentifierExpr expr = new SQLIdentifierExpr();
                expr.setName(field.name);
                field.table = table;
                field.isSelectItem = true;
                field.alias = field.name;
                current.addField(field);
                x.addColumn(expr);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        if (this.scope.context.sqlType == null) {
            this.scope.context.sqlType = TableStat.Mode.Update;
        }
        this.enterClauseScope(x);
        if (x.getTableSource() != null) {
            x.getTableSource().accept(this);
        }
        if (x.getFrom() != null) {
            x.getFrom().accept(this);
        }
        for (int i = 0; i < x.getItems().size(); ++i) {
            SQLUpdateSetItem item = x.getItems().get(i);
            if (item == null) continue;
            item.accept(this);
        }
        if (x.getWhere() != null) {
            x.getWhere().accept(this);
        }
        if (x.getOrderBy() != null) {
            x.getOrderBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleUpdateStatement x) {
        return this.visit((SQLUpdateStatement)x);
    }

    @Override
    public boolean visit(SQLMergeStatement x) {
        if (this.scope.context.sqlType == null) {
            this.scope.context.sqlType = TableStat.Mode.Merge;
        }
        this.enterClauseScope(x);
        if (x.getInto() != null) {
            x.getInto().accept(this);
        }
        TableMemo intoTable = (TableMemo)x.getInto().getAttribute("table");
        if (x.getUsing() != null) {
            Scope usingScope;
            x.getUsing().accept(this);
            if (x.getUsing() instanceof OracleSelectSubqueryTableSource && (usingScope = this.scope.getScope(x.getUsing())) != null) {
                usingScope.top = true;
            }
        }
        if (x.getOn() != null) {
            x.getOn().accept(this);
        }
        if (x.getUpdateClause() != null) {
            x.getUpdateClause().putAttribute("intoTable", intoTable);
            x.getUpdateClause().accept(this);
        }
        if (x.getInsertClause() != null) {
            x.getInsertClause().putAttribute("intoTable", intoTable);
            x.getInsertClause().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLMergeStatement.MergeUpdateClause x) {
        TableMemo table = (TableMemo)x.getAttribute("intoTable");
        Scope current = this.scope.getCurrent();
        if (x.getItems() != null) {
            for (SQLUpdateSetItem item : x.getItems()) {
                SQLExpr column = item.getColumn();
                String name = null;
                if (column instanceof SQLName) {
                    name = ((SQLName)column).getSimpleName();
                }
                if (name == null) continue;
                FieldMemo field = new FieldMemo();
                field.alias = field.name = current.dialector.wrap(name.toUpperCase());
                field.table = table;
                field.tables.add(table);
                field.exprs.add(column);
                field.isSelectItem = true;
                field.ref = column;
                field.scope = current;
                current.addField(field);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLMergeStatement.MergeInsertClause x) {
        Scope current = this.scope.getCurrent();
        TableMemo table = (TableMemo)x.getAttribute("intoTable");
        if (x.getColumns().size() == 0) {
            for (FieldMemo field : current.expandAllColumns(table, false)) {
                SQLIdentifierExpr expr = new SQLIdentifierExpr();
                expr.setName(field.name);
                expr.setParent(x);
                x.getColumns().add(expr);
                field.tables.add(table);
                field.exprs.add(expr);
                field.ref = expr;
                field.scope = current;
                current.addField(field);
            }
        } else {
            for (SQLExpr column : x.getColumns()) {
                String name = null;
                if (column instanceof SQLName) {
                    name = ((SQLName)column).getSimpleName();
                }
                if (name == null) continue;
                name = current.dialector.wrap(name);
                FieldMemo field = new FieldMemo();
                field.name = name;
                field.alias = name;
                field.table = table;
                field.tables.add(table);
                field.exprs.add(column);
                field.isSelectItem = true;
                field.ref = column;
                field.scope = current;
                current.addField(field);
            }
        }
        current.openFieldState();
        if (x.getValues() != null) {
            this.acceptChild(x.getValues());
        }
        current.closeFieldState();
        return false;
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        if (this.scope.context.sqlType == null) {
            this.scope.context.sqlType = TableStat.Mode.Delete;
        }
        this.enterClauseScope(x);
        return true;
    }

    @Override
    public boolean visit(OracleDeleteStatement x) {
        return this.visit((SQLDeleteStatement)x);
    }

    @Override
    public boolean visit(SQLWithSubqueryClause x) {
        if (this.debug) {
            System.out.println("enter SQLWithSubqueryClause  " + x.toString());
        }
        ClauseScope scope = this.enterClauseScope(x);
        scope.top = true;
        scope.fromField = scope.isFromField(x);
        return true;
    }

    @Override
    public boolean visit(SQLWithSubqueryClause.Entry x) {
        TableScope scope = this.enterTableScope(x);
        scope.fromField = scope.isFromField(x);
        scope.top = true;
        if (x.getSubQuery() != null) {
            x.getSubQuery().accept(this);
        }
        TableMemo table = this.registerTable(x);
        table.topTable = true;
        x.putAttribute("table", table);
        x.putAttribute("scope", scope);
        scope.table = table;
        return false;
    }

    @Override
    public boolean visit(OracleWithSubqueryEntry x) {
        TableScope scope = this.enterTableScope(x);
        scope.fromField = scope.isFromField(x);
        scope.top = true;
        if (x.getSubQuery() != null) {
            x.getSubQuery().accept(this);
        }
        if (x.getSearchClause() != null) {
            x.getSearchClause().accept(this);
        }
        if (x.getCycleClause() != null) {
            x.getCycleClause().accept(this);
        }
        TableMemo table = this.registerTable(x);
        table.topTable = true;
        x.putAttribute("table", table);
        x.putAttribute("scope", scope);
        scope.table = table;
        return false;
    }

    @Override
    public void endVisit(OracleWithSubqueryEntry x) {
        this.endVisit((SQLWithSubqueryClause.Entry)x);
    }

    @Override
    public void endVisit(SQLWithSubqueryClause.Entry x) {
        if (this.debug) {
            System.out.println("enter SQLWithSubqueryClause.Entry  " + x.toString());
        }
        Scope current = this.scope.getCurrent();
        TableMemo table = (TableMemo)x.getAttribute("table");
        boolean addColumns = x.getColumns().size() == 0;
        ArrayList<FieldMemo> fields = new ArrayList<FieldMemo>();
        current.getSubFieldsForWith(fields);
        for (Scope child : current.getChildren()) {
            table.getChildren().addAll(child.getBranchTables());
        }
        int k = 0;
        for (FieldMemo field : fields) {
            FieldMemo newNameField = field.copy();
            newNameField.name = field.alias;
            newNameField.alias = field.alias;
            if (!addColumns) {
                SQLExpr expr = x.getColumns().get(k);
                SQLName exprName = (SQLName)expr;
                String fieldName = exprName.getSimpleName();
                if (this.isEqual(fieldName, field.alias)) {
                    newNameField.name = fieldName;
                    newNameField.alias = fieldName;
                }
                newNameField.ref = expr;
                newNameField.exprs.add(expr);
            } else {
                SQLIdentifierExpr name = new SQLIdentifierExpr();
                String fieldName = newNameField.name;
                for (AliasField aliasField : field.aliasFields) {
                    if (!aliasField.isOutput) continue;
                    fieldName = aliasField.alias;
                    break;
                }
                newNameField.name = fieldName;
                newNameField.alias = fieldName;
                name.setName(fieldName);
                x.getColumns().add(name);
                name.setParent(x);
                newNameField.ref = name;
                newNameField.exprs.add(name);
            }
            newNameField.table = table;
            newNameField.scope = current;
            newNameField.tables.add(table);
            newNameField.children.add(field);
            current.addField(newNameField);
            ++k;
        }
        this.scope.exitScope();
    }

    @Override
    public boolean visit(OracleSelectQueryBlock x) {
        SQLExprTableSource xf;
        SQLExpr expr;
        if (this.debug) {
            System.out.println("enter OracleSelectQueryBlock  " + x.toString());
        }
        this.enterClauseScope(x);
        this.scope.fromField = this.scope.isFromField(x);
        if (x.getFrom() != null) {
            this.parseView(x.getFrom(), x);
        } else {
            SQLIdentifierExpr tableName = new SQLIdentifierExpr();
            tableName.setName("dual");
            SQLExprTableSource tableSource = new SQLExprTableSource();
            tableSource.setExpr(tableName);
            tableSource.setParent(x);
            x.setFrom(tableSource);
        }
        SQLTableSource from = x.getFrom();
        if (from instanceof SQLExprTableSource && ((expr = (xf = (SQLExprTableSource)from).getExpr()) instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr)) {
            Synonym syn;
            Scope current = this.scope.getCurrent();
            if (expr instanceof SQLPropertyExpr) {
                SQLPropertyExpr propOwner = (SQLPropertyExpr)expr;
                String name = propOwner.getName();
                String schema = propOwner.getOwnerName();
                syn = current.dialector.getSynonym(schema, name);
                if (syn != null && syn.getTableName() != null) {
                    propOwner.setOwner(syn.getTableOwner());
                    propOwner.setName(syn.getTableName());
                }
            } else if (expr instanceof SQLIdentifierExpr) {
                String name;
                SQLIdentifierExpr idOnwer = (SQLIdentifierExpr)expr;
                String schema = current.getDefaultSchema();
                syn = current.dialector.getSynonym(schema, name = idOnwer.getName());
                if (syn != null && syn.getTableName() != null) {
                    SQLPropertyExpr propertyExpr = new SQLPropertyExpr();
                    propertyExpr.setOwner(syn.getTableOwner());
                    propertyExpr.setName(syn.getTableName());
                    xf.setExpr(propertyExpr);
                }
            }
        }
        x.getFrom().accept(this);
        this.parsePivotTableSource(x.getFrom());
        this.parseSelectList(x);
        if (x.getWindows() != null) {
            for (int i = 0; i < x.getWindows().size(); ++i) {
                SQLWindow item = x.getWindows().get(i);
                item.accept(this);
            }
        }
        if (x.getInto() != null) {
            x.getInto().accept(this);
        }
        if (x.getWhere() != null) {
            x.getWhere().accept(this);
        }
        if (x.getStartWith() != null) {
            x.getStartWith().accept(this);
        }
        if (x.getConnectBy() != null) {
            x.getConnectBy().accept(this);
        }
        if (x.getGroupBy() != null) {
            x.getGroupBy().accept(this);
        }
        if (x.getOrderBy() != null) {
            x.getOrderBy().accept(this);
        }
        if (x.getWaitTime() != null) {
            x.getWaitTime().accept(this);
        }
        if (x.getLimit() != null) {
            x.getLimit().accept(this);
        }
        if (x.getForUpdateOf() != null) {
            this.acceptChild(x.getForUpdateOf());
        }
        return false;
    }

    private void parsePivotTableSource(SQLTableSource tableSource) {
        boolean isPivot;
        Object pivotOptions = tableSource.getAttribute("pivot");
        boolean bl = isPivot = pivotOptions == null ? false : (Boolean)pivotOptions;
        if (isPivot) {
            OracleSelectPivotBase pivot = null;
            if (tableSource instanceof OracleSelectTableReference) {
                pivot = ((OracleSelectTableReference)tableSource).getPivot();
            } else if (tableSource instanceof OracleSelectJoin) {
                pivot = ((OracleSelectJoin)tableSource).getPivot();
            } else if (tableSource instanceof OracleSelectSubqueryTableSource) {
                pivot = ((OracleSelectSubqueryTableSource)tableSource).getPivot();
            }
            if (pivot != null) {
                if (pivot instanceof OracleSelectPivot) {
                    tableSource.putAttribute("pivot_reverse", false);
                    this.parsePivot((OracleSelectPivot)pivot);
                } else if (pivot instanceof OracleSelectUnPivot) {
                    tableSource.putAttribute("pivot_reverse", true);
                    this.parseUnPivot((OracleSelectUnPivot)pivot);
                }
            }
        }
    }

    private void parsePivot(OracleSelectPivot pivot) {
        Scope current = this.scope.getCurrent();
        List<OracleSelectPivot.Item> items = pivot.getItems();
        ArrayList<FieldMemo> aggColumns = new ArrayList<FieldMemo>();
        for (OracleSelectPivot.Item column : items) {
            Object name = column.getAlias();
            if (name == null) {
                name = column.getExpr().toString();
            }
            for (SQLExpr expr : this.scope.getSubFieldExprs(column.getExpr())) {
                FieldMemo memo = this.getOrCreateFieldByName(expr.toString(), true);
                memo.ref = expr;
                memo.exprs.add(column);
                aggColumns.add(memo);
            }
        }
        current.putAttribute("pivot-agg-fields", aggColumns);
        List<SQLExpr> forColumns = pivot.getPivotFor();
        ArrayList<FieldMemo> forFields = new ArrayList<FieldMemo>();
        for (SQLExpr forColumn : forColumns) {
            SQLName sqlName = (SQLName)forColumn;
            String name = sqlName.getSimpleName();
            FieldMemo field = this.getOrCreateFieldByName(name, true);
            field.ref = forColumn;
            field.exprs.add(forColumn);
            forFields.add(field);
        }
        current.putAttribute("pivot-for-fields", forFields);
        List<OracleSelectPivot.Item> columns = pivot.getPivotIn();
        ArrayList<FieldMemo> newFields = new ArrayList<FieldMemo>();
        for (OracleSelectPivot.Item column : columns) {
            String name = column.getAlias();
            if (name == null) {
                name = column.getExpr().toString();
            }
            FieldMemo memo = this.getOrCreateFieldByName(name, true);
            if (memo.name == null) {
                memo.alias = memo.name = name;
            }
            memo.ref = column;
            memo.exprs.add(column);
            newFields.add(memo);
        }
        for (FieldMemo newField : newFields) {
            newField.children.addAll(aggColumns);
        }
        current.putAttribute("pivot-in-fields", newFields);
    }

    private void parseUnPivot(OracleSelectUnPivot pivot) {
        FieldMemo memo;
        Scope current = this.scope.getCurrent();
        List<SQLExpr> items = pivot.getItems();
        ArrayList<Object> aggColumns = new ArrayList<Object>();
        for (SQLExpr column : items) {
            boolean isPrimitive = this.scope.isPrimitive(column);
            if (isPrimitive) {
                FieldMemo memo2 = this.getOrCreateFieldByName(column.toString());
                memo2.ref = column;
                memo2.exprs.add(column);
                aggColumns.add(memo2);
                continue;
            }
            for (SQLExpr expr : this.scope.getSubFieldExprs(column)) {
                memo = this.getOrCreateFieldByName(expr.toString());
                memo.ref = expr;
                memo.exprs.add(column);
                aggColumns.add(memo);
            }
        }
        current.putAttribute("pivot-agg-fields", aggColumns);
        List<OracleSelectPivot.Item> columns = pivot.getPivotIn();
        ArrayList<FieldMemo> newFields = new ArrayList<FieldMemo>();
        for (OracleSelectPivot.Item column : columns) {
            String name = column.getAlias();
            if (name == null) {
                name = column.getExpr().toString();
            }
            memo = this.getOrCreateFieldByName(name);
            memo.ref = column;
            memo.exprs.add(column);
            newFields.add(memo);
        }
        current.putAttribute("pivot-in-fields", newFields);
    }

    private List<FieldMemo> parsePivotColumns(SQLObject x, List<FieldMemo> source) {
        Scope current = this.scope.getCurrent();
        Object pivotOptions = x.getAttribute("pivot");
        if (pivotOptions == null) {
            return source;
        }
        if (!((Boolean)pivotOptions).booleanValue()) {
            return source;
        }
        ArrayList<FieldMemo> target = new ArrayList<FieldMemo>();
        target.addAll(source);
        boolean reverse = (Boolean)x.getAttribute("pivot_reverse");
        List aggColumns = (List)current.getAttribute("pivot-agg-fields");
        List forColumns = (List)current.getAttribute("pivot-for-fields");
        List inColumns = (List)current.getAttribute("pivot-in-fields");
        if (!reverse) {
            FieldMemo z;
            Iterator iterator;
            for (FieldMemo column : aggColumns) {
                iterator = target.iterator();
                while (iterator.hasNext()) {
                    z = (FieldMemo)iterator.next();
                    if (!this.isEqual(z.name, column.name)) continue;
                    iterator.remove();
                }
            }
            for (FieldMemo column : forColumns) {
                iterator = target.iterator();
                while (iterator.hasNext()) {
                    z = (FieldMemo)iterator.next();
                    if (!this.isEqual(z.name, column.name)) continue;
                    iterator.remove();
                }
            }
            target.addAll(inColumns);
        } else {
            for (FieldMemo column : inColumns) {
                Iterator iterator = target.iterator();
                while (iterator.hasNext()) {
                    FieldMemo z = (FieldMemo)iterator.next();
                    if (!this.isEqual(z.name, column.name)) continue;
                    iterator.remove();
                }
            }
            target.addAll(aggColumns);
        }
        return target;
    }

    private FieldMemo getOrCreateFieldByName(String name) {
        return this.getOrCreateFieldByName(name, false);
    }

    private FieldMemo getOrCreateFieldByName(String name, boolean createField) {
        FieldMemo memo;
        Scope current = this.scope.getCurrent();
        FieldMemo exists = current.getFieldByName(name);
        if (exists == null) {
            memo = new FieldMemo();
            memo.name = current.dialector.wrap(name);
            memo.tables.addAll(current.getTableMap().values());
        } else {
            memo = exists.copy();
            memo.tables.addAll(exists.tables);
            memo.children.add(exists);
        }
        memo.alias = memo.name;
        if (memo.tables.size() == 1) {
            memo.table = memo.tables.get(0);
        }
        memo.scope = current;
        if (createField) {
            current.addField(memo);
        }
        memo.isSelectItem = false;
        return memo;
    }

    private void parseSelectList(OracleSelectQueryBlock x) {
        Scope current = this.scope.getCurrent();
        List<SQLSelectItem> selectList = x.getSelectList();
        for (int i = 0; i < selectList.size(); ++i) {
            SQLSelectItem item = selectList.get(i);
            boolean isAll = this.scope.isAllColumn(item.getExpr());
            if (item.getAlias() == null && !isAll) {
                this.setAlias(item);
            }
            if (!isAll || item.getAttribute("expanded") != null) continue;
            item.putAttribute("expanded", true);
            SQLObject parent = item.getParent();
            Owner owner = this.scope.getAllOwner(item.getExpr());
            TableMemo table = owner.alias == null ? null : current.getTable(item.getExpr());
            SQLTableSource tableSource = x.getFrom();
            boolean isSub = table != null && table.isSub || tableSource instanceof SQLSubqueryTableSource || tableSource instanceof SQLUnionQueryTableSource;
            List<FieldMemo> fields = current.expandAllColumns(table, isSub);
            fields = this.parsePivotColumns(x.getFrom(), fields);
            if (fields.size() == 0) continue;
            int k = 0;
            selectList.remove(i);
            String alias = x.getFrom().getAlias();
            if (alias == null) {
                alias = owner.alias;
            }
            for (FieldMemo field : fields) {
                if (field.name.equalsIgnoreCase("*")) continue;
                TableMemo fieldTable = field.table;
                SQLPropertyExpr propExpr = new SQLPropertyExpr();
                propExpr.setOwner(alias == null ? fieldTable.alias : alias);
                propExpr.setName(field.alias);
                SQLSelectItem newItem = new SQLSelectItem();
                newItem.setParent(parent);
                newItem.setExpr(propExpr);
                newItem.setAlias(field.alias);
                field.scope = current;
                field.isSelectItem = true;
                field.ref = newItem;
                field.exprs.add(propExpr);
                selectList.add(i + k++, newItem);
            }
        }
        int k = Integer.MIN_VALUE;
        for (SQLSelectItem item : selectList) {
            SQLExpr sqlExpr = item.getExpr();
            boolean isPrimitive = this.scope.isPrimitive(sqlExpr);
            item.putAttribute("isPrimitive", isPrimitive);
            item.accept(this);
            FieldMemo field = (FieldMemo)sqlExpr.getAttribute("field");
            if (sqlExpr instanceof SQLValuableExpr) {
                field.isConstant = true;
            }
            field.id = k++;
        }
    }

    private SQLTableSource parseView(SQLTableSource ts, SQLObject parent) {
        if (!(ts instanceof SQLExprTableSource) && !(ts instanceof OracleSelectTableReference)) {
            if (ts instanceof SQLJoinTableSource) {
                SQLTableSource right;
                SQLJoinTableSource jts = (SQLJoinTableSource)ts;
                SQLTableSource left = this.parseView(jts.getLeft(), jts);
                if (left != null) {
                    jts.setLeft(left);
                    left.setParent(jts);
                }
                if ((right = this.parseView(jts.getRight(), jts)) != null) {
                    jts.setRight(right);
                    right.setParent(jts);
                }
            }
        } else {
            SQLTableSource viewTableSource = this.getViewTableSource(ts);
            if (viewTableSource != null) {
                if (parent instanceof OracleSelectQueryBlock) {
                    OracleSelectQueryBlock block = (OracleSelectQueryBlock)parent;
                    block.setFrom(viewTableSource);
                    viewTableSource.setParent(parent);
                }
                return viewTableSource;
            }
        }
        return null;
    }

    private SQLTableSource getViewTableSource(SQLTableSource ts) {
        SQLExprTableSource e = (SQLExprTableSource)ts;
        String name = e.getTableName();
        if (name == null) {
            return ts;
        }
        String schema = e.getSchema() == null ? this.scope.getDefaultSchema() : e.getSchema();
        SQLSelect view = this.scope.context.getView(schema.toLowerCase(), name.toLowerCase());
        if (view != null && this.scope.context.sqlType == TableStat.Mode.Select) {
            SQLSubqueryTableSource subQuery = new SQLSubqueryTableSource();
            String alias = e.getAlias() == null ? e.getTableName() : e.getAlias();
            subQuery.setAlias(alias);
            subQuery.setSelect(view.clone());
            return subQuery;
        }
        return null;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        ClauseScope scope = this.enterClauseScope(x);
        scope.union = true;
        scope.isolated = false;
        this.visitChild(x.getRelations());
        for (Scope s1 : scope.getChildren()) {
            s1.isolated = false;
        }
        this.visitChild(x.getOrderBy());
        this.visitChild(x.getLimit());
        return false;
    }

    @Override
    public boolean visit(SQLLateralViewTableSource x) {
        TableMemo table = this.registerTable(x);
        TableScope scope = this.enterTableScope(x);
        scope.table = table;
        scope.isolated = false;
        return true;
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("enter SQLSubqueryTableSource  " + x.toString());
        }
        if (x.getAlias() == null) {
            x.setAlias(this.alias.aliasTable());
        }
        TableMemo table = this.registerTable(x);
        TableScope scope = this.enterTableScope(x);
        scope.isolated = false;
        scope.table = table;
        if (x.getSelect() != null) {
            x.getSelect().accept(this);
        }
        for (Scope s : scope.getChildren()) {
            s.isolated = false;
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectSubqueryTableSource x) {
        if (this.debug) {
            System.out.println("enter SQLSubqueryTableSource  " + x.toString());
        }
        if (x.getAlias() == null) {
            x.setAlias(this.alias.aliasTable());
        }
        x.putAttribute("pivot", x.getPivot() != null);
        TableMemo table = this.registerTable(x);
        TableScope scope = this.enterTableScope(x);
        scope.table = table;
        scope.isolated = false;
        if (x.getSelect() != null) {
            x.getSelect().accept(this);
        }
        for (Scope s : scope.getChildren()) {
            s.isolated = false;
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectTableReference x) {
        if (!(x.getExpr() instanceof SQLIdentifierExpr || x.getExpr() instanceof SQLPropertyExpr || x.getExpr() instanceof SQLDbLinkExpr)) {
            x.putAttribute("pivot", x.getPivot() != null);
            if (this.debug) {
                System.out.println("enter SQLSubqueryTableSource  " + x.toString());
            }
            if (x.getAlias() == null) {
                x.setAlias(this.alias.aliasTable());
            }
            x.putAttribute("pivot", x.getPivot() != null);
            TableMemo table = this.registerTable(x);
            TableScope scope = this.enterTableScope(x);
            scope.table = table;
            scope.isolated = false;
            return true;
        }
        this.registerTable(x);
        return true;
    }

    @Override
    public void endVisit(OracleSelectTableReference x) {
        if (!(x.getExpr() instanceof SQLIdentifierExpr || x.getExpr() instanceof SQLPropertyExpr || x.getExpr() instanceof SQLDbLinkExpr)) {
            if (this.debug) {
                System.out.println("exit OracleSelectTableReference  " + x);
            }
            this.scope.exitScope();
        } else if (this.debug) {
            System.out.println("end OracleSelectTableReference" + x.toString());
        }
    }

    @Override
    public boolean visit(SQLJoinTableSource x) {
        this.scope.getCurrent().join = true;
        return true;
    }

    @Override
    public boolean visit(OracleSelectJoin x) {
        this.scope.getCurrent().join = true;
        return true;
    }

    @Override
    public boolean visit(SQLUnionQueryTableSource x) {
        TableMemo table = this.registerTable(x);
        TableScope scope = this.enterTableScope(x);
        scope.union = true;
        scope.fromField = scope.isFromField(x);
        x.putAttribute("table", table);
        x.putAttribute("scope", scope);
        scope.table = table;
        scope.isolated = false;
        this.visitChild(x.getUnion());
        for (Scope s1 : scope.getChildren()) {
            s1.isolated = false;
        }
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        this.registerTable(x);
        return true;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        FieldMemo field = this.createField(x.getExpr(), x.getAlias(), true);
        field.ref = x;
        return false;
    }

    @Override
    public boolean visit(SQLAggregateExpr x) {
        if (x.getMethodName().equalsIgnoreCase("LISTAGG")) {
            this.setAttr(x, "AGG-PASS", true);
        }
        return true;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        if (this.scope.getCurrent().isFieldState()) {
            boolean needCreate = true;
            if (x.getParent() instanceof SQLAggregateExpr) {
                needCreate = false;
                SQLAggregateExpr agg = (SQLAggregateExpr)x.getParent();
                if (agg.getMethodName().equalsIgnoreCase("LISTAGG")) {
                    List<SQLExpr> arguments = agg.getArguments();
                    if (arguments.size() > 0 && arguments.get(0) == x) {
                        needCreate = true;
                        x.removeAttribute("AGG-PASS");
                    }
                } else {
                    needCreate = true;
                }
            }
            if (needCreate && !x.containsAttribute("AGG-PASS")) {
                FieldMemo field = this.createField(x, x.getName(), false);
                x.putAttribute("field", field);
            }
        } else if (!(x.getParent() instanceof SQLTableSource || x.getParent() instanceof SQLPartition || x.getParent() instanceof SQLDbLinkExpr)) {
            x.putAttribute("orderBy", x.getParent() instanceof SQLSelectOrderByItem);
            FieldMemo field = this.createField(x, x.getName(), false);
            x.putAttribute("field", field);
            if (x.getParent() instanceof SQLUpdateSetItem) {
                field.isSelectItem = true;
            }
        }
        return false;
    }

    private void setAttr(SQLExpr e, String name, Object value) {
        List<SQLObject> children;
        if (e != null && (children = e.getChildren()) != null && children.size() > 0) {
            for (SQLObject child : children) {
                child.putAttribute(name, value);
                if (!(child instanceof SQLExpr)) continue;
                this.setAttr((SQLExpr)child, name, value);
            }
        }
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        if (this.scope.getCurrent().isFieldState()) {
            this.createField(x, x.getName(), false);
        } else if (!(x.getParent() instanceof SQLTableSource) && !(x.getParent() instanceof SQLPartition)) {
            FieldMemo field = this.createField(x, x.getName(), false);
            if (x.getParent() instanceof SQLUpdateSetItem) {
                field.isSelectItem = true;
            }
        }
        return false;
    }

    @Override
    public boolean visit(OracleJsonArrayAggExpr x) {
        this.visitChild(x.getExpr());
        this.visitChild(x.getOrderBy());
        return false;
    }

    @Override
    public boolean visit(OracleJsonObjectExpr x) {
        for (OracleJsonObjectExpr.OracleJsonObjectExprItem item : x.getItems()) {
            SQLExpr value = item.getValue();
            value.accept(this);
        }
        return false;
    }

    private void createSequenceTable(String name) {
        Scope current = this.scope.getCurrent();
        TableMemo table = new TableMemo();
        table.name = name;
        table.nowName = table.alias = name;
        table.schema = this.scope.getDefaultSchema();
        table.sequence = true;
        table.scope = current;
        current.addTable(table);
        this.scope.context.append(table);
    }

    private FieldMemo createField(SQLExpr expr, String alias, boolean isSelectItem) {
        Scope current = this.scope.getCurrent();
        FieldMemo field = new FieldMemo();
        if (expr instanceof SQLIdentifierExpr) {
            String name;
            FieldMemo exist;
            boolean isOrderBy;
            SQLIdentifierExpr idExpr = (SQLIdentifierExpr)expr;
            boolean bl = isOrderBy = expr.getAttribute("orderBy") != null && (Boolean)expr.getAttribute("orderBy") != false;
            if (isOrderBy && (exist = current.getFieldByAlias(name = current.dialector.wrap(idExpr.getSimpleName()))) != null) {
                return exist;
            }
            field.name = idExpr.getName();
            field.atom = true;
            this.setField(field, alias, isSelectItem, expr);
            field.children = this.scope.getCurrent().getSubRelationFields(field);
            this.setAtom(field);
            field = current.addField(field);
        } else if (expr instanceof OracleSysdateExpr) {
            OracleSysdateExpr prop = (OracleSysdateExpr)expr;
            field.name = current.dialector.wrap(prop.toString());
            field.isConstant = true;
            this.setField(field, alias, isSelectItem, expr);
            field = current.addField(field);
        } else if (expr instanceof SQLPropertyExpr) {
            SQLPropertyExpr prop = (SQLPropertyExpr)expr;
            field.name = prop.getName();
            field.atom = true;
            this.setField(field, alias, isSelectItem, expr);
            field.children = this.scope.getCurrent().getSubRelationFields(field);
            this.setAtom(field);
            field = current.addField(field);
        } else if (expr instanceof SQLSequenceExpr) {
            SQLSequenceExpr prop = (SQLSequenceExpr)expr;
            field.name = prop.getFunction().toString();
            this.createSequenceTable(prop.getSequence().toString());
            this.setField(field, alias, isSelectItem, expr);
            field.children = this.scope.getCurrent().getSubRelationFields(field);
            field = current.addField(field);
        } else if (expr instanceof SQLValuableExpr) {
            field.name = alias;
            field.isConstant = true;
            this.setField(field, alias, isSelectItem, expr);
            field = current.addField(field);
        } else {
            AliasField aliasField;
            field.name = alias = current.dialector.wrap(alias);
            field.alias = alias;
            field.complex = true;
            field.isSelectItem = isSelectItem;
            field.ref = expr;
            if (expr instanceof SQLSelectItem) {
                field.exprs.add(((SQLSelectItem)((Object)expr)).getExpr());
                aliasField = new AliasField();
                aliasField.alias = alias;
                aliasField.field = field;
                aliasField.expr = expr;
                aliasField.isOutput = true;
                aliasField.scope = this.scope.getCurrent();
            } else {
                field.exprs.add(expr);
                aliasField = new AliasField();
                aliasField.alias = alias;
                aliasField.field = field;
                aliasField.expr = expr;
                aliasField.isOutput = true;
                aliasField.scope = this.scope.getCurrent();
            }
            current.openFieldState();
            expr.accept(this);
            current.closeFieldState();
            List<SQLExpr> exprs = current.getSubFieldExprs(expr);
            ArrayList<FieldMemo> subFields = new ArrayList<FieldMemo>();
            current.getFieldsByExprs(exprs, subFields);
            ArrayList<TableMemo> tables = new ArrayList<TableMemo>();
            ArrayList<FieldMemo> children = new ArrayList<FieldMemo>();
            HashSet<String> names = new HashSet<String>();
            boolean isPrimitive = this.scope.isPrimitive(expr);
            if (!isPrimitive) {
                current.getSubBranchFields(subFields);
            }
            if (subFields.size() <= 0) {
                tables.addAll(current.getBranchTables());
            } else {
                for (FieldMemo subField : subFields) {
                    if (!names.contains(subField.getUniqueName())) {
                        children.add(subField);
                        names.add(subField.getUniqueName());
                    }
                    if (subField.table != null && !names.contains(subField.table.getQualifiedName())) {
                        tables.add(subField.table);
                        names.add(subField.table.getQualifiedName());
                        continue;
                    }
                    if (subField.tables.size() <= 0) continue;
                    for (TableMemo table : subField.tables) {
                        if (names.contains(table.getQualifiedName())) continue;
                        tables.add(table);
                        names.add(table.getQualifiedName());
                    }
                }
            }
            field.tables = tables;
            if (tables.size() == 1) {
                field.table = (TableMemo)tables.get(0);
            }
            field.children = children;
            this.setAtom(field);
            current.addField(field);
        }
        expr.putAttribute("field", field);
        return field;
    }

    private void setAtom(FieldMemo field) {
        if (field.children.size() != 0) {
            Set<String> fdNames = field.tableNames();
            boolean found = false;
            for (FieldMemo child : field.children) {
                if (!this.isEqual(field.name, child.alias)) continue;
                Set<String> cdNames = child.tableNames();
                cdNames.retainAll(fdNames);
                if (cdNames.size() <= 0) continue;
                found = true;
            }
            if (!found) {
                field.atom = false;
            }
        }
    }

    private void setField(FieldMemo field, String alias, boolean isSelectItem, SQLExpr expr) {
        Scope current = this.scope.getCurrent();
        field.alias = alias == null ? field.name : alias;
        field.alias = current.dialector.wrap(field.alias);
        field.name = current.dialector.wrap(field.name);
        field.isSelectItem = isSelectItem;
        field.ref = expr;
        field.table = expr instanceof SQLSequenceExpr ? this.scope.getCurrent().getTable(((SQLSequenceExpr)expr).getSequence()) : this.scope.getCurrent().getTable(expr);
        field.tables.add(field.table);
        field.exprs.add(expr);
        AliasField aliasField = new AliasField();
        aliasField.alias = alias;
        aliasField.field = field;
        aliasField.expr = expr;
        aliasField.isOutput = isSelectItem;
        aliasField.scope = this.scope.getCurrent();
    }

    private TableMemo registerTable(SQLTableSource x) {
        Scope current = this.scope.getCurrent();
        if (x instanceof SQLExprTableSource) {
            SQLMethodInvokeExpr method;
            OracleSelectTableReference ref;
            SQLExprTableSource exprTableSource = (SQLExprTableSource)x;
            TableMemo table = new TableMemo(x);
            SQLExprTableSource tableSource = (SQLExprTableSource)x;
            String tableName = current.dialector.wrap(tableSource.getTableName());
            String schemaName = current.dialector.wrap(tableSource.getSchema() == null ? this.scope.getDefaultSchema() : tableSource.getSchema());
            table.name = tableName;
            table.nowName = table.alias = current.dialector.wrap(tableSource.getAlias() == null ? table.name : tableSource.getAlias());
            table.schema = schemaName;
            if (table.name == null) {
                table.name = table.alias;
            }
            if (table.name.equals("*") && exprTableSource.getExpr() != null && exprTableSource.getExpr() instanceof SQLPropertyExpr) {
                return null;
            }
            if (table.name == null && table.alias != null) {
                table.name = table.alias;
            }
            if (exprTableSource.getExpr() != null && exprTableSource.getExpr() instanceof SQLMethodInvokeExpr) {
                table.isSub = true;
            }
            if (exprTableSource.getExpr() != null && exprTableSource.getExpr() instanceof SQLDbLinkExpr) {
                SQLDbLinkExpr link = (SQLDbLinkExpr)exprTableSource.getExpr();
                Owner owner = this.scope.getOwner(link.getExpr());
                table.name = current.dialector.wrap(owner.table);
                if (owner.schema != null) {
                    table.schema = current.dialector.wrap(owner.schema);
                }
                if (link.getExpr().getParent() == null) {
                    link.getExpr().setParent(link);
                }
                table.dbLink = exprTableSource.getExpr().toString();
            }
            if (x instanceof OracleSelectTableReference && (ref = (OracleSelectTableReference)x).getExpr() != null && ref.getExpr() instanceof SQLMethodInvokeExpr && (method = (SQLMethodInvokeExpr)ref.getExpr()).getArguments().size() == 1 && method.getArguments().get(0) instanceof SQLQueryExpr) {
                if (table.name == null) {
                    String aliasTableName = current.dialector.wrap(this.alias.aliasTable());
                    ref.setAlias(aliasTableName);
                    table.name = aliasTableName;
                    if (table.alias == null) {
                        table.alias = table.name;
                    }
                    table.isSub = true;
                }
                this.setTableRelation(table);
                x.putAttribute("table", table);
                return table;
            }
            TableMemo refTable = current.getParentTable(schemaName, tableName);
            if (refTable != null) {
                table.schema = refTable.schema;
                table.topTable = true;
                table.scope = current;
                table.refTable = refTable;
                table.getChildren().add(refTable);
                current.addTable(table);
                table.topTable = refTable.topTable;
                return refTable;
            }
            boolean isFunction = false;
            SQLExpr expr = ((SQLExprTableSource)x).getExpr();
            isFunction = expr instanceof SQLMethodInvokeExpr;
            this.setTableRelation(table);
            table.system = this.scope.dialector.isSystemTable(table.name);
            if (!(table.isSub || isFunction || table.system)) {
                this.scope.context.append(table);
            }
            x.putAttribute("table", table);
            return table;
        }
        if (x instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource tableSource = (SQLSubqueryTableSource)x;
            TableMemo table = new TableMemo(x);
            table.name = current.dialector.wrap(tableSource.getAlias());
            table.alias = current.dialector.wrap(tableSource.getAlias());
            table.nowName = table.name;
            table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
            table.isSub = true;
            this.setTableRelation(table);
            x.putAttribute("table", table);
            return table;
        }
        if (x instanceof SQLLateralViewTableSource) {
            SQLLateralViewTableSource tableSource = (SQLLateralViewTableSource)x;
            TableMemo table = new TableMemo(x);
            table.name = current.dialector.wrap(tableSource.getAlias());
            table.alias = current.dialector.wrap(tableSource.getAlias());
            table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
            table.isSub = true;
            this.setTableRelation(table);
            x.putAttribute("table", table);
            return table;
        }
        if (x instanceof SQLUnionQueryTableSource) {
            SQLUnionQueryTableSource tableSource = (SQLUnionQueryTableSource)x;
            TableMemo table = new TableMemo(x);
            table.alias = table.name = current.dialector.wrap(tableSource.getAlias());
            table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
            table.nowName = table.name;
            table.isSub = true;
            this.setTableRelation(table);
            x.putAttribute("table", table);
            return table;
        }
        return null;
    }

    private TableMemo registerTable(SQLWithSubqueryClause.Entry x) {
        Scope current = this.scope.getCurrent();
        TableMemo table = new TableMemo(x);
        table.name = current.dialector.wrap(x.getAlias());
        table.nowName = current.dialector.wrap(table.name);
        table.alias = table.name;
        table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
        table.isSub = true;
        table.topTable = true;
        this.setTableRelation(table);
        return table;
    }

    private void setTableRelation(TableMemo table) {
        TableMemo parentTable;
        Scope current = this.scope.getCurrent();
        table.name = current.dialector.wrap(table.name);
        table.alias = current.dialector.wrap(table.alias);
        table.schema = current.dialector.wrap(table.schema);
        table.scope = current;
        current.addTable(table);
        TableScope tableScope = current.getNearestParentTableScope();
        if (tableScope != null && (parentTable = tableScope.table) != null) {
            parentTable.getChildren().add(table);
            if (table.isSub) {
                parentTable.isSub = true;
            }
        }
    }

    private TableScope enterTableScope(SQLTableSource x) {
        TableScope ts = new TableScope();
        ts.ref = x;
        ts.alias = ts.name = x.getAlias();
        this.scope.enterScope(ts);
        return ts;
    }

    private ClauseScope enterClauseScope(SQLObject x) {
        ClauseScope clauseScope = new ClauseScope();
        clauseScope.ref = x;
        this.scope.enterScope(clauseScope);
        return clauseScope;
    }

    private void setAlias(SQLSelectItem x) {
        if (x.getAlias() == null) {
            SQLExpr e = x.getExpr();
            if (e instanceof SQLIdentifierExpr) {
                String name = ((SQLIdentifierExpr)e).getName();
                if (!name.toUpperCase().equals("ROWID")) {
                    x.setAlias(name);
                }
            } else if (e instanceof SQLPropertyExpr) {
                String name = ((SQLPropertyExpr)e).getName();
                if (!name.toUpperCase().equals("ROWID")) {
                    x.setAlias(name);
                }
            } else if (e instanceof SQLNumericLiteralExpr) {
                x.setAlias("'" + e + "'");
            } else {
                x.setAlias(this.scope.dialector.wrap(e.toString()));
            }
        }
    }

    @Override
    public void endVisit(SQLMethodInvokeExpr x) {
        if ("LATERAL".equalsIgnoreCase(x.getMethodName())) {
            this.scope.getCurrent().isolated = false;
            for (Scope s : this.scope.getCurrent().getChildren()) {
                s.isolated = false;
            }
        }
    }
}

