package com.chenyang.nse.bussiness.aop;

import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreSecretkeyDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncrypLogDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreSecretkey;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncrypLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreEncryption;
import com.chenyang.nse.bussiness.entity.vo.excel.ExcelEncryptionVO;
import com.chenyang.nse.bussiness.entity.vo.strategy.LoadingColumnParamVO;
import com.chenyang.nse.bussiness.entity.vo.strategy.ReplaceColumnParamVO;
import com.chenyang.nse.bussiness.tools.encryption.SM3Utils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.token.TokenUtil;
import com.jcabi.aspects.Async;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class EncryptLogAspect {
   @Autowired
   private TCoreEncrypLogDao tCoreEncrypLogDao;
   @Autowired
   private TCoreSecretkeyDao tCoreSecretkeyDao;
   @Autowired
   private TCoreEncryptionDao tCoreEncryptionDao;
   @Autowired
   private TCoreDataProjectDao tCoreDataProjectDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   private static final String ENCRYPTION_CONFIG = "EncryptionConfigController";
   private static final String GET_DECRYPT_TABLE = "getDecryptTable";
   private static final String SAVE = "save";
   private static final String DOWN_LOAD = "download";
   private static final String EXPORT_TO_EXCEL = "exportToExcel";
   private static final String T_CORE_ENCRYPTION = "TCoreEncryptionController";
   private static final String SAVE_ENCRYPTION = "saveEncryption";
   private static final String DELETE_ENCRYPTION = "deleteEncryption";
   private static final String SAVE_SECRET_KEY = "saveSecretKey";
   private static final String DELETE_SECRET_KEY = "delSecretKey";
   private static final String EXCEL_FILE_UPLOAD = "excelFileUpLoad";
   private static final String REPLACE_COLUMN = "replaceColumn";
   private static final String LOADING_TABLE_PARAMS = "loadingTableParams";
   private static final String LOADING_COLUMN = "loadingColumn";
   private static final String REMOVE_LOADING_COLUMN = "removeLoadingColumn";
   private static final String SWITCH_FIELD_CONTROLLER = "SwitchFieldController";
   private static final String ENCRYPT_BATCH_SWITCH = "encryptbatchswitch";
   private static final String DECRYPT_BATCH_SWITCH = "decryptbatchswitch";

   @Pointcut("@annotation(com.chenyang.nse.bussiness.annot.EncryptLog)")
   public void encryptLogPointCut() {
   }

   private Method getMethod(JoinPoint joinPoint) {
      Signature signature = joinPoint.getSignature();
      MethodSignature methodSignature = (MethodSignature)signature;
      Method method = methodSignature.getMethod();
      return method != null ? method : null;
   }

   @Before("encryptLogPointCut()")
   public void beforeDo(JoinPoint joinPoint) throws Exception {
      this.handleLog2(joinPoint);
   }

   @AfterReturning(
      pointcut = "encryptLogPointCut()",
      returning = "rvt"
   )
   public void doAfter(JoinPoint joinPoint, Object rvt) throws Exception {
      this.handleLog(joinPoint, (Exception)null, rvt);
   }

   @Async
   private void handleLog(final JoinPoint joinPoint, final Exception e, Object rvt) throws Exception {
      ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
      String username;
      if (!ObjectUtils.isEmpty(attributes)) {
         HttpServletRequest request = attributes.getRequest();
         if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getHeader("token"))) {
            username = TokenUtil.getUserName(request.getHeader("token"));
         } else {
             username = null;
         }
      } else {
          username = null;
      }

       Method method = this.getMethod(joinPoint);
      String className = joinPoint.getTarget().getClass().getName();
      String methodName = null;

      assert method != null;

      methodName = method.getName();
      Object[] args = joinPoint.getArgs();
      LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
      String[] paramNames = u.getParameterNames(method);
      if ("EncryptionConfigController".equals(className.substring(className.lastIndexOf(".") + 1))) {
         if ("save".equals(methodName) && !ObjectUtils.isEmpty(args) && !ObjectUtils.isEmpty(paramNames)) {
            for(int i = 0; i < args.length; ++i) {
               if (args[i] instanceof Map) {
                  Set set = ((Map)args[i]).keySet();
                  String projectId = (String)((Map)args[i]).get("projectId");
                  String projectName = ((TCoreDataProject)this.tCoreDataProjectDao.get(projectId)).getProject();
                  String datasystemid = (String)((Map)args[i]).get("datasystemid");
                  String datasystemName = ((TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid)).getSysname();

                  for(Object key : set) {
                     if ("map".equals(key.toString())) {
                        String finalDecoValue = "加密设置";
                        ((Map)((Map)((Map)args[i]).get("map"))).forEach((k, v) -> {
                           TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
                           encryptionLog.setOperModule(finalDecoValue);
                           encryptionLog.setProjectId(projectId);
                           encryptionLog.setDataSystemId(datasystemid);
                           String[] split = k.toString().split("#\\|#");
                           String schemaname = split[0];
                           String tablename = split[1];
                           String fieldname = split[2];
                           String flag = (String)((Map)v).get("flag");
                           encryptionLog.setSchemaName(schemaname);
                           encryptionLog.setTableName(tablename);
                           encryptionLog.setFieldName(fieldname);
                           encryptionLog.setFlag(flag);
                           String code = null;
                           if ("0".equals(flag)) {
                              code = "DDM_02301";
                              encryptionLog.setCode(code);
                              encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, projectName, datasystemName, schemaname, tablename, fieldname}));
                              encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
                              encryptionLog.setCreatetime(new Date());
                              encryptionLog.setOperptionUser(username);
                              Date date = encryptionLog.getCreatetime();
                              SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                              String dateString = sdf.format(date);
                              String column_enc = "";

                              try {
                                 column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
                              } catch (Exception exception) {
                                 exception.printStackTrace();
                              }

                              encryptionLog.setColumn_enc(column_enc);
                              this.tCoreEncrypLogDao.save(encryptionLog);
                           }

                        });
                     }
                  }
               }
            }
         }

         if ("exportToExcel".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密模块";
            encryptionLog.setOperModule(finalDecoValue);
            ExcelEncryptionVO vo = (ExcelEncryptionVO)args[0];
            TCoreDataProject project = vo.getProject();
            String projectId = project.getId();
            encryptionLog.setProjectId(projectId);
            encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
            encryptionLog.setCreatetime(new Date());
            encryptionLog.setOperptionUser(username);
            String projectName = ((TCoreDataProject)this.tCoreDataProjectDao.get(projectId)).getProject();
            String code = "DDM_02305";
            encryptionLog.setCode(code);
            encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, projectName}));
            Date date = encryptionLog.getCreatetime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sdf.format(date);
            String column_enc = "";

            try {
               column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
            } catch (Exception exception) {
               exception.printStackTrace();
            }

            encryptionLog.setColumn_enc(column_enc);
            this.tCoreEncrypLogDao.save(encryptionLog);
         }
      }

      if ("TCoreEncryptionController".equals(className.substring(className.lastIndexOf(".") + 1))) {
         if ("excelFileUpLoad".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            String projectId = (String)args[1];
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密模块";
            encryptionLog.setOperModule(finalDecoValue);
            encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
            encryptionLog.setProjectId(projectId);
            encryptionLog.setCreatetime(new Date());
            encryptionLog.setOperptionUser(username);
            String code = "DDM_02306";
            encryptionLog.setCode(code);
            encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username}));
            Date date = encryptionLog.getCreatetime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sdf.format(date);
            String column_enc = "";

            try {
               column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
            } catch (Exception exception) {
               exception.printStackTrace();
            }

            encryptionLog.setColumn_enc(column_enc);
            this.tCoreEncrypLogDao.save(encryptionLog);
         }

         if ("loadingTableParams".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密设置";
            encryptionLog.setOperModule(finalDecoValue);
            LoadingColumnParamVO loadingColumnParamVO = (LoadingColumnParamVO)args[0];
            String dataSystemId = loadingColumnParamVO.getDataSystemId();
            String sysname;
            if (null != dataSystemId && !"".equals(dataSystemId.trim())) {
               sysname = ((TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId)).getSysname();
            } else {
               sysname = "";
            }

            String projectId = loadingColumnParamVO.getProjectId();
            String projectName = ((TCoreDataProject)this.tCoreDataProjectDao.get(projectId)).getProject();
            String schema = "";
            if (loadingColumnParamVO.getSchema() != null && !loadingColumnParamVO.getSchema().equals("")) {
               schema = loadingColumnParamVO.getSchema();
            }

            String tableName = "";
            if (loadingColumnParamVO.getTableName() != null && !loadingColumnParamVO.getTableName().equals("")) {
               tableName = loadingColumnParamVO.getTableName();
            }

            String flag = "";
            if (loadingColumnParamVO.getFlag() != null && !loadingColumnParamVO.getFlag().equals("")) {
               flag = loadingColumnParamVO.getFlag();
            }

            encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
            encryptionLog.setCreatetime(new Date());
            encryptionLog.setOperptionUser(username);
            String code = null;
            if ("0".equals(flag)) {
               code = "DDM_02314";
            } else {
               code = "DDM_02315";
            }

            encryptionLog.setCode(code);
            encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, projectName, sysname, schema, tableName}));
            Date date = encryptionLog.getCreatetime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sdf.format(date);
            String column_enc = "";

            try {
               column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
            } catch (Exception exception) {
               exception.printStackTrace();
            }

            encryptionLog.setColumn_enc(column_enc);
            this.tCoreEncrypLogDao.save(encryptionLog);
         }

         if ("loadingColumn".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密设置";
            encryptionLog.setOperModule(finalDecoValue);
            LoadingColumnParamVO loadingColumnParamVO = (LoadingColumnParamVO)args[0];
            String dataSystemId = loadingColumnParamVO.getDataSystemId();
            String sysname = ((TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId)).getSysname();
            String projectId = loadingColumnParamVO.getProjectId();
            String projectName = ((TCoreDataProject)this.tCoreDataProjectDao.get(projectId)).getProject();
            String schema = loadingColumnParamVO.getSchema();
            String tableName = loadingColumnParamVO.getTableName();
            String columnName = loadingColumnParamVO.getColumnName();
            encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
            encryptionLog.setCreatetime(new Date());
            encryptionLog.setProjectId(projectId);
            encryptionLog.setOperptionUser(username);
            String code = "DDM_02316";
            encryptionLog.setCode(code);
            encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, projectName, sysname, schema, tableName, columnName}));
            Date date = encryptionLog.getCreatetime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sdf.format(date);
            String column_enc = "";

            try {
               column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
            } catch (Exception exception) {
               exception.printStackTrace();
            }

            encryptionLog.setColumn_enc(column_enc);
            this.tCoreEncrypLogDao.save(encryptionLog);
         }

         if ("removeLoadingColumn".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密设置";
            encryptionLog.setOperModule(finalDecoValue);
            LoadingColumnParamVO loadingColumnParamVO = (LoadingColumnParamVO)args[0];
            String dataSystemId = loadingColumnParamVO.getDataSystemId();
            String sysname = ((TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId)).getSysname();
            String projectId = loadingColumnParamVO.getProjectId();
            String projectName = ((TCoreDataProject)this.tCoreDataProjectDao.get(projectId)).getProject();
            String schema = loadingColumnParamVO.getSchema();
            String tableName = loadingColumnParamVO.getTableName();
            String columnName = loadingColumnParamVO.getColumnName();
            encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
            encryptionLog.setProjectId(projectId);
            encryptionLog.setCreatetime(new Date());
            encryptionLog.setOperptionUser(username);
            String code = "DDM_02317";
            encryptionLog.setCode(code);
            encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, projectName, sysname, schema, tableName, columnName}));
            Date date = encryptionLog.getCreatetime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sdf.format(date);
            String column_enc = "";

            try {
               column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
            } catch (Exception exception) {
               exception.printStackTrace();
            }

            encryptionLog.setColumn_enc(column_enc);
            this.tCoreEncrypLogDao.save(encryptionLog);
         }
      }

   }

   @Async
   private void handleLog2(final JoinPoint joinPoint) throws Exception {
      ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
      String username = null;
      if (!ObjectUtils.isEmpty(attributes)) {
         HttpServletRequest request = attributes.getRequest();
         if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getHeader("token"))) {
            username = TokenUtil.getUserName(request.getHeader("token"));
         }
      }

      Method method = this.getMethod(joinPoint);
      String className = joinPoint.getTarget().getClass().getName();
      String methodName = null;

      assert method != null;

      methodName = method.getName();
      Object[] args = joinPoint.getArgs();
      LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
      u.getParameterNames(method);
      if ("TCoreEncryptionController".equals(className.substring(className.lastIndexOf(".") + 1))) {
         if ("saveEncryption".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密模块";
            encryptionLog.setOperModule(finalDecoValue);
            TCoreEncryption encryption = (TCoreEncryption)args[0];
            if (encryption.getId() != null && !"".equals(encryption.getId())) {
               String encryptionName = encryption.getEncryption_name();
               String code = "DDM_02308";
               encryptionLog.setCode(code);
               encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, encryptionName}));
            } else {
               String encryptionName = encryption.getEncryption_name();
               String code = "DDM_02307";
               encryptionLog.setCode(code);
               encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, encryptionName}));
            }

            encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
            encryptionLog.setEncryptionType(encryption.getEncryption_name());
            encryptionLog.setCreatetime(new Date());
            encryptionLog.setOperptionUser(username);
            Date date = encryptionLog.getCreatetime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sdf.format(date);
            String column_enc = "";

            try {
               column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
            } catch (Exception exception) {
               exception.printStackTrace();
            }

            encryptionLog.setColumn_enc(column_enc);
            this.tCoreEncrypLogDao.save(encryptionLog);
         }

         if ("deleteEncryption".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密模块";
            encryptionLog.setOperModule(finalDecoValue);
            Map<String, String> map = (Map)args[0];
            String encryptionId = (String)map.get("encryptionId");
            String encryption_name = ((TCoreEncryption)this.tCoreEncryptionDao.get(encryptionId)).getEncryption_name();
            encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
            encryptionLog.setCreatetime(new Date());
            encryptionLog.setOperptionUser(username);
            String code = "DDM_02309";
            encryptionLog.setCode(code);
            encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, encryption_name}));
            Date date = encryptionLog.getCreatetime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sdf.format(date);
            String column_enc = "";

            try {
               column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
            } catch (Exception exception) {
               exception.printStackTrace();
            }

            encryptionLog.setColumn_enc(column_enc);
            this.tCoreEncrypLogDao.save(encryptionLog);
         }

         if ("saveSecretKey".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密模块";
            encryptionLog.setOperModule(finalDecoValue);
            TCoreSecretkey tCoreSecretkey = (TCoreSecretkey)args[0];
            if (tCoreSecretkey.getId() != null && !"".equals(tCoreSecretkey.getId())) {
               String secretKeyName = tCoreSecretkey.getSecret_key_name();
               String encryption_name = ((TCoreEncryption)this.tCoreEncryptionDao.get(tCoreSecretkey.getEncryption_id())).getEncryption_name();
               String code = "DDM_02311";
               encryptionLog.setCode(code);
               encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, encryption_name, secretKeyName}));
               encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
               encryptionLog.setCreatetime(new Date());
               encryptionLog.setOperptionUser(username);
               Date date = encryptionLog.getCreatetime();
               SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
               String dateString = sdf.format(date);
               String column_enc = "";

               try {
                  column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
               } catch (Exception exception) {
                  exception.printStackTrace();
               }

               encryptionLog.setColumn_enc(column_enc);
               this.tCoreEncrypLogDao.save(encryptionLog);
            } else {
               String secretKeyName = tCoreSecretkey.getSecret_key_name();
               String encryption_name = ((TCoreEncryption)this.tCoreEncryptionDao.get(tCoreSecretkey.getEncryption_id())).getEncryption_name();
               String code = "DDM_02310";
               encryptionLog.setCode(code);
               encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, encryption_name, secretKeyName}));
               encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
               encryptionLog.setCreatetime(new Date());
               encryptionLog.setOperptionUser(username);
               Date date = encryptionLog.getCreatetime();
               SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
               String dateString = sdf.format(date);
               String column_enc = "";

               try {
                  column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
               } catch (Exception exception) {
                  exception.printStackTrace();
               }

               encryptionLog.setColumn_enc(column_enc);
               this.tCoreEncrypLogDao.save(encryptionLog);
            }
         }

         if ("delSecretKey".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密模块";
            encryptionLog.setOperModule(finalDecoValue);
            Map<String, String> map = (Map)args[0];
            String keyId = (String)map.get("keyId");
            TCoreSecretkey tCoreSecretkey = (TCoreSecretkey)this.tCoreSecretkeyDao.get(keyId);
            encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
            encryptionLog.setCreatetime(new Date());
            encryptionLog.setOperptionUser(username);
            String secretKeyName = tCoreSecretkey.getSecret_key_name();
            String encryption_name = ((TCoreEncryption)this.tCoreEncryptionDao.get(tCoreSecretkey.getEncryption_id())).getEncryption_name();
            String code = "DDM_02312";
            encryptionLog.setCode(code);
            encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, encryption_name, secretKeyName}));
            String column_enc = "";
            Date date = encryptionLog.getCreatetime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sdf.format(date);

            try {
               column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
            } catch (Exception exception) {
               exception.printStackTrace();
            }

            encryptionLog.setColumn_enc(column_enc);
            this.tCoreEncrypLogDao.save(encryptionLog);
         }

         if ("replaceColumn".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            ReplaceColumnParamVO param = (ReplaceColumnParamVO)joinPoint.getArgs()[0];
            String flag = param.getFlag();
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密模块";
            encryptionLog.setOperModule(finalDecoValue);
            ReplaceColumnParamVO replaceColumnParamVO = (ReplaceColumnParamVO)args[0];
            encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
            encryptionLog.setCreatetime(new Date());
            String projectName = ((TCoreDataProject)this.tCoreDataProjectDao.get(replaceColumnParamVO.getProjectId())).getProject();
            String DatasystemName = ((TCoreDatasystem)this.tCoreDatasystemDao.get(replaceColumnParamVO.getDataSystemId())).getSysname();
            encryptionLog.setOperptionUser(username);
            String code = "";
            if ("1".equals(flag)) {
               code = "DDM_02318";
            } else if ("6".equals(flag)) {
               code = "DDM_02319";
            } else if ("9".equals(flag)) {
               code = "DDM_02320";
            } else if ("10".equals(flag)) {
               code = "DDM_02321";
            }

            encryptionLog.setCode(code);
            encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, projectName, DatasystemName, replaceColumnParamVO.getSchema(), replaceColumnParamVO.getTableName(), replaceColumnParamVO.getColumnName()}));
            Date date = encryptionLog.getCreatetime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sdf.format(date);
            String column_enc = "";

            try {
               column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
            } catch (Exception exception) {
               exception.printStackTrace();
            }

            encryptionLog.setColumn_enc(column_enc);
            this.tCoreEncrypLogDao.save(encryptionLog);
         }
      }

   }

   @Pointcut("execution(public * com.chenyang.nse.bussiness.controller.core.SwitchFieldController.*(..))")
   public void SwitchFieldPointCut() {
   }

   @Before("SwitchFieldPointCut()")
   public void beforeDo1(JoinPoint joinPoint) throws Exception {
      this.SwitchField(joinPoint);
   }

   @Async
   private void SwitchField(final JoinPoint joinPoint) throws Exception {
      ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
      String username = null;
      if (!ObjectUtils.isEmpty(attributes)) {
         HttpServletRequest request = attributes.getRequest();
         if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getHeader("token"))) {
            username = TokenUtil.getUserName(request.getHeader("token"));
         }
      }

      Method method = this.getMethod(joinPoint);
      String className = joinPoint.getTarget().getClass().getName();
      String methodName = null;

      assert method != null;

      methodName = method.getName();
      Object[] args = joinPoint.getArgs();
      LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
      u.getParameterNames(method);
      if ("SwitchFieldController".equals(className.substring(className.lastIndexOf(".") + 1))) {
         if ("encryptbatchswitch".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密模块";
            encryptionLog.setOperModule(finalDecoValue);
            Map<String, String> map = (Map)args[0];
            String dataSystemId = (String)map.get("dataSystemId");
            String sysname = "";
            if (ObjectUtils.isEmpty(this.tCoreDatasystemDao.get(dataSystemId))) {
               sysname = ((TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId)).getSysname();
            }

            String schema = (String)map.get("schema");
            String tableName = (String)map.get("tableName");
            String code = "DDM_02318";
            encryptionLog.setCode(code);
            encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, "", sysname, schema, tableName}));
            encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
            encryptionLog.setCreatetime(new Date());
            encryptionLog.setOperptionUser(username);
            Date date = encryptionLog.getCreatetime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sdf.format(date);
            String column_enc = "";

            try {
               column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
            } catch (Exception exception) {
               exception.printStackTrace();
            }

            encryptionLog.setColumn_enc(column_enc);
            this.tCoreEncrypLogDao.save(encryptionLog);
         }

         if ("decryptbatchswitch".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
            TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
            String finalDecoValue = "加密模块";
            encryptionLog.setOperModule(finalDecoValue);
            Map<String, String> map = (Map)args[0];
            String dataSystemId = (String)map.get("dataSystemId");
            String sysname = "";
            if (ObjectUtils.isEmpty(this.tCoreDatasystemDao.get(dataSystemId))) {
               sysname = ((TCoreDatasystem)this.tCoreDatasystemDao.get(dataSystemId)).getSysname();
            }

            String schema = (String)map.get("schema");
            String tableName = (String)map.get("tableName");
            String code = "DDM_02319";
            encryptionLog.setCode(code);
            encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, "", sysname, schema, tableName}));
            encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
            encryptionLog.setCreatetime(new Date());
            encryptionLog.setOperptionUser(username);
            Date date = encryptionLog.getCreatetime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateString = sdf.format(date);
            String column_enc = "";

            try {
               column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
            } catch (Exception exception) {
               exception.printStackTrace();
            }

            encryptionLog.setColumn_enc(column_enc);
            this.tCoreEncrypLogDao.save(encryptionLog);
         }
      }

   }

   @Pointcut("execution(public * com.chenyang.nse.bussiness.controller.core.EncryptionConfigController.download(..))")
   public void downloadPointCut() {
   }

   @AfterReturning("downloadPointCut()")
   public void downloadBO(JoinPoint joinPoint) throws Exception {
      this.downloadLog(joinPoint);
   }

   @Async
   private void downloadLog(final JoinPoint joinPoint) throws Exception {
      ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
      String username = null;
      if (!ObjectUtils.isEmpty(attributes)) {
         HttpServletRequest request = attributes.getRequest();
         if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getHeader("token"))) {
            username = TokenUtil.getUserName(request.getHeader("token"));
         }
      }

      Method method = this.getMethod(joinPoint);
      String className = joinPoint.getTarget().getClass().getName();
      String methodName = null;

      assert method != null;

      methodName = method.getName();
      Object[] args = joinPoint.getArgs();
      LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
      u.getParameterNames(method);
      if ("EncryptionConfigController".equals(className.substring(className.lastIndexOf(".") + 1)) && "download".equals(methodName) && null != args && args.length != 0 && !ObjectUtils.isEmpty(args[0])) {
         TCoreEncrypLog encryptionLog = new TCoreEncrypLog();
         String finalDecoValue = "加密模块";
         encryptionLog.setOperModule(finalDecoValue);
         String projectid = (String)args[0];
         username = (String)args[1];
         encryptionLog.setProjectId(projectid);
         encryptionLog.setId(UUID.randomUUID().toString().replace("-", ""));
         encryptionLog.setCreatetime(new Date());
         encryptionLog.setOperptionUser(username);
         String projectName = ((TCoreDataProject)this.tCoreDataProjectDao.get(projectid)).getProject();
         String code = "DDM_02304";
         encryptionLog.setCode(code);
         encryptionLog.setOperptionMassage(MesUtil.getMsg(code, new String[]{username, projectName}));
         Date date = encryptionLog.getCreatetime();
         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         String dateString = sdf.format(date);
         String column_enc = "";

         try {
            column_enc = SM3Utils.encrypt(encryptionLog.getOperptionUser() + dateString + encryptionLog.getOperptionMassage());
         } catch (Exception exception) {
            exception.printStackTrace();
         }

         encryptionLog.setColumn_enc(column_enc);
         this.tCoreEncrypLogDao.save(encryptionLog);
      }

   }
}
