package com.chenyang.nse.bussiness.commmon;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.exception.ClientOutOfWhiteListException;
import com.chenyang.nse.bussiness.exception.CustomException;
import com.chenyang.nse.bussiness.exception.TokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerExceptionAdvice {
   static final Logger logger = LoggerFactory.getLogger(ControllerExceptionAdvice.class);

   @ExceptionHandler
   @ResponseBody
   public Object exceptionHandler(Exception e) {
      logger.error("", e);
      return RespHelper.exceptionResp(e);
   }

   @ExceptionHandler
   @ResponseBody
   public Object exceptionHandler(BindException e) {
      logger.error("", e);
      return RespHelper.paramErrResp();
   }

   @ExceptionHandler
   @ResponseBody
   public Object exceptionHandler(TokenException e) {
      logger.error("", e);
      return RespHelper.createResptoken();
   }

   @ExceptionHandler
   @ResponseBody
   public Object exceptionHandler(ClientOutOfWhiteListException e) {
      logger.error("", e);
      return RespHelper.createRespOutOfWhiteList();
   }

   @ExceptionHandler
   @ResponseBody
   public Object exceptionHandler(CustomException e) {
      logger.error("custom error", e);
      return RespHelper.createResp(e.getCode(), e.getMsg());
   }
}
