package com.chenyang.nse.bussiness.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WebApiConfig {
   @Value("${datawebapi.maxValueSize:100000}")
   private int maxValueSize;
   @Value("${datawebapi.taskBatch:50000}")
   private int taskBatch;

   public int getMaxValueSize() {
      return this.maxValueSize;
   }

   public int getTaskBatch() {
      return this.taskBatch;
   }

   public void setMaxValueSize(final int maxValueSize) {
      this.maxValueSize = maxValueSize;
   }

   public void setTaskBatch(final int taskBatch) {
      this.taskBatch = taskBatch;
   }

   public boolean equals(final Object o) {
      if (o == this) {
         return true;
      } else if (!(o instanceof WebApiConfig)) {
         return false;
      } else {
         WebApiConfig other = (WebApiConfig)o;
         if (!other.canEqual(this)) {
            return false;
         } else if (this.getMaxValueSize() != other.getMaxValueSize()) {
            return false;
         } else {
            return this.getTaskBatch() == other.getTaskBatch();
         }
      }
   }

   protected boolean canEqual(final Object other) {
      return other instanceof WebApiConfig;
   }

   public int hashCode() {
      int PRIME = 59;
      int result = 1;
      result = result * 59 + this.getMaxValueSize();
      result = result * 59 + this.getTaskBatch();
      return result;
   }

   public String toString() {
      return "WebApiConfig(maxValueSize=" + this.getMaxValueSize() + ", taskBatch=" + this.getTaskBatch() + ")";
   }
}
