package com.chenyang.nse.bussiness.controller.api;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.vo.api.DiscoverApiDirectoryVO;
import com.chenyang.nse.bussiness.service.core.ApiDirectoryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/api/DirectoryTree"})
public class DirectoryTreeController {
   @Autowired
   ApiDirectoryService apiDirectoryService;

   @ResponseBody
   @RequestMapping({"/getDirectoryTree"})
   public Response getDirectoryTree(@RequestBody Map<String, String> params) {
      String projectid = (String)params.get("projectid");
      String editionid = (String)params.get("editionid");
      List<DiscoverApiDirectoryVO> allList = new ArrayList();
      List<DiscoverApiDirectoryVO> apiList = new ArrayList();
      DiscoverApiDirectoryVO apiDirectoryVO = new DiscoverApiDirectoryVO();
      apiDirectoryVO.setId("0");
      apiDirectoryVO.setText("API");
      apiDirectoryVO.setType("0");
      apiDirectoryVO.setState("open");
      DiscoverApiDirectoryVO discoverApiDirectoryVO = new DiscoverApiDirectoryVO();
      discoverApiDirectoryVO.setId("1");
      discoverApiDirectoryVO.setText("发现结果API");
      List<DiscoverApiDirectoryVO> discoverApiDirectory = this.getDiscoverApiDirectory(projectid, editionid);
      if (discoverApiDirectory.size() > 0) {
         discoverApiDirectoryVO.setState("closed");
      }

      discoverApiDirectoryVO.setChildren(discoverApiDirectory);
      apiList.add(discoverApiDirectoryVO);
      DiscoverApiDirectoryVO sortApiDirectoryVO = new DiscoverApiDirectoryVO();
      sortApiDirectoryVO.setId("2");
      sortApiDirectoryVO.setText("分类分级API");
      if (this.getSortApiDirectory(projectid, editionid).size() > 0) {
         sortApiDirectoryVO.setState("closed");
      }

      sortApiDirectoryVO.setChildren(this.getSortApiDirectory(projectid, editionid));
      apiList.add(sortApiDirectoryVO);
      DiscoverApiDirectoryVO accountabilityApiDirectoryVO = new DiscoverApiDirectoryVO();
      accountabilityApiDirectoryVO.setId("3");
      accountabilityApiDirectoryVO.setText("认责体系API");
      if (this.getAccountabilityApiDirectory(projectid, editionid).size() > 0) {
         accountabilityApiDirectoryVO.setState("closed");
      }

      accountabilityApiDirectoryVO.setChildren(this.getAccountabilityApiDirectory(projectid, editionid));
      apiList.add(accountabilityApiDirectoryVO);
      apiDirectoryVO.setChildren(apiList);
      allList.add(apiDirectoryVO);
      return RespHelper.successResp(allList);
   }

   public List<DiscoverApiDirectoryVO> getDiscoverApiDirectory(String projectid, String editionid) {
      return this.apiDirectoryService.getDiscoverApiDirectory(projectid, editionid);
   }

   public List<DiscoverApiDirectoryVO> getSortApiDirectory(String projectid, String editionid) {
      return this.apiDirectoryService.getSortApiDirectory(projectid, editionid);
   }

   public List<DiscoverApiDirectoryVO> getLevelApiDirectory(String projectid, String editionid) {
      return this.apiDirectoryService.getLevelApiDirectory(projectid, editionid);
   }

   public List<DiscoverApiDirectoryVO> getComplianceApiDirectory(String projectid, String editionid) {
      return this.apiDirectoryService.getComplianceApiDirectory(projectid, editionid);
   }

   public List<DiscoverApiDirectoryVO> getDesensitizationApiDirectory(String projectid, String editionid) {
      return this.apiDirectoryService.getDesensitizationApiDirectory(projectid, editionid);
   }

   public List<DiscoverApiDirectoryVO> getAccountabilityApiDirectory(String projectid, String editionid) {
      return this.apiDirectoryService.getAccountabilityApiDirectory(projectid, editionid);
   }
}
