package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.bean.CacheThreadImmediately;
import com.chenyang.nse.bussiness.commmon.json.ErrCode;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectDatasourceDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsersys;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreConfig;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreControlledAsset;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystemoracle;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectDatasource;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.DataSourceAndTaskVO;
import com.chenyang.nse.bussiness.entity.vo.DataSystemConfig;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.UserVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.DatasystemProjectdatasourceVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataDbType;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.console.UserService;
import com.chenyang.nse.bussiness.service.core.ConfigService;
import com.chenyang.nse.bussiness.service.core.ControlledAssetService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.impl.DataSystemServiceImpl;
import com.chenyang.nse.bussiness.tools.es.TelnetUtil;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.KafkaTool;
import com.chenyang.nse.bussiness.tools.jdbc.MongodbTool;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.net.FtpTool;
import com.chenyang.nse.bussiness.tools.net.NetTool;
import com.chenyang.nse.bussiness.tools.net.SFTPUtil;
import com.chenyang.nse.bussiness.tools.spring.SpringUtil;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.token.TokenUtil;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerVersion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/datasystem"})
public class DataSystemController {
   @Autowired
   private TCoreProjectDatasourceDao tCoreProjectDatasourceDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private ControlledAssetService controlledAssetService;
   @Autowired
   private UserService userService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private ConfigService configService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   @PostMapping({"/testConnect"})
   @ResponseBody
   public Response testConnectOnAddOrEdit(@RequestBody DataSystemConfig datasource, HttpServletRequest request, HttpServletResponse response, Model model) {
      Response res = RespHelper.successRespObj();
      ResultVO resultvo = new ResultVO();
      if (datasource.getDbtype().equals("ES")) {
         try {
            if (!TelnetUtil.telnet(datasource.getDbip(), Integer.parseInt(datasource.getDbport()), 2000)) {
               return RespHelper.errResp(ErrCode.CONNECT_ERROR_CODE);
            }
         } catch (Exception var31) {
            return RespHelper.errResp(ErrCode.CONNECT_ERROR_CODE);
         }

         final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
         credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(datasource.getUsername(), datasource.getPassword()));
         RestClient restClient = RestClient.builder(new HttpHost[]{new HttpHost(datasource.getDbip(), Integer.parseInt(datasource.getDbport()), "http")}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback() {
            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
               return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
         }).build();

         try {
            Request getRequest = new Request("GET", "/_mappings");
            restClient.performRequest(getRequest);
            restClient.close();
            resultvo = new ResultVO("连接成功!", true);
            res.setFlag(resultvo.getResult());
            res.setMsg(resultvo.getMessage());
            return res;
         } catch (IOException e) {
            e.printStackTrace();
            return RespHelper.errResp(ErrCode.CONNECT_ERROR_CODE);
         }
      } else {
         if (datasource.getDbtype().equals("HADOOP")) {
            resultvo = new ResultVO("连接成功!", true);
         }

         if (EdbType.KAFKA.getDbname().equals(datasource.getDbtype())) {
            Properties props = new Properties();
            props.put("bootstrap.servers", datasource.getDbip() + ":" + Integer.valueOf(datasource.getDbport()));
            ResultVO resultVO = new ResultVO();

            try {
               AdminClient adminClient = AdminClient.create(props);
               Throwable var55 = null;

               try {
                  ListTopicsResult topicsResult = adminClient.listTopics();
                  ((Collection)topicsResult.listings().get(10L, TimeUnit.SECONDS)).forEach((topic) -> System.out.println("Topic: " + topic.toString()));
                  System.out.println("Kafka connectivity test passed.");
                  resultVO.setResult(true);
                  resultVO.setMessage("Kafka connectivity test passed.");
               } catch (Throwable var29) {
                  var55 = var29;
                  throw var29;
               } finally {
                  if (adminClient != null) {
                     if (var55 != null) {
                        try {
                           adminClient.close();
                        } catch (Throwable var28) {
                           var55.addSuppressed(var28);
                        }
                     } else {
                        adminClient.close();
                     }
                  }

               }
            } catch (Exception e) {
               resultVO.setResult(false);
               resultVO.setMessage("Kafka connectivity test failed: " + e.getMessage());
            }

            res.setFlag(resultVO.getResult());
            res.setMsg(resultVO.getMessage());
            return res;
         } else {
            if (!"MONGODB".equals(datasource.getDbtype())) {
               if ("LOCALFILE".equals(datasource.getDbtype())) {
                  resultvo.setResult(true);
                  res.setFlag(resultvo.getResult());
                  res.setMsg(resultvo.getMessage());
                  return res;
               }

               if ("SFTP".equals(datasource.getDbtype())) {
                  SFTPUtil sftp = new SFTPUtil(datasource.getUsername(), datasource.getPassword(), datasource.getDbip(), Integer.valueOf(datasource.getDbport()));
                  resultvo = SFTPUtil.login();
                  boolean b = resultvo.getResult();
                  sftp.logout();
                  if (b) {
                     res.setFlag(resultvo.getResult());
                     res.setMsg(resultvo.getMessage());
                     return res;
                  }

                  res.setFlag(resultvo.getResult());
                  res.setMsg(resultvo.getMessage());
                  return res;
               }

               if ("FTP".equals(datasource.getDbtype())) {
                  resultvo = FtpTool.ftpConnect(datasource.getDbip(), Integer.valueOf(datasource.getDbport()), datasource.getUsername(), datasource.getPassword());
                  boolean b = resultvo.getResult();
                  if (b) {
                     res.setFlag(resultvo.getResult());
                     res.setMsg(resultvo.getMessage());
                     return res;
                  }

                  res.setFlag(resultvo.getResult());
                  res.setMsg(resultvo.getMessage());
                  return res;
               }

               boolean result = true;
               String url = "";
               if (datasource.getDbtype().equals("POSTGRESQL")) {
                  datasource.setDbtype("GREENPLUM");
               }

               String driver = EdbType.getEdbTypeByDbcode(datasource.getDbtype()).getDbdriver();
               String code = EdbType.getEdbTypeByDbname(datasource.getDbtype()).getDbcode();
               String msg = datasource.getDbtype();
               byte insList = -1;
               switch (msg.hashCode()) {
                  case 62553026:
                     if (msg.equals("AS400")) {
                        insList = 1;
                     }
                     break;
                  case 961463896:
                     if (msg.equals("INFORMIX")) {
                        insList = 0;
                     }
               }

               label410: {
                  driver = EdbType.getEdbTypeByDbcode(datasource.getDbtype()).getDbdriver();
                  code = EdbType.getEdbTypeByDbname(datasource.getDbtype()).getDbcode();
                  String[] ips;
                  String[] ports;
                  List<Map<String, String>> ipports;
                  int i;
                  switch (datasource.getDbtype()) {
                     case "INFORMIX":
                        url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername(), datasource.getServername());
                        break label410;
                     case "AS400":
                        url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbservername(), datasource.getServername());
                        break label410;
                     default:
                        if (StringUtils.isNotBlank(datasource.getDbip()) && !code.equals(EdbType.GAUSSDB.getDbcode())) {
                           url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername());
                           break label410;
                        }

                        ips = datasource.getDbip().split(",");
                        ports = datasource.getDbport().split(",");
                        ipports = new ArrayList();
                        i = 0;
                  }

                  while(i < ips.length) {
                     Map<String, String> map = new HashMap();
                     map.put("ip", ips[i]);
                     map.put("port", ports[i]);
                     ipports.add(map);
                     ++i;
                  }

                  url = EdbType.getUrlByEdbcode(datasource.getDbtype(), ipports, datasource.getDbservername(), datasource.getDbservername());
               }

               if ("HIVE".equals(datasource.getDbtype()) && "on".equals(datasource.getIskerberos())) {
                  System.setProperty("java.security.krb5.conf", datasource.getXmlpath() + "/krb5.conf");
                  Connection conn = JdbcTool.getKerberosConn(url + ";principal=" + datasource.getPrincipal(), driver, datasource.getLoginprincipal(), datasource.getXmlpath());
                  if (conn != null) {
                     try {
                        conn.close();
                     } catch (SQLException e) {
                        e.printStackTrace();
                     }

                     res.setFlag(true);
                     res.setMsg("成功连接到kerberos");
                     return res;
                  }

                  res.setFlag(false);
                  res.setMsg("无法获取kerberos连接");
                  return res;
               }

               StringBuffer msgBuffer = new StringBuffer();
               if (!"ORACLE".equals(datasource.getDbtype())) {
                  resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), datasource.getPassword());
               } else if ("1".equals(datasource.getOracleisins())) {
                  List<TCoreDatasystemoracle> insListNew = datasource.getOracleIns();
                  if (!ObjectUtils.isEmpty(insListNew)) {
                     for(int i = 0; i < insListNew.size(); ++i) {
                        TCoreDatasystemoracle ins = (TCoreDatasystemoracle)insListNew.get(i);
                        url = EdbType.getUrlByEdbcode("ORACLEINS", ins.getInsip(), ins.getInsport(), ins.getInsname());
                        resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), datasource.getPassword());
                        if (StringUtils.isEmpty(ins.getInsname())) {
                           ins.setInsname(" ??? ");
                        }

                        this.appendInstanceMsg(msgBuffer, resultvo, ins);
                        if (!resultvo.getResult()) {
                           break;
                        }
                     }
                  }
               } else {
                  url = EdbType.getUrlByEdbcode("ORACLE", datasource.getDbip(), datasource.getDbport(), datasource.getDbservername());
                  resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), datasource.getPassword());
                  this.appendServiceMsg(msgBuffer, resultvo, datasource.getDbservername(), datasource);
                  if (StringUtils.isEmpty(datasource.getDbservername())) {
                     datasource.setDbservername(" ??? ");
                  }

                  resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), datasource.getPassword());
               }

               if ("ORACLE".equals(datasource.getDbtype()) && StringUtils.isNotBlank(msgBuffer.toString())) {
                  resultvo.setMessage(msgBuffer.toString());
               }

               result = resultvo.getResult();
               if (!result || StringUtils.isNotBlank(resultvo.getMessage())) {
                  res.setFlag(false);
                  res.setMsg(resultvo.getMessage());
                  return res;
               }
            } else {
               MongoClient client = null;

               try {
                  if (!"".equals(datasource.getDbservername()) && datasource.getDbservername() != null) {
                     client = MongodbTool.connect(datasource.getDbservername(), datasource.getUsername(), datasource.getPassword(), datasource.getDbip(), Integer.parseInt(datasource.getDbport()), true);
                  } else {
                     client = MongodbTool.connect(datasource.getDbservername(), datasource.getUsername(), datasource.getPassword(), datasource.getDbip(), Integer.parseInt(datasource.getDbport()), false);
                  }

                  client.getDatabaseNames();
                  resultvo = new ResultVO("连接成功!", true);
               } catch (Exception e) {
                  String message = SFTPUtil.getExceptionSrintStackTrace(e);
                  resultvo.setMessage(message);
                  resultvo.setResult(false);
               }
            }

            res.setFlag(resultvo.getResult());
            res.setMsg(resultvo.getMessage());
            return res;
         }
      }
   }

   @PostMapping({"/checkVersion"})
   @ResponseBody
   public Response checkVersion(@RequestBody DataSystemConfig datasource, HttpServletRequest request, HttpServletResponse response, Model model) {
      Response res = RespHelper.successRespObj();
      ResultVO resultvo = new ResultVO();
      if ("ES".equals(datasource.getDbtype())) {
         try {
            if (!TelnetUtil.telnet(datasource.getDbip(), Integer.parseInt(datasource.getDbport()), 2000)) {
               return RespHelper.errResp(ErrCode.CONNECT_ERROR_CODE);
            }
         } catch (Exception var20) {
            return RespHelper.errResp(ErrCode.CONNECT_ERROR_CODE);
         }

         final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
         credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(datasource.getUsername(), datasource.getPassword()));
         RestClient restClient = RestClient.builder(new HttpHost[]{new HttpHost(datasource.getDbip(), Integer.parseInt(datasource.getDbport()), "http")}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback() {
            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
               return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
         }).build();

         try {
            Request getRequest = new Request("GET", "");
            org.elasticsearch.client.Response response1 = restClient.performRequest(getRequest);
            HttpEntity entity = response1.getEntity();
            String e = EntityUtils.toString(entity);
            e = e.replace("{", "").replace("}", "").replace("\n", "").replaceAll(" +", "").replace("\"", "").replace(",", ":");
            String[] earray = e.split(":");
            String version = "";

            for(int i = 0; i < earray.length; ++i) {
               if ("number".equals(earray[i]) && i + 1 < earray.length) {
                  version = earray[i + 1];
                  break;
               }
            }

            restClient.close();
            resultvo = new ResultVO("连接成功!", true);
            res.setFlag(resultvo.getResult());
            res.setMsg(resultvo.getMessage());
            res.setData(version);
            return res;
         } catch (IOException e) {
            e.printStackTrace();
            return RespHelper.errResp(ErrCode.CONNECT_ERROR_CODE);
         }
      } else if ("HADOOP".equals(datasource.getDbtype())) {
         resultvo = new ResultVO("连接成功!", true);
         res.setFlag(resultvo.getResult());
         res.setMsg("1.0.0");
         return res;
      } else if (EdbType.KAFKA.getDbname().equals(datasource.getDbtype())) {
         Package kafkaPackage = ConsumerConfig.class.getPackage();
         String version = kafkaPackage.getImplementationVersion();
         new ResultVO("连接成功!", true);
         resultvo = KafkaTool.conntest(datasource.getDbip(), Integer.parseInt(datasource.getDbport()));
         res.setFlag(resultvo.getResult());
         res.setMsg(version);
         return res;
      } else {
         if (!"MONGODB".equals(datasource.getDbtype())) {
            if ("LOCALFILE".equals(datasource.getDbtype())) {
               resultvo.setResult(true);
               res.setFlag(resultvo.getResult());
               res.setMsg(resultvo.getMessage());
               return res;
            }

            if ("SFTP".equals(datasource.getDbtype())) {
               SFTPUtil sftp = new SFTPUtil(datasource.getUsername(), datasource.getPassword(), datasource.getDbip(), Integer.valueOf(datasource.getDbport()));
               resultvo = SFTPUtil.login();
               boolean b = resultvo.getResult();
               sftp.logout();
               if (b) {
                  res.setFlag(resultvo.getResult());
                  res.setMsg(resultvo.getMessage());
                  return res;
               }

               res.setFlag(resultvo.getResult());
               res.setMsg(resultvo.getMessage());
               return res;
            }

            if ("FTP".equals(datasource.getDbtype())) {
               resultvo = FtpTool.ftpConnect(datasource.getDbip(), Integer.valueOf(datasource.getDbport()), datasource.getUsername(), datasource.getPassword());
               boolean b = resultvo.getResult();
               if (b) {
                  res.setFlag(resultvo.getResult());
                  res.setMsg(resultvo.getMessage());
                  return res;
               }

               res.setFlag(resultvo.getResult());
               res.setMsg(resultvo.getMessage());
               return res;
            }

            boolean result = true;
            String url = "";
            String driver = EdbType.getEdbTypeByDbcode(datasource.getDbtype()).getDbdriver();
            String code = EdbType.getEdbTypeByDbname(datasource.getDbtype()).getDbcode();
            String clusterDescription = datasource.getDbtype();
            byte serverDescriptionList = -1;
            switch (clusterDescription.hashCode()) {
               case 62553026:
                  if (clusterDescription.equals("AS400")) {
                     serverDescriptionList = 1;
                  }
                  break;
               case 961463896:
                  if (clusterDescription.equals("INFORMIX")) {
                     serverDescriptionList = 0;
                  }
            }

            label206: {
               boolean resultNew = true;
               String urlNew = "";
               String driverNew = EdbType.getEdbTypeByDbcode(datasource.getDbtype()).getDbdriver();
               String codeNew = EdbType.getEdbTypeByDbname(datasource.getDbtype()).getDbcode();
               String[] ips;
               String[] ports;
               List<Map<String, String>> ipports;
               int i;
               switch (datasource.getDbtype()) {
                  case "INFORMIX":
                     url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername(), datasource.getServername());
                     break label206;
                  case "AS400":
                     url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbservername(), datasource.getServername());
                     break label206;
                  default:
                     if (StringUtils.isNotBlank(datasource.getDbip()) && !codeNew.equals(EdbType.GAUSSDB.getDbcode())) {
                        url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername());
                        break label206;
                     }

                     ips = datasource.getDbip().split(",");
                     ports = datasource.getDbport().split(",");
                     ipports = new ArrayList();
                     i = 0;
               }

               while(i < ips.length) {
                  Map<String, String> map = new HashMap();
                  map.put("ip", ips[i]);
                  map.put("port", ports[i]);
                  ipports.add(map);
                  ++i;
               }

               url = EdbType.getUrlByEdbcode(datasource.getDbtype(), ipports, datasource.getDbservername(), datasource.getDbservername());
            }

            if ("HIVE".equals(datasource.getDbtype()) && "on".equals(datasource.getIskerberos())) {
               System.setProperty("java.security.krb5.conf", datasource.getXmlpath() + "/krb5.conf");
               Connection conn = JdbcTool.getKerberosConn(url + ";principal=" + datasource.getPrincipal(), driver, datasource.getLoginprincipal(), datasource.getXmlpath());
               if (conn != null) {
                  try {
                     conn.close();
                  } catch (SQLException e) {
                     e.printStackTrace();
                  }

                  res.setFlag(true);
                  res.setMsg("成功连接到kerberos");
                  return res;
               }

               res.setFlag(false);
               res.setMsg("无法获取kerberos连接");
               return res;
            }

            StringBuffer msg = new StringBuffer();
            if (!"ORACLE".equals(datasource.getDbtype())) {
               resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), datasource.getPassword());
            } else if ("1".equals(datasource.getOracleisins())) {
               List<TCoreDatasystemoracle> insList = datasource.getOracleIns();
               if (!ObjectUtils.isEmpty(insList)) {
                  for(int i = 0; i < insList.size(); ++i) {
                     TCoreDatasystemoracle ins = (TCoreDatasystemoracle)insList.get(i);
                     url = EdbType.getUrlByEdbcode("ORACLEINS", ins.getInsip(), ins.getInsport(), ins.getInsname());
                     resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), datasource.getPassword());
                     if (StringUtils.isEmpty(ins.getInsname())) {
                        ins.setInsname(" ??? ");
                     }

                     this.appendInstanceMsg(msg, resultvo, ins);
                     if (!resultvo.getResult()) {
                        break;
                     }
                  }
               }
            } else {
               url = EdbType.getUrlByEdbcode("ORACLE", datasource.getDbip(), datasource.getDbport(), datasource.getDbservername());
               resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), datasource.getPassword());
               this.appendServiceMsg(msg, resultvo, datasource.getDbservername(), datasource);
               if (StringUtils.isEmpty(datasource.getDbservername())) {
                  datasource.setDbservername(" ??? ");
               }

               resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), datasource.getPassword());
            }

            if ("ORACLE".equals(datasource.getDbtype()) && StringUtils.isNotBlank(msg.toString())) {
               resultvo.setMessage(msg.toString());
            }

            result = resultvo.getResult();
            if (!result || StringUtils.isNotBlank(resultvo.getMessage())) {
               res.setFlag(false);
               res.setMsg(resultvo.getMessage());
               return res;
            }
         } else {
            MongoClient client = null;

            try {
               if (!"".equals(datasource.getDbservername()) && datasource.getDbservername() != null) {
                  client = MongodbTool.connect(datasource.getDbservername(), datasource.getUsername(), datasource.getPassword(), datasource.getDbip(), Integer.parseInt(datasource.getDbport()), true);
               } else {
                  client = MongodbTool.connect(datasource.getDbservername(), datasource.getUsername(), datasource.getPassword(), datasource.getDbip(), Integer.parseInt(datasource.getDbport()), false);
               }

               Class cls = Mongo.class;
               Method method = cls.getDeclaredMethod("getCluster");
               method.setAccessible(true);
               Cluster cluster = (Cluster)method.invoke(client);
               ClusterDescription clusterDescription = cluster.getDescription();
               List<ServerDescription> serverDescriptionList = clusterDescription.getServerDescriptions();
               ServerDescription serverDescription = (ServerDescription)serverDescriptionList.get(0);
               ServerVersion serverVersion = serverDescription.getVersion();
               List<Integer> integerList = serverVersion.getVersionList();
               String v = "";

               for(int i = 0; i < integerList.size(); ++i) {
                  if (i != 0) {
                     v = v + "." + integerList.get(i);
                  } else {
                     v = v + integerList.get(i);
                  }
               }

               resultvo.setResult(true);
               resultvo.setVersion(v);
            } catch (Exception e) {
               String message = SFTPUtil.getExceptionSrintStackTrace(e);
               resultvo.setMessage(message);
               resultvo.setResult(false);
            }
         }

         res.setFlag(resultvo.getResult());
         res.setMsg(resultvo.getMessage());
         res.setData(resultvo.getVersion());
         return res;
      }
   }

   private void appendServiceMsg(StringBuffer msg, ResultVO resultvo, String serviceName, DataSystemConfig datasource) {
      if (!ObjectUtils.isEmpty(resultvo) && !resultvo.getResult() && StringUtils.isNotBlank(resultvo.getMessage())) {
         String serviceNameConfig = "服务名[";
         String linkError = "]连接不通";
         msg.append(serviceNameConfig).append(serviceName).append(linkError).append("[ip: ").append(datasource.getDbip()).append("]").append("[port: ").append(datasource.getDbport()).append("]").append(resultvo.getMessage());
      }

   }

   private void appendInstanceMsg(StringBuffer msg, ResultVO resultvo, TCoreDatasystemoracle ins) {
      if (!ObjectUtils.isEmpty(resultvo) && !resultvo.getResult() && StringUtils.isNotBlank(resultvo.getMessage())) {
         msg.append("实例名[").append(ins.getInsname()).append("]连接不通").append("[ip: ").append(ins.getInsip()).append("]").append("[port: ").append(ins.getInsport()).append("]").append(resultvo.getMessage()).append("\n");
      }

   }

   @ResponseBody
   @RequestMapping({"/initEdit"})
   public Response<DataSystemConfig> queryByFlagById(String flag, String id) {
      DataSystemConfig tCoreDatasystem = this.dataSystemService.queryByFlagById(flag, id);
      return RespHelper.<DataSystemConfig>successResp(tCoreDatasystem);
   }

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/datasystem/datasystem";
   }

   @RequestMapping({"/relationaldatabase"})
   public String relationaldatabase(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/datasystem/relationaldatabase";
   }

   @RequestMapping({"/datafile"})
   public String datafile(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/datasystem/datafile";
   }

   @RequestMapping({"/hadoop"})
   public String hadoop(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/datasystem/hadoop";
   }

   @RequestMapping({"/nosql"})
   public String nosql(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/datasystem/nosql";
   }

   @RequestMapping({"/kafka"})
   public String kafka(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/datasystem/kafka";
   }

   @ResponseBody
   @GetMapping({"/queryAll"})
   public Response query(String sysname, String ip, String projectId, String dbtype, String userId) {
      List<TCoreDatasystem> list = this.dataSystemService.queryAll(sysname, ip, dbtype, userId);
      List<TCoreDatasystem> newList = new ArrayList();
      CollectionUtils.addAll(newList, new Object[list.size()]);
      Collections.copy(newList, list);

      for(TCoreDatasystem tCoreDatasystem : list) {
         tCoreDatasystem.setPassword(AesTool.decrypt(tCoreDatasystem.getPassword(), "ghca"));
      }

      List<TCoreDatasystem> listl = new ArrayList();
      if (StringUtils.isNotBlank(projectId)) {
         List<TCoreProjectDatasource> listProject = this.tCoreProjectDatasourceDao.queryAll(new Criterion[]{Restrictions.eq("project_id", projectId)});
         if (null != listProject && listProject.size() > 0) {
            List<String> did = (List)listProject.stream().map(TCoreProjectDatasource::getSystemsource_id).collect(Collectors.toList());
            listl = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.in("id", did)});
         }
      }

      ddmauditLogger.info(MesUtil.getMsg("DDM_01101", new String[]{CommonUtils.loginUsername()}));
      return StringUtils.isNotBlank(projectId) ? RespHelper.successResp(listl) : RespHelper.successResp(list);
   }

   @ResponseBody
   @GetMapping({"/query"})
   public Response query(String type, PageInfo pageInfo, Integer pageno, Integer pagesize, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(pageno);
      pageInfo.setPagesize(pagesize);
      List<String> flag = new ArrayList();
      flag.add(type);
      List<TCoreDatasystem> list = this.dataSystemService.query(flag, pageInfo);
      if ("1".equals(type)) {
         for(TCoreDatasystem tCoreDatasystem : list) {
            tCoreDatasystem.setPassword(AesTool.decrypt(tCoreDatasystem.getPassword(), "ghca"));
         }
      }

      ddmauditLogger.info(MesUtil.getMsg("DDM_01101", new String[]{CommonUtils.loginUsername()}));
      return RespHelper.updateResp(pageInfo, list);
   }

   @PostMapping({"/del"})
   @ResponseBody
   public Response remove(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = (String)params.get("id");
      String sysname = (String)params.get("sysname");
      ddmauditLogger.info(MesUtil.getMsg("DDM_01105", new String[]{CommonUtils.loginUsername(), sysname}));
      this.dataSystemService.remove(id);
      return RespHelper.successResp();
   }

   @RequestMapping({"/getFileSysGroup"})
   @ResponseBody
   public List<ComboboxVO> getFileSysGroup(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      new ArrayList();
      List<ComboboxVO> list = this.dataSystemService.getFileSysGroup(id);
      return list;
   }

   @PostMapping({"/add"})
   @ResponseBody
   public Response<TCoreDatasystem> add(@RequestBody DataSystemConfig dataSystemConfig, String linkname, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreDatasystem datasource = new TCoreDatasystem();
      datasource.setCreateuser(TokenUtil.getUserName(request.getHeader("token")));
      datasource.setCreatetime(dataSystemConfig.getCreattime());
      datasource.setDbip(StringUtils.isBlank(dataSystemConfig.getDbip()) ? "" : dataSystemConfig.getDbip());
      datasource.setDbport(dataSystemConfig.getDbport());
      datasource.setServername(dataSystemConfig.getServername());
      datasource.setDbtype(dataSystemConfig.getDbtype());
      datasource.setVersionname(dataSystemConfig.getVersionname());
      datasource.setId(dataSystemConfig.getId());
      datasource.setSysname(dataSystemConfig.getSysname());
      datasource.setUsername(dataSystemConfig.getUsername());
      datasource.setPassword(dataSystemConfig.getPassword());
      datasource.setPagecode(dataSystemConfig.getPagecode());
      datasource.setDblinkname(dataSystemConfig.getSysname());
      datasource.setIskerberos(dataSystemConfig.getIskerberos());
      datasource.setPrincipal(dataSystemConfig.getPrincipal());
      datasource.setLoginprincipal(dataSystemConfig.getLoginprincipal());
      datasource.setKeytab(dataSystemConfig.getKeytab());
      datasource.setVersion(dataSystemConfig.getVersion());
      datasource.setIstargetdb("");
      datasource.setConnectmode(dataSystemConfig.getConnectmode());
      datasource.setXmlpath(dataSystemConfig.getXmlpath());
      datasource.setFlag(dataSystemConfig.getFlag());
      if ("ORACLE".equals(dataSystemConfig.getDbtype())) {
         datasource.setIssysdba(dataSystemConfig.getIssysdba());
      } else {
         datasource.setIssysdba("");
      }

      datasource.setOracleisins(dataSystemConfig.getOracleisins());
      List<TBaseUser> users = dataSystemConfig.getUser();
      List<TCoreDatasystemoracle> oracleIns = dataSystemConfig.getOracleIns();
      String ip = "";
      String port = "";
      ip = dataSystemConfig.getDbip();
      port = dataSystemConfig.getDbport();
      if (oracleIns != null && oracleIns.size() > 0) {
         ip = ((TCoreDatasystemoracle)oracleIns.get(0)).getInsip();
         port = ((TCoreDatasystemoracle)oracleIns.get(0)).getInsport();
      }

      if (dataSystemConfig.getDbtype().equals("KAFKA")) {
         datasource.setDbservername("KAFKA");
      } else {
         datasource.setDbservername(StringUtils.isEmpty(dataSystemConfig.getDbservername()) ? "ES" : dataSystemConfig.getDbservername());
         String code = dataSystemConfig.getDbtype() + ":" + ip + ":" + port + ":" + dataSystemConfig.getDbservername();
         datasource.setCode(code.hashCode() + "");
      }

      this.dataSystemService.save((TCoreConfig)null, datasource, linkname, users, oracleIns);
      String userid = CommonUtils.loginUser().getId();
      TBaseUsersys userSys = new TBaseUsersys();
      userSys.setUserid(userid);
      userSys.setSysid(datasource.getId());
      userSys.setCrud("1");
      userSys.setUpdateuserid(userid);
      this.userService.saveUserSys(userSys);
      DataSystemServiceImpl dataSystemService = (DataSystemServiceImpl)SpringUtil.getBean(DataSystemServiceImpl.class);
      (new CacheThreadImmediately(dataSystemService, datasource)).start();
      return RespHelper.<TCoreDatasystem>successResp(datasource);
   }

   @RequestMapping({"/queryconfig"})
   @ResponseBody
   public TCoreConfig queryBydbtype(String dbtype, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreConfig tCoreConfig = this.configService.queryBydbtype(dbtype);
      return tCoreConfig;
   }

   @RequestMapping({"/testConnect33"})
   @ResponseBody
   public ResultVO testConnecdt(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreDatasystem datasource = this.dataSystemService.queryDataSystemById(id);
      ResultVO resultvo = new ResultVO();
      if (EdbType.KAFKA.getDbname().equals(datasource.getDbtype())) {
         new ResultVO("连接成功!", true);
         resultvo = KafkaTool.conntest(datasource.getDbip(), Integer.parseInt(datasource.getDbport()));
         return resultvo;
      } else {
         if ("MONGODB".equals(datasource.getDbtype())) {
            resultvo = new ResultVO("连接成功!", true);

            try {
               if (!"".equals(datasource.getDbservername()) && datasource.getDbservername() != null) {
                  MongoClient connect = MongodbTool.connect(datasource.getDbservername(), datasource.getUsername(), datasource.getPassword(), datasource.getDbip(), Integer.parseInt(datasource.getDbport()), true);
                  connect.getDatabaseNames();
               } else {
                  MongodbTool.connect(datasource.getDbservername(), datasource.getUsername(), datasource.getPassword(), datasource.getDbip(), Integer.parseInt(datasource.getDbport()), false);
               }
            } catch (Exception e) {
               String message = SFTPUtil.getExceptionSrintStackTrace(e);
               resultvo.setMessage(message);
               resultvo.setResult(false);
            }
         } else {
            if ("LOCALFILE".equals(datasource.getDbtype())) {
               resultvo.setResult(true);
               return resultvo;
            }

            if ("SFTP".equals(datasource.getDbtype())) {
               SFTPUtil sftp = new SFTPUtil(datasource.getUsername(), datasource.getPassword(), datasource.getDbip(), Integer.valueOf(datasource.getDbport()));
               resultvo = SFTPUtil.login();
               boolean b = resultvo.getResult();
               sftp.logout();
               if (b) {
                  return resultvo;
               }

               return resultvo;
            }

            if ("FTP".equals(datasource.getDbtype())) {
               resultvo = FtpTool.ftpConnect(datasource.getDbip(), Integer.valueOf(datasource.getDbport()), datasource.getUsername(), datasource.getPassword());
               boolean b = resultvo.getResult();
               if (b) {
                  return resultvo;
               }

               return resultvo;
            }

            boolean result = true;
            if (!datasource.getDbtype().equalsIgnoreCase("AS400")) {
               resultvo = NetTool.isHostConnectable(datasource.getDbip(), Integer.parseInt(datasource.getDbport()));
               if (resultvo.getResult() != null && !resultvo.getResult()) {
                  return resultvo;
               }
            }

            String url = "";
            String driver = EdbType.getEdbTypeByDbcode(datasource.getDbtype()).getDbdriver();
            switch (datasource.getDbtype()) {
               case "INFORMIX":
                  url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername(), datasource.getServername());
                  break;
               case "AS400":
                  url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbservername(), datasource.getServername());
                  break;
               default:
                  url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername());
            }

            if ("HIVE".equals(datasource.getDbtype()) && "on".equals(datasource.getIskerberos())) {
               System.setProperty("java.security.krb5.conf", datasource.getXmlpath() + "/krb5.conf");
               Connection conn = JdbcTool.getKerberosConn(url + ";principal=" + datasource.getPrincipal(), driver, datasource.getLoginprincipal(), datasource.getXmlpath());
               if (conn != null) {
                  try {
                     conn.close();
                  } catch (SQLException e) {
                     e.printStackTrace();
                  }

                  return new ResultVO("成功连接到kerberos", true);
               }

               return new ResultVO("无法获取kerberos连接", false);
            }

            String password = "1".equals(datasource.getFlag()) ? AesTool.decrypt(datasource.getPassword(), "ghca") : datasource.getPassword();
            resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), password);
            result = resultvo.getResult();
            if (!result) {
               return resultvo;
            }
         }

         return resultvo;
      }
   }

   @RequestMapping({"/testConnectOn"})
   @ResponseBody
   public ResultVO testConnectOn(String datasystemid, HttpServletRequest request, HttpServletResponse response, Model model) {
      ResultVO resultvo = new ResultVO();
      TCoreDatasystem datasource = this.dataSystemService.queryDataSystemById(datasystemid);
      if (!"3".equals(datasource.getFlag()) && !"5".equals(datasource.getFlag())) {
         datasource.setPassword(AesTool.decrypt(datasource.getPassword(), "ghca"));
      }

      if (EdbType.KAFKA.getDbname().equals(datasource.getDbtype())) {
         Properties props = new Properties();
         props.put("bootstrap.servers", datasource.getDbip() + ":" + Integer.valueOf(datasource.getDbport()));

         try {
            AdminClient adminClient = AdminClient.create(props);
            Throwable var54 = null;

            ResultVO var12;
            try {
               ListTopicsResult topicsResult = adminClient.listTopics();
               ((Collection)topicsResult.listings().get(10L, TimeUnit.SECONDS)).forEach((topic) -> System.out.println("Topic: " + topic.toString()));
               System.out.println("Kafka connectivity test passed.");
               ResultVO resultVO = new ResultVO();
               resultVO.setResult(true);
               resultVO.setMessage("Kafka connectivity test passed.");
               var12 = resultVO;
            } catch (Throwable var38) {
               var54 = var38;
               throw var38;
            } finally {
               if (adminClient != null) {
                  if (var54 != null) {
                     try {
                        adminClient.close();
                     } catch (Throwable var37) {
                        var54.addSuppressed(var37);
                     }
                  } else {
                     adminClient.close();
                  }
               }

            }

            return var12;
         } catch (Exception e) {
            ResultVO resultVO = new ResultVO();
            resultVO.setResult(false);
            resultVO.setMessage("Kafka connectivity test failed: " + e.getMessage());
            return resultVO;
         }
      } else if ("LOCALFILE".equals(datasource.getDbtype())) {
         resultvo.setResult(true);
         return resultvo;
      } else if ("SFTP".equals(datasource.getDbtype())) {
         SFTPUtil sftp = new SFTPUtil(datasource.getUsername(), datasource.getPassword(), datasource.getDbip(), Integer.valueOf(datasource.getDbport()));
         resultvo = SFTPUtil.login();
         boolean b = resultvo.getResult();
         sftp.logout();
         return b ? resultvo : resultvo;
      } else if ("FTP".equals(datasource.getDbtype())) {
         resultvo = FtpTool.ftpConnect(datasource.getDbip(), Integer.valueOf(datasource.getDbport()), datasource.getUsername(), datasource.getPassword());
         boolean b = resultvo.getResult();
         return b ? resultvo : resultvo;
      } else {
         boolean result = true;
         String url = "";
         String driver = EdbType.getEdbTypeByDbcode(datasource.getDbtype()).getDbdriver();
         switch (datasource.getDbtype()) {
            case "INFORMIX":
               url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername(), datasource.getServername());
               break;
            case "AS400":
               url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbservername(), datasource.getServername());
               break;
            default:
               url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername());
         }

         if ("HIVE".equals(datasource.getDbtype()) && "on".equals(datasource.getIskerberos())) {
            System.setProperty("java.security.krb5.conf", datasource.getXmlpath() + "/krb5.conf");
            Connection conn = null;

            try {
               conn = JdbcTool.getKerberosConnect(url + ";principal=" + datasource.getPrincipal(), driver, datasource.getLoginprincipal(), datasource.getXmlpath());
            } catch (IOException | SQLException | ClassNotFoundException e1) {
               ((Exception)e1).printStackTrace();
               resultvo.setMessage(JdbcTool.getExceptionSrintStackTrace(e1));
               resultvo.setResult(false);
            } finally {
               if (conn != null) {
                  try {
                     conn.close();
                  } catch (SQLException e) {
                     e.printStackTrace();
                  }

                  resultvo.setMessage("");
                  resultvo.setResult(true);
               }

               return resultvo;
            }
         } else {
            resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), datasource.getPassword());
            result = resultvo.getResult();
            return !result ? resultvo : resultvo;
         }
      }
   }

   @RequestMapping({"/validatelinkname"})
   @ResponseBody
   public String validatelinkname(String value, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreDatasystem> list = this.dataSystemService.query("1");
      List<String> linkname = new ArrayList();

      for(TCoreDatasystem tCoreDatasystem : list) {
         linkname.add(tCoreDatasystem.getDblinkname());
      }

      return linkname.contains(value) ? "0" : "1";
   }

   @RequestMapping({"/validatesystemname"})
   @ResponseBody
   public String validatesystemname(String value, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreDatasystem> list = this.dataSystemService.query("1");
      List<String> linkname = new ArrayList();

      for(TCoreDatasystem tCoreDatasystem : list) {
         linkname.add(tCoreDatasystem.getSysname());
      }

      return linkname.contains(value) ? "0" : "1";
   }

   @RequestMapping({"/getlocal"})
   @ResponseBody
   public String getlocal(String path, long num, HttpServletRequest request, HttpServletResponse response, Model model) {
      StringBuffer sb = new StringBuffer();

      try {
         Process process = Runtime.getRuntime().exec("tail -n " + num + " " + path);
         InputStream inputStream = process.getInputStream();
         BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));

         String line;
         while((line = reader.readLine()) != null) {
            sb.append(line + "<br>");
         }

         process.waitFor();
         if (process != null) {
            process.destroy();
         }
      } catch (Exception var16) {
      } finally {
         ;
      }

      return sb.toString();
   }

   @ResponseBody
   @RequestMapping({"/queryByEditSort"})
   public DataGridVO<DatasystemProjectdatasourceVO> queryByEditSort(String userid, String dbtype, String flag, PageInfo pageInfo, int rows, int page) {
      DataGridVO<DatasystemProjectdatasourceVO> vo = null;
      List<DatasystemProjectdatasourceVO> list = null;
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      if ("1".equals(userid)) {
         list = this.dataSystemService.queryByEditSort(flag, dbtype, pageInfo);
         vo = new DataGridVO<DatasystemProjectdatasourceVO>(pageInfo.getCount(), list);
      } else {
         List<TBaseUsersys> tBaseUsersys = this.dataSystemService.queryTBaseUsersysByUserid(userid);
         List<String> groupidlist = this.userService.queryGroupByusrid(userid);
         if (tBaseUsersys.size() == 0 && groupidlist.size() == 0) {
            vo = new DataGridVO<DatasystemProjectdatasourceVO>(pageInfo.getCount(), list);
         } else {
            new ArrayList();
            String groupid = (String)groupidlist.get(0);
            list = this.dataSystemService.queryByCrud(userid, groupid, flag, dbtype, pageInfo);
            vo = new DataGridVO<DatasystemProjectdatasourceVO>(pageInfo.getCount(), list);
         }
      }

      return vo;
   }

   @ResponseBody
   @RequestMapping({"/queryByFlag"})
   public List<ComboboxVO> queryByFlag(String flag) {
      List<ComboboxVO> list = this.dataSystemService.queryByFlag(flag);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryByFlagHadoop"})
   public List<ComboboxVO> queryByFlagHadoop(String flag, HttpServletRequest request, HttpServletResponse response) {
      List<ComboboxVO> list = this.dataSystemService.queryByFlagHadoop(flag);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryByFlagNosql"})
   public List<ComboboxVO> queryByFlagNosql(String flag, HttpServletRequest request, HttpServletResponse response) {
      List<ComboboxVO> list = this.dataSystemService.queryByFlagNosql(flag);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryByFlagKafka"})
   public List<ComboboxVO> queryByFlagKafka(String flag, HttpServletRequest request, HttpServletResponse response) {
      List<ComboboxVO> list = this.dataSystemService.queryByFlagKafka(flag);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryDiscoverydate"})
   public DataGridVO<DataSourceAndTaskVO> queryDiscoverydate(PageInfo pageInfo, int rows, int page, String sourceid) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<DataSourceAndTaskVO> list = this.dataSystemService.queryDiscoverydate(pageInfo, sourceid);
      DataGridVO<DataSourceAndTaskVO> vo = new DataGridVO<DataSourceAndTaskVO>(pageInfo.getCount(), list);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/queryDesensitizationtask"})
   public DataGridVO<DataSourceAndTaskVO> queryDesensitizationtask(PageInfo pageInfo, int rows, int page, String sourceid) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<DataSourceAndTaskVO> list = this.dataSystemService.queryDesensitizationtask(pageInfo, sourceid);
      DataGridVO<DataSourceAndTaskVO> vo = new DataGridVO<DataSourceAndTaskVO>(pageInfo.getCount(), list);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/ininDatabase"})
   public Map ininDatabase(PageInfo pageInfo, int rows, int page, String sourceid) {
      Map map = new HashMap();
      return map;
   }

   @ResponseBody
   @RequestMapping({"/portWay"})
   public String portWay(String dbtype) {
      String type = "-1";
      String[] importtype = EdataDbType.getImporttype(dbtype);
      String[] exporttype = EdataDbType.getExporttype(dbtype);
      boolean im = Arrays.asList(importtype).contains("LOAD");
      boolean ex = Arrays.asList(exporttype).contains("LOAD") || Arrays.asList(exporttype).contains("MULTILOAD");
      if (!im && !ex) {
         type = "0";
      } else if (im && !ex) {
         type = "1";
      } else if (!im && ex) {
         type = "2";
      } else if (im && ex) {
         type = "3";
      }

      return type;
   }

   @RequestMapping({"/getname"})
   @ResponseBody
   public String getname(String name, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreDatasystem> list = this.dataSystemService.getname(name);
      return list.isEmpty() ? "success" : "false";
   }

   @RequestMapping({"/querySysCrudUser"})
   @ResponseBody
   public List<UserVO> querySysCrudUser(String sysid, String userid, HttpServletRequest request, HttpServletResponse response, Model model) {
      if ("1".equals(userid)) {
         List<UserVO> list = this.userService.querynoSysCrudUser(sysid);
         List<UserVO> list1 = this.userService.querySysCrudUser(sysid);
         list.addAll(list1);
         Collections.sort(list, new Comparator<UserVO>() {
            public int compare(UserVO o1, UserVO o2) {
               return o1.getUsername().compareTo(o2.getUsername());
            }
         });
         return list;
      } else {
         List<UserVO> list = this.userService.querynoSysCrudUser(sysid);
         List<UserVO> list1 = this.userService.querySysSelfGiveCrudUser(sysid, userid);
         list.addAll(list1);
         Collections.sort(list, new Comparator<UserVO>() {
            public int compare(UserVO o1, UserVO o2) {
               return o1.getUsername().compareTo(o2.getUsername());
            }
         });
         return list;
      }
   }

   @RequestMapping({"/queryCharset"})
   @ResponseBody
   public Response querySqlType(@RequestParam Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String dbtype = (String)params.get("dbtype");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String charset = "";
      if (StringUtils.isNotBlank(dbtype)) {
         charset = props.getProperty(dbtype + "charset");
      }

      Object[] charsetList = null;
      if (StringUtils.isNotBlank(charset)) {
         charsetList = Arrays.stream(charset.split(",")).toArray();
      }

      return RespHelper.successResp(charsetList);
   }

   @PostMapping({"/checkDatasystemUsed"})
   @ResponseBody
   public Response checkDatasystemUsed(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String id = (String)params.get("id");
      if (this.dataSystemService.checkUsedByProject(id)) {
         return RespHelper.createResp(false, "pop_00033", MesUtil.getMsg("pop_00033", new String[0]));
      } else {
         TCoreControlledAsset coreControlledAsset = this.controlledAssetService.queryByDatasourceid(id);
         return !ObjectUtils.isEmpty(coreControlledAsset) ? RespHelper.errResp(ErrCode.DATASOURCE_USE_CODE) : RespHelper.successResp();
      }
   }

   @PostMapping({"/getDataView"})
   @ResponseBody
   public Response getDataView(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      Map<String, Object> dataView = this.dataSystemService.getDataView(params);
      return RespHelper.successResp(dataView);
   }

   @PostMapping({"/getHomePage"})
   @ResponseBody
   public Response getHomePage(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      Map<String, Object> dataView = this.dataSystemService.getHomePage(params);
      return RespHelper.successResp(dataView);
   }

   @RequestMapping({"/checkRepeatName"})
   @ResponseBody
   public Response checkRepeatName(@RequestBody Map<String, String> map, HttpServletRequest request, HttpServletResponse response, Model model) {
      String sysname = (String)map.get("sysname");
      String datasystemid = map.get("datasystemid") != null ? (String)map.get("datasystemid") : "";
      int count = this.dataSystemService.checkRepeatName(sysname, datasystemid);
      return count == 0 ? RespHelper.successResp(true) : RespHelper.createResp(false, "500", "该资产库名称已存在");
   }
}
