package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TNumDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TNumDescription;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TNumProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TNumSchema;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TNumTable;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.DataScopeCharsService;
import com.chenyang.nse.bussiness.service.core.DataScopeService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/rulereport"})
public class FieldlistRuleReportController {
   @Autowired
   private DataScopeService dataScopeService;
   @Autowired
   private DataScopeCharsService dataScopeCharsService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, String type) {
      model.addAttribute("type", type);
      return "core/datascope/report/projectfieldlist";
   }

   @RequestMapping({"getdescriptionpage"})
   public String getdescriptionpage(HttpServletRequest request, HttpServletResponse response, Model model, String project_name, String type) {
      model.addAttribute("type", type);
      model.addAttribute("project_name", project_name);
      return "core/datascope/report/rulefieldlist";
   }

   @RequestMapping({"/getdatasystempage"})
   public String getdatasystempage(HttpServletRequest request, HttpServletResponse response, Model model, String project_name, String description_name, String type) {
      model.addAttribute("type", type);
      model.addAttribute("project_name", project_name);
      model.addAttribute("description_name", description_name);
      return "core/datascope/report/datasysfieldlist";
   }

   @RequestMapping({"/getschemapage"})
   public String getschemapage(HttpServletRequest request, HttpServletResponse response, Model model, String project_name, String description_name, String datasystem_name, String type) {
      model.addAttribute("type", type);
      model.addAttribute("project_name", project_name);
      model.addAttribute("description_name", description_name);
      model.addAttribute("datasystem_name", datasystem_name);
      return "core/datascope/report/schemafieldlist";
   }

   @RequestMapping({"/gettablepage"})
   public String gettablepage(HttpServletRequest request, HttpServletResponse response, Model model, String project_name, String description_name, String datasystem_name, String schema_name, String type) {
      model.addAttribute("type", type);
      model.addAttribute("project_name", project_name);
      model.addAttribute("description_name", description_name);
      model.addAttribute("datasystem_name", datasystem_name);
      model.addAttribute("schema_name", schema_name);
      return "core/datascope/report/tablefieldlist";
   }

   @RequestMapping({"/getprojectlist"})
   @ResponseBody
   public DataGridVO<TNumProject> getProjectList(PageInfo pageInfo, int rows, int page, String project_name, String type) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TNumProject> result = this.dataScopeCharsService.getProjectlistRuleReport(pageInfo, project_name, type);
      return new DataGridVO<TNumProject>(pageInfo.getCount(), result);
   }

   @RequestMapping({"/getdescriptionlist"})
   @ResponseBody
   public DataGridVO<TNumDescription> getDescriptionList(PageInfo pageInfo, int rows, int page, String project_name, String description_name, String type) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TNumDescription> result = this.dataScopeCharsService.getDescriptionlistRuleReport(pageInfo, project_name, description_name, type);
      return new DataGridVO<TNumDescription>(pageInfo.getCount(), result);
   }

   @RequestMapping({"/getdatasystemlist"})
   @ResponseBody
   public DataGridVO<TNumDatasystem> getDatasystemList(PageInfo pageInfo, int rows, int page, String project_name, String description_name, String datasystem_name, String type) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TNumDatasystem> result = this.dataScopeCharsService.getDatasystemlistRuleReport(pageInfo, project_name, description_name, datasystem_name, type);
      return new DataGridVO<TNumDatasystem>(pageInfo.getCount(), result);
   }

   @RequestMapping({"/getschemalist"})
   @ResponseBody
   public DataGridVO<TNumSchema> getSchemaList(PageInfo pageInfo, int rows, int page, String project_name, String description_name, String datasystem_name, String schema_name, String type) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TNumSchema> result = this.dataScopeCharsService.getSchemalistRuleReport(pageInfo, project_name, description_name, datasystem_name, schema_name, type);
      return new DataGridVO<TNumSchema>(pageInfo.getCount(), result);
   }

   @RequestMapping({"/gettablelist"})
   @ResponseBody
   public DataGridVO<TNumTable> getTableList(PageInfo pageInfo, int rows, int page, String project_name, String description_name, String datasystem_name, String schema_name, String table_name, String type) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TNumTable> result = this.dataScopeCharsService.getTablelistRuleReport(pageInfo, project_name, description_name, datasystem_name, schema_name, table_name, type);
      return new DataGridVO<TNumTable>(pageInfo.getCount(), result);
   }
}
