package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.SessionBean;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreImporttask;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreSyncKeyindex;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.temporary.TCoreMonitorTemporary;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.service.core.AllwaysMonitorService;
import com.chenyang.nse.bussiness.service.core.MaskingSelfTaskService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/monitortask"})
public class MonitorController {
   private static Logger logger = LoggerFactory.getLogger(MonitorController.class);
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private AllwaysMonitorService allwaysMonitorService;
   @Autowired
   private MaskingSelfTaskService maskingSelfTaskService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/monitor/monitortask";
   }

   @RequestMapping({"/selfmonitor"})
   public String selfmonitor(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/monitor/selfmonitor";
   }

   @RequestMapping({"/selfmonitorlog"})
   public String selfmonitorlog(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/monitor/selfmonitorlog";
   }

   @ResponseBody
   @RequestMapping({"/monitorrun"})
   public DataGridVO<TCoreMaskingTask> monitorrun(String taskid, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (taskid != null && !"".equals(taskid)) {
         pageInfo.setPageno(page);
         pageInfo.setPagesize(rows);
         TCoreMaskingTask task = this.maskingTaskService.queryMaskingTaskByID(taskid);
         List<TCoreMaskingTask> list = new ArrayList();
         list.add(task);
         DataGridVO<TCoreMaskingTask> vo = new DataGridVO<TCoreMaskingTask>(pageInfo.getCount(), list);
         return vo;
      } else {
         return null;
      }
   }

   @ResponseBody
   @RequestMapping({"/selftask"})
   public DataGridVO<TCoreMaskingselfTask> selftask(String taskid, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (taskid != null && !"".equals(taskid)) {
         pageInfo.setPageno(page);
         pageInfo.setPagesize(rows);
         TCoreMaskingselfTask task = this.maskingSelfTaskService.queryMaskingTaskByID(taskid);
         List<TCoreMaskingselfTask> list = new ArrayList();
         list.add(task);
         DataGridVO<TCoreMaskingselfTask> vo = new DataGridVO<TCoreMaskingselfTask>(pageInfo.getCount(), list);
         return vo;
      } else {
         return null;
      }
   }

   @RequestMapping({"/monitorsubtask"})
   public String monitorsubtask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (taskid != null && !"".equals(taskid)) {
         model.addAttribute("taskid", taskid);
         return "core/monitor/monitorsubtask";
      } else {
         return null;
      }
   }

   @ResponseBody
   @RequestMapping({"/querytask"})
   public DataGridVO<TCoreMaskingTask> querytask(String engineid, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (engineid != null && !"".equals(engineid)) {
         pageInfo.setPageno(page);
         pageInfo.setPagesize(rows);
         List<TCoreMaskingTask> list = this.maskingTaskService.queryTask(engineid, "", pageInfo);
         DataGridVO<TCoreMaskingTask> vo = new DataGridVO<TCoreMaskingTask>(pageInfo.getCount(), list);
         return vo;
      } else {
         return null;
      }
   }

   @ResponseBody
   @RequestMapping({"/querytasklist"})
   public List<TCoreMaskingTask> querytasklist(String engineid, String taskname, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (engineid != null && !"".equals(engineid)) {
         List<TCoreMaskingTask> list = this.maskingTaskService.queryTaskList(engineid, taskname);
         return list;
      } else {
         return null;
      }
   }

   @ResponseBody
   @RequestMapping({"/queryTaskVersionList"})
   public List<Map<String, String>> queryTaskVersionList(HttpServletRequest request, HttpServletResponse response, Model model, String taskId) {
      List list = this.maskingTaskService.queryTaskVersionList(taskId);
      List<Map<String, String>> listMap = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
         long lt = new Long(list.get(i).toString());
         Date date = new Date(lt);
         String res = simpleDateFormat.format(date);
         Map<String, String> map = new HashMap();
         map.put("groupid", res);
         listMap.add(map);
      }

      return listMap;
   }

   @ResponseBody
   @RequestMapping({"/querytaskobj"})
   public List<TCoreMaskingTask> querytaskobj(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreMaskingTask> task = this.maskingTaskService.queryTaskList(taskid);
      return task;
   }

   @ResponseBody
   @RequestMapping({"/queryTaskListByIndex"})
   public List<TCoreMaskingTask> queryTaskListByIndex(String engineid, String taskname, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreMaskingTask> listtask = this.maskingTaskService.queryTaskListByIndex(engineid, taskname);
      return listtask;
   }

   @RequestMapping({"/exeTaskMonitor"})
   @ResponseBody
   public SessionBean exeTaskMonitor(HttpServletRequest request, HttpServletResponse response, Model model, String taskid, String wfname, String tmpid) {
      TCoreMaskingTask task = this.maskingTaskService.queryMaskingTaskById(taskid);
      InfoProperty info = this.maskingTaskService.getInfoProperty(task);
      new SessionBean();
      TCoreMonitorTemporary tmp = this.maskingTaskService.gettmp(tmpid);

      SessionBean sessionbean;
      try {
         sessionbean = this.allwaysMonitorService.getLogForTaskMapping(task, info, wfname);
         sessionbean.setSrcsuccessrows((long)tmp.getDatacount());
      } catch (Exception var13) {
         SessionBean se = new SessionBean();
         se.setStatus("FAIL");
         return se;
      }

      model.addAttribute("taskid", taskid);
      model.addAttribute("wfname", wfname);
      model.addAttribute("tmpid", tmpid);
      return sessionbean;
   }

   @RequestMapping({"/exeTaskSelfMonitor"})
   @ResponseBody
   public SessionBean exeTaskSelfMonitor(HttpServletRequest request, HttpServletResponse response, Model model, String taskid, String wfname) {
      TCoreMaskingselfTask task = this.maskingSelfTaskService.queryMaskingTaskByID(taskid);
      InfoProperty info = this.maskingTaskService.getInfoPropertySelf(task);
      new SessionBean();

      SessionBean sessionbean;
      try {
         sessionbean = this.allwaysMonitorService.getLogForSelfTaskMapping(task, info, wfname);
      } catch (Exception var11) {
         SessionBean se = new SessionBean();
         se.setStatus("FAIL");
         return se;
      }

      model.addAttribute("taskid", taskid);
      model.addAttribute("wfname", wfname);
      return sessionbean;
   }

   @RequestMapping({"/exeTaskImpMonitor"})
   @ResponseBody
   public SessionBean exeTaskImpMonitor(HttpServletRequest request, HttpServletResponse response, Model model, String taskid) {
      TCoreMaskingTask task = this.maskingTaskService.queryMaskingTaskById(taskid);
      InfoProperty info = this.maskingTaskService.getInfoProperty(task);
      TCoreImporttask imptask = this.allwaysMonitorService.getImpTask(task);
      new SessionBean();

      try {
         SessionBean sessionbean = this.allwaysMonitorService.getLogForImpMapping(task, info, imptask);
         return sessionbean;
      } catch (Exception var11) {
         SessionBean se = new SessionBean();
         se.setStatus("FAIL");
         return se;
      }
   }

   @ResponseBody
   @RequestMapping({"/querytmporary"})
   public DataGridVO<TCoreMonitorTemporary> querytmporary(String taskid, String groupid, Integer indexrow, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      if (taskid != null && !"".equals(taskid)) {
         if (groupid != null && !"".equals(groupid)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            long ts = 0L;

            try {
               Date date = sdf.parse(groupid);
               ts = date.getTime();
            } catch (ParseException e) {
               e.printStackTrace();
            }

            String res = String.valueOf(ts);
            List<TCoreMonitorTemporary> list = this.maskingTaskService.queryTasktmpo(taskid, res, pageInfo, indexrow);
            DataGridVO<TCoreMonitorTemporary> vo = new DataGridVO<TCoreMonitorTemporary>(pageInfo.getCount(), list);
            return vo;
         } else {
            return null;
         }
      } else {
         return null;
      }
   }

   @ResponseBody
   @RequestMapping({"/querytmporarycoreindex"})
   public List<TCoreMonitorTemporary> querytmporarycoreindex(String taskid, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (taskid != null && !"".equals(taskid)) {
         List<TCoreMonitorTemporary> list = this.maskingTaskService.queryTasktmpoCoreIndex(taskid);
         return list;
      } else {
         return null;
      }
   }

   @RequestMapping({"/exeTaskSubMonitor"})
   @ResponseBody
   public SessionBean exeTaskSubMonitor(HttpServletRequest request, HttpServletResponse response, Model model, String taskid) {
      TCoreMaskingTask task = this.maskingTaskService.queryMaskingTaskById(taskid);
      InfoProperty info = this.maskingTaskService.getInfoProperty(task);
      SessionBean sessionbean = this.allwaysMonitorService.getLogForTaskMapping(task, info, task.getTaskname());
      return sessionbean;
   }

   @RequestMapping({"/stopwork"})
   @ResponseBody
   public ResultVO stopwork(HttpServletRequest request, HttpServletResponse response, Model model, String taskid, String wfname) {
      boolean result_status = this.allwaysMonitorService.stopwork(taskid, wfname);
      return result_status ? new ResultVO("执行成功", true) : new ResultVO("执行失败", false);
   }

   @RequestMapping({"/recoverywork"})
   @ResponseBody
   public ResultVO recoverywork(HttpServletRequest request, HttpServletResponse response, Model model, String taskid, String wfname) {
      boolean result_status = this.allwaysMonitorService.recoverywork(taskid, wfname);
      return result_status ? new ResultVO("执行成功", true) : new ResultVO("执行失败", false);
   }

   @RequestMapping({"/shutdown"})
   @ResponseBody
   public ResultVO shutdown(HttpServletRequest request, HttpServletResponse response, Model model, String taskid) {
      boolean result_status = this.maskingTaskService.stopwork(taskid);
      return result_status ? new ResultVO("", true) : new ResultVO("", false);
   }

   @RequestMapping({"/getsyncprimary"})
   @ResponseBody
   public List<Map<String, String>> getsyncprimary(String taskid, String sourcename, String targetname) {
      return this.allwaysMonitorService.getSyncPrimary(taskid, sourcename, targetname);
   }

   @RequestMapping({"/getsyncindex"})
   @ResponseBody
   public List<Map<String, String>> getsyncindex(String taskid, String sourcename, String targetname) {
      return this.allwaysMonitorService.getSyncIndex(taskid, sourcename, targetname);
   }

   @RequestMapping({"/getsynckeyindex"})
   @ResponseBody
   public TCoreSyncKeyindex getsynckeyindex(String taskid, String sourcename) {
      return this.allwaysMonitorService.getSyncKeyIndex(taskid, sourcename);
   }

   @ResponseBody
   @RequestMapping({"/getCountTable"})
   public int getCountTable(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      int count = this.maskingSelfTaskService.getCountTable(taskid);
      return count;
   }

   @RequestMapping({"/updateMonitorTaskState"})
   @ResponseBody
   public void updateMonitorTaskState(String taskid, String state, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreMonitorTemporary> list = this.maskingTaskService.queryTCoreMonitorTemporaryList(taskid);
      if ("1".equals(state) || "2".equals(state)) {
         ((TCoreMonitorTemporary)list.get(0)).setFlag(state);
         this.maskingTaskService.update((TCoreMonitorTemporary)list.get(0));
      }
   }

   @RequestMapping({"/stopworkflow"})
   @ResponseBody
   public ResultVO stopWorkflow(String taskid, String wfname, HttpServletRequest request, HttpServletResponse response, Model model) {
      String stopWorkflow = this.maskingTaskService.stopWorkflow(taskid, wfname);
      return !"FAIL".equals(stopWorkflow) ? new ResultVO("执行成功", true) : new ResultVO("执行失败", false);
   }

   @RequestMapping({"/querySessionLog"})
   @ResponseBody
   public SessionBean querySessionLog(String taskid, String wfname) {
      TCoreMaskingTask task = this.maskingTaskService.queryMaskingTaskById(taskid);
      InfoProperty engine = this.maskingTaskService.getInfoProperty(task);
      new SessionBean();
      SessionBean sessionbean = this.allwaysMonitorService.getSessionLog(task, wfname, engine);
      return sessionbean;
   }
}
