package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.previousblob.TCorePreviousBlobTask;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.entity.vo.previousblobtask.TCorePreviousBlobTaskVO;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.service.core.PreviousBlobTaskService;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/previousblobtask"})
public class PreviousblobtaskController {
   @Autowired
   private PreviousBlobTaskService previousBlobTaskService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private MaskingTaskService maskingTaskService;
   private static Logger logger = LoggerFactory.getLogger(PreviousblobtaskController.class);

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/previousblobtask/previousblobtask";
   }

   @ResponseBody
   @RequestMapping({"/querytask"})
   public DataGridVO<TCorePreviousBlobTask> querytask(String taskname, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TCorePreviousBlobTask> list = this.previousBlobTaskService.querytask(taskname, pageInfo);
      DataGridVO<TCorePreviousBlobTask> vo = new DataGridVO<TCorePreviousBlobTask>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/createtask"})
   public String createtask(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/previousblobtask/createstep/createtask";
   }

   @RequestMapping({"/createtaskstep"})
   public String createtaskstep(String step, HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/previousblobtask/createstep/" + step;
   }

   @ResponseBody
   @RequestMapping({"/isexist"})
   public boolean isexist(String taskname, HttpServletRequest request, HttpServletResponse response, Model model) {
      Boolean reFlg = false;
      List<TCorePreviousBlobTask> task = this.previousBlobTaskService.isexist(taskname);
      if (null != task && task.size() > 0) {
         reFlg = true;
      }

      return reFlg;
   }

   @RequestMapping({"/querydatasystem"})
   @ResponseBody
   public List<TCoreDatasystem> querydatasystem(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreDatasystem> list = this.dataSystemService.query("1");
      return list;
   }

   @RequestMapping({"/queryschema"})
   @ResponseBody
   public List<ComboboxVO> queryschema(String datasystemid, HttpServletRequest request, HttpServletResponse response, Model model) {
      Connection conn = this.dataSystemService.getConnectionByDataSystemId(datasystemid);
      if (conn == null) {
         return new ArrayList();
      } else {
         List<String> schema = JdbcTool.getDbSchemas(conn);
         JdbcTool.closeConnection(conn);
         List<ComboboxVO> list = new ArrayList();

         for(String str : schema) {
            ComboboxVO cv = new ComboboxVO(str);
            list.add(cv);
         }

         return list;
      }
   }

   @RequestMapping({"/querytable"})
   @ResponseBody
   public List<DBTableVO> querytable(String datasystemid, String schema) {
      List<DBTableVO> dbTableLst = this.dataSystemService.queryTablename(datasystemid, schema);
      return dbTableLst;
   }

   @RequestMapping({"/querycolumninfo"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumninfo(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      String datasystemid = id.replace(tablename, "");
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
      if (datasystem == null) {
         return null;
      } else {
         Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tablename);

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return list;
      }
   }

   @RequestMapping({"/save"})
   @ResponseBody
   public ResultVO addtask(@RequestBody TCorePreviousBlobTask tCorePreviousBlobTask, HttpServletRequest request) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      if (loginUser == null) {
         return new ResultVO("对话超时！", false);
      } else {
         ResultVO rv = this.previousBlobTaskService.savePreviousBlobTask(tCorePreviousBlobTask);
         return rv;
      }
   }

   @ResponseBody
   @RequestMapping({"/removetask"})
   public void removetask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.previousBlobTaskService.removetask(taskid);
   }

   @ResponseBody
   @RequestMapping({"/executetask"})
   public ResultVO executetask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      if (loginUser == null) {
         return new ResultVO("对话超时！", false);
      } else {
         this.previousBlobTaskService.executetask(taskid);
         return new ResultVO("", true);
      }
   }

   @RequestMapping({"/detail"})
   public String detail(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("taskid", taskid);
      return "core/previousblobtask/detail/previousblobtaskdetail";
   }

   @RequestMapping({"/detailtype"})
   public String detailtype() {
      return "core/previousblobtask/detail/detailtype";
   }

   @RequestMapping({"/querytaskdetail"})
   @ResponseBody
   public TCorePreviousBlobTaskVO queryBlobTaskDetail(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCorePreviousBlobTaskVO vo = null;
      vo = this.previousBlobTaskService.queryBlobMaskingTaskVOByID(taskid);
      return vo;
   }
}
