package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.annot.PassToken;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.vo.TableRuleInfo;
import com.chenyang.nse.bussiness.service.core.TableRuleService;
import com.chenyang.nse.bussiness.tools.token.TokenUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/core/tablerule"})
public class TableRuleController {
   @Autowired
   private TableRuleService service;

   @PassToken
   @PostMapping({"/get"})
   @ResponseBody
   public Response<TableRuleInfo> getTableRule(@RequestBody TableRuleInfo req) {
      Response<TableRuleInfo> response = new Response<TableRuleInfo>();

      try {
         TableRuleInfo info = this.service.getHiveStoreInfo(req.getProjectId(), req.getDataSystemId(), req.getSchema(), req.getTable());
         response.setFlag(true);
         response.setCode("200");
         response.setData(info);
      } catch (Exception e) {
         response.setFlag(false);
         response.setCode("500");
         response.setMsg("读取HIVE表规则信息失败:" + e.toString());
      }

      return response;
   }

   @PassToken
   @PostMapping({"/enctypes"})
   @ResponseBody
   public Response<List<String>> getHiveEncDecTypes() {
      Response<List<String>> response = new Response<List<String>>();

      try {
         List<String> info = this.service.getHiveEncDecTypeNames();
         response.setFlag(true);
         response.setCode("200");
         response.setData(info);
      } catch (Exception e) {
         response.setFlag(false);
         response.setCode("500");
         response.setMsg("读取HIVE加密解密规则信息失败:" + e.toString());
      }

      return response;
   }

   @PassToken
   @PostMapping({"/save"})
   public Response<Boolean> saveHiveTableRule(@RequestBody TableRuleInfo info, HttpServletRequest request) {
      Response<Boolean> response = new Response<Boolean>();

      try {
         if (info == null) {
            throw new Exception("保存的数据格式错误,数据为空");
         }

         if (info.getProjectId() == null || info.getProjectId().length() == 0) {
            throw new Exception("保存的数据格式错误,项目编号为空");
         }

         if (info.getDataSystemId() == null || info.getDataSystemId().length() == 0) {
            throw new Exception("保存的数据格式错误,资产库编号为空");
         }

         if (info.getSchema() == null || info.getSchema().length() == 0) {
            throw new Exception("保存的数据格式错误,schema为空");
         }

         if (info.getTable() == null || info.getTable().length() == 0) {
            throw new Exception("保存的数据格式错误,表名称为空");
         }

         if (info.getEncType() == null || info.getEncType().length() == 0) {
            throw new Exception("保存的数据格式错误,加密类型为空");
         }

         String newUsername = "admin";
         String token = request.getHeader("token");
         if (token != null) {
            newUsername = TokenUtil.getUserName(token);
         }

         info.setUsername(newUsername);
         boolean data = this.service.saveHiveTableRuleInfo(info);
         response.setFlag(true);
         response.setCode("200");
         response.setData(data);
      } catch (Exception e) {
         e.printStackTrace();
         response.setData(false);
         response.setFlag(false);
         response.setCode("500");
         response.setMsg("保存HIVE加密解密规则信息失败:" + e.toString());
      }

      return response;
   }
}
