package com.chenyang.nse.bussiness.controller.restfulapi.entity;

public enum ResultAPIEnum {
   RT_SUC_CODE_200_STR(200, "Success"),
   RT_SUC_CODE_201_STR(201, "Create or update data success"),
   RT_SUC_CODE_202_STR(202, "Accepted"),
   RT_SUC_CODE_204_STR(204, "Delete"),
   RT_ERROR_CODE_400_STR(400, "Invalid Request"),
   RT_ERROR_CODE_401_STR(401, "Unauthorized"),
   RT_ERROR_CODE_403_STR(403, "The record doesn't exist"),
   RT_ERROR_CODE_404_STR(404, "Page Not Found"),
   RT_ERROR_CODE_406_STR(406, "Not Acceptable"),
   RT_ERROR_CODE_410_STR(410, "Gone"),
   RT_ERROR_CODE_422_STR(422, "Unprocessable entity"),
   RT_ERROR_CODE_500_STR(500, "Internal Server Error"),
   RT_ERROR_CODE_430_STR(430, "Interface does not exist"),
   RT_ERROR_CODE_431_STR(431, "Interface not published"),
   RT_ERROR_CODE_432_STR(431, "Engine Interface Server Error"),
   UNDEFINE(-1, "undefine Exception");

   private int code;
   private String msg;

   private ResultAPIEnum(int code, String msg) {
      this.code = code;
      this.msg = msg;
   }

   public static String msg(int code) {
      for(ResultAPIEnum m : values()) {
         if (m.getCode() == code) {
            return m.getMsg();
         }
      }

      return UNDEFINE.getMsg();
   }

   public int getCode() {
      return this.code;
   }

   public void setCode(int code) {
      this.code = code;
   }

   public String getMsg() {
      return this.msg;
   }

   public void setMsg(String msg) {
      this.msg = msg;
   }
}
