package com.chenyang.nse.bussiness.dao;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

public interface IBaseDao<T, PK extends Serializable> {
   void removeById(PK id);

   void remove(Criterion... criterion);

   T get(PK id);

   void save(T o);

   void saveOrUpdate(T o);

   void remove(T o);

   void remove(Collection<T> entities);

   void update(T t);

   boolean exists(PK id);

   long count();

   long count(Criteria criteria);

   long count(Criterion... criterion);

   long count(String hql);

   Criteria createCriteria();

   Criteria createCriteria(Criterion... criterions);

   Criteria addOrders(Criteria criteria, List<Order> orders);

   List<T> queryAll();

   List<T> queryAll(Criterion... criterion);

   List<T> queryAll(Order order, Criterion... criterion);

   List<T> queryAll(Criteria criteria);

   List<T> queryAll(String orderBy, boolean isAsc);

   List<T> queryByPageInfo(PageInfo pageinfo, Order order);

   List<T> queryAll(String orderBy, boolean isAsc, Criterion... criterion);

   List<T> queryByPageInfo(PageInfo pageinfo);

   List<T> queryByPageInfo(PageInfo pageinfo, Criterion... criterion);

   List<T> queryByPageInfo(PageInfo pageinfo, Order order, Criterion... criterion);

   T queryUnique(Criterion... criterion);

   Session openSession();

   List queryGroup(Order order, String groupBy, Criterion... criterions);

   List<T> queryByPageInfo1(PageInfo pageinfo, Order order, Order order1, Criterion[] criterion);

   List<T> queryByPageInfoByOrders(PageInfo pageinfo, List<Order> orders, Criterion... criterion);
}
