package com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool;

import com.chenyang.nse.bussiness.commmon.ApplicationConstants;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Component;

@Component
public class InfoExecUtil {
   public String execPmrepConnect(String pmrep_path, String infa_rep, String infaIp, String infa_pmrep_user, String infa_pmrep_password) {
      Runtime rn = Runtime.getRuntime();
      Process p = null;
      String text = null;
      if (!"".equals(pmrep_path) && pmrep_path != null) {
         try {
            p = rn.exec(pmrep_path + " connect -r " + infa_rep + " -h " + infaIp + " -o 6005 -n " + infa_pmrep_user + " -x " + infa_pmrep_password);
         } catch (IOException e) {
            e.printStackTrace();
         }
      } else {
         try {
            p = rn.exec(ApplicationConstants.pmrep_path + " connect -r " + infa_rep + " -h " + infaIp + " -o 6005 -n " + infa_pmrep_user + " -x " + infa_pmrep_password);
         } catch (IOException e) {
            e.printStackTrace();
         }
      }

      InputStream is = p.getInputStream();
      String rtnstr = "";

      try {
         text = IOUtils.toString(is, "GBK");
         if (text.contains("已连接到存储库")) {
            rtnstr = "成功";
            System.out.println("已连接到存储库登录成功!!!");
         } else if (text.contains("connect completed successfully")) {
            rtnstr = "成功";
            System.out.println("connect completed successfully登录成功!!!");
         } else if (!text.contains("invalid username/password") && !text.contains("用户名/口令无效")) {
            System.out.println(text);
            rtnstr = text;
         } else {
            rtnstr = "用户名或密码错误";
            System.out.println("connect completed successfully用户名或密码错误!!!");
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return rtnstr;
   }

   public String execPmcmdConnect(String pmcmd_path, String infa_cmd, String infa_name, String infa_cmd_user, String infa_cmd_password) {
      Runtime rn = Runtime.getRuntime();
      Process p = null;
      String text = null;
      if (!"".equals(pmcmd_path) && pmcmd_path != null) {
         try {
            p = rn.exec(pmcmd_path + " connect -sv " + infa_cmd + " -d " + infa_name + " -u " + infa_cmd_user + " -p " + infa_cmd_password);
         } catch (IOException e) {
            e.printStackTrace();
         }
      } else {
         try {
            p = rn.exec(pmcmd_path + " connect -sv " + infa_cmd + " -d " + infa_name + " -u " + infa_cmd_user + " -p " + infa_cmd_password);
         } catch (IOException e) {
            e.printStackTrace();
         }
      }

      InputStream is = p.getInputStream();
      String rtnstr = "";

      try {
         text = IOUtils.toString(is, "GBK");
         if (text.contains("已连接到集成服务")) {
            rtnstr = "成功";
            System.out.println("已连接到集成服务登录成功!!!");
         } else {
            System.out.println(text);
            rtnstr = text;
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

      return rtnstr;
   }

   public static String createDb(String pmrep_path, String dbIpStr, String dbUserStr, String dbUserPwd, String infaLinkName, String tnSName, String pagecode) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmrep_path + " CreateConnection -s " + dbIpStr + " -n " + infaLinkName + " -u " + dbUserStr + " -p " + dbUserPwd + " -c " + infaLinkName + " -l " + pagecode + "");
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      return text;
   }

   public static String updateDb(String pmrep_path, String dbIpStr, String dbUserStr, String dbUserPwd, String infaLinkName, String tnSName, String pagecode) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmrep_path + " updateConnection -t " + dbIpStr + " -d " + infaLinkName + " -u " + dbUserStr + " -p " + dbUserPwd + " -c " + infaLinkName + " -l " + pagecode + "");
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      return text;
   }

   public static String deleteDb(String pmrep_path, String linkname) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmrep_path + " deleteconnection -n " + linkname + " -f ");
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      return text;
   }

   public static String createHadoopConn(TCoreDatasystem datasource) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         FileTool.createFile("/data/createhadoop.sh");
         String infaHome = System.getenv("INFA_HOME");
         if ("on".equals(datasource.getIskerberos())) {
            System.out.println("创建kerberos连接！");
            FileTool.writeContentToFile("/data/createhadoop.sh", infaHome + "/server/bin/pmrep CreateConnection -s'Hadoop HDFS Connection' -n " + datasource.getDblinkname() + " -u " + datasource.getUsername() + " -p " + datasource.getPassword() + " -k 'HDFS Connection URI=hdfs://" + datasource.getConnectip() + ":8020;Hive URL=jdbc:hive2://" + datasource.getDbip() + ":" + datasource.getDbport() + "/" + datasource.getDbservername() + "\\;principal=" + datasource.getPrincipal() + ";Hive User Name=" + datasource.getUsername() + ";Hive Password=" + datasource.getPassword() + ";'");
         } else {
            FileTool.writeContentToFile("/data/createhadoop.sh", infaHome + "/server/bin/pmrep CreateConnection -s'Hadoop HDFS Connection' -n " + datasource.getDblinkname() + " -u " + datasource.getUsername() + " -p " + datasource.getPassword() + " -k 'HDFS Connection URI=hdfs://" + datasource.getConnectip() + ":8020;Hive URL=jdbc:hive2://" + datasource.getDbip() + ":" + datasource.getDbport() + "/" + datasource.getDbservername() + ";Hive User Name=" + datasource.getUsername() + ";Hive Password=" + datasource.getPassword() + ";'");
            System.out.printf("/data/createhadoop.sh", infaHome + "/server/bin/pmrep CreateConnection -s'Hadoop HDFS Connection' -n " + datasource.getDblinkname() + " -u " + datasource.getUsername() + " -p " + datasource.getPassword() + " -k 'HDFS Connection URI=hdfs://" + datasource.getConnectip() + ":8020;Hive URL=jdbc:hive2://" + datasource.getDbip() + ":" + datasource.getDbport() + "/" + datasource.getDbservername() + ";Hive User Name=" + datasource.getUsername() + ";Hive Password=" + datasource.getPassword() + ";'");
         }

         Process var7 = rn.exec("chmod 777 /data/createhadoop.sh");
         var7.waitFor();
         p = rn.exec("/data/createhadoop.sh");
         p.waitFor();
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      is.close();
      p.destroy();
      File file = new File("/data/createhadoop.sh");
      if (file.exists()) {
         file.delete();
      }

      return text;
   }

   public static String deleteHadoopConn(TCoreDatasystem datasource) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec("/home/infa/Informatica/9.6.1/server/bin/pmrep deleteconnection -n " + datasource.getDblinkname() + " -f -s application");
         System.out.println(p.toString());
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      System.out.println(text);
      p.waitFor();
      is.close();
      p.destroy();
      return text;
   }

   public static String executWorkflow(String pmcmd_path, String workflowfolder, String server, String domain, String user, String password, String workflowname) throws Exception {
      System.out.println(">>>>>>>>>>start executWorkflow");
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         System.out.println(">>工作流执行方法：" + pmcmd_path + " startworkflow -f " + workflowfolder + " -sv " + server + " -d " + domain + " -u " + user + " -p " + password + " -nowait " + workflowname);
         p = rn.exec(pmcmd_path + " startworkflow -f " + workflowfolder + " -sv " + server + " -d " + domain + " -u " + user + " -p " + password + " -nowait " + workflowname);
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      System.out.println("*************wwwwwwwwwwwwwwwwwwww" + text);
      System.out.println(">>>>>>>>>>end executWorkflow");
      return text;
   }

   public static String executRecoverWorkflow(String pmcmd_path, String server, String user, String password, String folder, String workflowname) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmcmd_path + " RecoverWorkflow -sv " + server + " -u " + user + " -p " + password + " -f " + folder + " " + workflowname);
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      System.out.println("*************wwwwwwwwwwwwwwwwwwww" + text);
      return text;
   }

   public static String executStopWorkflow(String pmcmd_path, String server, String user, String password, String folder, String workflowname) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmcmd_path + " StopWorkflow -sv " + server + " -u " + user + " -p " + password + " -f " + folder + " " + workflowname);
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      System.out.println("*************wwwwwwwwwwwwwwwwwwww" + text);
      return text;
   }

   public static String executabortworkflow(String pmcmd_path, String server, String user, String password, String folder, String workflowname) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmcmd_path + " abortworkflow -sv " + server + " -u " + user + " -p " + password + " -f " + folder + " " + workflowname);
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      System.out.println("*************wwwwwwwwwwwwwwwwwwww" + text);
      return text;
   }

   public String executMonitor(String pmcmd_path, String server, String user, String password) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmcmd_path + " getrunningsessionsdetails -sv " + server + " -u " + user + " -p " + password);
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      System.out.println("*************ggggggggggggggggggggggg" + text);
      return text;
   }

   public String executKill(String pmrep_path, String user) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmrep_path + " KillUserConnection  -n " + user);
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      System.out.println("*************ggggggggggggggggggggggg" + text);
      return text;
   }

   public static String executImport(String pmrep_path, String exeXmlName, String conXmlPath, String logPath) throws Exception {
      String masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
      if (!"1".equals(masking_engine_type)) {
         Runtime rn = Runtime.getRuntime();
         Process p = null;

         try {
            System.out.println("导入命令：" + pmrep_path + " objectimport -i " + exeXmlName + " -c " + conXmlPath + " -l " + logPath);
            p = rn.exec(pmrep_path + " objectimport -i " + exeXmlName + " -c " + conXmlPath + " -l " + logPath);
         } catch (IOException e) {
            e.printStackTrace();
         }

         InputStream is = p.getInputStream();
         String text = IOUtils.toString(is, "GBK");
         System.out.println(text);
         p.waitFor();
         is.close();
         p.destroy();
         System.out.println("************" + text);
         return text;
      } else {
         return "successfully";
      }
   }

   public static String execreatfolder(String pmrep_path, String foldername) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmrep_path + " createfolder -n " + foldername);
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      System.out.println(text);
      p.waitFor();
      is.close();
      p.destroy();
      return text;
   }

   public static String exedelfolder(String pmrep_path, String foldername) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmrep_path + " DeleteFolder -n " + foldername);
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      System.out.println(text);
      p.waitFor();
      is.close();
      p.destroy();
      return text;
   }

   public static List<String> exeAllLinks(String pmrep_path) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmrep_path + " ListConnections ");
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
      new String("");
      List<String> list = new ArrayList();

      String sTempOneLine;
      while((sTempOneLine = tBufferedReader.readLine()) != null) {
         if (sTempOneLine.endsWith("relational")) {
            list.add(sTempOneLine.split(",")[0]);
         }
      }

      for(int i = 0; i < list.size(); ++i) {
         System.out.println((String)list.get(i));
      }

      p.waitFor();
      is.close();
      p.destroy();
      return list;
   }

   public String exeobjectexport(String pmrep_path, String foldername, String workflowname, String taskname) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmrep_path + " objectexport -n " + workflowname + " -b -r -s -o workflow  -f " + foldername + " -u " + ApplicationConstants.export_path + taskname + ".xml");
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      return text;
   }

   public static String exeobjectexportmapplet(String pmrep_path, String foldername, String workflowname, String taskname) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         p = rn.exec(pmrep_path + " objectexport -n " + workflowname + " -b -r -s -o mapplet  -f " + foldername + " -u " + taskname + ".xml");
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      return text;
   }

   public static String executMonitor(String pmcmd_path, String workflowfolder, String workflowname, String sessionname, String usernmae, String password, String servername, String domainname, String runid) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;
      if (!"".equals(pmcmd_path) && pmcmd_path != null) {
         try {
            p = rn.exec(pmcmd_path + " getsessionstatistics -sv " + servername + " -d " + domainname + " -u " + usernmae + " -p " + password + " -f " + workflowfolder + " -w " + workflowname + " -wfrunid " + runid + " " + sessionname);
         } catch (IOException e) {
            e.printStackTrace();
         }
      }

      InputStream is = p.getInputStream();
      BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
      StringBuffer tStringBuffer = new StringBuffer();
      new String("");

      String sTempOneLine;
      while((sTempOneLine = tBufferedReader.readLine()) != null) {
         if (sTempOneLine.startsWith("Target success rows:")) {
            String ssr = sTempOneLine.replace("Target success rows:", "");
            ssr = ssr.substring(2, ssr.length() - 1);
            tStringBuffer.append(ssr);
         }
      }

      p.waitFor();
      is.close();
      p.destroy();
      return tStringBuffer.toString();
   }

   public static String executResult(String pmcmd_path, String workflowfolder, String workflowname, String sessionname, String usernmae, String password, String servername, String domainname, String runid) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;
      if (!"".equals(pmcmd_path) && pmcmd_path != null) {
         try {
            p = rn.exec(pmcmd_path + " getsessionstatistics -sv " + servername + " -d " + domainname + " -u " + usernmae + " -p " + password + " -f " + workflowfolder + " -w " + workflowname + " -wfrunid " + runid + " " + sessionname);
         } catch (IOException e) {
            e.printStackTrace();
         }
      }

      InputStream is = p.getInputStream();
      BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
      StringBuffer tStringBuffer = new StringBuffer();
      new String("");

      String sTempOneLine;
      while((sTempOneLine = tBufferedReader.readLine()) != null) {
         if (sTempOneLine.startsWith("Task run status:")) {
            String ssr = sTempOneLine.replace("Task run status:", "");
            ssr = ssr.substring(2, ssr.length() - 1);
            tStringBuffer.append(ssr);
         }
      }

      p.waitFor();
      is.close();
      p.destroy();
      return tStringBuffer.toString();
   }

   public static String executeSybaseIQWorkflow(String pmcmd_path, String workflowfolder, String server, String domain, String user, String password, String workflowname, String tablename, TCoreMaskingTask task) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         System.out.println(">>工作流执行方法：" + pmcmd_path + " startworkflow -f " + workflowfolder + " -sv " + server + " -d " + domain + " -u " + user + " -p " + password + " -nowait " + workflowname);
         p = rn.exec(pmcmd_path + " startworkflow -f " + workflowfolder + " -sv " + server + " -d " + domain + " -u " + user + " -p " + password + " -nowait " + workflowname);
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      System.out.println("*************wwwwwwwwwwwwwwwwwwww" + text);
      return text;
   }

   public static String executeTeradataWorkflow(String pmcmd_path, String workflowfolder, String server, String domain, String user, String password, String workflowname, String tablename, TCoreMaskingTask task) throws Exception {
      Runtime rn = Runtime.getRuntime();
      Process p = null;

      try {
         System.out.println(">>工作流执行方法：" + pmcmd_path + " startworkflow -f " + workflowfolder + " -sv " + server + " -d " + domain + " -u " + user + " -p " + password + " -nowait " + workflowname);
         p = rn.exec(pmcmd_path + " startworkflow -f " + workflowfolder + " -sv " + server + " -d " + domain + " -u " + user + " -p " + password + " -nowait " + workflowname);
      } catch (IOException e) {
         e.printStackTrace();
      }

      InputStream is = p.getInputStream();
      String text = IOUtils.toString(is, "GBK");
      p.waitFor();
      is.close();
      p.destroy();
      System.out.println("*************wwwwwwwwwwwwwwwwwwww" + text);
      return text;
   }

   public static void main(String[] args) throws Exception {
      executMonitor("D:\\infotwo\\clients\\PowerCenterClient\\CommandLineUtilities\\PC\\server\\bin\\pmcmd.exe", "test05", "wf_ONTTOTWO", "s_M_mp_ONTTOTWO", "Administrator", "admin", "PWC_IS", "Domain_USER-XHW", "21");
   }
}
