package com.chenyang.nse.bussiness.entity.orm.table.core.datamap;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CORE_DATAMAP_USERMAP"
)
public class TCoreDatamapUsermap extends TBaseEntity {
   private String tableid;
   private String userid;
   private String datamapid;

   public TCoreDatamapUsermap() {
   }

   public TCoreDatamapUsermap(String tableid, String userid, String datamapid) {
      this.tableid = tableid;
      this.userid = userid;
      this.datamapid = datamapid;
   }

   public String getTableid() {
      return this.tableid;
   }

   public void setTableid(String tableid) {
      this.tableid = tableid;
   }

   public String getUserid() {
      return this.userid;
   }

   public void setUserid(String userid) {
      this.userid = userid;
   }

   public String getDatamapid() {
      return this.datamapid;
   }

   public void setDatamapid(String datamapid) {
      this.datamapid = datamapid;
   }

   public String toString() {
      return "TCoreDatamapUsermap [tableid=" + this.tableid + ", userid=" + this.userid + ", datamapid=" + this.datamapid + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.datamapid == null ? 0 : this.datamapid.hashCode());
      result = 31 * result + (this.tableid == null ? 0 : this.tableid.hashCode());
      result = 31 * result + (this.userid == null ? 0 : this.userid.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreDatamapUsermap other = (TCoreDatamapUsermap)obj;
         if (this.datamapid == null) {
            if (other.datamapid != null) {
               return false;
            }
         } else if (!this.datamapid.equals(other.datamapid)) {
            return false;
         }

         if (this.tableid == null) {
            if (other.tableid != null) {
               return false;
            }
         } else if (!this.tableid.equals(other.tableid)) {
            return false;
         }

         if (this.userid == null) {
            if (other.userid != null) {
               return false;
            }
         } else if (!this.userid.equals(other.userid)) {
            return false;
         }

         return true;
      }
   }
}
