package com.chenyang.nse.bussiness.enumeration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum EmaskingTaskType {
   SEPARATOR("-", "separator", "分隔符"),
   DB("0a", "dbsystem", "库"),
   FILE("1a", "filesystem", "文件"),
   HIVE("2a", "Hive", "Hive"),
   DB_TO_DB("0a-0a", "dbsystem_to_dbsystem", "库对库"),
   DB_TO_FILE_TO_DB("0b-0b", "dbsystem_to_file_to_dbsystem", "本库脱敏"),
   DB_TO_FILE("0a-1a", "dbsystem_to_filesystem", "库对文件"),
   FILE_TO_DB("1a-0a", "filesystem_to_dbsystem", "文件对库"),
   FILE_TO_FILE("1a-1a", "filesystem_to_filesystem", "文件对文件"),
   IM_TO_DB("im-db", "import_to_db", "任务导入"),
   SUB_TO_DB("sub-db", "subset_to_db", "子集任务"),
   DB_TO_HIVE("0a-2a", "dbsystem_to_hive", "库对Hive"),
   FILE_TO_HIVE("1a-2a", "filesystem_to_hive", "文件对Hive"),
   HIVE_TO_HIVE("2a-2a", "hive_to_hive", "Hive对Hive"),
   HIVE_TO_DB("2a-0a", "hive_to_db", "Hive对库"),
   HIVE_TO_FILE("2a-1a", "hive_to_filesystem", "Hive对文件"),
   DB_TO_DB_DISCOVERY("0b0b", "dbsystem_to_dbsystem_discovery", "库对库-从发现结果中进行脱敏");

   private String flag;
   private String code;
   private String maskingtype;

   private EmaskingTaskType(String flag, String code, String maskingtype) {
      this.flag = flag;
      this.code = code;
      this.maskingtype = maskingtype;
   }

   public String getFlag() {
      return this.flag;
   }

   public void setFlag(String flag) {
      this.flag = flag;
   }

   public String getCode() {
      return this.code;
   }

   public void setCode(String code) {
      this.code = code;
   }

   public String getMaskingtype() {
      return this.maskingtype;
   }

   public void setMaskingtype(String maskingtype) {
      this.maskingtype = maskingtype;
   }

   public static List<EmaskingTaskType> getMaskingType() {
      List<EmaskingTaskType> list = Arrays.asList(values());
      return list;
   }

   public static List<String> getDesensitizeTypeName() {
      List<EmaskingTaskType> list = getMaskingType();
      List<String> nameList = null;
      if (list != null && list.size() > 0) {
         nameList = new ArrayList();

         for(EmaskingTaskType item : list) {
            nameList.add(item.getMaskingtype());
         }
      }

      return nameList;
   }

   public static EmaskingTaskType getEmaskingTaskTypeByFlag(String flag) {
      if (flag != null && !"".equals(flag)) {
         for(EmaskingTaskType item : getMaskingType()) {
            if (flag.equals(item.getFlag())) {
               return item;
            }
         }

         return null;
      } else {
         return null;
      }
   }

   public static EmaskingTaskType getEmaskingTaskTypeByType(String type) {
      if (type != null && !"".equals(type)) {
         for(EmaskingTaskType item : getMaskingType()) {
            if (type.equals(item.getMaskingtype())) {
               return item;
            }
         }

         return null;
      } else {
         return null;
      }
   }
}
