package com.chenyang.nse.bussiness.init;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.SimpleDateFormat;

public class CustomObjectMapper extends ObjectMapper {
   private static final long serialVersionUID = -6074288171783373481L;

   public CustomObjectMapper() {
      this.setSerializationInclusion(Include.NON_NULL);
      this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
      this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      this.setDateFormat(sdf);
   }
}
