package com.chenyang.nse.bussiness.init;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chenyang.nse.bussiness.entity.vo.ReturnInterfaceDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;

@Component
@Order(3)
@RequestMapping({"datainitload"})
public class DataInitLoad implements ApplicationRunner {
   public static boolean initCacheFlag = false;
   @Value("${classify.classifyEnable}")
   boolean classifyEnable;
   @Value("${classify.url}")
   String classifyIpAndPort;
   @Value("${classify.classifyName}")
   String classifyName;
   @Value("${classify.levelName}")
   String levelName;
   public static final int PAGE_SIZE = 10000;

   public void run(ApplicationArguments args) throws Exception {
      (new Thread(() -> {
         try {
            if (this.classifyEnable) {
               try {
                  this.initClassifyInfos();
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

      })).start();
   }

   @RequestMapping({"initClassifyInfos"})
   public void initClassifyInfos() {
      try {
         this.initClassifyAndLevel();
      } catch (Exception e) {
         e.printStackTrace();
      }

      this.initColumnAndClassifyAndLevelAndAreaRelation();
   }

   public void initClassifyAndLevel() {
      String classifyUrl = this.classifyIpAndPort + this.classifyName;
      String levelUrl = this.classifyIpAndPort + this.levelName;
      String jsonBody = "{\"edition_id\": \"1\",\"type\":\"0\"}";
      String jsonBody2 = "{\"edition_id\": \"1\",\"type\":\"1\"}";

      try {
         String classifyRes = sendHttpPost(classifyUrl, jsonBody);
         Map classifyMap = (Map)JSON.parse(classifyRes);
         List<Map<String, Object>> classifyList = (List)classifyMap.get("data");
         StaticDatasPool.allCtrlClassifyList = classifyList;
         String levelRes = sendHttpPost(levelUrl, jsonBody);
         Map levelMap = (Map)JSON.parse(levelRes);
         List<Map> levelList = (List)levelMap.get("data");
         StaticDatasPool.allCtrlLevelList = levelList;
         String classifyRes2 = sendHttpPost(classifyUrl, jsonBody2);
         Map classifyMap2 = (Map)JSON.parse(classifyRes2);
         List<Map> classifyList2 = (List)classifyMap2.get("data");
         StaticDatasPool.allColumnClassifyList = classifyList2;
         String levelRes2 = sendHttpPost(levelUrl, jsonBody2);
         Map levelMap2 = (Map)JSON.parse(levelRes2);
         List<Map> levelList2 = (List)levelMap2.get("data");
         StaticDatasPool.allColumnLevelList = levelList2;
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public static String sendHttpPost(String url, String JSONBody) throws Exception {
      CloseableHttpClient httpClient = HttpClients.createDefault();
      HttpPost httpPost = new HttpPost(url);
      httpPost.addHeader("Content-Type", "application/json");
      httpPost.setEntity(new StringEntity(JSONBody));
      CloseableHttpResponse response = httpClient.execute(httpPost);
      HttpEntity entity = response.getEntity();
      String responseContent = EntityUtils.toString(entity, "UTF-8");
      response.close();
      httpClient.close();
      return responseContent;
   }

   public void initColumnAndClassifyAndLevelAndAreaRelation() {
      String url = this.classifyIpAndPort + "/core/datascope/getScopeAndSensitiveInfo";
      String jsonBody = "";

      try {
         String classifyRes = sendHttpPost(url, jsonBody);
         Map result = (Map)JSON.parse(classifyRes);
         Map map = (Map)result.get("data");
         List<ReturnInterfaceDate> list = new ArrayList();
         if (map != null && map.size() > 0) {
            list = JSON.parseArray(JSONObject.toJSONString(map.get("allInfo")), ReturnInterfaceDate.class);
         }

         StaticDatasPool.columnAndClassifyAndLevelAndAreaRelationList = list;
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public void changeColumnAndClassifyAndLevelAndAreaRelation(String dataSystemId, String schemaName, String tableName, String columnName) {
      String url = this.classifyIpAndPort + "/core/datascope/getScopeAndSensitiveInfoForPush";
      String jsonBody = "{\"dataSystemId\": \"" + dataSystemId + "\",\"schemaName\": \"" + schemaName + "\",\"tableName\": \"" + tableName + "\",\"columnName\": \"" + columnName + "\"}";

      try {
         String classifyRes = sendHttpPost(url, jsonBody);
         Map result = (Map)JSON.parse(classifyRes);
         Map map = (Map)result.get("data");
         List<ReturnInterfaceDate> list = (List)map.get("list");
         StaticDatasPool.columnAndClassifyAndLevelAndAreaRelationList = list;
      } catch (Exception e) {
         e.printStackTrace();
      }

   }
}
