package com.chenyang.nse.bussiness.init;

import com.chenyang.nse.bussiness.service.core.config.BaseConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class InitConfigListener implements ApplicationListener<ContextRefreshedEvent> {
   @Autowired
   private BaseConfigService baseConfigService;

   public void onApplicationEvent(ContextRefreshedEvent arg0) {
      if (arg0.getApplicationContext().getParent() == null) {
         this.baseConfigService.initConfig();
      }

      try {
         Class.forName("com.chenyang.nse.bussiness.common.PropertiesConstant");
      } catch (ClassNotFoundException e) {
         throw new RuntimeException(e);
      }
   }
}
