package com.chenyang.nse.bussiness.odbc.business;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.chenyang.nse.bussiness.jar.db.TCoreClientInfoDao;
import com.chenyang.nse.bussiness.jar.db.TCoreClientRuleChangeLogDao;
import com.chenyang.nse.bussiness.jar.util.JarClientUtil;
import com.chenyang.nse.bussiness.odbc.po.RuleReqInfo;
import com.chenyang.nse.bussiness.tools.spring.SpringUtil;
import com.chenyang.nse.bussiness.tools.strategy.StrategyData;
import java.io.IOException;

public class RuleApi implements OdbcApiCallable {
   public Object invoke(byte[] data) {
      try {
         ObjectMapper mapper = new ObjectMapper();
         RuleReqInfo info = null;
         info = (RuleReqInfo)mapper.readValue(data, RuleReqInfo.class);
         String projectId = info.getProject();
         String remoteHost = info.getHost();
         String remotePort = info.getPort();

         try {
            StrategyData strategyData = (StrategyData)SpringUtil.getBean(StrategyData.class);
            JarClientUtil.log(remoteHost, Integer.parseInt(remotePort), "开始同步加密策略...");
            String strategyjson = strategyData.getEncryptionData(projectId, "5", "44");
            JarClientUtil.log(remoteHost, Integer.parseInt(remotePort), "加密策略同步完成!同步内容为：" + strategyjson);
            TCoreClientRuleChangeLogDao ruleChangeLogDao = (TCoreClientRuleChangeLogDao)SpringUtil.getBean(TCoreClientRuleChangeLogDao.class);
            TCoreClientInfoDao clientInfoDao = (TCoreClientInfoDao)SpringUtil.getBean(TCoreClientInfoDao.class);
            return strategyjson;
         } catch (Exception e) {
            e.printStackTrace();
            return "{}";
         }
      } catch (IOException e) {
         e.printStackTrace();
         return "{}";
      }
   }
}
