package com.chenyang.nse.bussiness.service.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.HgToFlFj;
import com.chenyang.nse.bussiness.entity.orm.table.core.HgToYuan;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreFullChart;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreFieldSensitive;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreScopeField;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TViewComplianceDirectoryProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TViewDataScopeProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TViewSensitiveLevelProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.project.TCoreProjectInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.scopeproject.TProEditionScope;
import com.chenyang.nse.bussiness.entity.vo.datascope.DataScopeVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.EditionProjectVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldDetailReportVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldlistReportVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.ReportCheckboxVO;
import java.util.List;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public interface DataScopeService {
   boolean dataScopeIsExistsByName(String text, String editionid);

   void save(DataScopeVO scope);

   DataScopeVO editbyid(String id);

   void remove(String id);

   List<FieldlistReportVO> getFieldlistReport(PageInfo pageInfo, String projectid, String type, String directory_name, String tablename, String columnname);

   Object getFieldlistRuleReport(PageInfo pageInfo, String type, String directory_name, String tablename, String columnname);

   List<TCoreProjectInfo> getProjectList();

   List<ReportCheckboxVO> getComplianceDirectoryList();

   List<ReportCheckboxVO> getCoreDataScopeList();

   List<ReportCheckboxVO> getTCoreSensitiveLevelList();

   List<TViewComplianceDirectoryProject> getTViewComplianceDirectoryProject(PageInfo pageInfo, String projectid, String type, String directory_name, String tablename, String columnname);

   List<TViewDataScopeProject> getTViewDataScopeProject(PageInfo pageInfo, String projectid, String type, String directory_name, String tablename, String columnname);

   List<TViewSensitiveLevelProject> getTViewSensitiveLevelProject(PageInfo pageInfo, String projectid, String type, String directory_name, String tablename, String columnname);

   void saveDataToRedis();

   void removeDataToRedis();

   List<FieldDetailReportVO> getFieldDetail(String columnid);

   void getDataFromTable();

   List<TProEditionScope> getDataScopeProjectList();

   void saveProject(EditionProjectVO project);

   EditionProjectVO editpeproject(String id);

   void removepeproject(String id);

   List<TProEditionScope> geteditionlist();

   List<DataScopeVO> getScopeTable(String vo);

   String getmaxdatetid(String editionid);

   String getdefaultedition(String setuptype, String projectId);

   void setdefaultedition(String setuptype, String editionid);

   String hasEditName(EditionProjectVO project);

   List<TCoreFullChart> findFirst();

   List<TCoreFullChart> queryALl();

   List<Map> findAllScopeField();

   List<HgToFlFj> queryALltwo();

   List<HgToYuan> queryAllThree();

   void excelModelUp(MultipartFile file, String editionid);

   void saveExcelData(List<List<String>> list, String editionid, String user) throws Exception;

   void removeByEdition(String editionid);

   List<TProEditionScope> geteditionlistds(String projectId);

   List<TProEditionScope> geteditionlistByEditionId(String editionid);

   List<TCoreScopeField> getTCoreScopeFieldInfo(String datasystemid, String projectid, String schemaname, String tablename);

   List<TCoreFieldSensitive> getTCoreFieldSensitiveInfo(String datasystemid, String projectid, String schemaname, String tablename);

   String checkName(String scopename, String editionid);

   List<Map<String, String>> selectRelationType(String editionid, String rule, String type);

   List<Map<String, String>> selectRelationGrade(String type, String id, String editionid);

   List<Map<String, String>> getScopelist(String editionid, String rule);

   Map<String, String> queryScopeById(String id);

   Map<String, String> queryNewTProEditionScope(String projectid);

   List<Map<String, String>> getScopelevellist(String editionid, String rule);

   Map<String, String> queryScopelevelById(String id);

   List<TCoreScopeField> queryScopeById(String projectid, String datasystemid, String editionid);

   List<TCoreFieldSensitive> queryScopeLevelById(String projectid, String datasystemid, String editionid);

   Map getVersionInfo(String projectid, String versions, String editionid);

   boolean isExistsByName(String edition_name, String scope_level);

   String getEditionNameById(String id);

   List<TProEditionScope> geteditionlistds();

   int checkDatasystem();
}
