package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.TCoreConfigDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreConfig;
import com.chenyang.nse.bussiness.service.core.ConfigService;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfigServiceImpl implements ConfigService {
   @Autowired
   private TCoreConfigDao tCoreConfigDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;

   public TCoreConfig queryBydbtype(String dbtype) {
      TCoreConfig tCoreConfig = new TCoreConfig();
      String sourcedelimiter = "";
      String sourcequoteCharacter = "";
      String targetquoteCharacter = "";
      String targetdelimiter = "";
      String fileDir = "";
      String suffix = "";
      String dabtype = "";
      if (dbtype.equals("MYSQL")) {
         dabtype = "MYSQL";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      } else if (dbtype.equals("HANA")) {
         dabtype = "HANA";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      } else if (dbtype.equals("TERADATA")) {
         dabtype = "TERADATA";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      } else if (dbtype.equals("HIVE")) {
         dabtype = "HIVE";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      } else if (dbtype.equals("MSSQLSERVER")) {
         dabtype = "MSSQLSERVER";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      } else if (dbtype.equals("SYBASE")) {
         dabtype = "SYBASE";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      } else if (dbtype.equals("SYBASE_IQ")) {
         dabtype = "SYBASE_IQ";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      } else if (dbtype.equals("DB2")) {
         dabtype = "DB2";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      } else if (dbtype.equals("ORACLE")) {
         dabtype = "ORACLE";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      } else if (dbtype.equals("INFORMIX")) {
         dabtype = "INFORMIX";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      } else if (dbtype.equals("MARIADB")) {
         dabtype = "MARIADB";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      } else if (dbtype.equals("GREENPLUM")) {
         dabtype = "GREENPLUM";
         sourcedelimiter = XmlTool.getFileValue(dbtype + "/db-sourcedelimiter");
         sourcequoteCharacter = XmlTool.getFileValue(dbtype + "/db-sourcequoteCharacter");
         targetdelimiter = XmlTool.getFileValue(dbtype + "/db-targetdelimiter");
         targetquoteCharacter = XmlTool.getFileValue(dbtype + "/db-targetquoteCharacter");
         suffix = XmlTool.getFileValue(dbtype + "/db-suffix");
         fileDir = XmlTool.getFileValue(dbtype + "/db-fileDir");
      }

      List<String> tCoreConfig1 = this.tCoreConfigDao.queryBydbtype(dbtype);
      if (tCoreConfig1 != null && tCoreConfig1.size() > 0) {
         tCoreConfig.setId((String)tCoreConfig1.get(0));
         tCoreConfig.setSourcedelimiter(sourcedelimiter);
         tCoreConfig.setSourcequoteCharacter(sourcequoteCharacter);
         tCoreConfig.setTargetdelimiter(targetdelimiter);
         tCoreConfig.setTargetquoteCharacter(targetquoteCharacter);
         tCoreConfig.setDbtype(dbtype);
         tCoreConfig.setSuffix(suffix);
         tCoreConfig.setFileDir(fileDir);
         return tCoreConfig;
      } else {
         tCoreConfig.setId(StringTool.getTablePrimaryKey());
         tCoreConfig.setSourcedelimiter(sourcedelimiter);
         tCoreConfig.setSourcequoteCharacter(sourcequoteCharacter);
         tCoreConfig.setTargetdelimiter(targetdelimiter);
         tCoreConfig.setTargetquoteCharacter(targetquoteCharacter);
         tCoreConfig.setDbtype(dbtype);
         tCoreConfig.setSuffix(suffix);
         tCoreConfig.setFileDir(fileDir);
         return tCoreConfig;
      }
   }

   public List<String> queryBysystemid(String id) {
      List<String> list = this.tCoreConfigDao.queryBysystemid(id);
      return list;
   }

   @Transactional
   public void removeBysysid(String id) {
      this.tCoreConfigDao.removeBysysid(id);
   }
}
