package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.DataScopeDao;
import com.chenyang.nse.bussiness.dao.core.SensitiveLevelDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreComplianceDirectoryDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDataScopeDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSensitiveLevelDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.FullChartDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.HgToFlFjDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.HgToYuanDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreFieldDirectoryDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreFieldSensitiveDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreScopeDirectoryDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreScopeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.view.TViewComplianceDirectoryDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.view.TViewComplianceDirectoryProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.view.TViewDataScopeDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.view.TViewDataScopeProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.view.TViewSensitiveLevelDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.view.TViewSensitiveLevelProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.project.TCoreProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.scopeproject.TProAttributeGroupDao;
import com.chenyang.nse.bussiness.dao.table.core.scopeproject.TProEditionScopeDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.HgToFlFj;
import com.chenyang.nse.bussiness.entity.orm.table.core.HgToYuan;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreComplianceDirectory;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataScope;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreFullChart;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiveLevel;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreFieldSensitive;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreScopeField;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TViewComplianceDirectoryProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TViewDataScopeProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.view.TViewSensitiveLevelProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.project.TCoreProjectInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.scopeproject.TProAttributeGroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.scopeproject.TProEditionScope;
import com.chenyang.nse.bussiness.entity.vo.datascope.DataScopeVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.EditionProjectVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldDetailReportVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldlistReportVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.ReportCheckboxVO;
import com.chenyang.nse.bussiness.service.core.DataScopeService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class DataScopeServiceImpl implements DataScopeService {
   @Autowired
   private FullChartDao fullchartdao;
   @Autowired
   private HgToFlFjDao hgtoflfjdao;
   @Autowired
   private HgToYuanDao hgtoyuan;
   @Autowired
   private TViewSensitiveLevelProjectDao tViewSensitiveLevelProjectDao;
   @Autowired
   private TViewDataScopeProjectDao tViewDataScopeProjectDao;
   @Autowired
   private TViewComplianceDirectoryProjectDao tViewComplianceDirectoryProjectDao;
   @Autowired
   private TCoreComplianceDirectoryDao tCoreComplianceDirectoryDao;
   @Autowired
   private TCoreScopeDirectoryDao tCoreScopeDirectoryDao;
   @Autowired
   private TCoreProjectDao tCoreProjectDao;
   @Autowired
   private TCoreDataScopeDao tCoreDataScopeDao;
   @Autowired
   private TCoreSensitiveLevelDao tCoreSensitiveLevelDao;
   @Autowired
   private DataScopeDao dataScopeDao;
   @Autowired
   private RedisService redisService;
   @Autowired
   private TViewComplianceDirectoryDao tViewComplianceDirectoryDao;
   @Autowired
   private TViewDataScopeDao tViewDataScopeDao;
   @Autowired
   private TViewSensitiveLevelDao tViewSensitiveLevelDao;
   @Autowired
   private TProEditionScopeDao tProEditionScopeDao;
   @Autowired
   private TProAttributeGroupDao tProAttributeGroupDao;
   @Autowired
   private TCoreScopeFieldDao tCoreScopeFieldDao;
   @Autowired
   private TCoreFieldDirectoryDao tCoreFieldDirectoryDao;
   @Autowired
   private TCoreFieldSensitiveDao tCoreFieldSensitiveDao;
   @Autowired
   private DataScopeService dataScopeService;
   @Autowired
   private SensitiveLevelDao sensitiveLevelDao;
   @Autowired
   TCoreDatasystemDao tCoreDatasystemDao;

   public void save(DataScopeVO scope) {
      if (scope.getTid() != null && !"".equals(scope.getTid())) {
         this.dataScopeDao.updateScope(scope);
      } else if (scope.getFa_tid() == null) {
         scope.setTid(UUID.randomUUID().toString().replace("-", ""));
         List<TCoreDataScope> ll = this.tCoreDataScopeDao.queryAll(new Criterion[]{Restrictions.eq("edition_id", scope.getEdition_id())});
         if (ll.size() > 0) {
            this.dataScopeDao.insertAddFa(scope);
         } else {
            this.dataScopeDao.insertAddZero(scope);
         }
      } else if (this.dataScopeDao.ishavebro(scope).size() > 0) {
         scope.setTid(UUID.randomUUID().toString().replace("-", ""));
         this.dataScopeDao.havebro(scope);
      } else {
         scope.setTid(UUID.randomUUID().toString().replace("-", ""));
         this.dataScopeDao.nothavebro(scope);
      }

      this.dataScopeDao.delRelation(scope);
      String rules = scope.getRules();
      if (rules != null && rules != "") {
         String[] ruleList = rules.split(",");

         for(String rule : ruleList) {
            this.dataScopeDao.insertRelation(scope, rule);
         }
      }

      String idPro = scope.getTid();
      this.saveColumn(scope, idPro);
   }

   public void remove(String id) {
      TCoreDataScope ds = (TCoreDataScope)this.tCoreDataScopeDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
      List<Map<String, Object>> relatedList = this.tCoreDataScopeDao.relatedfandson(ds.getScope_id(), ds.getEdition_id());
      List<String> listname = new ArrayList();

      for(Map<String, Object> a : relatedList) {
         listname.add((String)a.get("id"));
      }

      this.tCoreScopeFieldDao.remove(new Criterion[]{Restrictions.in("scope_id", listname)});
      this.dataScopeDao.delselfandson(ds.getScope_id(), ds.getEdition_id());

      for(DataScopeVO dataScopeVO : this.dataScopeDao.findbroandhisson(ds.getScope_id(), ds.getFa_tid(), ds.getEdition_id())) {
         if (ds.getFa_tid().equals(dataScopeVO.getFa_tid())) {
            this.dataScopeDao.updatebro(dataScopeVO.getTid());
         } else {
            this.dataScopeDao.updatebroson(dataScopeVO.getTid(), ds.getScope_id());
         }
      }

   }

   public List<DataScopeVO> getScopeTable(String edition_id) {
      new ArrayList();
      List<DataScopeVO> list = this.dataScopeDao.getDataScopeGroup(edition_id);
      list.forEach((l) -> {
         List<TProAttributeGroup> listGroup = this.tProAttributeGroupDao.queryAll(new Criterion[]{Restrictions.eq("group_id", l.getTid())});
         Map<String, String> map = new HashMap();
         listGroup.forEach((lg) -> map.put(lg.getColumnname(), lg.getColumnvalue()));
         l.setColumnsGroups(map);
      });
      List<DataScopeVO> trees = this.buildTree(list, "全部");
      return trees;
   }

   private List<DataScopeVO> buildTree(List<DataScopeVO> list, String parentId) {
      List<DataScopeVO> trees = new ArrayList();

      for(DataScopeVO entity : list) {
         String menuId = entity.getTid();
         String pid = entity.getFa_tid();
         if (parentId.equals(pid)) {
            List<DataScopeVO> menuLists = this.buildTree(list, menuId);
            entity.setChildren(menuLists);
            trees.add(entity);
         }
      }

      return trees;
   }

   public DataScopeVO editbyid(String id) {
      TCoreDataScope o = (TCoreDataScope)this.tCoreDataScopeDao.queryAll(new Criterion[]{Restrictions.eq("id", id)}).get(0);
      String fatid = o.getFa_tid();
      String editionid = o.getEdition_id();
      DataScopeVO vo = new DataScopeVO();
      if ("全部".equals(fatid)) {
         vo.setFa_name("全部");
      } else {
         List<TCoreDataScope> f = this.tCoreDataScopeDao.queryAll(new Criterion[]{Restrictions.eq("id", id)});
         String faid = ((TCoreDataScope)f.get(0)).getFa_tid();
         vo.setFa_name(((TCoreDataScope)this.tCoreDataScopeDao.queryUnique(new Criterion[]{Restrictions.eq("id", faid)})).getScope_name());
      }

      List<Map<String, String>> maps = this.dataScopeDao.selectRelation(id);
      String rules = "";
      if (maps != null && !maps.isEmpty()) {
         for(Map<String, String> map : maps) {
            if (rules == "") {
               rules = rules + (String)map.get("rule");
            } else {
               rules = rules + "," + (String)map.get("rule");
            }
         }
      }

      vo.setTid(o.getId());
      vo.setText(o.getScope_name());
      vo.setId(o.getScope_id());
      vo.setFa_tid(o.getFa_tid());
      vo.setNote(o.getNote());
      vo.setEdition_id(o.getEdition_id());
      vo.setCreate_user(o.getCreate_user());
      vo.setCreate_date(o.getCreate_date());
      vo.setRules(rules);
      List<TProAttributeGroup> list = this.tProAttributeGroupDao.queryAll(new Criterion[]{Restrictions.eq("group_id", id)});
      Map<String, String> map = new HashMap();
      list.forEach((l) -> map.put(l.getColumnname(), l.getColumnvalue()));
      vo.setColumnsGroups(map);
      return vo;
   }

   public void saveDataToRedis() {
      String[] var10000 = new String[]{"levelBycolumn", "projectBylevelBycolumn", "complianceBycolumn", "projectBycomplianceBycolumn", "datatangeBycolumn", "projectBydatatangeBycolumn"};
      this.redisService.set("proess", "0%");
      List<TCoreSensitiveLevel> tCoreSensitiveLevellist = this.tCoreSensitiveLevelDao.queryAll();
      List<Map<String, Object>> getDatacount_levelBycolumn = this.tCoreSensitiveLevelDao.getDatacount();
      Map<String, String> map_levelBycolumn = new HashMap();

      for(Map<String, Object> mapc : getDatacount_levelBycolumn) {
         map_levelBycolumn.put(mapc.get("sensitive_id").toString(), mapc.get("count").toString());
      }

      List<String> levelBycolumn_key_list = new ArrayList();
      List<String> levelBycolumn_value_list = new ArrayList();

      for(TCoreSensitiveLevel tCoreSensitiveLevel : tCoreSensitiveLevellist) {
         levelBycolumn_key_list.add(tCoreSensitiveLevel.getSensitive_name());
         levelBycolumn_value_list.add(map_levelBycolumn.get(tCoreSensitiveLevel.getId()) == null ? "0" : (String)map_levelBycolumn.get(tCoreSensitiveLevel.getId()));
      }

      this.redisService.set("levelBycolumn_key_list", levelBycolumn_key_list);
      this.redisService.set("levelBycolumn_value_list", levelBycolumn_value_list);
      this.tViewSensitiveLevelDao.clearTable();
      this.tViewSensitiveLevelDao.createViewSensitiveLevel();
      this.redisService.set("proess", "12%");
      List<TCoreComplianceDirectory> tCoreComplianceDirectorylist = this.tCoreComplianceDirectoryDao.queryAll();
      List<Map<String, Object>> getDatacount_complianceBycolumn = this.tCoreComplianceDirectoryDao.getDatacount();
      Map<String, String> map_complianceBycolumn = new HashMap();

      for(Map<String, Object> mapc : getDatacount_complianceBycolumn) {
         map_complianceBycolumn.put(mapc.get("directory_id").toString(), mapc.get("count").toString());
      }

      List<String> complianceBycolumn_key_list = new ArrayList();
      List<String> complianceBycolumn_value_list = new ArrayList();

      for(TCoreComplianceDirectory tCoreComplianceDirectory : tCoreComplianceDirectorylist) {
         complianceBycolumn_key_list.add(tCoreComplianceDirectory.getDirectory_name());
         complianceBycolumn_value_list.add(map_complianceBycolumn.get(tCoreComplianceDirectory.getId()) == null ? "0" : (String)map_complianceBycolumn.get(tCoreComplianceDirectory.getId()));
      }

      this.redisService.set("complianceBycolumn_key_list", complianceBycolumn_key_list);
      this.redisService.set("complianceBycolumn_value_list", complianceBycolumn_value_list);
      this.tViewComplianceDirectoryDao.clearTable();
      this.tViewComplianceDirectoryDao.createViewComplianceDirectory();
      this.redisService.set("proess", "24%");
      List<TCoreDataScope> tCoreDataScopeDaolist = this.tCoreDataScopeDao.queryAll();
      List<Map<String, Object>> getDatacount_datatangeBycolumn = this.tCoreDataScopeDao.getDatacount();
      Map<String, String> map_datatangeBycolumn = new HashMap();

      for(Map<String, Object> mapc : getDatacount_datatangeBycolumn) {
         map_datatangeBycolumn.put(mapc.get("scope_id").toString(), mapc.get("count").toString());
      }

      List<String> datatangeBycolumn_key_list = new ArrayList();
      List<String> datatangeBycolumn_value_list = new ArrayList();

      for(TCoreDataScope tCoreDataScope : tCoreDataScopeDaolist) {
         datatangeBycolumn_key_list.add(tCoreDataScope.getScope_name());
         datatangeBycolumn_value_list.add(map_datatangeBycolumn.get(tCoreDataScope.getScope_id()) == null ? "0" : (String)map_datatangeBycolumn.get(tCoreDataScope.getScope_id()));
      }

      this.redisService.set("datatangeBycolumn_key_list", datatangeBycolumn_key_list);
      this.redisService.set("datatangeBycolumn_value_list", datatangeBycolumn_value_list);
      this.tViewDataScopeDao.clearTable();
      this.tViewDataScopeDao.createViewDataScope();
      this.redisService.set("proess", "36%");
      List<String> projectBylevelBycolumn_key_list = new ArrayList();
      List<String> projectBycomplianceBycolumn_key_list = new ArrayList();
      List<String> projectBydatatangeBycolumn_key_list = new ArrayList();
      List<TCoreProjectInfo> tCoreProjectInfolist = this.tCoreProjectDao.queryAll();
      List<String> projectBycolumn_id_list = new ArrayList();
      double z_project = (double)64.0F;
      double every_project = (double)(64 / (tCoreProjectInfolist.size() * 3 == 0 ? 1 : tCoreProjectInfolist.size() * 3));
      this.tCoreSensitiveLevelDao.truncate("t_view_compliance_directory_project");
      this.tCoreSensitiveLevelDao.truncate("t_view_data_scope_project");
      this.tCoreSensitiveLevelDao.truncate("t_view_sensitive_level_project");
      int k = 0;
      Iterator var27 = tCoreProjectInfolist.iterator();
      if (var27.hasNext()) {
         TCoreProjectInfo tCoreProjectInfo = (TCoreProjectInfo)var27.next();
         String projectid = tCoreProjectInfo.getRealprojectname();
         projectBylevelBycolumn_key_list.add(tCoreProjectInfo.getProjectname());
         projectBycolumn_id_list.add(projectid);
         this.tCoreSensitiveLevelDao.insert(projectid);
         z_project += every_project;
         if (z_project > (double)100.0F) {
            z_project = (double)100.0F;
         }

         this.redisService.set("proess", z_project + "%");
         this.tCoreComplianceDirectoryDao.insert(projectid);
         z_project += every_project;
         if (z_project > (double)100.0F) {
            z_project = (double)100.0F;
         }

         this.redisService.set("proess", z_project + "%");
         this.tCoreDataScopeDao.insert(projectid);
         z_project += every_project;
         if (z_project > (double)100.0F) {
            z_project = (double)100.0F;
         }

         this.redisService.set("proess", z_project + "%");
      }

      projectBycomplianceBycolumn_key_list.addAll(projectBylevelBycolumn_key_list);
      projectBydatatangeBycolumn_key_list.addAll(projectBylevelBycolumn_key_list);
      this.redisService.set("projectBycolumn_id_list", projectBycolumn_id_list);
      this.redisService.set("projectBylevelBycolumn_key_list", projectBylevelBycolumn_key_list);
      this.redisService.set("projectBycomplianceBycolumn_key_list", projectBycomplianceBycolumn_key_list);
      this.redisService.set("projectBydatatangeBycolumn_key_list", projectBydatatangeBycolumn_key_list);
      this.redisService.set("proess", "90%");
   }

   public List<FieldlistReportVO> getFieldlistReport(PageInfo pageInfo, String projectid, String type, String directory_name, String tablename, String columnname) {
      List<FieldlistReportVO> list = this.tCoreDataScopeDao.getFieldList(projectid, type, directory_name, tablename, columnname);
      pageInfo.setCount((long)list.size());
      return list;
   }

   public Object getFieldlistRuleReport(PageInfo pageInfo, String type, String description, String names, String fields) {
      Object list = null;
      if ("0".equals(type)) {
         if ("".equals(description) && "".equals(names) && "".equals(fields)) {
            list = this.tViewComplianceDirectoryDao.queryByPageInfo(pageInfo);
         } else {
            list = this.tViewComplianceDirectoryDao.queryByPageInfo(pageInfo, new Criterion[]{Restrictions.eq("description", description), Restrictions.like("names", "%" + names + "%"), Restrictions.like("fields", "%" + fields + "%")});
         }
      } else if ("1".equals(type)) {
         if ("".equals(description) && "".equals(names) && "".equals(fields)) {
            list = this.tViewDataScopeDao.queryByPageInfo(pageInfo);
         } else {
            list = this.tViewDataScopeDao.queryByPageInfo(pageInfo, new Criterion[]{Restrictions.eq("description", description), Restrictions.like("names", "%" + names + "%"), Restrictions.like("fields", "%" + fields + "%")});
         }
      } else if ("2".equals(type)) {
         if ("".equals(description) && "".equals(names) && "".equals(fields)) {
            list = this.tViewSensitiveLevelDao.queryByPageInfo(pageInfo);
         } else {
            list = this.tViewSensitiveLevelDao.queryByPageInfo(pageInfo, new Criterion[]{Restrictions.eq("description", description), Restrictions.like("names", "%" + names + "%"), Restrictions.like("fields", "%" + fields + "%")});
         }
      }

      return list;
   }

   public List<TCoreProjectInfo> getProjectList() {
      return this.tCoreProjectDao.queryAll();
   }

   public List<ReportCheckboxVO> getComplianceDirectoryList() {
      return this.tCoreComplianceDirectoryDao.queryComplianceDirectoryList();
   }

   public List<ReportCheckboxVO> getCoreDataScopeList() {
      return this.tCoreDataScopeDao.getCoreDataScopeList();
   }

   public List<ReportCheckboxVO> getTCoreSensitiveLevelList() {
      return this.tCoreSensitiveLevelDao.getTCoreSensitiveLevelList();
   }

   public List<FieldDetailReportVO> getFieldDetail(String columnid) {
      return this.tCoreDataScopeDao.getFieldDetail(columnid);
   }

   public void removeDataToRedis() {
      String[] key_value = new String[]{"levelBycolumn_key_list", "levelBycolumn_value_list", "complianceBycolumn_key_list", "complianceBycolumn_value_list", "datatangeBycolumn_key_list", "datatangeBycolumn_value_list", "projectBylevelBycolumn_key_list", "projectBylevelBycolumn_value_list", "projectBycomplianceBycolumn_key_list", "projectBycomplianceBycolumn_value_list", "projectBydatatangeBycolumn_key_list", "projectBydatatangeBycolumn_value_list"};
      this.redisService.remove(key_value);
      this.redisService.set("proess", "0%");
   }

   public List<TViewComplianceDirectoryProject> getTViewComplianceDirectoryProject(PageInfo pageInfo, String projectid, String type, String directory_name, String tablename, String columnname) {
      return this.tViewComplianceDirectoryProjectDao.queryBylist(pageInfo, projectid, type, directory_name, tablename, columnname);
   }

   public List<TViewDataScopeProject> getTViewDataScopeProject(PageInfo pageInfo, String projectid, String type, String directory_name, String tablename, String columnname) {
      return this.tViewDataScopeProjectDao.queryBylist(pageInfo, projectid, type, directory_name, tablename, columnname);
   }

   public List<TViewSensitiveLevelProject> getTViewSensitiveLevelProject(PageInfo pageInfo, String projectid, String type, String directory_name, String tablename, String columnname) {
      return this.tViewSensitiveLevelProjectDao.queryBylist(pageInfo, projectid, type, directory_name, tablename, columnname);
   }

   public void getDataFromTable() {
      List<Map<String, List<String>>> projectBylevelBycolumn_value_list = new ArrayList();
      List<Map<String, List<String>>> projectBycomplianceBycolumn_value_list = new ArrayList();
      List<Map<String, List<String>>> projectBydatatangeBycolumn_value_list = new ArrayList();
      List<String> tCoreProjectInfoListName = (List)this.redisService.get("projectBylevelBycolumn_key_list");
      String[] name_arr = new String[]{"projectBylevelBycolumn", "projectBycomplianceBycolumn", "projectBydatatangeBycolumn"};

      for(String name : name_arr) {
         switch (name) {
            case "projectBylevelBycolumn":
               List<String> ruleName1 = (List)this.redisService.get("levelBycolumn_key_list");
               Map<String, List<String>> map1 = new HashMap();
               Iterator var26 = ruleName1.iterator();

               String str;
               List<String> countKind1;
               for(; var26.hasNext(); map1.put(str, countKind1)) {
                  str = (String)var26.next();
                  List<Map<String, Object>> ll = this.tCoreSensitiveLevelDao.getEachDatacount(str);
                  countKind1 = new ArrayList();
                  if (ll != null) {
                     label123:
                     for(String ln : tCoreProjectInfoListName) {
                        for(Map<String, Object> map : ll) {
                           if (ln.equals(map.get("projectname"))) {
                              countKind1.add(map.get("count").toString());
                              continue label123;
                           }
                        }

                        countKind1.add("0");
                     }
                  }
               }

               projectBylevelBycolumn_value_list.add(map1);
               break;
            case "projectBycomplianceBycolumn":
               List<String> ruleName2 = (List)this.redisService.get("complianceBycolumn_key_list");
               Map<String, List<String>> map2 = new HashMap();

               for(String strNew : ruleName2) {
                  List<Map<String, Object>> ll = this.tCoreComplianceDirectoryDao.getEachDatacount(strNew);
                  List<String> countKind2 = new ArrayList();
                  if (ll != null) {
                     label100:
                     for(String ln : tCoreProjectInfoListName) {
                        for(Map<String, Object> map : ll) {
                           if (ln.equals(map.get("projectname"))) {
                              countKind2.add(map.get("count").toString());
                              continue label100;
                           }
                        }

                        countKind2.add("0");
                     }
                  }

                  map2.put(strNew, countKind2);
               }

               projectBycomplianceBycolumn_value_list.add(map2);
               break;
            case "projectBydatatangeBycolumn":
               List<String> ruleName3 = (List)this.redisService.get("datatangeBycolumn_key_list");
               Map<String, List<String>> map3 = new HashMap();

               for(String strNew : ruleName3) {
                  List<Map<String, Object>> ll = this.tCoreDataScopeDao.getEachDatacount(strNew);
                  List<String> countKind3 = new ArrayList();
                  if (ll != null) {
                     label81:
                     for(String ln : tCoreProjectInfoListName) {
                        for(Map<String, Object> map : ll) {
                           if (ln.equals(map.get("projectname"))) {
                              countKind3.add(map.get("count").toString());
                              continue label81;
                           }
                        }

                        countKind3.add("0");
                     }
                  }

                  map3.put(strNew, countKind3);
               }

               projectBydatatangeBycolumn_value_list.add(map3);
         }
      }

      this.redisService.set("projectBylevelBycolumn_value_list", projectBylevelBycolumn_value_list);
      this.redisService.set("projectBycomplianceBycolumn_value_list", projectBycomplianceBycolumn_value_list);
      this.redisService.set("projectBydatatangeBycolumn_value_list", projectBydatatangeBycolumn_value_list);
      this.redisService.set("proess", "100%");
   }

   public List<TProEditionScope> getDataScopeProjectList() {
      List<TProEditionScope> list = this.tProEditionScopeDao.queryAll(Order.desc("create_date"), new Criterion[]{Restrictions.eq("enable_type", "1")});
      return list;
   }

   public void saveProject(EditionProjectVO project) {
      try {
         Class clazz = project.getClass();
         TProEditionScope tes = new TProEditionScope();
         String idPro = project.getTid();
         if (idPro != null && !"".equals(idPro)) {
            this.tProAttributeGroupDao.remove(new Criterion[]{Restrictions.eq("group_id", idPro)});
         }

         tes.setId(project.getTid());
         tes.setEdition_name(project.getEdition_name());
         tes.setScope_level(project.getScope_level());
         tes.setEnable_type("1");
         tes.setNote(project.getNote());
         tes.setCreate_user(project.getCreate_user());
         tes.setProjectid(project.getProjectid());
         List<TProEditionScope> tProEditionScopeList = this.tProEditionScopeDao.queryAll(new Criterion[]{Restrictions.eq("id", idPro)});
         if (tProEditionScopeList.size() > 0) {
            this.tProEditionScopeDao.updateScopeEdition(tes);
         } else {
            tes.setCreate_date(new Date());
            this.tProEditionScopeDao.save(tes);
         }

         project.getColumnsGroups().entrySet().forEach((map) -> {
            TProAttributeGroup tag = new TProAttributeGroup();
            tag.setId(UUID.randomUUID().toString().replace("-", ""));
            tag.setColumnname((String)map.getKey());
            tag.setColumnvalue((String)map.getValue());
            tag.setGroup_id(tes.getId());
            this.tProAttributeGroupDao.save(tag);
         });
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public EditionProjectVO editpeproject(String id) {
      EditionProjectVO vo = new EditionProjectVO();
      TProEditionScope tes = (TProEditionScope)this.tProEditionScopeDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
      vo.setTid(id);
      vo.setEdition_name(tes.getEdition_name());
      vo.setNote(tes.getNote());
      vo.setCreate_user(tes.getCreate_user());
      vo.setCreate_date(tes.getCreate_date());
      List<TProAttributeGroup> list = this.tProAttributeGroupDao.queryAll(new Criterion[]{Restrictions.eq("group_id", id)});
      Map<String, String> map = new HashMap();
      list.forEach((l) -> map.put(l.getColumnname(), l.getColumnvalue()));
      vo.setColumnsGroups(map);
      return vo;
   }

   public void removepeproject(String id) {
      this.tProEditionScopeDao.removePro(id);
      this.tCoreScopeFieldDao.remove(new Criterion[]{Restrictions.eq("edition_id", id)});
      this.tCoreFieldSensitiveDao.remove(new Criterion[]{Restrictions.eq("edition_id", id)});
      this.tCoreDataScopeDao.remove(new Criterion[]{Restrictions.eq("edition_id", id)});
      this.tCoreSensitiveLevelDao.remove(new Criterion[]{Restrictions.eq("edition_id", id)});
   }

   private void saveColumn(DataScopeVO obj, String idPro) {
      try {
         Class clazz = obj.getClass();
         if (idPro != null && !"".equals(idPro)) {
            this.tProAttributeGroupDao.remove(new Criterion[]{Restrictions.eq("group_id", idPro)});
         }

         obj.getColumnsGroups().entrySet().forEach((map) -> {
            TProAttributeGroup tag = new TProAttributeGroup();
            tag.setId(UUID.randomUUID().toString().replace("-", ""));
            tag.setGroup_id(idPro);
            tag.setColumnname((String)map.getKey());
            tag.setColumnvalue((String)map.getValue());
            this.tProAttributeGroupDao.save(tag);
         });
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public List<TProEditionScope> geteditionlist() {
      List<TProEditionScope> list = this.tProEditionScopeDao.queryAll(Order.desc("create_date"), new Criterion[]{Restrictions.eq("scope_level", "0"), Restrictions.eq("enable_type", "1")});
      return list;
   }

   public List<TProEditionScope> geteditionlistds(String projectId) {
      List<TProEditionScope> list = this.tProEditionScopeDao.queryAll(Order.desc("create_date"), new Criterion[]{Restrictions.eq("projectid", projectId)});
      return list;
   }

   public List<TProEditionScope> geteditionlistByEditionId(String editionid) {
      List<TProEditionScope> list = this.tProEditionScopeDao.queryAll(Order.desc("create_date"), new Criterion[]{Restrictions.eq("id", editionid)});
      return list;
   }

   public String getmaxdatetid(String editionid) {
      String id = "";
      if (editionid != null && !"".equals(editionid)) {
         List<Map<String, Object>> tmax = this.tCoreDataScopeDao.getmaxdatetid(editionid);
         if (!tmax.isEmpty()) {
            id = (String)((Map)tmax.get(0)).get("id");
         }
      }

      return id;
   }

   public String getdefaultedition(String setuptype, String projectId) {
      String obj = null;
      List<Map<String, Object>> list = this.tProEditionScopeDao.getdefaultedition(setuptype, projectId);
      if (!list.isEmpty()) {
         obj = (String)((Map)list.get(0)).get("id");
      }

      return obj;
   }

   public void setdefaultedition(String setuptype, String editionid) {
      this.tProEditionScopeDao.setdefaultedition(setuptype, editionid);
   }

   public String hasEditName(EditionProjectVO project) {
      new ArrayList();
      if (project.getTid() == "") {
         List<TProEditionScope> list = this.tProEditionScopeDao.queryAll(new Criterion[]{Restrictions.eq("edition_name", project.getEdition_name()), Restrictions.eq("create_user", project.getCreate_user()), Restrictions.eq("enable_type", "1"), Restrictions.eq("projectid", project.getProjectid())});
         return list.isEmpty() ? "yes" : "no";
      } else {
         return "yes";
      }
   }

   public List<Map> findAllScopeField() {
      String sql = "select d.dbtype , count(DISTINCT a.scope_id), count(DISTINCT b.scope_id),count(DISTINCT c.scope_id) from t_core_scope_field a , t_core_field_directory b, t_core_field_sensitive c ,t_core_datasystem d where d.id = a.datasystem_id";
      return this.tCoreScopeFieldDao.getTCoreScopeFieldDistinct(sql);
   }

   public List<TCoreFullChart> findFirst() {
      String sql = "select * from fullchart";
      return this.fullchartdao.getTCoreScopeFieldDistinct(sql);
   }

   public List<TCoreFullChart> queryALl() {
      return this.fullchartdao.queryAll();
   }

   public List<HgToFlFj> queryALltwo() {
      return this.hgtoflfjdao.queryAll();
   }

   public List<HgToYuan> queryAllThree() {
      return this.hgtoyuan.queryAll();
   }

   public void excelModelUp(MultipartFile file, String editionid) {
   }

   private void saveScopeData(TCoreDataScope data) {
      this.tCoreDataScopeDao.save(data);
      String fid = data.getId();
      data.getGroups().forEach((g) -> {
         g.setGroup_id(fid);
         this.tProAttributeGroupDao.save(g);
      });
      if (data.getChildrens().size() > 0) {
         data.getChildrens().forEach((c) -> {
            c.setFa_tid(fid);
            this.saveScopeData(c);
         });
      }

   }

   private void saveScopeDataMap(Map<String, TCoreDataScope> map) {
      TCoreDataScope all = (TCoreDataScope)map.get("全部");
      List<TCoreDataScope> fathers = all.getChildrens();
      fathers.forEach((f) -> this.saveScopeData(f));
   }

   public void saveExcelData(List<List<String>> list, String editionid, String user) throws Exception {
      Map<String, TCoreDataScope> map = new HashMap();
      map.put("全部", new TCoreDataScope());
      list.stream().forEach((row) -> {
         String uuid = UUID.randomUUID().toString().replace("-", "");
         TCoreDataScope tds = new TCoreDataScope();

         for(int j = 3; j < row.size() && j % 2 == 1 && null != row.get(j); ++j) {
            TProAttributeGroup attr = new TProAttributeGroup();
            attr.setColumnname((String)row.get(j));
            attr.setColumnvalue((String)row.get(j + 1));
            attr.setColumnnum(String.valueOf((j - 1) / 2));
            tds.getGroups().add(attr);
            ++j;
         }

         tds.setScope_id((String)row.get(0));
         tds.setScope_name((String)row.get(1));
         tds.setNote((String)row.get(2));
         tds.setEdition_id(editionid);
         tds.setCreate_user(user);
         tds.setCreate_date(new Date());
         map.put(row.get(0), tds);
      });
      map.entrySet().forEach((row) -> {
         if (((String)row.getKey()).length() > 3) {
            String fscope = ((TCoreDataScope)row.getValue()).getScope_id().substring(0, ((TCoreDataScope)row.getValue()).getScope_id().length() - 3);
            TCoreDataScope fdata = (TCoreDataScope)map.get(fscope);
            List<TCoreDataScope> childrens = fdata.getChildrens();
            childrens.add(row.getValue());
         } else if (((String)row.getKey()).length() == 3) {
            ((TCoreDataScope)row.getValue()).setFa_tid("全部");
            ((TCoreDataScope)map.get("全部")).getChildrens().add(row.getValue());
         }

      });
      this.saveScopeDataMap(map);
   }

   public void removeByEdition(String editionid) {
      this.tCoreScopeFieldDao.remove(new Criterion[]{Restrictions.eq("edition_id", editionid)});
      this.tProAttributeGroupDao.removeAssScope(editionid);
      this.tCoreDataScopeDao.remove(new Criterion[]{Restrictions.eq("edition_id", editionid)});
      this.sensitiveLevelDao.delrelationByeditionid(editionid, "1");
   }

   public List<TCoreScopeField> getTCoreScopeFieldInfo(String datasystemid, String projectid, String schemaname, String tablename) {
      List<TCoreScopeField> tCoreScopeFields = this.tCoreScopeFieldDao.queryAll(Order.desc("updatetime"), Order.desc("createtime"), new Criterion[]{Restrictions.eq("datasystem_id", datasystemid), Restrictions.eq("projectid", projectid), Restrictions.eq("tschemas", schemaname), Restrictions.eq("names", tablename)});
      return tCoreScopeFields;
   }

   public List<TCoreFieldSensitive> getTCoreFieldSensitiveInfo(String datasystemid, String projectid, String schemaname, String tablename) {
      List<TCoreFieldSensitive> tCoreFieldSensitives = this.tCoreFieldSensitiveDao.queryAll(Order.desc("updatetime"), Order.desc("createtime"), new Criterion[]{Restrictions.eq("datasystem_id", datasystemid), Restrictions.eq("projectid", projectid), Restrictions.eq("tschemas", schemaname), Restrictions.eq("names", tablename)});
      return tCoreFieldSensitives;
   }

   public String checkName(String scopename, String editionid) {
      List<TCoreDataScope> list = this.tCoreDataScopeDao.queryAll(new Criterion[]{Restrictions.eq("scope_name", scopename), Restrictions.eq("edition_id", editionid)});
      return list.isEmpty() ? "yes" : "no";
   }

   public List<Map<String, String>> getScopelist(String editionid, String rule) {
      return this.dataScopeDao.getScopelist(editionid, rule);
   }

   public List<Map<String, String>> getScopelevellist(String editionid, String rule) {
      return this.dataScopeDao.getScopelevellist(editionid, rule);
   }

   public Map<String, String> queryScopeById(String id) {
      Map<String, String> map = this.dataScopeDao.queryScopeById(id);

      String name;
      for(name = ""; !"全部".equals(map.get("fa_tid")); map = this.dataScopeDao.queryScopeByfaid((String)map.get("fa_tid"), (String)map.get("edition_id"))) {
         name = (String)map.get("scope_name") + "->" + name;
      }

      name = (String)map.get("scope_name") + "->" + name;
      Map<String, String> remap = new HashMap();
      remap.put("scope_name", name.substring(0, name.length() - 2));
      return remap;
   }

   public Map<String, String> queryScopelevelById(String id) {
      return this.dataScopeDao.queryScopelevelById(id);
   }

   public List<TCoreScopeField> queryScopeById(String projectid, String datasystemid, String editionid) {
      return this.dataScopeDao.queryScopeById(projectid, datasystemid, editionid);
   }

   public List<TCoreFieldSensitive> queryScopeLevelById(String projectid, String datasystemid, String editionid) {
      return this.dataScopeDao.queryScopeLevelById(projectid, datasystemid, editionid);
   }

   public Map<String, String> queryNewTProEditionScope(String projectid) {
      List<TProEditionScope> list = this.tProEditionScopeDao.queryAll(Order.desc("create_date"), new Criterion[]{Restrictions.eq("scope_level", "0"), Restrictions.eq("enable_type", "1"), Restrictions.eq("projectid", projectid)});
      String editionId = list.size() > 0 ? ((TProEditionScope)list.get(0)).getId() : null;
      List<TProEditionScope> list1 = this.tProEditionScopeDao.queryAll(Order.desc("create_date"), new Criterion[]{Restrictions.eq("scope_level", "1"), Restrictions.eq("enable_type", "1"), Restrictions.eq("projectid", projectid)});
      String editionId1 = list1.size() > 0 ? ((TProEditionScope)list1.get(0)).getId() : null;
      Map<String, String> map = new HashMap();
      map.put("scope_category", editionId);
      map.put("scope_level", editionId1);
      return map;
   }

   public List<Map<String, String>> selectRelationType(String editionid, String rule, String type) {
      List<Map<String, String>> list = this.dataScopeDao.selectRelationType(editionid, rule, type);
      return list;
   }

   public List<Map<String, String>> selectRelationGrade(String type, String id, String editionid) {
      List<Map<String, String>> list = this.dataScopeDao.selectRelationGrade(type, id, editionid);
      return list;
   }

   public Map getVersionInfo(String projectid, String versions, String editionid) {
      Map<String, Map<String, Object>> map = new HashMap();
      String scope_category = editionid;
      String scope_level = editionid;
      if (versions != null && !"".equals(versions)) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String filepath = "";
         String ver = versions.split("/")[0];
         if ("AllVersion".equals(ver)) {
            File file = new File(props.getProperty("AllVersion"));
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("AllVersion") + file.listFiles()[0].getName();
            }
         } else if ("ProjectVersion".equals(ver)) {
            File file = new File(props.getProperty("ProjectVersion") + projectid);
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("ProjectVersion") + projectid + File.separator + file.listFiles()[0].getName();
            }
         } else if ("TaskVersion".equals(ver)) {
            filepath = props.getProperty("TaskVersion") + versions.split("/")[1] + "/" + versions.split("/")[2];
         } else if ("CustomVersion".equals(ver)) {
            File file = new File(props.getProperty("CustomVersion"));
            if (file.listFiles() != null && file.listFiles().length > 0) {
               filepath = props.getProperty("CustomVersion") + File.separator + file.listFiles()[0].getName();
            }
         }

         if (FileTool.isFileExit(filepath)) {
            InputStreamReader newRead = null;

            try {
               newRead = new InputStreamReader(new FileInputStream(filepath), "GBK");
            } catch (UnsupportedEncodingException e1) {
               e1.printStackTrace();
            } catch (FileNotFoundException e1) {
               e1.printStackTrace();
            }

            BufferedReader newBufferedReader = new BufferedReader(newRead);
            String newInformationLine = "";
            String[] str = null;

            try {
               while((newInformationLine = newBufferedReader.readLine()) != null) {
                  str = newInformationLine.split(",", -1);
                  if (!"".equals(str[3])) {
                     Map<String, Object> objectMap = new HashMap();
                     List<Map<String, String>> scopelist = this.dataScopeService.getScopelist(scope_category, str[3]);
                     List<Map<String, String>> scopenewlist = new ArrayList();
                     String finalStr = str[3];
                     scopelist.forEach((scopeinfo) -> {
                        String scopeid = (String)scopeinfo.get("id");
                        Map<String, String> scopenamemap = this.dataScopeService.queryScopeById(scopeid);
                        Map<String, String> map1 = new HashMap();
                        map1.put("scopeid", scopeid);
                        map1.put("scopename", scopenamemap.get("scope_name"));
                        map1.put("dataareaid", finalStr);
                        scopenewlist.add(map1);
                     });
                     objectMap.put("scope", scopenewlist);
                     List<Map<String, String>> scopelevellist = this.dataScopeService.getScopelevellist(scope_level, str[3]);
                     Map<String, String> map2 = new HashMap();
                     if (scopelevellist.size() > 0) {
                        String scopelevelid = (String)((Map)scopelevellist.get(0)).get("id");
                        map2.put("id", scopelevelid);
                        Map<String, String> scopenamemap = this.dataScopeService.queryScopelevelById(scopelevelid);
                        map2.put("name", scopenamemap.get("sensitive_name"));
                        map2.put("dataareaid", finalStr);
                     } else {
                        map2.put("id", "");
                        map2.put("name", "");
                        map2.put("dataareaid", "");
                     }

                     objectMap.put("scopelevel", map2);
                     String key = str[8] + "." + str[0] + "." + str[1] + "." + str[2];
                     map.put(key, objectMap);
                  }
               }
            } catch (IOException e) {
               e.printStackTrace();
            } finally {
               a(newBufferedReader, newRead);
            }
         }
      }

      return map;
   }

   public boolean isExistsByName(String edition_name, String scope_level) {
      return this.tProEditionScopeDao.queryUnique(new Criterion[]{Restrictions.eq("edition_name", edition_name), Restrictions.eq("scope_level", scope_level)}) != null;
   }

   private static void a(Closeable... closeables) {
      if (closeables != null) {
         try {
            for(Closeable closeable : closeables) {
               if (closeable != null) {
                  closeable.close();
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

   }

   public boolean dataScopeIsExistsByName(String text, String editionid) {
      return this.tCoreDataScopeDao.queryUnique(new Criterion[]{Restrictions.eq("scope_name", text), Restrictions.eq("edition_id", editionid)}) != null;
   }

   public String getEditionNameById(String id) {
      return this.tProEditionScopeDao.getEditionNameById(id);
   }

   public List<TProEditionScope> geteditionlistds() {
      List<TProEditionScope> list = this.tProEditionScopeDao.queryAll(Order.desc("create_date"), new Criterion[]{Restrictions.eq("enable_type", "1")});
      return list;
   }

   public int checkDatasystem() {
      List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll();
      return list.size();
   }
}
