package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.bean.Column;
import com.chenyang.nse.bussiness.bean.DataBase;
import com.chenyang.nse.bussiness.bean.DataCache;
import com.chenyang.nse.bussiness.bean.Schema;
import com.chenyang.nse.bussiness.bean.Table;
import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.core.TCoreDataSourceSchemaDao;
import com.chenyang.nse.bussiness.dao.core.TCoreFirstPageDataDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserprojectDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserroleDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUsersysDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemoracleDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemuserDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreTablestructureDao;
import com.chenyang.nse.bussiness.dao.table.core.TcoreDiscoverySensitivecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.datamap.TCoreDatamapTablealiasDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreFileSysGroupDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectDatasourceDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectDatasourceVoDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectFindruleDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingFilesystemDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingHiveDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTableDao;
import com.chenyang.nse.bussiness.dao.table.core.maskingself.TCoreMaskingselfTableDao;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.InfoExecUtil;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserproject;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserrole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsersys;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreConfig;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasourceSchema;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystemoracle;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystemuser;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreTablestructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.datamap.TCoreDatamapTablealias;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreFileSysGroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectDatasource;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFindrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.duty.UserJoinFieldInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.fieldscope.TCoreFieldSensitive;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingFilesystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingHive;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.maskingself.TCoreMaskingselfTable;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.DataSourceAndTaskVO;
import com.chenyang.nse.bussiness.entity.vo.DataSystemConfig;
import com.chenyang.nse.bussiness.entity.vo.DataSystemVO;
import com.chenyang.nse.bussiness.entity.vo.TreeVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.DatasystemProjectdatasourceVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldReportFormVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdataSystem;
import com.chenyang.nse.bussiness.enumeration.EdataSystemGrade;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.console.UserService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.FieldReportFormService;
import com.chenyang.nse.bussiness.service.core.SensitiveLevelService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpTool;
import com.chenyang.nse.bussiness.tools.dmp.TableStructureInfo;
import com.chenyang.nse.bussiness.tools.es.EsUtil;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MongodbTool;
import com.chenyang.nse.bussiness.tools.jdbc.QueryBloodTool;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.string.PasswordEncryptTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.token.TokenUtil;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.common.KafkaFuture;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class DataSystemServiceImpl implements DataSystemService {
   private static final String Link_character = "_";
   @Autowired
   private TBaseUserDao userDao;
   @Autowired
   private TCoreDataProjectDao tCoreDataProjectDao;
   @Autowired
   private TCoreProjectFindruleDao tCoreProjectFindruleDao;
   @Autowired
   private TCoreProjectDatasourceDao tCoreProjectDatasourceDao;
   @Autowired
   private TCoreFirstPageDataDao firstPageDataDao;
   @Autowired
   private FieldReportFormService fieldReportFormService;
   @Autowired
   private SensitiveLevelService sensitiveLevelService;
   @Autowired
   private TBaseUserDao tBaseUserDao;
   @Autowired
   private TBaseUsersysDao tBaseUsersysDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreTablestructureDao tCoreTablestructureDao;
   @Autowired
   private TCoreDatamapTablealiasDao tCoreDatamapTablealiasDao;
   @Autowired
   private TcoreDiscoverySensitivecolumnDao tCoreSensitivecolumnDao;
   @Autowired
   private TCoreMaskingFilesystemDao tCoreMaskingFilesystemDao;
   @Autowired
   private TCoreMaskingTableDao tCoreMaskingTableDao;
   @Autowired
   private TCoreMaskingHiveDao tCoreMaskingHiveDao;
   @Autowired
   private TCoreMaskingselfTableDao tCoreMaskingselfTableDao;
   @Resource
   private HttpServletRequest request;
   @Autowired
   private UserService userService;
   @Autowired
   private RedisService redisService;
   @Autowired
   private TCoreProjectDatasourceVoDao tCoreProjectDatasourceVoDao;
   @Autowired
   private TCoreFileSysGroupDao tCoreFileSysGroupDao;
   @Autowired
   private TCoreDatasystemuserDao tCoreDatasystemuserDao;
   @Autowired
   private TCoreDatasystemoracleDao tCoreDatasystemoracleDao;
   @Autowired
   private TCoreDataSourceSchemaDao tCoreDataSourceSchemaDao;
   @Autowired
   private TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao;
   @Autowired
   TBaseUserprojectDao tBaseUserprojectDao;
   @Autowired
   private TBaseUserroleDao tBaseUserroleDao;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   public List<TCoreDatasystem> queryAll(String sysname, String ip, String dbtype, String userid) {
      if (StringUtils.isBlank(sysname)) {
         sysname = "";
      }

      if (StringUtils.isBlank(ip)) {
         ip = "";
      }

      if (StringUtils.isBlank(dbtype)) {
         dbtype = "";
      }

      Conjunction conjunction = Restrictions.conjunction();
      conjunction.add(Restrictions.like("sysname", sysname, MatchMode.ANYWHERE).ignoreCase());
      conjunction.add(Restrictions.like("dbip", ip, MatchMode.ANYWHERE).ignoreCase());
      conjunction.add(Restrictions.like("dbtype", dbtype, MatchMode.ANYWHERE).ignoreCase());
      List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(Order.desc("createtime"), new Criterion[]{conjunction});
      if ("1".equals(userid)) {
         return list;
      } else {
         List<TCoreDatasystem> notAdminResult = new ArrayList();

         for(TCoreDatasystem dataSystem : list) {
            for(TBaseUser user : this.tCoreDatasystemuserDao.queryUsersByDatasystemId(dataSystem.getId())) {
               if (user.getId().equals(userid)) {
                  notAdminResult.add(dataSystem);
               }
            }
         }

         return notAdminResult;
      }
   }

   public List<TCoreDatasystem> queryAll() {
      return this.tCoreDatasystemDao.queryAll();
   }

   public List<TCoreDatasystem> query(String flag) {
      new ArrayList();
      List<TCoreDatasystem> list;
      if (StringTool.emptyOrNull(flag)) {
         list = this.tCoreDatasystemDao.queryAll(Order.desc("createtime"), new Criterion[0]);
      } else {
         list = this.tCoreDatasystemDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("flag", flag)});
      }

      Object obj = this.request.getSession().getAttribute("loginUser");
      LoginUser loginUser = null;
      if (obj != null) {
         loginUser = (LoginUser)obj;
      }

      List<TBaseUsersys> userSysLst = this.userService.queryusersysbyuserid(loginUser.getTsysUser().getId());
      Map<String, String> sysMap = new HashMap();

      for(TBaseUsersys usrsys : userSysLst) {
         sysMap.put(usrsys.getSysid(), "");
      }

      List<TCoreDatasystem> reList = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         if (sysMap.containsKey(((TCoreDatasystem)list.get(i)).getId())) {
            reList.add(list.get(i));
         }
      }

      return reList;
   }

   public List<TCoreDatasystem> query(List<String> flag, String dbType) {
      if (flag != null && flag.size() > 0) {
         List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.in("flag", flag), Restrictions.eq("dbtype", dbType), Restrictions.ne("id", "402882e9608bf3c001608c09a7410042")});
         Object obj = this.request.getSession().getAttribute("loginUser");
         LoginUser loginUser = null;
         if (obj != null) {
            loginUser = (LoginUser)obj;
         }

         List<TBaseUsersys> userSysLst = this.userService.queryusersysbyuserid(loginUser.getTsysUser().getId());
         Map<String, String> sysMap = new HashMap();

         for(TBaseUsersys usrsys : userSysLst) {
            sysMap.put(usrsys.getSysid(), "");
         }

         List<TCoreDatasystem> reList = new ArrayList();

         for(int i = 0; i < list.size(); ++i) {
            if (sysMap.containsKey(((TCoreDatasystem)list.get(i)).getId())) {
               reList.add(list.get(i));
            }
         }

         return reList;
      } else {
         return null;
      }
   }

   public List<TCoreDatasystem> query(List<String> flag, PageInfo pageInfo) {
      return flag != null && flag.size() > 0 ? this.tCoreDatasystemDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{Restrictions.in("flag", flag), Restrictions.ne("id", "402882e9608bf3c001608c09a7410042")}) : null;
   }

   public void remove(String id) {
      try {
         String infaHome = System.getenv("INFA_HOME");
         String oracleHome = System.getenv("ORACLE_HOME");
         TCoreDatasystem datasource = (TCoreDatasystem)this.tCoreDatasystemDao.get(id);
         String masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
         if (datasource.getFlag().equals("1")) {
            if (datasource.getConnectmode().equals("0")) {
               String filePath = oracleHome + "/network/admin/tnsnames.ora";
               FileTool.modifyOraFile(true, filePath, datasource);
            } else if (datasource.getConnectmode().equals("1")) {
               String filePath = infaHome + "/ODBC7.1/odbc.ini";
               FileTool.modifyIniFile(true, filePath, datasource, datasource.getDblinkname(), infaHome);
            }

            if (masking_engine_type.equals("0")) {
               InfoExecUtil.deleteDb(infaHome + "/server/bin/pmrep", datasource.getDblinkname());
            }
         }

         if (masking_engine_type.equals("0") && datasource.getFlag().equals("3")) {
            InfoExecUtil.deleteHadoopConn(datasource);
         }
      } catch (Exception var7) {
      }

      this.tCoreDatasystemDao.removeById(id);
   }

   public void save(TCoreConfig tCoreConfig, TCoreDatasystem datasource, String linkname, List<TBaseUser> users, List<TCoreDatasystemoracle> oracleIns) {
      String infaHome = System.getenv("INFA_HOME");
      String oracleHome = System.getenv("ORACLE_HOME");
      if (datasource.getFlag().equals("1")) {
         try {
            if ("0".equals(datasource.getConnectmode())) {
               String filePath = oracleHome + "/network/admin/tnsnames.ora";
               FileTool.modifyOraFile(false, filePath, datasource);
               if (StringTool.emptyOrNull(datasource.getId())) {
                  if ("UTF-8".equals(datasource.getPagecode())) {
                     InfoExecUtil.createDb(infaHome + "/server/bin/pmrep", datasource.getDbtype(), datasource.getUsername(), datasource.getPassword(), datasource.getDblinkname(), datasource.getDbservername(), "UTF-8");
                  } else {
                     InfoExecUtil.createDb(infaHome + "/server/bin/pmrep", datasource.getDbtype(), datasource.getUsername(), datasource.getPassword(), datasource.getDblinkname(), datasource.getDbservername(), "MS936");
                  }
               } else if (datasource.getPagecode().equals("UTF-8")) {
                  InfoExecUtil.updateDb(infaHome + "/server/bin/pmrep", datasource.getDbtype(), datasource.getUsername(), datasource.getPassword(), datasource.getDblinkname(), datasource.getDbservername(), "UTF-8");
               } else {
                  InfoExecUtil.updateDb(infaHome + "/server/bin/pmrep", datasource.getDbtype(), datasource.getUsername(), datasource.getPassword(), datasource.getDblinkname(), datasource.getDbservername(), "MS936");
               }
            } else if ("1".equals(datasource.getConnectmode())) {
               String path = infaHome + "/ODBC7.1/odbc.ini";
               FileTool.modifyIniFile(false, path, datasource, datasource.getDblinkname(), infaHome);
               if (StringTool.emptyOrNull(datasource.getId())) {
                  if ("UTF-8".equals(datasource.getPagecode())) {
                     InfoExecUtil.createDb(infaHome + "/server/bin/pmrep", "ODBC", datasource.getUsername(), datasource.getPassword(), datasource.getDblinkname(), datasource.getDbservername(), "UTF-8");
                  } else {
                     InfoExecUtil.createDb(infaHome + "/server/bin/pmrep", "ODBC", datasource.getUsername(), datasource.getPassword(), datasource.getDblinkname(), datasource.getDbservername(), "MS936");
                  }
               } else if ("UTF-8".equals(datasource.getPagecode())) {
                  InfoExecUtil.updateDb(infaHome + "/server/bin/pmrep", "ODBC", datasource.getUsername(), datasource.getPassword(), datasource.getDblinkname(), datasource.getDbservername(), "UTF-8");
               } else {
                  InfoExecUtil.updateDb(infaHome + "/server/bin/pmrep", "ODBC", datasource.getUsername(), datasource.getPassword(), datasource.getDblinkname(), datasource.getDbservername(), "MS936");
               }
            }

            if ("DB2".equals(datasource.getDbtype())) {
               System.out.println("in DB2 connection");
               String linkName = datasource.getDblinkname();
               if (linkName.length() > 8) {
                  linkName = "a" + linkName.substring(linkName.length() - 7, linkName.length());
               }

               CommandTool.command("db2 uncatalog db " + linkName);
               CommandTool.command("db2 uncatalog node " + linkName);
               CommandTool.command("db2 terminate");
               CommandTool.command("db2 catalog tcpip node " + linkName + " remote " + datasource.getDbip() + " server " + datasource.getDbport());
               CommandTool.command("db2 catalog db " + datasource.getDbservername() + " as " + linkName + " at node " + linkName);
               CommandTool.command("db2 terminate");
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      if (datasource.getFlag().equals("3")) {
         if (!StringTool.emptyOrNull(datasource.getId())) {
            try {
               String masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
               if (masking_engine_type.equals("0")) {
                  InfoExecUtil.deleteHadoopConn(datasource);
               }
            } catch (Exception var11) {
            }
         }

         try {
            String masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
            if (masking_engine_type.equals("0")) {
               InfoExecUtil.createHadoopConn(datasource);
            }
         } catch (Exception var10) {
         }
      }

      datasource.setPassword(AesTool.encrypt(datasource.getPassword(), "ghca"));
      new TConsoleLog();
      if (StringTool.emptyOrNull(datasource.getId())) {
         datasource.setCreatetime(new Date());
         datasource.setInengine("0");
         ddmauditLogger.info(MesUtil.getMsg("DDM_01104", new String[]{CommonUtils.loginUsername(), datasource.getSysname()}));
         this.tCoreDatasystemDao.save(datasource);
         this.saveUsers(users, datasource);
         if ("1".equals(datasource.getOracleisins())) {
            this.saveOracleIns(oracleIns, datasource);
         }

         String tCoreDatasystem = datasource.getId();
      } else {
         datasource.setCreatetime(new Date());
         datasource.setInengine("0");
         ddmauditLogger.info(MesUtil.getMsg("DDM_01103", new String[]{CommonUtils.loginUsername(), datasource.getSysname()}));
         TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", datasource.getId())});
         BeanUtils.copyProperties(datasource, tCoreDatasystem);
         this.tCoreDatasystemDao.saveOrUpdate(tCoreDatasystem);
         this.deleteDataSystemUser(datasource.getId());
         this.saveUsers(users, datasource);
         if ("1".equals(datasource.getOracleisins())) {
            this.deleteOracleIns(datasource.getId());
            this.saveOracleIns(oracleIns, datasource);
         }
      }

   }

   private void saveUsers(List<TBaseUser> userList, TCoreDatasystem datasource) {
      if (!ObjectUtils.isEmpty(userList)) {
         userList.forEach((item) -> {
            TCoreDatasystemuser datasystemuser = new TCoreDatasystemuser();
            datasystemuser.setUserid(item.getId());
            datasystemuser.setDatasystemid(datasource.getId());
            datasystemuser.setFlag("0");
            item.setCreatetime(new Date());
            item.setCreateuser(CommonUtils.loginUsername());
            datasystemuser.setId(StringTool.getTablePrimaryKey());
            this.tCoreDatasystemuserDao.save(datasystemuser);
         });
      }

   }

   public void deleteDataSystemUser(String datasystemid) {
      Criterion croleid = Restrictions.in("datasystemid", new Object[]{datasystemid});
      this.tCoreDatasystemuserDao.remove(new Criterion[]{croleid});
   }

   private void saveOracleIns(List<TCoreDatasystemoracle> oracleInsList, TCoreDatasystem datasource) {
      if (!ObjectUtils.isEmpty(oracleInsList)) {
         oracleInsList.forEach((item) -> {
            item.setDatasystemid(datasource.getId());
            item.setFlag("0");
            item.setCreatetime(new Date());
            item.setCreateuser(CommonUtils.loginUsername());
            item.setId(StringTool.getTablePrimaryKey());
            this.tCoreDatasystemoracleDao.save(item);
         });
      }

   }

   public void deleteOracleIns(String datasystemid) {
      Criterion croleid = Restrictions.in("datasystemid", new Object[]{datasystemid});
      this.tCoreDatasystemoracleDao.remove(new Criterion[]{croleid});
   }

   private Object getHibernateTemplate() {
      return null;
   }

   public List<TCoreDatasystem> queryExcludeId(String excludeId) {
      List<TCoreDatasystem> list = null;
      if (StringTool.emptyOrNull(excludeId)) {
         list = this.tCoreDatasystemDao.queryAll();
      } else {
         list = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.ne("id", excludeId)});
      }

      return list;
   }

   @Async
   public void saveTableStructure(TCoreDatasystem datasource) {
      String datasourceid = datasource.getId();
      Date now = new Date();
      String dbtype = datasource.getDbtype();
      String url = EdbType.getUrlByEdbcode(dbtype, datasource.getDbip(), datasource.getDbport(), datasource.getDbservername());
      String driver = EdbType.getEdbTypeByDbcode(dbtype).getDbdriver();
      Connection conn = JdbcTool.getConnection(driver, url, datasource.getUsername(), "1".equals(datasource.getFlag()) ? AesTool.decrypt(datasource.getPassword(), "ghca") : datasource.getPassword());
      if (conn != null) {
         List<String> schemas = JdbcTool.getDbSchemas(conn);
         if (schemas.size() == 0) {
//            schemas.add(null);
            schemas.add(null);
         }

         for(String schema : schemas) {
            for(String table : JdbcTool.getAllTableName(conn, schema)) {
               TCoreTablestructure t = new TCoreTablestructure();
               t.setTableorcolumnname(table);
               t.setDbschema(schema);
               t.setCreatetime(now);
               this.tCoreTablestructureDao.save(t);
            }
         }

         if (null != conn) {
            try {
               conn.close();
            } catch (SQLException e) {
               e.printStackTrace();
            }
         }

      }
   }

   public TCoreDatasystem queryDataSystemById(String id) {
      return (TCoreDatasystem)this.tCoreDatasystemDao.get(id);
   }

   public TCoreDatasystem queryDataSystemByCode(String code) {
      List<TCoreDatasystem> tCoreDatasystems = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.eq("code", code)});
      return tCoreDatasystems.size() > 0 ? (TCoreDatasystem)tCoreDatasystems.get(0) : null;
   }

   public Connection getConnectionByDataSystemId(String datasystemid) {
      TCoreDatasystem datasystem = this.queryDataSystemById(datasystemid);

      try {
         String dbcode = datasystem.getDbtype();
         if (EdbType.KAFKA.getDbname().equalsIgnoreCase(dbcode)) {
            return null;
         } else {
            String ip = datasystem.getDbip();
            String port = datasystem.getDbport();
            String servername = datasystem.getDbservername();
            String server = datasystem.getServername();
            String url = "";
            String oracleisins = datasystem.getOracleisins();
            if ("1".equals(oracleisins)) {
               dbcode = "ORACLEINS";
               List<TCoreDatasystemoracle> tCoreDatasystemoracles = this.tCoreDatasystemoracleDao.queryInsByDatasnystemId(datasystem.getId());
               ip = ((TCoreDatasystemoracle)tCoreDatasystemoracles.get(0)).getInsip();
               port = ((TCoreDatasystemoracle)tCoreDatasystemoracles.get(0)).getInsport();
               servername = ((TCoreDatasystemoracle)tCoreDatasystemoracles.get(0)).getInsname();
            }

            switch (datasystem.getDbtype()) {
               case "INFORMIX":
                  url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server);
                  break;
               case "TERADATA":
                  url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server, datasystem.getPagecode());
                  break;
               default:
                  String code = EdbType.getEdbTypeByDbname(datasystem.getDbtype()).getDbcode();
                  if (!code.equals(EdbType.GAUSSDB.getDbcode())) {
                     url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername);
                  } else {
                     String[] ips = datasystem.getDbip().split(",");
                     String[] ports = datasystem.getDbport().split(",");
                     List<Map<String, String>> ipports = new ArrayList();

                     for(int i = 0; i < ips.length; ++i) {
                        Map<String, String> map = new HashMap();
                        map.put("ip", ips[i]);
                        map.put("port", ports[i]);
                        ipports.add(map);
                     }

                     url = EdbType.getUrlByEdbcode(dbcode, ipports, servername, servername);
                  }
            }

            String username = datasystem.getUsername();
            String password = AesTool.decrypt(datasystem.getPassword(), "ghca");
            String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
            if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
               System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
               Connection conn = JdbcTool.getKerberosConn(url + ";principal=" + datasystem.getPrincipal(), driver, datasystem.getLoginprincipal(), datasystem.getXmlpath());
               return conn;
            } else if (dbcode.equals("RAPIDSDB")) {
               Connection conn = JdbcTool.getConnection(driver, url, username, "");
               return conn;
            } else {
               Connection conn = JdbcTool.getConnection(driver, url, username, password);
               return conn;
            }
         }
      } catch (Exception var18) {
         return null;
      }
   }

   public Connection getConnection(String datasystemid) throws SQLException, ClassNotFoundException, IOException {
      TCoreDatasystem datasystem = this.queryDataSystemById(datasystemid);
      String dbcode = datasystem.getDbtype();
      String ip = datasystem.getDbip();
      String port = datasystem.getDbport();
      String servername = datasystem.getDbservername();
      String server = datasystem.getServername();
      String url = "";
      String oracleisins = datasystem.getOracleisins();
      if ("1".equals(oracleisins)) {
         dbcode = "ORACLEINS";
         List<TCoreDatasystemoracle> tCoreDatasystemoracles = this.tCoreDatasystemoracleDao.queryInsByDatasnystemId(datasystem.getId());
         ip = ((TCoreDatasystemoracle)tCoreDatasystemoracles.get(0)).getInsip();
         port = ((TCoreDatasystemoracle)tCoreDatasystemoracles.get(0)).getInsport();
         servername = ((TCoreDatasystemoracle)tCoreDatasystemoracles.get(0)).getInsname();
      }

      switch (datasystem.getDbtype()) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server);
            break;
         case "TERADATA":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server, datasystem.getPagecode());
            break;
         default:
            String code = EdbType.getEdbTypeByDbname(datasystem.getDbtype()).getDbcode();
            if (!code.equals(EdbType.GAUSSDB.getDbcode())) {
               url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername);
            } else {
               String[] ips = datasystem.getDbip().split(",");
               String[] ports = datasystem.getDbport().split(",");
               List<Map<String, String>> ipports = new ArrayList();

               for(int i = 0; i < ips.length; ++i) {
                  Map<String, String> map = new HashMap();
                  map.put("ip", ips[i]);
                  map.put("port", ports[i]);
                  ipports.add(map);
               }

               url = EdbType.getUrlByEdbcode(dbcode, ipports, servername, servername);
            }
      }

      String username = datasystem.getUsername();
      String password = AesTool.decrypt(datasystem.getPassword(), "ghca");
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
         Connection conn = JdbcTool.getKerberosConnect(url + ";principal=" + datasystem.getPrincipal(), driver, datasystem.getLoginprincipal(), datasystem.getXmlpath());
         return conn;
      } else if (dbcode.equals("RAPIDSDB")) {
         Connection conn = JdbcTool.getconnection(driver, url, username, "");
         return conn;
      } else {
         Connection conn = JdbcTool.getconnection(driver, url, username, password);
         return conn;
      }
   }

   public TCoreDatasystem queryDataSystemBySysname(String sysname, String flag) {
      if (sysname != null && !"".equals(sysname)) {
         List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.eq("sysname", sysname), Restrictions.eq("flag", flag)});
         return list != null && list.size() > 0 ? (TCoreDatasystem)list.get(0) : null;
      } else {
         return null;
      }
   }

   public TCoreDatasystem queryDataMapSystem(String parentid, String schemaname) {
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("parentid", parentid), Restrictions.eq("dbschema", schemaname), Restrictions.eq("flag", EdataSystem.DATAMAPSYSTEM.getFlag())});
      return datasystem;
   }

   public TCoreDatasystem queryDataSystem(String parentid, String schemaname, String flag) {
      List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.eq("parentid", parentid), Restrictions.eq("dbschema", schemaname), Restrictions.eq("flag", flag)});
      return list != null && list.size() > 0 ? (TCoreDatasystem)list.get(0) : null;
   }

   public TCoreDatasystem getSubDataSystem(String parentid, String schema) {
      List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.eq("parentid", parentid), Restrictions.eq("dbschema", schema), Restrictions.eq("flag", "4")});
      if (list != null && list.size() > 0) {
         return (TCoreDatasystem)list.get(0);
      } else {
         TCoreDatasystem dbsys = (TCoreDatasystem)this.tCoreDatasystemDao.get(parentid);
         TCoreDatasystem newDataSystem = new TCoreDatasystem();

         try {
            ObjectTool.fieldCoty(dbsys, newDataSystem);
         } catch (Exception e) {
            e.printStackTrace();
         }

         newDataSystem.setDbschema(schema);
         newDataSystem.setSysname(dbsys.getSysname() + "(" + schema + ")");
         newDataSystem.setFlag("4");
         newDataSystem.setParentid(parentid);
         this.tCoreDatasystemDao.save(newDataSystem);
         return dbsys;
      }
   }

   public List<ComboboxVO> queryShemas(String dbType, String dataSystemId) {
      List<ComboboxVO> result = new ArrayList();
      TCoreDatasystem datasystem = this.queryDataSystemById(dataSystemId);
      if ("MONGODB".equals(dbType)) {
         String ip = datasystem.getDbip();
         String username = datasystem.getUsername();
         String port = datasystem.getDbport();
         String databaseName = datasystem.getDbservername();
         String passwd = datasystem.getPassword();
         MongoClient connect = null;

         try {
            if (username != null && !"".equals(username)) {
               passwd = !"1".equals(datasystem.getFlag()) && !"4".equals(datasystem.getFlag()) ? datasystem.getPassword() : AesTool.decrypt(datasystem.getPassword(), "ghca");
               connect = MongodbTool.connect(databaseName, username, passwd, ip, Integer.valueOf(port), true);
            } else {
               connect = MongodbTool.connect(databaseName, username, passwd, ip, Integer.getInteger(port), false);
            }

            if (connect != null) {
               List<String> dbname = null;

               for(String schemaname : connect.getDatabaseNames()) {
                  result.add(new ComboboxVO(schemaname));
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else if ("ES".equals(dbType)) {
         EsUtil esUtil = new EsUtil();

         try {
            Object[] indexs = esUtil.queryAllIndex(datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), datasystem.getUsername(), AesTool.decrypt(datasystem.getPassword(), "ghca"));

            for(Object index : indexs) {
               result.add(new ComboboxVO((String)index));
            }

            return result;
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else if ("KAFKA".equals(dbType)) {
         String ip = datasystem.getDbip();
         String port = datasystem.getDbport();
         String bootstrapServers = ip + ":" + port;
         Properties config = new Properties();
         config.put("bootstrap.servers", bootstrapServers);

         try {
            AdminClient adminClient = AdminClient.create(config);
            Throwable var54 = null;

            Object var60;
            try {
               ListTopicsResult topicsResult = adminClient.listTopics();
               KafkaFuture<Set<String>> topicsFuture = topicsResult.names();
               Set<String> topicNames = (Set)topicsFuture.get();
               System.out.println("Topics in the Kafka cluster:");

               for(String topicName : topicNames) {
                  result.add(new ComboboxVO(topicName));
               }

               var60 = result;
            } catch (Throwable var28) {
               var54 = var28;
               throw var28;
            } finally {
               if (adminClient != null) {
                  if (var54 != null) {
                     try {
                        adminClient.close();
                     } catch (Throwable var26) {
                        var54.addSuppressed(var26);
                     }
                  } else {
                     adminClient.close();
                  }
               }

            }

            return (List<ComboboxVO>)var60;
         } catch (ExecutionException | InterruptedException e) {
            ((Exception)e).printStackTrace();
         }
      } else if ("HADOOP".equals(dbType)) {
         ComboboxVO comboboxVO = new ComboboxVO();
         comboboxVO.setId("11");
         comboboxVO.setDbType("HADOOP");
         comboboxVO.setTid("11");
         comboboxVO.setValue("s1");
         comboboxVO.setText("192.168.2.222");
         comboboxVO.setFlag("0");
         ComboboxVO comboboxVO1 = new ComboboxVO();
         comboboxVO1.setId("11");
         comboboxVO1.setDbType("HADOOP");
         comboboxVO1.setTid("11");
         comboboxVO1.setValue("s2");
         comboboxVO1.setText("s2");
         comboboxVO1.setFlag("0");
         result.add(comboboxVO);
         result.add(comboboxVO1);
      } else {
         String defaultSchema = "";
         if (datasystem.getDbtype().equals(EdbType.ORACLE.getDbcode())) {
            defaultSchema = datasystem.getUsername();
         } else {
            defaultSchema = datasystem.getDbservername();
         }

         Connection conn = this.getConnectionByDataSystemId(dataSystemId);
         if (conn != null) {
            List<String> schema = JdbcTool.getDbSchemas(conn);

            try {
               if (conn != null) {
                  conn.close();
               }
            } catch (SQLException e) {
               e.printStackTrace();
            }

            for(String schemaname : schema) {
               ComboboxVO comboboxVO = new ComboboxVO(schemaname);
               if (schemaname.equalsIgnoreCase(defaultSchema)) {
                  comboboxVO.setFlag("1");
               }

               result.add(comboboxVO);
            }
         }
      }

      return result;
   }

   public List<ComboboxVO> querySchema_new(TCoreDatasystem datasystem, Connection conn) {
      String dbType = datasystem.getDbtype();
      List<ComboboxVO> result = new ArrayList();
      if ("MONGODB".equals(dbType)) {
         String ip = datasystem.getDbip();
         String username = datasystem.getUsername();
         String port = datasystem.getDbport();
         String databaseName = datasystem.getDbservername();
         String passwd = datasystem.getPassword();
         MongoClient connect = null;

         try {
            if (username != null && !"".equals(username)) {
               connect = MongodbTool.connect(databaseName, username, passwd, ip, Integer.valueOf(port), true);
            } else {
               connect = MongodbTool.connect(databaseName, username, passwd, ip, Integer.getInteger(port), false);
            }

            if (connect != null) {
               List<String> dbname = null;

               for(String schemaname : connect.getDatabaseNames()) {
                  result.add(new ComboboxVO(schemaname));
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else if ("ES".equals(dbType)) {
         EsUtil esUtil = new EsUtil();

         try {
            for(String index : esUtil.getESSchema(datasystem.getDbip(), datasystem.getDbport())) {
               result.add(new ComboboxVO(index));
            }

            return result;
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else {
         String defaultSchema = "";
         if (datasystem.getDbtype().equals(EdbType.ORACLE.getDbcode())) {
            defaultSchema = datasystem.getUsername();
         } else {
            defaultSchema = datasystem.getDbservername();
         }

         if (conn != null) {
            for(String schemaname : JdbcTool.getDbSchemas(conn)) {
               ComboboxVO comboboxVO = new ComboboxVO(schemaname);
               if (schemaname.equalsIgnoreCase(defaultSchema)) {
                  comboboxVO.setFlag("1");
               }

               result.add(comboboxVO);
            }
         }
      }

      return result;
   }

   public List<ComboboxVO> queryshemas(String dbType, String dataSystemId) throws SQLException, ClassNotFoundException, IOException {
      List<ComboboxVO> result = new ArrayList();
      if ("MONGODB".equals(dbType)) {
         TCoreDatasystem datasystem = this.queryDataSystemById(dataSystemId);
         String ip = datasystem.getDbip();
         String username = datasystem.getUsername();
         String port = datasystem.getDbport();
         String databaseName = datasystem.getDbservername();
         String passwd = datasystem.getPassword();
         MongoClient connect = null;

         try {
            if (username != null && !"".equals(username)) {
               connect = MongodbTool.connect(databaseName, username, passwd, ip, Integer.valueOf(port), true);
            } else {
               connect = MongodbTool.connect(databaseName, username, passwd, ip, Integer.getInteger(port), false);
            }

            if (connect != null) {
               List<String> dbname = null;

               for(String schemaname : connect.getDatabaseNames()) {
                  result.add(new ComboboxVO(schemaname));
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else if ("ES".equals(dbType)) {
         EsUtil esUtil = new EsUtil();

         try {
            TCoreDatasystem datasystem = this.queryDataSystemById(dataSystemId);

            for(String index : esUtil.getESSchema(datasystem.getDbip(), datasystem.getDbport())) {
               result.add(new ComboboxVO(index));
            }

            return result;
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else {
         Connection conn = this.getConnection(dataSystemId);
         if (conn != null) {
            List<String> schema = JdbcTool.getDbSchemas(conn);
            if (conn != null) {
               conn.close();
            }

            for(String schemaname : schema) {
               result.add(new ComboboxVO(schemaname));
            }
         }
      }

      return result;
   }

   public List<TCoreDatasystem> querydatasource() {
      List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.ne("id", "402882e9608bf3c001608c09a7410042"), Restrictions.ne("flag", "4")});
      Object obj = this.request.getSession().getAttribute("loginUser");
      LoginUser loginUser = null;
      if (obj != null) {
         loginUser = (LoginUser)obj;
      }

      List<TBaseUsersys> userSysLst = this.userService.queryusersysbyuserid(loginUser.getTsysUser().getId());
      Map<String, String> sysMap = new HashMap();

      for(TBaseUsersys usrsys : userSysLst) {
         sysMap.put(usrsys.getSysid(), "");
      }

      List<TCoreDatasystem> reList = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         if (sysMap.containsKey(((TCoreDatasystem)list.get(i)).getId())) {
            reList.add(list.get(i));
         }
      }

      return reList;
   }

   public List<TCoreDatasystem> querydatasourceds(String projectId) {
      List<Map<String, String>> list = this.tCoreProjectDatasourceVoDao.queryDatasystemListDataScope(projectId);
      String token = this.request.getHeader("token");
      String userid = this.userDao.queryUserIdByName(TokenUtil.getUserName(token));
      List<TBaseUsersys> userSysLst = this.userService.queryusersysbyuserid(userid);
      Map<String, String> sysMap = new HashMap();

      for(TBaseUsersys usrsys : userSysLst) {
         sysMap.put(usrsys.getSysid(), "");
      }

      List<TCoreDatasystem> reList = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         if (sysMap.containsKey(((Map)list.get(i)).get("id"))) {
            TCoreDatasystem tCoreDatasystem = new TCoreDatasystem();
            tCoreDatasystem.setId((String)((Map)list.get(i)).get("id"));
            tCoreDatasystem.setSysname((String)((Map)list.get(i)).get("sysname"));
            tCoreDatasystem.setDbtype((String)((Map)list.get(i)).get("dbtype"));
            tCoreDatasystem.setPagecode((String)((Map)list.get(i)).get("pagecode"));
            tCoreDatasystem.setDbip((String)((Map)list.get(i)).get("dbip"));
            tCoreDatasystem.setDbport((String)((Map)list.get(i)).get("dbport"));
            tCoreDatasystem.setUsername((String)((Map)list.get(i)).get("username"));
            tCoreDatasystem.setFlag((String)((Map)list.get(i)).get("flag"));
            reList.add(tCoreDatasystem);
         }
      }

      return reList;
   }

   public List<TCoreDatasystem> querydatasourceds(String projectId, String userId) {
      List<Map<String, String>> list = this.tCoreProjectDatasourceVoDao.queryDatasystemListDataScope(projectId);
      List<TBaseUsersys> userSysLst = this.userService.queryusersysbyuserid(userId);
      Map<String, String> sysMap = new HashMap();

      for(TBaseUsersys usrsys : userSysLst) {
         sysMap.put(usrsys.getSysid(), "");
      }

      List<TCoreDatasystem> reList = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         if (sysMap.containsKey(((Map)list.get(i)).get("id"))) {
            TCoreDatasystem tCoreDatasystem = new TCoreDatasystem();
            tCoreDatasystem.setId((String)((Map)list.get(i)).get("id"));
            tCoreDatasystem.setSysname((String)((Map)list.get(i)).get("sysname"));
            tCoreDatasystem.setDbtype((String)((Map)list.get(i)).get("dbtype"));
            tCoreDatasystem.setPagecode((String)((Map)list.get(i)).get("pagecode"));
            tCoreDatasystem.setDbip((String)((Map)list.get(i)).get("dbip"));
            tCoreDatasystem.setDbport((String)((Map)list.get(i)).get("dbport"));
            tCoreDatasystem.setUsername((String)((Map)list.get(i)).get("username"));
            tCoreDatasystem.setFlag((String)((Map)list.get(i)).get("flag"));
            reList.add(tCoreDatasystem);
         }
      }

      return reList;
   }

   public List<Map<String, String>> querydatasource(String projectid, String discoverytype, String userid) {
      List<Map<String, String>> list = this.tCoreProjectDatasourceVoDao.queryDatasourceList(projectid, discoverytype, userid);
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         List<Map<String, String>> newlist = new ArrayList();

         for(Map<String, String> map : list) {
            Map<String, String> newmap = new HashMap();

            for(String key : map.keySet()) {
               newmap.put(key.toLowerCase(Locale.ROOT), map.get(key));
            }

            newlist.add(newmap);
         }

         list = newlist;
      }

      return list;
   }

   public List<TCoreDatasystem> querydataAllsource() {
      List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.ne("id", "402882e9608bf3c001608c09a7410042"), Restrictions.ne("flag", "4")});
      return list;
   }

   public List<DataSystemVO> queryDatasystemCrudByUserid(List<String> userid) {
      return this.tCoreDatasystemDao.queryDatasystemCrudByUserid(userid);
   }

   public List<TreeVO> inittree(String flag) {
      List<TreeVO> tree_datasystem = new ArrayList();

      for(TCoreDatasystem item : this.query(flag)) {
         TreeVO vo = new TreeVO();
         vo.setFlag("DATASYSTEM");
         vo.setId(item.getId());
         vo.setState("closed");
         vo.setText(item.getSysname());
         vo.setIconCls("icon-db");
         tree_datasystem.add(vo);
      }

      for(TreeVO item : tree_datasystem) {
         Connection conn = this.getConnectionByDataSystemId(item.getId());
         List<String> schema = JdbcTool.getDbSchemas(conn);

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         List<TreeVO> tree_schema = new ArrayList();

         for(String schemaname : schema) {
            TreeVO vo_schema = new TreeVO();
            vo_schema.setFlag("SCHEMA");
            vo_schema.setId(PasswordEncryptTool.generatePassword(item.getId() + schemaname));
            vo_schema.setState("closed");
            vo_schema.setText(schemaname);
            vo_schema.setIconCls("icon-folder");
            tree_schema.add(vo_schema);
            conn = this.getConnectionByDataSystemId(item.getId());
            List<String> table = JdbcTool.getAllTableName(conn, schemaname);

            try {
               if (conn != null) {
                  conn.close();
               }
            } catch (SQLException e) {
               e.printStackTrace();
            }

            List<TreeVO> tree_table = new ArrayList();

            for(String tablename : table) {
               TreeVO vo_table = new TreeVO();
               vo_table.setFlag("TABLE");
               vo_table.setId(PasswordEncryptTool.generatePassword(item.getId() + schemaname + tablename));
               vo_table.setState("open");
               vo_table.setText(tablename);
               vo_table.setIconCls("icon-table");
               tree_table.add(vo_table);
            }

            if (tree_table != null && tree_table.size() != 0) {
               vo_schema.setChildren(tree_table);
            } else {
               vo_schema.setState("open");
            }
         }

         item.setChildren(tree_schema);
      }

      for(TreeVO item : tree_datasystem) {
         Iterator<TreeVO> iter = item.getChildren().iterator();

         while(iter.hasNext()) {
            TreeVO s = (TreeVO)iter.next();
            if (s.getState().equals("open")) {
               iter.remove();
            }
         }
      }

      return tree_datasystem;
   }

   public List<TreeVO> initTree(String flag, String code, String text, String parentid, String alias) {
      List<TreeVO> tree_datasystem = new ArrayList();
      if (code != null && code.equals(EdataSystemGrade.DATASYSTEM.getCode())) {
         for(TCoreDatasystem item : this.query(flag)) {
            tree_datasystem.add(new TreeVO(item.getId(), item.getSysname(), "closed", TreeVO.CHECKED_FALSE, EdataSystemGrade.DATASYSTEM.getCode(), "icon-db", (List)null));
         }

         return tree_datasystem;
      } else if (code != null && code.equals(EdataSystemGrade.SCHEMA.getCode())) {
         Connection conn = this.getConnectionByDataSystemId(parentid);
         List<String> schemalist = JdbcTool.getDbSchemas(conn);
         JdbcTool.closeConnection(conn);

         for(String item : schemalist) {
            tree_datasystem.add(new TreeVO(parentid + item, item, "closed", TreeVO.CHECKED_FALSE, EdataSystemGrade.SCHEMA.getCode(), "icon-folder", (List)null));
         }

         return tree_datasystem;
      } else if (code != null && code.equals(EdataSystemGrade.TABLE.getCode())) {
         String datasystemid = parentid.replace(text, "");
         Connection conn = this.getConnectionByDataSystemId(datasystemid);
         List<String> tablelist = JdbcTool.getAllTableName(conn, text);
         JdbcTool.closeConnection(conn);

         for(String item : tablelist) {
            TreeVO tabletree = new TreeVO(parentid + item, item, "open", TreeVO.CHECKED_FALSE, EdataSystemGrade.TABLE.getCode(), "icon-table", (List)null);
            if ("1".equals(alias)) {
               TCoreDatamapTablealias tableAlias = this.tCoreDatamapTablealiasDao.queryDataMapTableAlias(datasystemid, text, item);
               if (tableAlias != null && !"".equals(tableAlias.getTablebyname().trim())) {
                  tabletree.setNodebyname(tableAlias.getTablebyname().trim());
               }
            }

            tree_datasystem.add(tabletree);
         }

         return tree_datasystem;
      } else {
         return null;
      }
   }

   public List<TreeVO> initTreeSchema() {
      List<TreeVO> tree_datasystem = new ArrayList();

      for(TCoreDatasystem item : this.query("0")) {
         tree_datasystem.add(new TreeVO(item.getId(), item.getSysname(), "closed", TreeVO.CHECKED_FALSE, EdataSystemGrade.DATASYSTEM.getCode(), "icon-db", (List)null));
      }

      for(TreeVO item : tree_datasystem) {
         List<TreeVO> tree_schema = new ArrayList();
         Connection conn = this.getConnectionByDataSystemId(item.getId());
         List<String> schemalist = JdbcTool.getDbSchemas(conn);
         JdbcTool.closeConnection(conn);

         for(String schema : schemalist) {
            tree_schema.add(new TreeVO(item.getId() + schema, schema, "open", TreeVO.CHECKED_FALSE, EdataSystemGrade.SCHEMA.getCode(), "icon-folder", (List)null));
         }

         item.setChildren(tree_schema);
      }

      return tree_datasystem;
   }

   public void generateDataSystemTree() {
      for(TCoreDatasystem tdataSystem : this.query("0")) {
         this.addDataSystemTreeBySystemId(tdataSystem.getId());
      }

   }

   public List<TreeVO> queryDataSystemTree() {
      List<TreeVO> tree_datasystem = new ArrayList();
      return tree_datasystem;
   }

   public List<TreeVO> queryDataSystemTreeUser(String userid) {
      return null;
   }

   public void addDataSystemTreeBySystemId(String datasystemid) {
   }

   public void addDataSystemTreeBySystemId(String datasystemid, String schemaname) {
   }

   public void removeDataSystemTreeBySystemId(String datasystemid) {
   }

   public void addTableNodeToDataSystemTree(String datasystemid, String schema, String table) {
   }

   public void synDataSystemTree() {
      for(TCoreDatasystem tdataSystem : this.query("0")) {
         this.synDataSystemTreeDataSystem(tdataSystem.getId());
      }

   }

   public void synDataSystemTreeDataSystem(String datasystemid) {
   }

   public void synDataSystemTreeSchema(String datasystemid, String schemaname) {
   }

   public List<DBTableVO> queryTablename(String datasystemid, String schema) {
      List<DBTableVO> list = new ArrayList();
      TCoreDatasystem datasystem = this.queryDataSystemById(datasystemid);
      if ("MONGODB".equals(datasystem.getDbtype())) {
         String ip = datasystem.getDbip();
         String username = datasystem.getUsername();
         String port = datasystem.getDbport();
         String databaseName = datasystem.getDbservername();
         String passwd = datasystem.getPassword();
         MongoClient connect = null;

         try {
            if (username != null && !"".equals(username)) {
               passwd = !"1".equals(datasystem.getFlag()) && !"4".equals(datasystem.getFlag()) ? datasystem.getPassword() : AesTool.decrypt(datasystem.getPassword(), "ghca");
               connect = MongodbTool.connect(databaseName, username, passwd, ip, Integer.valueOf(port), true);
            } else {
               connect = MongodbTool.connect(databaseName, username, passwd, ip, Integer.getInteger(port), false);
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         if (connect != null) {
            MongoDatabase db = connect.getDatabase(schema);
            if (db != null) {
               MongoCursor var12 = db.listCollectionNames().iterator();

               while(var12.hasNext()) {
                  String str = (String)var12.next();
                  DBTableVO v = new DBTableVO();
                  v.setTablename(str);
                  list.add(v);
               }
            }
         }
      } else if ("ES".equals(datasystem.getDbtype())) {
         EsUtil esUtil = new EsUtil();
         Set<String> types = null;

         for(String t : esUtil.getESType(datasystem, schema)) {
            DBTableVO v = new DBTableVO();
            v.setTablename(t);
            list.add(v);
         }
      } else {
         Connection conn = this.getConnectionByDataSystemId(datasystemid);
         if (conn != null) {
            List<String> tablelist = JdbcTool.getAllTableName(conn, schema);
            JdbcTool.closeConnection(conn);

            for(String str : tablelist) {
               DBTableVO v = new DBTableVO();
               v.setTablename(str);
               list.add(v);
            }
         }
      }

      return list;
   }

   public List<DBTableVO> queryTablename_new(TCoreDatasystem datasystem, String schema, Connection con) {
      List<DBTableVO> list = new ArrayList();
      if ("MONGODB".equals(datasystem.getDbtype())) {
         String ip = datasystem.getDbip();
         String username = datasystem.getUsername();
         String port = datasystem.getDbport();
         String databaseName = datasystem.getDbservername();
         String passwd = datasystem.getPassword();
         MongoClient connect = null;

         try {
            if (username != null && !"".equals(username)) {
               connect = MongodbTool.connect(databaseName, username, passwd, ip, Integer.valueOf(port), true);
            } else {
               connect = MongodbTool.connect(databaseName, username, passwd, ip, Integer.getInteger(port), false);
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         if (connect != null) {
            MongoDatabase db = connect.getDatabase(schema);
            if (db != null) {
               MongoCursor var12 = db.listCollectionNames().iterator();

               while(var12.hasNext()) {
                  String str = (String)var12.next();
                  DBTableVO v = new DBTableVO();
                  v.setTablename(str);
                  list.add(v);
               }
            }
         }
      } else if ("ES".equals(datasystem.getDbtype())) {
         EsUtil esUtil = new EsUtil();
         Set<String> types = null;

         for(String t : esUtil.getESType(datasystem, schema)) {
            DBTableVO v = new DBTableVO();
            v.setTablename(t);
            list.add(v);
         }
      } else if (con != null) {
         for(String str : JdbcTool.getAllTableName(con, schema)) {
            DBTableVO v = new DBTableVO();
            v.setTablename(str);
            list.add(v);
         }
      }

      return list;
   }

   public List<DBTableVO> queryTablename(String datasystemid, String schema, String tableNamePattern) {
      Connection conn = this.getConnectionByDataSystemId(datasystemid);
      List<String> tablelist = JdbcTool.getAllTableNameLike(conn, schema, tableNamePattern);
      JdbcTool.closeConnection(conn);
      List<DBTableVO> list = new ArrayList();

      for(String str : tablelist) {
         DBTableVO v = new DBTableVO();
         v.setTablename(str);
         list.add(v);
      }

      return list;
   }

   public List<String> getAllTableNameList(String mutifile, String dmpFilePath, String dmptype, String tasknamereal) {
      List<String> allTableNameList = new ArrayList();
      if ("0".equals(mutifile)) {
         if ("0".equals(dmptype)) {
            Map<String, Object> tableInfoMap = DmpDpTool.getAllTableinfo(dmpFilePath);
            this.redisService.set(tasknamereal + "_" + "Dmpdp_tableInfoMap_masking", tableInfoMap);
            List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               allTableNameList.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
            }

            return allTableNameList;
         } else {
            Map<String, Object> tableInfoMap = DmpTool.getAllTableinfo(dmpFilePath);
            this.redisService.set(tasknamereal + "_" + "Dmp_tableInfoMap_masking", tableInfoMap);
            List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               allTableNameList.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
            }

            return allTableNameList;
         }
      } else {
         List<String> dmpFileList = new ArrayList();
         String[] mutidmpFilePath = dmpFilePath.split(",");

         for(String string : mutidmpFilePath) {
            dmpFileList.add(string);
         }

         if ("0".equals(dmptype)) {
            Map<String, Object> tableInfoMap = MultipleDmpDpTool.getAllTableinfo(dmpFileList);
            this.redisService.set(tasknamereal + "_" + "multiDmpdp_tableInfoMap_masking", tableInfoMap);
            List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               allTableNameList.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
            }
         } else {
            Map<String, Object> tableInfoMap = MultipleDmpTool.getAllTableinfo(dmpFileList);
            this.redisService.set(tasknamereal + "_" + "multiDmp_tableInfoMap_masking", tableInfoMap);
            List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               allTableNameList.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
            }
         }

         return allTableNameList;
      }
   }

   public List<String> getAllTableNameLists(String mutifile, String dmpFilePath, String dmptype) {
      List<String> allTableNameList = new ArrayList();
      if ("0".equals(mutifile)) {
         if ("0".equals(dmptype)) {
            List<String> tableNameList = DmpDpTool.getAllTableNameList(dmpFilePath);

            for(int i = 0; i < tableNameList.size(); ++i) {
               allTableNameList.add(tableNameList.get(i));
            }

            return allTableNameList;
         } else {
            List<String> tableNameList = DmpTool.getAllTableNameList(dmpFilePath);

            for(int i = 0; i < tableNameList.size(); ++i) {
               allTableNameList.add(tableNameList.get(i));
            }

            return allTableNameList;
         }
      } else {
         List<String> dmpFileList = new ArrayList();
         String[] mutidmpFilePath = dmpFilePath.split(",");

         for(String string : mutidmpFilePath) {
            dmpFileList.add(string);
         }

         if ("0".equals(dmptype)) {
            allTableNameList = MultipleDmpDpTool.getAllTableNameList(dmpFileList);
         } else {
            allTableNameList = MultipleDmpTool.getAllTableNameList(dmpFileList);
         }

         return allTableNameList;
      }
   }

   public Map<String, String> queryTableName(String datasystemid, String schema, String tableNamePattern) {
      Connection conn = this.getConnectionByDataSystemId(datasystemid);
      List<String> tablelist = JdbcTool.getAllTableNameLike(conn, schema, tableNamePattern);
      JdbcTool.closeConnection(conn);
      Map<String, String> map = new HashMap();

      for(String str : tablelist) {
         map.put(str, "0");
      }

      return map;
   }

   public boolean issystemexist(String id) {
      PageInfo page = new PageInfo();
      page.setPagesize(1);
      List<TcoreDiscoverySensitivecolumn> tCoreDatasystem = this.tCoreSensitivecolumnDao.queryByPageInfo(page, new Criterion[]{Restrictions.eq("datasourceid", id)});
      List<TCoreMaskingFilesystem> tCoreMaskingFile = this.tCoreMaskingFilesystemDao.queryByPageInfo(page, new Criterion[]{Restrictions.eq("datasystemid", id)});
      List<TCoreMaskingTable> tCoreMaskingTable = this.tCoreMaskingTableDao.queryByPageInfo(page, new Criterion[]{Restrictions.eq("datasystemid", id)});
      List<TCoreMaskingHive> tCoreMaskingHive = this.tCoreMaskingHiveDao.queryByPageInfo(page, new Criterion[]{Restrictions.eq("datasystemid", id)});
      List<TCoreMaskingselfTable> tCoreMaskingselfTable = this.tCoreMaskingselfTableDao.queryByPageInfo(page, new Criterion[]{Restrictions.eq("datasystemid", id)});
      if (tCoreDatasystem.size() != 0) {
         return false;
      } else if (tCoreMaskingFile.size() != 0) {
         return false;
      } else if (tCoreMaskingTable.size() != 0) {
         return false;
      } else if (tCoreMaskingHive.size() != 0) {
         return false;
      } else {
         return tCoreMaskingselfTable.size() == 0;
      }
   }

   public List<TCoreDatasystem> queryDataSystem(String flag, String istargetdb) {
      String projectid = this.request.getSession().getAttribute("projectid").toString();
      List<Map<String, String>> list = this.tCoreProjectDatasourceVoDao.queryDatasystemList(projectid, flag, istargetdb);
      Object obj = this.request.getSession().getAttribute("loginUser");
      LoginUser loginUser = null;
      if (obj != null) {
         loginUser = (LoginUser)obj;
      }

      List<TBaseUsersys> userSysLst = this.userService.queryusersysbyuserid(loginUser.getTsysUser().getId());
      Map<String, String> sysMap = new HashMap();

      for(TBaseUsersys usrsys : userSysLst) {
         sysMap.put(usrsys.getSysid(), "");
      }

      List<TCoreDatasystem> reList = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         if (sysMap.containsKey(((Map)list.get(i)).get("id"))) {
            TCoreDatasystem tCoreDatasystem = new TCoreDatasystem();
            tCoreDatasystem.setId((String)((Map)list.get(i)).get("id"));
            tCoreDatasystem.setSysname((String)((Map)list.get(i)).get("sysname"));
            tCoreDatasystem.setDbtype((String)((Map)list.get(i)).get("dbtype"));
            tCoreDatasystem.setPagecode((String)((Map)list.get(i)).get("pagecode"));
            tCoreDatasystem.setDbip((String)((Map)list.get(i)).get("dbip"));
            tCoreDatasystem.setDbport((String)((Map)list.get(i)).get("dbport"));
            tCoreDatasystem.setUsername((String)((Map)list.get(i)).get("username"));
            reList.add(tCoreDatasystem);
         }
      }

      return reList;
   }

   public List<TCoreDatasystem> queryDataSystemEM(String flag, String istargetdb) {
      List<Map<String, String>> list = this.tCoreProjectDatasourceVoDao.queryDatasystemListEM(flag, istargetdb);
      List<TCoreDatasystem> reList = new ArrayList();

      for(int i = 0; i < list.size(); ++i) {
         TCoreDatasystem tCoreDatasystem = new TCoreDatasystem();
         tCoreDatasystem.setId((String)((Map)list.get(i)).get("id"));
         tCoreDatasystem.setSysname((String)((Map)list.get(i)).get("sysname"));
         tCoreDatasystem.setDbtype((String)((Map)list.get(i)).get("dbtype"));
         tCoreDatasystem.setPagecode((String)((Map)list.get(i)).get("pagecode"));
         tCoreDatasystem.setDbip((String)((Map)list.get(i)).get("dbip"));
         tCoreDatasystem.setDbport((String)((Map)list.get(i)).get("dbport"));
         tCoreDatasystem.setUsername((String)((Map)list.get(i)).get("username"));
         reList.add(tCoreDatasystem);
      }

      return reList;
   }

   public List<DatasystemProjectdatasourceVO> queryByEditSort(String flag, String dbtype, PageInfo pageInfo) {
      List<DatasystemProjectdatasourceVO> list;
      if ((dbtype == null || dbtype.equals("全部") || "".equals(dbtype)) && "3".equals(flag)) {
         list = this.tCoreDatasystemDao.queryHadoopByFlagAll(pageInfo, flag);
      } else if ((dbtype == null || dbtype.equals("全部") || "".equals(dbtype)) && !"3".equals(flag)) {
         list = this.tCoreDatasystemDao.queryByFlagAll(pageInfo, flag);
      } else if (dbtype.equals("HIVE")) {
         list = this.tCoreDatasystemDao.queryByHive(pageInfo, flag);
      } else if (dbtype.equals("INCEPTOR")) {
         list = this.tCoreDatasystemDao.queryByInceptor(pageInfo, flag);
      } else {
         list = this.tCoreDatasystemDao.queryByEditSort(flag, dbtype, pageInfo);
      }

      return list;
   }

   public List<DatasystemProjectdatasourceVO> queryByCrud(String userid, String groupid, String flag, String dbtype, PageInfo pageInfo) {
      List<DatasystemProjectdatasourceVO> list;
      if ((dbtype == null || dbtype.equals("全部") || "".equals(dbtype)) && "3".equals(flag)) {
         list = this.tCoreDatasystemDao.queryHadoopByFlagAllcrud(userid, groupid, pageInfo, flag);
      } else if ((dbtype == null || dbtype.equals("全部") || "".equals(dbtype)) && !"3".equals(flag)) {
         list = this.tCoreDatasystemDao.queryByFlagAllcrud(userid, groupid, pageInfo, flag);
      } else if (dbtype.equals("HIVE")) {
         list = this.tCoreDatasystemDao.queryByHivecrud(userid, groupid, pageInfo, flag);
      } else if (dbtype.equals("INCEPTOR")) {
         list = this.tCoreDatasystemDao.queryByInceptorcrud(userid, groupid, pageInfo, flag);
      } else {
         list = this.tCoreDatasystemDao.queryByEditSortcrud(userid, groupid, flag, dbtype, pageInfo);
      }

      return list;
   }

   public DataSystemConfig queryByFlagById(String flag, String id) {
      DataSystemConfig dataSystemConfig = new DataSystemConfig();
      List<Map<String, Object>> list = this.tCoreDatasystemDao.queryByaId(id);
      if (list != null && !list.isEmpty()) {
         if (!HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            dataSystemConfig.setSysname((String)((Map)list.get(0)).get("sysname"));
            dataSystemConfig.setDbtype((String)((Map)list.get(0)).get("dbtype"));
            dataSystemConfig.setVersionname((String)((Map)list.get(0)).get("versionname"));
            dataSystemConfig.setPagecode((String)((Map)list.get(0)).get("pagecode"));
            dataSystemConfig.setDbip((String)((Map)list.get(0)).get("dbip"));
            dataSystemConfig.setDbport((String)((Map)list.get(0)).get("dbport"));
            dataSystemConfig.setServername((String)((Map)list.get(0)).get("servername"));
            dataSystemConfig.setDbservername((String)((Map)list.get(0)).get("dbservername"));
            dataSystemConfig.setDblinkname((String)((Map)list.get(0)).get("dblinkname"));
            dataSystemConfig.setUsername((String)((Map)list.get(0)).get("username"));
            dataSystemConfig.setIskerberos((String)((Map)list.get(0)).get("iskerberos"));
            dataSystemConfig.setIstargetdb((String)((Map)list.get(0)).get("istargetdb"));
            dataSystemConfig.setPrincipal((String)((Map)list.get(0)).get("principal"));
            dataSystemConfig.setLoginprincipal((String)((Map)list.get(0)).get("loginprincipal"));
            dataSystemConfig.setKeytab((String)((Map)list.get(0)).get("keytab"));
            dataSystemConfig.setXmlpath((String)((Map)list.get(0)).get("xmlpath"));
            dataSystemConfig.setVersion((String)((Map)list.get(0)).get("version"));
            dataSystemConfig.setCreattime((Date)((Map)list.get(0)).get("createtime"));
            dataSystemConfig.setCreateuser((String)((Map)list.get(0)).get("createuser"));
            dataSystemConfig.setOracleisins((String)((Map)list.get(0)).get("oracleisins"));
            String password1 = AesTool.decrypt((String)((Map)list.get(0)).get("password"), "ghca");
            dataSystemConfig.setPassword(password1);
            dataSystemConfig.setId((String)((Map)list.get(0)).get("id"));
         } else {
            dataSystemConfig.setSysname((String)((Map)list.get(0)).get("sysname".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setDbtype((String)((Map)list.get(0)).get("dbtype".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setVersionname((String)((Map)list.get(0)).get("versionname".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setPagecode((String)((Map)list.get(0)).get("pagecode".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setDbip((String)((Map)list.get(0)).get("dbip".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setDbport((String)((Map)list.get(0)).get("dbport".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setServername((String)((Map)list.get(0)).get("servername".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setDbservername((String)((Map)list.get(0)).get("dbservername".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setDblinkname((String)((Map)list.get(0)).get("dblinkname".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setUsername((String)((Map)list.get(0)).get("username".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setIskerberos((String)((Map)list.get(0)).get("iskerberos".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setIstargetdb((String)((Map)list.get(0)).get("istargetdb".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setPrincipal((String)((Map)list.get(0)).get("principal".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setLoginprincipal((String)((Map)list.get(0)).get("loginprincipal".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setKeytab((String)((Map)list.get(0)).get("keytab".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setXmlpath((String)((Map)list.get(0)).get("xmlpath".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setVersion((String)((Map)list.get(0)).get("version".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setCreattime((Date)((Map)list.get(0)).get("createtime".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setCreateuser((String)((Map)list.get(0)).get("createuser".toUpperCase(Locale.ROOT)));
            dataSystemConfig.setOracleisins((String)((Map)list.get(0)).get("oracleisins".toUpperCase(Locale.ROOT)));
            String password1 = AesTool.decrypt((String)((Map)list.get(0)).get("password".toUpperCase(Locale.ROOT)), "ghca");
            dataSystemConfig.setPassword(password1);
            dataSystemConfig.setId((String)((Map)list.get(0)).get("id".toUpperCase(Locale.ROOT)));
         }
      }

      List<TBaseUser> userList = this.tCoreDatasystemuserDao.queryUsersByDatasystemId(dataSystemConfig.getId());
      dataSystemConfig.setUser(userList);
      if ("1".equals(dataSystemConfig.getOracleisins())) {
         List<TCoreDatasystemoracle> datasystemoracleList = this.tCoreDatasystemoracleDao.queryInsByDatasnystemId(dataSystemConfig.getId());
         dataSystemConfig.setOracleIns(datasystemoracleList);
      }

      return dataSystemConfig;
   }

   public List<DataSourceAndTaskVO> queryDiscoverydate(PageInfo pageInfo, String sourceid) {
      List<DataSourceAndTaskVO> list = this.tCoreDatasystemDao.queryDiscoverydate(pageInfo, sourceid);
      return list;
   }

   public List<DataSourceAndTaskVO> queryDesensitizationtask(PageInfo pageInfo, String sourceid) {
      List<DataSourceAndTaskVO> list = this.tCoreDatasystemDao.queryDesensitizationtask(pageInfo, sourceid);
      return list;
   }

   public List<ComboboxVO> queryByFlag(String flag) {
      List<ComboboxVO> list = new ArrayList();
      List<Map<String, Object>> list1 = this.tCoreDatasystemDao.queryByFlag(flag);
      if (list1 != null && !list1.isEmpty()) {
         for(int i = 0; i < list1.size(); ++i) {
            ComboboxVO combobox = new ComboboxVO();
            String text1 = (String)((Map)list1.get(i)).get("text");
            String value2 = (String)((Map)list1.get(i)).get("value");
            combobox.setText(text1);
            combobox.setValue(value2);
            list.add(combobox);
         }

         ComboboxVO combobox1 = new ComboboxVO();
         combobox1.setText("0");
         combobox1.setValue("全部");
         list.add(combobox1);
         return list;
      } else {
         return null;
      }
   }

   public List<ComboboxVO> queryByFlagHadoop(String flag) {
      List<ComboboxVO> list = new ArrayList();
      ComboboxVO combobox1 = new ComboboxVO();
      combobox1.setText("0");
      combobox1.setValue("全部");
      list.add(combobox1);
      ComboboxVO combobox2 = new ComboboxVO();
      combobox2.setText("1");
      combobox2.setValue("HIVE");
      list.add(combobox2);
      ComboboxVO combobox3 = new ComboboxVO();
      combobox3.setText("2");
      combobox3.setValue("INCEPTOR");
      list.add(combobox3);
      return list;
   }

   public List<ComboboxVO> queryByFlagNosql(String flag) {
      List<ComboboxVO> list = new ArrayList();
      ComboboxVO combobox1 = new ComboboxVO();
      combobox1.setText("0");
      combobox1.setValue("全部");
      list.add(combobox1);
      ComboboxVO combobox2 = new ComboboxVO();
      combobox2.setText("1");
      combobox2.setValue("MONGODB");
      list.add(combobox2);
      return list;
   }

   public List<ComboboxVO> queryByFlagKafka(String flag) {
      List<ComboboxVO> list = new ArrayList();
      ComboboxVO combobox1 = new ComboboxVO();
      combobox1.setText("0");
      combobox1.setValue("全部");
      list.add(combobox1);
      ComboboxVO combobox2 = new ComboboxVO();
      combobox2.setText("1");
      combobox2.setValue("KAFKA");
      list.add(combobox2);
      return list;
   }

   public List<ComboboxVO> getFileSysGroup(String id) {
      List<ComboboxVO> list = this.tCoreFileSysGroupDao.getFileSysGroup(id);
      return list;
   }

   public void saveFileSysGroup(TCoreFileSysGroup obj) {
      this.tCoreFileSysGroupDao.save(obj);
   }

   public void removeFileSysGroup(String id) {
      this.tCoreFileSysGroupDao.remove(new Criterion[]{Restrictions.eq("systemid", id)});
   }

   public List<TCoreDatasystem> getname(String name) {
      List<TCoreDatasystem> namelist = this.tCoreDatasystemDao.getname(name);
      return namelist;
   }

   public List<TBaseUsersys> queryTBaseUsersysByUserid(String userid) {
      return this.tBaseUsersysDao.queryAll(new Criterion[]{Restrictions.eq("userid", userid)});
   }

   public List<String> queryView(String datasystemid, String schema) {
      List<String> list = new ArrayList();
      Connection conn = this.getConnectionByDataSystemId(datasystemid);
      if (conn != null) {
         list = JdbcTool.getAllViewName(conn, schema);
         JdbcTool.closeConnection(conn);
      }

      return list;
   }

   public List<String> querySynonym(String datasystemid, String schema) {
      List<String> list = new ArrayList();
      Connection conn = this.getConnectionByDataSystemId(datasystemid);
      if (conn != null) {
         list = JdbcTool.getAllSynonymName(conn, schema);
         JdbcTool.closeConnection(conn);
      }

      return list;
   }

   public Map<String, Object> getDataView(Map<String, Object> params) {
      Map<String, Object> result = new HashMap();

      try {
         String projectid = params.get("projectid").toString();
         String edition_id = params.get("edition_id").toString();
         String datasystemid = params.get("datasystemid").toString();
         String dbType = params.get("dbType").toString();
         TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
         result.put("sysname", datasystem.getSysname());
         int auth_user_num = 0;
         List<UserJoinFieldInfo> dutyInfoList = this.firstPageDataDao.queryDutyInfoList(projectid, datasystemid, (String)null, (String)null);
         List<String> dutyUserIdList = new ArrayList();

         for(UserJoinFieldInfo userinfo : dutyInfoList) {
            if (userinfo.getJointype().equals("2")) {
               dutyUserIdList.add(userinfo.getJoinid());
            } else {
               for(TBaseUserrole tBaseUserrole : this.tBaseUserroleDao.queryAll(new Criterion[]{Restrictions.eq("roleid", userinfo.getJoinid())})) {
                  dutyUserIdList.add(tBaseUserrole.getUserid());
               }
            }
         }

         dutyUserIdList = (List)dutyUserIdList.stream().distinct().collect(Collectors.toList());
         result.put("authorizationNum", dutyUserIdList.size());
         int tableNum = 0;
         int filedNum = 0;

         for(TCoreDatasourceSchema schema : this.firstPageDataDao.querySchemasByProjectId(projectid, datasystemid)) {
            List<TCoreDatasystem> systemList = this.firstPageDataDao.getDataSourceDetail(schema.getOsdsid());
            Connection connection = JdbcTool.getConnection((TCoreDatasystem)systemList.get(0));
            tableNum = (int)((double)tableNum + QueryBloodTool.getTabelNum((TCoreDatasystem)systemList.get(0), connection, schema.getSchemaname(), schema.getDbtype()));
            filedNum = (int)((double)filedNum + QueryBloodTool.getColumnNum((TCoreDatasystem)systemList.get(0), connection, schema.getSchemaname(), schema.getDbtype()));
         }

         result.put("tableNum", tableNum);
         result.put("filedNum", filedNum);
         char maxOpenLevel = this.sensitiveLevelService.getMaxOpenLevel(edition_id);
         char insertOpenLevel = 'A';
         if (!String.valueOf(maxOpenLevel).isEmpty()) {
            insertOpenLevel = maxOpenLevel;
         }

         Map<String, Object> map = new HashMap();
         map.put("dataall[datasystemname]", datasystemid);
         map.put("dataall[setuptype]", "2");
         map.put("dataall[editionid]", edition_id);
         map.put("open_level", insertOpenLevel + "");
         this.fieldReportFormService.getfieldreportform(map, new ArrayList());
         List<TCoreFieldSensitive> sensitiveFiledList = this.firstPageDataDao.querySensitiveFiledList(projectid, datasystemid);
         result.put("sensitiveNum", sensitiveFiledList.size());
         map.put("dataall[setuptype]", "0");
         List<FieldReportFormVO> var31 = this.fieldReportFormService.getfieldreportform(map, new ArrayList());
         result.put("classifyNum", var31.size());
         List<Map<String, Object>> busiDutyList = this.firstPageDataDao.queryDatasourceDuty(projectid, "1", datasystemid);
         List<Map<String, Object>> techDutyList = this.firstPageDataDao.queryDatasourceDuty(projectid, "2", datasystemid);
         result.put("busiDutyList", busiDutyList.stream().distinct().collect(Collectors.toList()));
         result.put("techDutyList", techDutyList.stream().distinct().collect(Collectors.toList()));
      } catch (Exception e) {
         e.printStackTrace();
      }

      return result;
   }

   public Map<String, Object> getHomePage(Map<String, Object> map) {
      List<DataBase> dataList = DataCache.dataList;
      Map<String, Object> result = new HashMap();
      Object projectid = map.get("projectid");
      List<TCoreDataProject> projectList = null;
      if (projectid != null) {
         projectList = this.tCoreDataProjectDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("id", projectid.toString()), Restrictions.like("project", "", MatchMode.ANYWHERE), Restrictions.like("note", "", MatchMode.ANYWHERE)});
      } else {
         projectList = this.tCoreDataProjectDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.like("project", "", MatchMode.ANYWHERE), Restrictions.like("note", "", MatchMode.ANYWHERE)});
      }

      String username = TokenUtil.getUserName(this.request.getHeader("token"));
      TBaseUser tBaseUser = this.tBaseUserDao.queryByusername(username);
      if (!"1".equals(tBaseUser.getId())) {
         List<TBaseUserproject> baseUserProjectList = this.tBaseUserprojectDao.queryAll(new Criterion[]{Restrictions.eq("userid", tBaseUser.getId())});
         projectList = (List)projectList.stream().filter((ex) -> {
            boolean filter = false;

            for(TBaseUserproject tBaseUserproject : baseUserProjectList) {
               if (tBaseUserproject.getProid().equals(ex.getId())) {
                  filter = true;
                  break;
               }
            }

            return filter;
         }).collect(Collectors.toList());
         List<DataBase> newDataList = new ArrayList();

         for(DataBase dataBase : dataList) {
            for(TBaseUser user : this.tCoreDatasystemuserDao.queryUsersByDatasystemId(dataBase.getDatasystemid())) {
               if (user.getId().equals(tBaseUser.getId())) {
                  newDataList.add(dataBase);
               }
            }
         }

         dataList = newDataList;
      }

      result.put("projectNum", projectList.size());
      int dataBaseNum = 0;
      int tableNum = 0;
      int fieldNum = 0;
      List<TCoreProjectFindrule> dataFieldList = new ArrayList();
      List<Map<String, Object>> busiDutyList = new ArrayList();
      List<Map<String, Object>> techDutyList = new ArrayList();
      List<FieldReportFormVO> sensitiveField = new ArrayList();
      List<TCoreProjectDatasource> dataSystemList = new ArrayList();
      Set<String> sensitiveTable = new HashSet();
      List<String> projectidList = new ArrayList();

      for(TCoreDataProject project : projectList) {
         projectidList.add("'" + project.getId() + "'");
         List<TCoreProjectDatasource> dataSourceIdList = this.tCoreProjectDatasourceDao.queryAll(new Criterion[]{Restrictions.eq("project_id", project.getId()), Restrictions.eq("systemstyle", "1")});
         dataSystemList.addAll(dataSourceIdList);
         dataBaseNum += dataSourceIdList.size();

         for(TCoreProjectDatasource datasource : dataSourceIdList) {
            busiDutyList.addAll(this.firstPageDataDao.queryDatasourceDuty(project.getId(), "1", datasource.getSystemsource_id()));
            techDutyList.addAll(this.firstPageDataDao.queryDatasourceDuty(project.getId(), "2", datasource.getSystemsource_id()));
            Map<String, Object> param = new HashMap();
            param.put("dataall[datasystemname]", datasource.getSystemsource_id());
            param.put("dataall[setuptype]", "2");
            param.put("dataall[editionid]", project.getEdition_id());
            param.put("open_level", "A");
            List<FieldReportFormVO> filedList = this.fieldReportFormService.getfieldreportform(param, new ArrayList());
            sensitiveField.addAll(filedList);

            for(FieldReportFormVO fieldReportFormVO : filedList) {
               sensitiveTable.add(fieldReportFormVO.getNames());
            }

            for(DataBase dataBase : dataList) {
               if (dataBase != null && datasource.getSystemsource_id().equals(dataBase.getDatasystemid())) {
                  List<Schema> schemaList = dataBase.getSchemaList();
                  if (schemaList != null) {
                     List<TCoreDatasourceSchema> projectSchemaList = this.querySchemas(project.getId(), dataBase.getDatasystemid());
                     Map<String, String> projectSchemasMap = new HashMap();
                     if (null != projectSchemaList && projectSchemaList.size() > 0) {
                        for(TCoreDatasourceSchema projectSchema : projectSchemaList) {
                           projectSchemasMap.put(projectSchema.getSchemaname(), projectSchema.getSchemaid());
                        }
                     }

                     for(Schema schema : schemaList) {
                        if (projectSchemasMap.containsKey(schema.getName())) {
                           List<Table> tableList = schema.getTableList();
                           tableNum += tableList.size();

                           for(Table table : tableList) {
                              List<Column> columnList = table.getColumnList();
                              if (columnList != null) {
                                 fieldNum += columnList.size();
                              }
                           }
                        }
                     }
                  }
               }
            }
         }

         List<TCoreProjectFindrule> areaAndRuleList = this.tCoreProjectFindruleDao.queryAll(new Criterion[]{Restrictions.eq("project_id", project.getId())});
         dataFieldList.addAll(areaAndRuleList);
      }

      if (projectid == null) {
         tableNum = 0;
         fieldNum = 0;

         for(DataBase dataBase : dataList) {
            if (dataBase != null) {
               List<Schema> schemaList = dataBase.getSchemaList();
               if (schemaList != null) {
                  for(Schema schema : schemaList) {
                     List<Table> tableList = schema.getTableList();
                     tableNum += tableList.size();

                     for(Table table : tableList) {
                        List<Column> columnList = table.getColumnList();
                        if (columnList != null) {
                           fieldNum += columnList.size();
                        }
                     }
                  }
               }
            }
         }
      }

      if (projectid == null) {
         result.put("dataBaseNum", dataList.size());
      } else {
         result.put("dataBaseNum", dataSystemList.size());
      }

      dataFieldList = (List)dataFieldList.stream().filter(distinctByKey((b) -> b.getDataarea_id())).collect(Collectors.toList());
      busiDutyList.addAll(techDutyList);
      busiDutyList = (List)busiDutyList.stream().distinct().collect(Collectors.toList());
      sensitiveField = (List)sensitiveField.stream().distinct().collect(Collectors.toList());
      result.put("tableNum", tableNum);
      result.put("fieldNum", fieldNum);
      result.put("dataFieldNum", dataFieldList.size());
      int encryptTableCount = 0;
      int encryptColumnCount = 0;
      String projectidStr = (String)projectidList.stream().collect(Collectors.joining(","));
      Object s = this.tCoreEncryptionTypeFieldDao.queryTotalEncrypTableCount(projectidStr);
      Object o = this.tCoreEncryptionTypeFieldDao.queryTotalEncrypColumnCount(projectidStr);
      if (s != null) {
         encryptTableCount = Integer.parseInt(s.toString());
      }

      if (o != null) {
         encryptColumnCount = Integer.parseInt(o.toString());
      }

      result.put("encryptTableCount", encryptTableCount);
      result.put("encryptColumnCount", encryptColumnCount);
      OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
      boolean isWin = System.getProperty("os.name").toLowerCase().contains("win");
      boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0;
      double cpuLoad = osmxb.getSystemCpuLoad();
      int percentCpuLoad = (int)(cpuLoad * (double)100.0F);
      int cpuCount = Runtime.getRuntime().availableProcessors();
      double totalvirtualMemory = (double)osmxb.getTotalPhysicalMemorySize();
      BigDecimal totalvirtualMemorys = (new BigDecimal(totalvirtualMemory)).divide(BigDecimal.valueOf(1073741824L), 0, 5);
      int percentMemoryLoad = 0;
      if (isWin) {
         double freePhysicalMemorySize = (double)osmxb.getFreePhysicalMemorySize();
         double value = freePhysicalMemorySize / totalvirtualMemory;
         percentMemoryLoad = (int)(((double)1.0F - value) * (double)100.0F);
      } else {
         percentMemoryLoad = getMemeoryUsage();
      }

      result.put("cpuCount", cpuCount);
      result.put("percentCpuLoad", percentCpuLoad);
      result.put("totalvirtualMemory", totalvirtualMemorys);
      result.put("percentMemoryLoad", percentMemoryLoad);
      if (isLinux) {
         try {
            result = this.getDeskUsage(result);
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      if (isWin) {
         List<Map<String, Object>> resultList = new ArrayList();
         File[] roots = File.listRoots();

         for(File file : roots) {
            Map<String, Object> space = new HashMap();
            System.out.println(file.getPath());
            BigDecimal freespace = (new BigDecimal(file.getFreeSpace())).divide(BigDecimal.valueOf(1073741824L), 0, 5);
            BigDecimal totalspace = (new BigDecimal(file.getTotalSpace())).divide(BigDecimal.valueOf(1073741824L), 0, 5);
            BigDecimal usedpace = totalspace.subtract(freespace);
            space.put("path", file.getPath());
            space.put("freespace", freespace);
            space.put("usedpace", usedpace);
            resultList.add(space);
         }

         result.put("space", resultList);
      }

      return result;
   }

   public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
      Map<Object, Boolean> seen = new ConcurrentHashMap();
      return (t) -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
   }

   public int getMemeoryUsage11() {
      Runtime rt = Runtime.getRuntime();
      int meo = 0;
      BufferedReader in = null;

      try {
         int pid = Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
         String[] cmd = new String[]{"/bin/sh", "-c", "top -b -n 1 | grep " + pid};
         Process p = rt.exec(cmd);
         in = new BufferedReader(new InputStreamReader(p.getInputStream()));
         String str = in.readLine();
         String[] strArray = str.split(" ");
         int m = 0;

         for(String s : strArray) {
            if (s.trim().length() != 0) {
               if (m == 9) {
                  meo = Double.valueOf(s).intValue();
                  break;
               }

               ++m;
            }
         }
      } catch (IOException e) {
         e.printStackTrace();
      } finally {
         try {
            in.close();
         } catch (IOException e) {
            e.printStackTrace();
         }

      }

      return meo;
   }

   public static int getMemeoryUsage() {
      int meo = 0;
      Runtime rt = Runtime.getRuntime();
      BufferedReader in = null;

      try {
         try {
            Process p = rt.exec("cat /proc/meminfo");
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String str = null;
            int i = 0;
            int total = 0;

            for(int last = 0; (str = in.readLine()) != null; ++i) {
               new HashMap();
               if (i == 0) {
                  System.out.println("内存总大小----------" + str);
                  String[] strArr = str.split(":");
                  String totalStr = strArr[1];
                  totalStr = totalStr.replaceAll("(?i)kb", "").trim();
                  total = Integer.valueOf(totalStr);
               }

               if (i == 1) {
                  System.out.println("内存剩余大小----------" + str);
                  String[] strArr = str.split(":");
                  String lastStr = strArr[1];
                  lastStr = lastStr.replaceAll("(?i)kb", "").trim();
                  last = Integer.valueOf(lastStr);
                  DecimalFormat df = new DecimalFormat("0");
                  String value1 = df.format((double)((float)(total - last) / (float)total * 100.0F));
                  meo = Integer.valueOf(value1);
                  System.out.println("内存使用率----------" + meo + "%");
                  break;
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         return meo;
      } finally {
         ;
      }
   }

   public Map<String, Object> getDeskUsage11(Map<String, Object> resultMap) throws Exception {
      Runtime rt = Runtime.getRuntime();
      Process p = rt.exec("df -h");
      BufferedReader in = null;

      try {
         in = new BufferedReader(new InputStreamReader(p.getInputStream()));
         String str = null;
         String[] strArray = null;
         List<Map<String, Object>> resultList = new ArrayList();
         int i = 0;

         while((str = in.readLine()) != null) {
            double totalHD = (double)0.0F;
            double usedHD = (double)0.0F;
            Map<String, Object> map = new HashMap();
            if (str.indexOf("Size") == -1 || i++ != 0) {
               System.out.println("磁盘情况第" + (i + 1) + "str个字符串----------" + str);
               strArray = str.split(" ");
               System.out.println("磁盘情况第" + (i + 1) + "strArray个数组----------" + strArray);
               String[] ssStrinsStrings = new String[6];
               System.out.println("磁盘情况第" + (i + 1) + "ssStrinsStrings个字符串----------" + str);
               int iiii = 0;

               for(int i1 = 0; i1 < strArray.length; ++i1) {
                  if (!strArray[i1].toString().equals("")) {
                     ssStrinsStrings[iiii] = strArray[i1];
                     ++iiii;
                  }
               }

               DecimalFormat df = new DecimalFormat("######0.00");
               String str1 = ssStrinsStrings[1].trim();
               String str2 = ssStrinsStrings[2].trim();
               if (!str1.equals("0")) {
                  totalHD = Double.parseDouble(str1.substring(0, str1.length() - 1));
                  if (str1.indexOf("M") != -1) {
                     String totasdasdsasslHD = df.format(totalHD / (double)1024.0F);
                     totalHD = Double.parseDouble(totasdasdsasslHD);
                  }
               }

               if (!str2.equals("0")) {
                  usedHD = Double.parseDouble(str2.substring(0, str2.length() - 1));
                  if (str2.indexOf("M") != -1) {
                     String totasdasdsasslHD = df.format(usedHD / (double)1024.0F);
                     usedHD = Double.parseDouble(totasdasdsasslHD);
                  }
               }

               map.put("freespace", totalHD - usedHD);
               map.put("usedpace", usedHD);
               map.put("path", ssStrinsStrings[5].trim());
               resultList.add(map);
               ++i;
            }
         }

         resultMap.put("space", resultList);
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         in.close();
      }

      return resultMap;
   }

   public Map<String, Object> getDeskUsage(Map<String, Object> resultMap) throws Exception {
      Runtime rt = Runtime.getRuntime();
      Process p = rt.exec("df -h");
      BufferedReader in = null;

      try {
         in = new BufferedReader(new InputStreamReader(p.getInputStream()));
         String str = null;
         String[] strArray = null;
         List<Map<String, Object>> resultList = new ArrayList();
         int i = 0;
         boolean firstLine = true;

         while((str = in.readLine()) != null) {
            Map<String, Object> map = new HashMap();
            if (firstLine) {
               firstLine = false;
            } else {
               System.out.println("磁盘情况第" + (i + 1) + "str个字符串----------" + str);
               strArray = str.split(" ");
               System.out.println("磁盘情况第" + (i + 1) + "strArray个数组----------" + strArray);
               String[] ssStrinsStrings = new String[6];
               System.out.println("磁盘情况第" + (i + 1) + "ssStrinsStrings个字符串----------" + str);
               int iiii = 0;

               for(int i1 = 0; i1 < strArray.length; ++i1) {
                  if (!strArray[i1].toString().equals("")) {
                     ssStrinsStrings[iiii] = strArray[i1];
                     ++iiii;
                  }
               }

               double totalHD = (double)0.0F;
               double usedHD = (double)0.0F;
               DecimalFormat df = new DecimalFormat("######0.00");
               String str1 = ssStrinsStrings[1].trim();
               String str2 = ssStrinsStrings[2].trim();
               if (!str1.equals("0")) {
                  totalHD = Double.parseDouble(str1.substring(0, str1.length() - 1));
                  if (str1.indexOf("M") != -1) {
                     String totasdasdsasslHD = df.format(totalHD / (double)1024.0F);
                     totalHD = Double.parseDouble(totasdasdsasslHD);
                  }
               }

               if (!str2.equals("0")) {
                  usedHD = Double.parseDouble(str2.substring(0, str2.length() - 1));
                  if (str2.indexOf("M") != -1) {
                     String totasdasdsasslHD = df.format(usedHD / (double)1024.0F);
                     usedHD = Double.parseDouble(totasdasdsasslHD);
                  }
               }

               map.put("freespace", totalHD - usedHD);
               map.put("usedpace", usedHD);
               map.put("path", ssStrinsStrings[5].trim());
               resultList.add(map);
            }
         }

         resultMap.put("space", resultList);
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         in.close();
      }

      return resultMap;
   }

   public List<ColumnInfoVO> queryColumnInfo(String datasystemid, String schema, String tableName) {
      Connection conn = this.getConnectionByDataSystemId(datasystemid);
      List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tableName);

      try {
         if (conn != null) {
            conn.close();
         }
      } catch (SQLException e) {
         e.printStackTrace();
      }

      return list;
   }

   public List<ColumnInfoVO> queryColumnInfo_new(Connection conn, String schema, String tableName) {
      List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tableName);
      return list;
   }

   public List<ComboboxVO> getSchemaList(String projectid, String dataSystemId) {
      List<ComboboxVO> result = new ArrayList();
      List<String> list = new ArrayList();
      List<Map<String, String>> schemas = this.tCoreDatasystemDao.getSchemaList(projectid, dataSystemId);

      for(int i = 0; i < schemas.size(); ++i) {
         String schemaname;
         if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            schemaname = (String)((Map)schemas.get(i)).get("SCHEMANAME");
         } else {
            schemaname = (String)((Map)schemas.get(i)).get("schemaname");
         }

         list.add(schemaname);
      }

      for(String schemaname : list) {
         result.add(new ComboboxVO(schemaname));
      }

      return result;
   }

   public List<TCoreDatasourceSchema> querySchemas(String projectid, String dataSystemId) {
      List<TCoreDatasourceSchema> schemaL = this.tCoreDataSourceSchemaDao.queryAll(new Criterion[]{Restrictions.eq("osdsid", dataSystemId), Restrictions.eq("projectid", projectid)});
      return schemaL;
   }

   public boolean checkUsedByProject(String datasystemid) {
      List<TCoreProjectDatasource> datasourcesInfo = this.tCoreProjectDatasourceDao.queryAll(new Criterion[]{Restrictions.eq("systemsource_id", datasystemid)});
      return !datasourcesInfo.isEmpty();
   }

public boolean checkUsedByProject(String datasystemid, String projectId) {
   List<Criterion> criteria = new ArrayList<>();
   criteria.add(Restrictions.eq("systemsource_id", datasystemid));
   if (projectId != null && !projectId.isEmpty()) {
      criteria.add(Restrictions.ne("project_id", projectId));
   }
   List<TCoreProjectDatasource> datasourcesInfo = this.tCoreProjectDatasourceDao.queryAll(criteria.toArray(new Criterion[0]));
   return !datasourcesInfo.isEmpty();
}

   public int checkRepeatName(String sysname, String datasystemid) {
      new ArrayList();
      List list;
      if (StringUtils.isBlank(datasystemid)) {
         list = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.eq("sysname", sysname)});
      } else {
         list = this.tCoreDatasystemDao.queryAll(new Criterion[]{Restrictions.eq("sysname", sysname), Restrictions.ne("id", datasystemid)});
      }

      return list.size();
   }

   public static void main(String[] args) {
      getMemeoryUsage();
   }

   public List<TCoreFileSysGroup> queryByGroupid(String groupid) {
      return this.tCoreFileSysGroupDao.queryAll(new Criterion[]{Restrictions.eq("filegroupid", groupid)});
   }
}
