package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationAlgorithmDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationAlgorithmTypeDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationAlgorithm;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationAlgorithmType;
import com.chenyang.nse.bussiness.service.core.DesensitizationAlgorithmService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DesensitizationAlgorithmServiceImpl implements DesensitizationAlgorithmService {
   @Autowired
   private DesensitizationAlgorithmTypeDao desensitizationAlgorithmTypeDao;
   @Autowired
   private DesensitizationAlgorithmDao desensitizationAlgorithmDao;

   public List<DesensitizationAlgorithmType> queryTypeAll() {
      return this.desensitizationAlgorithmTypeDao.queryAll();
   }

   public List<DesensitizationAlgorithm> queryInfoById(String typeid) {
      return this.desensitizationAlgorithmDao.queryAll(new Criterion[]{Restrictions.eq("algorithmtypeid", typeid)});
   }

   public List<DesensitizationAlgorithm> queryAll() {
      return this.desensitizationAlgorithmDao.queryAll();
   }

   public DesensitizationAlgorithm queryInfoByName(String name) {
      return (DesensitizationAlgorithm)this.desensitizationAlgorithmDao.queryUnique(new Criterion[]{Restrictions.eq("name", name)});
   }
}
