package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.console.TConsoleDictionaryDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDictionarytypeDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.vo.DictionartFileVO;
import com.chenyang.nse.bussiness.entity.vo.ReadExcel;
import com.chenyang.nse.bussiness.service.core.DictionartFileService;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DictionartFileServiceImpl implements DictionartFileService {
   @Autowired
   private TConsoleDictionaryDao tConsoleDictionaryDao;
   @Autowired
   private TConsoleDictionarytypeDao tConsoleDictionarytypeDao;

   public List<DictionartFileVO> queryDictionaryFile(String typecode) {
      List<DictionartFileVO> fileList = new ArrayList();
      List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryDictionaryFile(typecode);
      if (list != null && !list.isEmpty()) {
         for(int i = 0; i < list.size(); ++i) {
            DictionartFileVO dictionartFileVO = new DictionartFileVO();
            String dictionaryTypeName = ((TConsoleDictionary)list.get(i)).getTypename();
            dictionartFileVO.setDictionaryTypeName(dictionaryTypeName);
            String dictionaryTypeId = ((TConsoleDictionary)list.get(i)).getTypecode();
            dictionartFileVO.setDictionaryTypeId(dictionaryTypeId);
            String dictionaryValue = ((TConsoleDictionary)list.get(i)).getValue();
            dictionartFileVO.setDictionaryValue(dictionaryValue);
            String dictionaryName = ((TConsoleDictionary)list.get(i)).getName();
            dictionartFileVO.setDictionaryName(dictionaryName);
            String parentName = ((TConsoleDictionary)list.get(i)).getParentid();
            dictionartFileVO.setParentName(parentName);
            fileList.add(dictionartFileVO);
         }
      }

      return fileList;
   }

   public String readExcelFile(MultipartFile file) {
      String result = "";
      ReadExcel readExcel = new ReadExcel();
      List<TConsoleDictionary> fileList = readExcel.getExcelInfo(file);
      if (fileList != null && fileList.isEmpty()) {
         result = "上传成功";
      } else {
         result = "上传失败";
      }

      return result;
   }

   @Transactional
   public void saveTableData(List<TConsoleDictionary> list1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      new TConsoleDictionary();
      StringBuilder sb = new StringBuilder();
      List<String> list_table = JdbcTool.sql_insert_q(new TConsoleDictionary());
      list_table.add("id");
      String sb_sql_table = JdbcTool.sql_insert_z(list_table, "T_CONSOLE_DICTIONARY");
      sb.append(sb_sql_table);

      for(TConsoleDictionary v : list1) {
         v.setId(UUID.randomUUID().toString().replace("-", ""));
         String value = JdbcTool.sql_insert_h(v, list_table);
         sb.append(value);
      }

      this.tConsoleDictionaryDao.savetCoreDicField(sb.deleteCharAt(sb.length() - 1));
   }

   public void delTableData() {
   }

   @Transactional
   public void empty1(String smart, String typecode) {
      System.out.println(smart);
      if (smart.equals("1")) {
         this.tConsoleDictionaryDao.deleteByTypecode(typecode);
      }

   }
}
