package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleFastManageDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleFastManage;
import com.chenyang.nse.bussiness.service.core.TFastManageService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TFastManageServiceImpl implements TFastManageService {
   @Autowired
   private TConsoleFastManageDao tConsoleFastManageDao;

   public List<TConsoleFastManage> query(PageInfo pageInfo) {
      pageInfo.setCount(this.tConsoleFastManageDao.count());
      List<TConsoleFastManage> list = this.tConsoleFastManageDao.queryByPageDesc(pageInfo);
      return list;
   }

   public void save(TConsoleFastManage tConsoleFastManage) {
      this.tConsoleFastManageDao.save(tConsoleFastManage);
   }

   public void update(TConsoleFastManage tConsoleFastManage, String date1) {
      this.tConsoleFastManageDao.updatefast(tConsoleFastManage, date1);
   }

   public void remove(String id) {
      this.tConsoleFastManageDao.removeById(id);
   }

   public List<TConsoleFastManage> getdatatypebyid(String id) {
      return this.tConsoleFastManageDao.queryAll(new Criterion[]{Restrictions.eq("id", id)});
   }

   public List<TConsoleFastManage> getdatatypebyname(String name) {
      return this.tConsoleFastManageDao.queryAll(new Criterion[]{Restrictions.eq("databasetype", name)});
   }
}
