package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSearchregexDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataAreaDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDiscoverySysdataDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TdataDiscoveryDataResultDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TdataDiscoveryResultDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleinfoDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDiscoverySysdata;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectAllrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryDataResult;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryResult;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.vo.DiscoveryResultVO;
import com.chenyang.nse.bussiness.service.core.TdataDiscoveryResultService;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.sql.SqlFileTool;
import com.chenyang.nse.bussiness.tools.xml.TxtTool;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TdataDiscoveryResultServiceImpl implements TdataDiscoveryResultService {
   @Autowired
   private TdataDiscoveryDataResultDao tdataDiscoveryDataResultDao;
   @Autowired
   private TdataDiscoveryResultDao tdataDiscoveryResultDao;
   @Autowired
   private TCoreDiscoverySysdataDao tCoreDiscoverySysdataDao;
   @Autowired
   private TCoreDataAreaDao tCoreDataAreaDao;
   @Autowired
   private TConsoleSearchregexDao tConsoleSearchregexDao;
   @Autowired
   private TCoreMaskingRuleinfoDao tCoreMaskingRuleinfoDao;

   public TcoreDiscoveryDataResult getDiscoverResultReport(String tablename) {
      TcoreDiscoveryDataResult vo = (TcoreDiscoveryDataResult)this.tdataDiscoveryDataResultDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", tablename)});
      return vo;
   }

   public void discoverChangeRuleAll(DiscoveryResultVO obj) {
      this.tdataDiscoveryResultDao.discoverChangeRuleAll(obj);
   }

   public void discoverChangeRule(DiscoveryResultVO obj, String id) {
      this.tdataDiscoveryResultDao.discoverChangeRule(obj, id);
   }

   public List<TCoreDiscoverySysdata> discoverResultTable(DiscoveryResultVO obj) {
      List<TCoreDiscoverySysdata> list = this.tdataDiscoveryResultDao.discoverResultTable(obj);
      return list;
   }

   public void makeDiscoverResultSureAll(DiscoveryResultVO obj) {
      this.tdataDiscoveryResultDao.makeDiscoverResultSureAll(obj);
   }

   public void makeDiscoverResultSure(DiscoveryResultVO obj, String id) {
      this.tdataDiscoveryResultDao.makeDiscoverResultSure(obj, id);
   }

   public List<TCoreProjectAllrule> selectDataAreaHas(String project_id) {
      List<TCoreProjectAllrule> list = this.tdataDiscoveryResultDao.selectDataAreaHas(project_id);
      return list;
   }

   public List<TCoreProjectAllrule> selectDataAreaFindRule(String project_id, String dataarea_id) {
      List<TCoreProjectAllrule> list = this.tdataDiscoveryResultDao.selectDataAreaFindRule(project_id, dataarea_id);
      return list;
   }

   public List<TCoreProjectAllrule> getRuledis(String project_id, String dataarea_id) {
      List<TCoreProjectAllrule> list = this.tdataDiscoveryResultDao.selectDataAreaHas(project_id, dataarea_id);
      return list;
   }

   public List<TcoreDiscoveryResult> getResultTableInfo(DiscoveryResultVO obj) {
      List<TcoreDiscoveryResult> list = this.tdataDiscoveryResultDao.getResultTableInfo(obj);
      return list;
   }

   public boolean saveEdition(DiscoveryResultVO obj, String address) {
      List<TcoreDiscoveryResult> list = this.tdataDiscoveryResultDao.selectResult(obj);
      if (list.size() == 0) {
         return false;
      } else {
         StringBuilder content = new StringBuilder();
         List<TCoreProjectAllrule> ruleInfo_white = this.tdataDiscoveryResultDao.queryMaskingRuleInfo("白名单");

         for(int i = 0; i < list.size(); ++i) {
            String schemaName = ((TcoreDiscoveryResult)list.get(i)).getTschemas();
            String tableName = ((TcoreDiscoveryResult)list.get(i)).getTtables();
            String columnName = ((TcoreDiscoveryResult)list.get(i)).getTfields();
            String dataareaId = ((TcoreDiscoveryResult)list.get(i)).getDataarea_id();
            String dataareaName = ((TcoreDiscoveryResult)list.get(i)).getDataarea_name();
            String sensitiveId = ((TcoreDiscoveryResult)list.get(i)).getSensitive_id();
            String sensitiveName = ((TcoreDiscoveryResult)list.get(i)).getSensitive_name();
            String issure = ((TcoreDiscoveryResult)list.get(i)).getIssure();
            String tdatasystem_id = ((TcoreDiscoveryResult)list.get(i)).getTdatasystem_id();
            content.append(schemaName + "," + tableName + "," + columnName + "," + dataareaId + "," + dataareaName + "," + sensitiveId + "," + sensitiveName + "," + issure + "," + tdatasystem_id + "\r\n");
         }

         TxtTool.exportTxt(content.toString(), address, "GBK");
         return true;
      }
   }

   public void saveSysdataTable(List<TCoreDiscoverySysdata> list) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      int count = 0;
      StringBuilder sb_TCoreDiscoverySysdata = new StringBuilder();
      List<String> list_table_TCoreDiscoverySysdata = JdbcTool.sql_insert_q(new TCoreDiscoverySysdata());
      list_table_TCoreDiscoverySysdata.add("id");
      String sb_sql_table_TCoreDiscoverySysdata = JdbcTool.sql_insert_z(list_table_TCoreDiscoverySysdata, "t_core_discovery_sysdata");
      sb_TCoreDiscoverySysdata.append(sb_sql_table_TCoreDiscoverySysdata);
      if (list != null) {
         for(TCoreDiscoverySysdata t : list) {
            ++count;
            t.setId(UUID.randomUUID().toString());
            sb_TCoreDiscoverySysdata.append(JdbcTool.sql_insert_h(t, list_table_TCoreDiscoverySysdata));
         }
      }

      if (count != 0) {
         this.tCoreDiscoverySysdataDao.saveTCoreDiscoverySysdata(sb_TCoreDiscoverySysdata.deleteCharAt(sb_TCoreDiscoverySysdata.length() - 1));
      }

   }

   public List<TCoreDiscoverySysdata> discoverResultPage(int i, Integer rows) {
      List<TCoreDiscoverySysdata> list = this.tCoreDiscoverySysdataDao.discoverResultPage(i, rows);
      return list;
   }

   public List<TcoreDiscoveryResult> getPageDataResult(String tablename, String tschemas, String ttables, String nfield) {
      List<TcoreDiscoveryResult> list = this.tdataDiscoveryResultDao.getPageDataResult(tablename, tschemas, ttables, nfield);
      return list;
   }

   public List<TcoreDiscoveryResult> getPageDataResultfile(PageInfo pageinfo, String dataArea1, String tablename, String tschemas, String ttables, String structStr1, String checksure, String issensitive) {
      List<TcoreDiscoveryResult> list = this.tdataDiscoveryResultDao.getPageDataResultfile(pageinfo, dataArea1, tablename, tschemas, ttables, structStr1, checksure, issensitive);
      return list;
   }

   public String getFileContent(String id, String tablename) {
      String fileContent = this.tdataDiscoveryResultDao.getFileContent(id, tablename);
      return fileContent;
   }

   public Long getPageDataCount() {
      Long con = this.tCoreDiscoverySysdataDao.count();
      return con;
   }

   public void discoverDeleRuleAll(DiscoveryResultVO obj) {
      this.tdataDiscoveryResultDao.discoverDeleRuleAll(obj);
   }

   public void discoverDeleRule(DiscoveryResultVO obj, String id) {
      this.tdataDiscoveryResultDao.discoverDeleRule(obj, id);
   }

   public List<TcoreDiscoveryResult> saveExcel(DiscoveryResultVO obj) {
      List<TcoreDiscoveryResult> list = this.tdataDiscoveryResultDao.selectAll(obj);
      return list;
   }

   public List<TcoreDiscoveryResult> selectApiDiscoveryResult(DiscoveryResultVO vo) {
      List<TcoreDiscoveryResult> list = this.tdataDiscoveryResultDao.selectApiDiscoveryResultList(vo);
      return list;
   }

   public List<TCoreDiscoverySysdata> queryAll() {
      return this.tCoreDiscoverySysdataDao.queryAll();
   }

   public void saveTableData(DiscoveryResultVO obj, List<TcoreDiscoveryResult> list1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      new TcoreDiscoveryResult();
      StringBuilder sb = new StringBuilder();
      List<String> list_table = JdbcTool.sql_insert_q(new TcoreDiscoveryResult());
      list_table.add("id");
      String sb_sql_table = JdbcTool.sql_insert_z(list_table, obj.getTablename());
      sb.append(sb_sql_table);

      for(TcoreDiscoveryResult v : list1) {
         String value = JdbcTool.sql_insert_h(v, list_table);
         sb.append(value);
      }

      this.tdataDiscoveryResultDao.savetCoreAssignmentField(sb.deleteCharAt(sb.length() - 1));
   }

   public void delTableData(DiscoveryResultVO obj) {
      this.tdataDiscoveryResultDao.clearRealTable(obj);
   }

   public void clearT() {
      this.tdataDiscoveryResultDao.clearTable();
   }

   public void resetResultRun(String tablename) {
      SqlFileTool.importSql(tablename);
   }

   public void clearTable(String tablename) {
      this.tdataDiscoveryResultDao.deleteTable(tablename);
   }

   public Map<String, String> getDataAreaAll() {
      List<TCoreDataArea> list = this.tCoreDataAreaDao.queryAll();
      Map<String, String> map = new HashMap();

      for(TCoreDataArea tCoreDataArea : list) {
         map.put(tCoreDataArea.getDataarea(), tCoreDataArea.getId());
      }

      return map;
   }

   public Map<String, String> getFindRulsAll() {
      List<TCoreMaskingRuleinfo> list = this.tCoreMaskingRuleinfoDao.queryAll();
      Map<String, String> map = new HashMap();

      for(TCoreMaskingRuleinfo tCoreMaskingRuleinfo : list) {
         map.put(tCoreMaskingRuleinfo.getName(), tCoreMaskingRuleinfo.getId());
      }

      return map;
   }
}
