package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.core.ComplianceDirectoryDao;
import com.chenyang.nse.bussiness.dao.core.DataScopeDao;
import com.chenyang.nse.bussiness.dao.core.ProEditionScopeDao;
import com.chenyang.nse.bussiness.dao.core.SensitiveLevelDao;
import com.chenyang.nse.bussiness.dao.core.TCoreDataSourceSchemaDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserprojectDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSearchregexDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSensitiveregexDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreComplianceDirectoryDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDataScopeDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSensitiveLevelDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataAreaDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataProjectDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDiscoverytaskDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectDataareaDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectDatasourceDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectDesensitizationruleDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectFindruleDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreTaskFindruleDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TcoreDiscoveryColumnDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TcoreDiscoveryDataResultDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationimgtask.DesensitizationImgInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationimgtask.DesensitizationImgtaskDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationFileDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationSelfTaskDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationTablecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationsourceDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtableDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtargetDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.DesensitizationtaskDao;
import com.chenyang.nse.bussiness.dao.table.core.desensitizationtask.TCoreMonitorTmporaryDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.DesensitizationStrategyDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreFieldSensitiveDao;
import com.chenyang.nse.bussiness.dao.table.core.fieldscope.TCoreScopeFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleinfoDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreWatermarkKeyInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.scheduler.TCoreSchedulerRelationDao;
import com.chenyang.nse.bussiness.dao.table.core.scheduler.TCoreSchedulerRulesDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserproject;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasourceSchema;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectAllrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectDatasource;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFindrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationimgtask.DesensitizationImgtask;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationselftask.DesensitizationSelfTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryColumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreWatermarkKeyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.scheduler.TCoreSchedulerRules;
import com.chenyang.nse.bussiness.entity.orm.table.core.scopeproject.TProEditionScope;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataProjectVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.DatasystemProjectdatasourceVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDataProjectVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreProjectDatasourceVO;
import com.chenyang.nse.bussiness.jar.db.TCoreClientInfo;
import com.chenyang.nse.bussiness.jar.db.TCoreClientInfoDao;
import com.chenyang.nse.bussiness.jar.db.TCoreClientIpControlledDao;
import com.chenyang.nse.bussiness.jar.db.TCoreClientRuleChangeLogDao;
import com.chenyang.nse.bussiness.service.core.DesensitizationtaskService;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TdataProjectServiceImpl implements TdataProjectService {
   @Autowired
   DesensitizationStrategyDao desensitizationStrategyDao;
   @Autowired
   private TCoreDataProjectDao tCoreDataProjectDao;
   @Autowired
   private TCoreProjectDatasourceDao tCoreProjectDatasourceDao;
   @Autowired
   private TCoreProjectDataareaDao tCoreProjectDataareaDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreDataAreaDao tCoreDataAreaDao;
   @Autowired
   private TCoreProjectFindruleDao tCoreProjectFindruleDao;
   @Autowired
   private TCoreProjectDesensitizationruleDao tCoreProjectDesensitizationruleDao;
   @Autowired
   private TConsoleSearchregexDao tConsoleSearchregexDao;
   @Autowired
   private TConsoleSensitiveregexDao tConsoleSensitiveregexDao;
   @Autowired
   private TcoreDiscoveryColumnDao tcoreDiscoveryColumnDao;
   @Autowired
   private TCoreDiscoverytaskDao tCoreDiscoverytaskDao;
   @Autowired
   private TCoreTaskFindruleDao tCoreTaskFindruleDao;
   @Autowired
   private TcoreDiscoveryDataResultDao tcoreDiscoveryDataResultDao;
   @Autowired
   private TCoreMaskingRuleinfoDao tCoreMaskingRuleinfoDao;
   @Autowired
   private DesensitizationtaskService desensitizationtaskService;
   @Autowired
   private DesensitizationtaskDao desensitizationtaskDao;
   @Autowired
   private TCoreSchedulerRulesDao tCoreSchedulerRulesDao;
   @Autowired
   private TBaseUserprojectDao tBaseUserprojectDao;
   @Autowired
   private DataScopeDao dataScopeDao;
   @Autowired
   private SensitiveLevelDao sensitiveLevelDao;
   @Autowired
   private ComplianceDirectoryDao complianceDirectoryDao;
   @Autowired
   private DesensitizationImgtaskDao desensitizationImgtaskDao;
   @Autowired
   private DesensitizationSelfTaskDao desensitizationSelfTaskDao;
   @Autowired
   private TCoreWatermarkKeyInfoDao tCoreWatermarkKeyInfoDao;
   @Autowired
   private TCoreMonitorTmporaryDao tCoreMonitorTmporaryDao;
   @Autowired
   private DesensitizationtableDao desensitizationtableDao;
   @Autowired
   private DesensitizationtargetDao desensitizationtargetDao;
   @Autowired
   private DesensitizationsourceDao desensitizationsourceDao;
   @Autowired
   private DesensitizationFileDao desensitizationFileDao;
   @Autowired
   private DesensitizationTablecolumnDao desensitizationTablecolumnDao;
   @Autowired
   private DesensitizationImgInfoDao desensitizationImgInfoDao;
   @Autowired
   private TCoreSchedulerRelationDao tCoreSchedulerRelationDao;
   @Autowired
   private ProEditionScopeDao proEditionScopeDao;
   @Autowired
   private TCoreDataScopeDao tCoreDataScopeDao;
   @Autowired
   private TCoreSensitiveLevelDao tCoreSensitiveLevelDao;
   @Autowired
   private TCoreComplianceDirectoryDao tCoreComplianceDirectoryDao;
   @Autowired
   private TCoreScopeFieldDao tCoreScopeFieldDao;
   @Autowired
   private TCoreDataSourceSchemaDao tCoreDataSourceSchemaDao;
   @Autowired
   private TCoreFieldSensitiveDao tCoreFieldSensitiveDao;
   @Autowired
   private TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao;
   @Autowired
   private TCoreClientInfoDao clientInfoDao;
   @Autowired
   private TCoreClientRuleChangeLogDao ruleChangeLogDao;
   @Autowired
   private TCoreClientIpControlledDao clientIpControlledDao;

   public void saveDataProject(TCoreDataProject obj) {
      this.tCoreDataProjectDao.save(obj);
   }

   @Transactional
   public void editDataProject(TCoreDataProject obj) {
      this.tCoreDataProjectDao.editDataProject(obj);
   }

   public Map<String, String> deleteDataProject(String id) {
      Map<String, String> result = new HashMap();
      result.put("flag", "true");
      result.put("msg", "删除成功");

      for(TCoreProjectDatasource tCoreProjectDatasource : this.tCoreProjectDatasourceDao.queryAll(new Criterion[]{Restrictions.eq("project_id", id)})) {
         int count = 0;
         Object s1 = this.tCoreEncryptionTypeFieldDao.queryEncryptionColumnNum(id, tCoreProjectDatasource.getSystemsource_id());
         if (s1 != null) {
            count = Integer.parseInt(s1.toString());
         }

         if (count != 0) {
            result.put("flag", "false");
            result.put("msg", "存在加密字段，不可以删除");
            return result;
         }
      }

      this.tCoreDataProjectDao.removeById(id);
      this.desensitizationStrategyDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
      this.tCoreProjectDatasourceDao.remove(new Criterion[]{Restrictions.eq("project_id", id)});
      this.tCoreDataSourceSchemaDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
      this.tCoreProjectDataareaDao.remove(new Criterion[]{Restrictions.eq("project_id", id)});
      this.tCoreProjectFindruleDao.remove(new Criterion[]{Restrictions.eq("project_id", id)});
      List<TcoreDiscoveryTask> tasklist = this.tCoreDiscoverytaskDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < tasklist.size(); ++i) {
         this.tCoreDiscoverytaskDao.removeById(((TcoreDiscoveryTask)tasklist.get(i)).getId());
         this.tCoreTaskFindruleDao.remove(new Criterion[]{Restrictions.eq("taskid", ((TcoreDiscoveryTask)tasklist.get(i)).getId())});
         this.tcoreDiscoveryColumnDao.remove(new Criterion[]{Restrictions.eq("taskid", ((TcoreDiscoveryTask)tasklist.get(i)).getId())});
         StringBuilder sqlstr = new StringBuilder("DROP TABLE " + ((TcoreDiscoveryTask)tasklist.get(i)).getResultid());
         this.tCoreDiscoverytaskDao.createsqlstr(sqlstr);
         this.tcoreDiscoveryDataResultDao.remove(new Criterion[]{Restrictions.eq("taskid", ((TcoreDiscoveryTask)tasklist.get(i)).getId())});
      }

      List<Desensitizationtask> masklist = this.desensitizationtaskDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});
      this.desensitizationtaskDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < masklist.size(); ++i) {
         this.desensitizationtableDao.remove(new Criterion[]{Restrictions.eq("taskid", ((Desensitizationtask)masklist.get(i)).getId())});
         this.desensitizationTablecolumnDao.remove(new Criterion[]{Restrictions.eq("taskid", ((Desensitizationtask)masklist.get(i)).getId())});
         this.desensitizationsourceDao.remove(new Criterion[]{Restrictions.eq("taskid", ((Desensitizationtask)masklist.get(i)).getId())});
         this.desensitizationtargetDao.remove(new Criterion[]{Restrictions.eq("taskid", ((Desensitizationtask)masklist.get(i)).getId())});
         this.desensitizationFileDao.remove(new Criterion[]{Restrictions.eq("taskid", ((Desensitizationtask)masklist.get(i)).getId())});
      }

      List<DesensitizationImgtask> imgmasklist = this.desensitizationImgtaskDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});
      this.desensitizationImgtaskDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < imgmasklist.size(); ++i) {
         this.desensitizationImgInfoDao.remove(new Criterion[]{Restrictions.eq("taskid", ((DesensitizationImgtask)imgmasklist.get(i)).getId())});
      }

      List<DesensitizationSelfTask> selfmasklist = this.desensitizationSelfTaskDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});
      this.desensitizationSelfTaskDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < selfmasklist.size(); ++i) {
         this.desensitizationtableDao.remove(new Criterion[]{Restrictions.eq("taskid", ((DesensitizationSelfTask)selfmasklist.get(i)).getId())});
         this.desensitizationTablecolumnDao.remove(new Criterion[]{Restrictions.eq("taskid", ((DesensitizationSelfTask)selfmasklist.get(i)).getId())});
         this.desensitizationsourceDao.remove(new Criterion[]{Restrictions.eq("taskid", ((DesensitizationSelfTask)selfmasklist.get(i)).getId())});
         this.desensitizationtargetDao.remove(new Criterion[]{Restrictions.eq("taskid", ((DesensitizationSelfTask)selfmasklist.get(i)).getId())});
      }

      List<TCoreSchedulerRules> schedulerlist = this.tCoreSchedulerRulesDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < schedulerlist.size(); ++i) {
         this.tCoreSchedulerRelationDao.remove(new Criterion[]{Restrictions.eq("rulesid", ((TCoreSchedulerRules)schedulerlist.get(i)).getId())});
      }

      this.tCoreSchedulerRulesDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
      List<TProEditionScope> editionscopelist = this.proEditionScopeDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});
      this.tCoreScopeFieldDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
      this.tCoreFieldSensitiveDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < editionscopelist.size(); ++i) {
         this.tCoreDataScopeDao.remove(new Criterion[]{Restrictions.eq("edition_id", ((TProEditionScope)editionscopelist.get(i)).getId())});
         this.tCoreSensitiveLevelDao.remove(new Criterion[]{Restrictions.eq("edition_id", ((TProEditionScope)editionscopelist.get(i)).getId())});
      }

      this.tCoreComplianceDirectoryDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
      this.proEditionScopeDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
      this.tCoreEncryptionTypeFieldDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});

      try {
         this.clientIpControlledDao.remove(new Criterion[]{Restrictions.eq("project_id", id)});
         List<TCoreClientInfo> clients = this.clientInfoDao.queryAll(new Criterion[]{Restrictions.eq("project_id", id)});
         clients.forEach((client) -> this.ruleChangeLogDao.remove(new Criterion[]{Restrictions.eq("t_client_id", client.getId())}));
         this.clientInfoDao.remove(new Criterion[]{Restrictions.eq("project_id", id)});
      } catch (Exception e) {
         e.printStackTrace();
      }

      return result;
   }

   public void deleteRelationdata(String id) {
      this.tCoreProjectDatasourceDao.remove(new Criterion[]{Restrictions.eq("project_id", id)});
      this.tCoreProjectDataareaDao.remove(new Criterion[]{Restrictions.eq("project_id", id)});
      List<TcoreDiscoveryTask> tasklist = this.tCoreDiscoverytaskDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < tasklist.size(); ++i) {
         this.tCoreDiscoverytaskDao.removeById(((TcoreDiscoveryTask)tasklist.get(i)).getId());
         this.tCoreTaskFindruleDao.remove(new Criterion[]{Restrictions.eq("taskid", ((TcoreDiscoveryTask)tasklist.get(i)).getId())});
         this.tcoreDiscoveryColumnDao.remove(new Criterion[]{Restrictions.eq("taskid", ((TcoreDiscoveryTask)tasklist.get(i)).getId())});
         StringBuilder sqlstr = new StringBuilder("DROP TABLE " + ((TcoreDiscoveryTask)tasklist.get(i)).getResultid());
         this.tCoreDiscoverytaskDao.createsqlstr(sqlstr);
         this.tcoreDiscoveryDataResultDao.remove(new Criterion[]{Restrictions.eq("taskid", ((TcoreDiscoveryTask)tasklist.get(i)).getId())});
      }

      List<Desensitizationtask> masklist = this.desensitizationtaskDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});
      this.desensitizationtaskDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < masklist.size(); ++i) {
         this.desensitizationtableDao.remove(new Criterion[]{Restrictions.eq("taskid", ((Desensitizationtask)masklist.get(i)).getId())});
         this.desensitizationTablecolumnDao.remove(new Criterion[]{Restrictions.eq("taskid", ((Desensitizationtask)masklist.get(i)).getId())});
         this.desensitizationsourceDao.remove(new Criterion[]{Restrictions.eq("taskid", ((Desensitizationtask)masklist.get(i)).getId())});
         this.desensitizationtargetDao.remove(new Criterion[]{Restrictions.eq("taskid", ((Desensitizationtask)masklist.get(i)).getId())});
         this.desensitizationFileDao.remove(new Criterion[]{Restrictions.eq("taskid", ((Desensitizationtask)masklist.get(i)).getId())});
      }

      List<DesensitizationImgtask> imgmasklist = this.desensitizationImgtaskDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});
      this.desensitizationImgtaskDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < imgmasklist.size(); ++i) {
         this.desensitizationImgInfoDao.remove(new Criterion[]{Restrictions.eq("taskid", ((DesensitizationImgtask)imgmasklist.get(i)).getId())});
      }

      List<DesensitizationSelfTask> selfmasklist = this.desensitizationSelfTaskDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});
      this.desensitizationSelfTaskDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < selfmasklist.size(); ++i) {
         this.desensitizationtableDao.remove(new Criterion[]{Restrictions.eq("taskid", ((DesensitizationSelfTask)selfmasklist.get(i)).getId())});
         this.desensitizationTablecolumnDao.remove(new Criterion[]{Restrictions.eq("taskid", ((DesensitizationSelfTask)selfmasklist.get(i)).getId())});
         this.desensitizationsourceDao.remove(new Criterion[]{Restrictions.eq("taskid", ((DesensitizationSelfTask)selfmasklist.get(i)).getId())});
         this.desensitizationtargetDao.remove(new Criterion[]{Restrictions.eq("taskid", ((DesensitizationSelfTask)selfmasklist.get(i)).getId())});
      }

      List<TCoreSchedulerRules> schedulerlist = this.tCoreSchedulerRulesDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < schedulerlist.size(); ++i) {
         this.tCoreSchedulerRelationDao.remove(new Criterion[]{Restrictions.eq("rulesid", ((TCoreSchedulerRules)schedulerlist.get(i)).getId())});
      }

      this.tCoreSchedulerRulesDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
      List<TProEditionScope> editionscopelist = this.proEditionScopeDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});
      this.tCoreScopeFieldDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < editionscopelist.size(); ++i) {
         this.tCoreDataScopeDao.remove(new Criterion[]{Restrictions.eq("edition_id", ((TProEditionScope)editionscopelist.get(i)).getId())});
         this.tCoreSensitiveLevelDao.remove(new Criterion[]{Restrictions.eq("edition_id", ((TProEditionScope)editionscopelist.get(i)).getId())});
      }

      this.tCoreComplianceDirectoryDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
      this.proEditionScopeDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
   }

   public TCoreDataProject selectOneDataProject(String id) {
      TCoreDataProject obj = (TCoreDataProject)this.tCoreDataProjectDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
      return obj;
   }

   public List<TCoreDataProject> selectDataProject(String proName, String note) {
      List<TCoreDataProject> list = null;
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("1") && StringUtils.isBlank(note)) {
         list = this.tCoreDataProjectDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.like("project", proName, MatchMode.ANYWHERE)});
      } else {
         list = this.tCoreDataProjectDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.like("project", proName, MatchMode.ANYWHERE), Restrictions.like("note", note, MatchMode.ANYWHERE)});
      }

      return list;
   }

   public List<TCoreDataProject> selectDataProject() {
      List<TCoreDataProject> list = this.tCoreDataProjectDao.queryAll(Order.desc("createtime"), new Criterion[0]);
      return list;
   }

   public List<TCoreDataProject> selectMyDataProject(String userid, String proName, String note) {
      List<TCoreDataProject> list = this.tCoreDataProjectDao.queryMyProject(userid, proName, note);
      return list;
   }

   public void saveProDataSource(TCoreProjectDatasource obj) {
      this.tCoreProjectDatasourceDao.save(obj);
   }

   public boolean deleteProDataSource(TCoreProjectDatasource obj) {
      List<TcoreDiscoveryColumn> list = this.tcoreDiscoveryColumnDao.queryAll(new Criterion[]{Restrictions.eq("datasourceid", obj.getSystemsource_id()), Restrictions.eq("projectid", obj.getProject_id())});
      if (list.size() > 0) {
         return false;
      } else {
         this.tCoreProjectDatasourceDao.remove(new Criterion[]{Restrictions.eq("systemsource_id", obj.getSystemsource_id()), Restrictions.eq("systemstyle", obj.getSystemstyle()), Restrictions.eq("project_id", obj.getProject_id())});
         return true;
      }
   }

   public TCoreDatasystem selectOneProDataSource(String id) {
      TCoreDatasystem obj = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
      return obj;
   }

   public List<ComboboxVO> selectProDataSource(String systemstyle) {
      List<ComboboxVO> list = this.tCoreDatasystemDao.selectProDataSourceKind(systemstyle);
      return list;
   }

   public List<ComboboxVO> selectProDataSource1(String systemstyle) {
      List<ComboboxVO> list = this.tCoreDatasystemDao.selectProDataSourceKind1(systemstyle);
      return list;
   }

   public List<ComboboxVO> selectProDataSourceDet(String systemstyle, String dbtype) {
      List<ComboboxVO> list = this.tCoreDatasystemDao.selectProDataSourceKind(systemstyle, dbtype);
      return list;
   }

   public List<ComboboxVO> selectProDataSourceDet1(String systemstyle, String dbtype, String versionname) {
      List<ComboboxVO> list = this.tCoreDatasystemDao.selectProDataSourceKind2(systemstyle, dbtype, versionname);
      return list;
   }

   public List<TCoreDatasystem> selectCheckProDataSource(String projectid, String systemstyle, String searchval) {
      List<TCoreProjectDatasource> plist = this.tCoreProjectDatasourceDao.queryAll(new Criterion[]{Restrictions.eq("project_id", projectid), Restrictions.eq("systemstyle", systemstyle)});
      List<String> str = new ArrayList();
      str.add(" ");

      for(TCoreProjectDatasource tCoreProjectDatasource : plist) {
         str.add(tCoreProjectDatasource.getSystemsource_id());
      }

      if (!searchval.isEmpty()) {
         List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(Order.asc("dbtype"), new Criterion[]{Restrictions.in("id", str), Restrictions.like("sysname", "%" + searchval + "%")});
         return list;
      } else {
         List<TCoreDatasystem> list = this.tCoreDatasystemDao.queryAll(Order.asc("dbtype"), new Criterion[]{Restrictions.in("id", str)});
         return list;
      }
   }

   public void saveDataArea(TCoreProjectFindrule obj) {
      List<TCoreProjectFindrule> list = this.tCoreProjectFindruleDao.queryAll(new Criterion[]{Restrictions.eq("project_id", obj.getProject_id()), Restrictions.eq("rule_id", obj.getRule_id()), Restrictions.eq("dataarea_id", obj.getDataarea_id())});
      List<TCoreProjectFindrule> list1 = this.tCoreProjectFindruleDao.queryAll(new Criterion[]{Restrictions.eq("project_id", obj.getProject_id()), Restrictions.eq("dataarea_id", obj.getDataarea_id()), Restrictions.eq("rulestyle", "0")});
      if (list.isEmpty()) {
         if (list1.isEmpty()) {
            obj.setDefaultrule("1");
         }

         this.tCoreProjectFindruleDao.save(obj);
      }

   }

   public void deleteDataArea(TCoreProjectFindrule obj) {
      this.tCoreProjectFindruleDao.remove(new Criterion[]{Restrictions.eq("project_id", obj.getProject_id()), Restrictions.eq("rule_id", obj.getRule_id()), Restrictions.eq("dataarea_id", obj.getDataarea_id())});
   }

   public List<TCoreDataArea> selectDataArea() {
      List<TCoreDataArea> list = this.tCoreDataAreaDao.queryAll();
      return list;
   }

   public List<TCoreDataArea> selectDataAreaHasFindRule() {
      return this.tCoreDataAreaDao.selectDataAreaHasFindRule();
   }

   public List<Map<String, Object>> selectDataAreaHas(String id) {
      List<Map<String, Object>> list = this.tCoreProjectDataareaDao.selectDataAreaHas(id);
      return list;
   }

   public List<Map<String, Object>> selectDataAreaHasEM() {
      List<Map<String, Object>> list = this.tCoreProjectDataareaDao.selectDataAreaHasEM();
      return list;
   }

   public List<Map<String, Object>> selectCheckDataArea(String id) {
      List<Map<String, Object>> list = this.tCoreProjectDataareaDao.selectCheckDataArea(id);
      return list;
   }

   public List<TCoreProjectAllrule> selectDataAreaFindRule(TCoreProjectFindrule obj) {
      List<TCoreProjectAllrule> list1 = new ArrayList();
      List<TConsoleSearchregex> searchlist = this.tConsoleSearchregexDao.queryAll(Order.asc("name"), new Criterion[]{Restrictions.eq("dataarea_id", obj.getDataarea_id())});
      List<TCoreProjectFindrule> rulelist = this.tCoreProjectFindruleDao.queryAll(new Criterion[]{Restrictions.eq("project_id", obj.getProject_id()), Restrictions.eq("dataarea_id", obj.getDataarea_id()), Restrictions.eq("rulestyle", "0")});
      List<String> name = new ArrayList();
      String defaultrule = "";
      if (rulelist.isEmpty()) {
         TConsoleSearchregex searchdefault = (TConsoleSearchregex)this.tConsoleSearchregexDao.queryUnique(new Criterion[]{Restrictions.eq("dataarea_id", obj.getDataarea_id()), Restrictions.eq("defaulttype", "1")});
         if (searchdefault != null) {
            defaultrule = searchdefault.getId();
         }
      } else {
         for(TCoreProjectFindrule tCoreProjectFindrule : rulelist) {
            name.add(tCoreProjectFindrule.getRule_id());
            if ("1".equals(tCoreProjectFindrule.getDefaultrule())) {
               defaultrule = tCoreProjectFindrule.getRule_id();
            }
         }
      }

      for(TConsoleSearchregex tConsoleSearchregex : searchlist) {
         TCoreProjectAllrule a = new TCoreProjectAllrule();
         a.setDataarea_id(tConsoleSearchregex.getDataarea_id());
         a.setRulestyle("0");
         a.setRule_id(tConsoleSearchregex.getId());
         a.setRulename(tConsoleSearchregex.getName());
         if (defaultrule.equals(tConsoleSearchregex.getId())) {
            a.setIsdefault("1");
         }

         if (!"".equals(tConsoleSearchregex.getRuleexample()) && tConsoleSearchregex.getRuleexample() != null) {
            a.setExample(tConsoleSearchregex.getRuleexample());
         } else {
            a.setExample("无");
         }

         if (!"".equals(tConsoleSearchregex.getNote()) && tConsoleSearchregex.getNote() != null) {
            a.setNote(tConsoleSearchregex.getNote());
         } else {
            a.setNote("无");
         }

         if (name.contains(tConsoleSearchregex.getId())) {
            a.setCheckstyle("1");
         } else {
            a.setCheckstyle("0");
         }

         list1.add(a);
      }

      return list1;
   }

   public List<TConsoleSearchregex> selectDataAreaFindRule(String dataAreaId) {
      List<TConsoleSearchregex> searchlist = this.tConsoleSearchregexDao.queryAll(Order.asc("name"), new Criterion[]{Restrictions.eq("dataarea_id", dataAreaId)});
      return searchlist;
   }

   public void defaultRow(String rule_id, String project_id, String dataarea_id, String rulestyle) {
      this.tCoreProjectFindruleDao.defaultRowClear(project_id, dataarea_id, rulestyle);
      this.tCoreProjectFindruleDao.defaultRow(project_id, dataarea_id, rule_id, rulestyle);
   }

   public void resetDefault(String id) {
   }

   public void deleteTable(String project_id, String dataarea_id) {
      this.tCoreProjectFindruleDao.remove(new Criterion[]{Restrictions.eq("project_id", project_id), Restrictions.eq("dataarea_id", dataarea_id)});
   }

   public List<Map<String, Object>> selectSource(String id, String userid) {
      List<Map<String, Object>> list = this.tCoreProjectDatasourceDao.selectSource(id, userid);
      return list;
   }

   public List<Map<String, Object>> selectArea(String id) {
      List<Map<String, Object>> list = this.tCoreProjectDataareaDao.selectAreaCount(id);
      return list;
   }

   public List<Map<String, Object>> selectFind(String id) {
      List<Map<String, Object>> list = this.tCoreDiscoverytaskDao.selectFindCount(id);
      return list;
   }

   public List<Map<String, Object>> selectMasking(String id) {
      List<Map<String, Object>> list = this.desensitizationtaskDao.selectMaskingCount(id);
      return list;
   }

   public List<Map<String, Object>> querySensitiveRuleList(String projectid) {
      List<Map<String, Object>> list = this.tCoreProjectFindruleDao.querySensitiveRuleList(projectid);
      return list;
   }

   public List<Map<String, Object>> querySensitiveRuleList() {
      List<Map<String, Object>> list = this.tCoreProjectFindruleDao.querySensitiveRuleList();
      return list;
   }

   public List<Map<String, Object>> queryDbSensitiveRuleList(String dataSystemId) {
      List<Map<String, Object>> list = this.tCoreProjectFindruleDao.queryDbSensitiveRuleList(dataSystemId);
      return list;
   }

   public List<TCoreProjectAllrule> selectDataAreaMaskingRule(TCoreProjectFindrule obj, String searchstr) {
      List<TCoreProjectAllrule> list1 = new ArrayList();
      List<TCoreMaskingRuleinfo> sensitivelist = this.tCoreMaskingRuleinfoDao.queryAll(Order.asc("name"), new Criterion[]{Restrictions.eq("dataarea_id", obj.getDataarea_id()), Restrictions.like("name", "%" + searchstr + "%")});
      List<TCoreProjectFindrule> rulelist = this.tCoreProjectFindruleDao.queryAll(new Criterion[]{Restrictions.eq("project_id", obj.getProject_id()), Restrictions.eq("dataarea_id", obj.getDataarea_id()), Restrictions.eq("rulestyle", "1")});
      List<String> name = new ArrayList();
      String defaultrule = "";
      if (rulelist.isEmpty()) {
         TCoreMaskingRuleinfo sensitivefault = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("dataarea_id", obj.getDataarea_id()), Restrictions.eq("defaulttype", "1")});
         if (sensitivefault != null) {
            defaultrule = sensitivefault.getId();
         }
      } else {
         for(TCoreProjectFindrule tCoreProjectFindrule : rulelist) {
            name.add(tCoreProjectFindrule.getRule_id());
            if ("1".equals(tCoreProjectFindrule.getDefaultrule())) {
               defaultrule = tCoreProjectFindrule.getRule_id();
            }
         }
      }

      for(TCoreMaskingRuleinfo tCoreMaskingRuleinfo : sensitivelist) {
         TCoreProjectAllrule a = new TCoreProjectAllrule();
         a.setDataarea_id(tCoreMaskingRuleinfo.getDataarea_id());
         a.setRulestyle("1");
         a.setRule_id(tCoreMaskingRuleinfo.getId());
         a.setRulename(tCoreMaskingRuleinfo.getName());
         if (defaultrule.equals(tCoreMaskingRuleinfo.getId())) {
            a.setIsdefault("1");
         }

         if (!"".equals(tCoreMaskingRuleinfo.getRuledemo()) && tCoreMaskingRuleinfo.getRuledemo() != null) {
            a.setExample(tCoreMaskingRuleinfo.getRuledemo());
         } else {
            a.setExample("无");
         }

         if (!"".equals(tCoreMaskingRuleinfo.getNote()) && tCoreMaskingRuleinfo.getNote() != null) {
            a.setNote(tCoreMaskingRuleinfo.getNote());
         } else {
            a.setNote("无");
         }

         if (name.contains(tCoreMaskingRuleinfo.getId())) {
            a.setCheckstyle("1");
         } else {
            a.setCheckstyle("0");
         }

         list1.add(a);
      }

      return list1;
   }

   public List<TCoreMaskingRule> queryMaskingRule(String projectid) {
      return this.tCoreProjectFindruleDao.queryMaskingRule(projectid);
   }

   public List<TCoreMaskingRuleinfo> selectDataAreaMaskingRules(TCoreProjectFindrule obj, String searchstr) {
      if (StringUtils.isBlank(searchstr)) {
         searchstr = "";
      }

      List<TCoreMaskingRuleinfo> sensitivelist = this.tCoreMaskingRuleinfoDao.queryAll(Order.asc("name"), new Criterion[]{Restrictions.eq("dataarea_id", obj.getDataarea_id()), Restrictions.like("name", "%" + searchstr + "%")});
      return sensitivelist;
   }

   public List<ComboboxVO> queryProjectList(String projectids) {
      return this.tCoreDataProjectDao.queryProjectList(projectids);
   }

   public List<ComboboxVO> queryTaskList(String taskids, String projectid) {
      return this.tCoreDiscoverytaskDao.queryTaskList(taskids, projectid);
   }

   public void saveAllFind(String project_id, String dataarea_id, String defaultid) {
      try {
         List<TConsoleSearchregex> searchlist = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", dataarea_id)});
         this.tCoreProjectFindruleDao.remove(new Criterion[]{Restrictions.eq("project_id", project_id), Restrictions.eq("dataarea_id", dataarea_id)});
         StringBuilder sb = new StringBuilder();
         List<String> list_table = JdbcTool.sql_insert_q(new TCoreProjectFindrule());
         list_table.add("id");
         String sb_sql_table = JdbcTool.sql_insert_z(list_table, "t_core_project_findrule");
         sb.append(sb_sql_table);
         TCoreProjectFindrule obj = new TCoreProjectFindrule();

         for(TConsoleSearchregex o : searchlist) {
            obj.setId(UUID.randomUUID().toString());
            obj.setDataarea_id(dataarea_id);
            if (o.getId().equals(defaultid)) {
               obj.setDefaultrule("1");
            } else {
               obj.setDefaultrule("0");
            }

            obj.setProject_id(project_id);
            obj.setRule_id(o.getId());
            obj.setRulestyle("0");
            String value = JdbcTool.sql_insert_h(obj, list_table);
            sb.append(value);
         }

         this.tCoreProjectFindruleDao.saveAllFind(sb.deleteCharAt(sb.length() - 1));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public void saveAllMasking(String project_id, String dataarea_id, String defaultid, String rulestyle) {
      try {
         List<TCoreMaskingRuleinfo> maskinglist = this.tCoreMaskingRuleinfoDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", dataarea_id)});
         this.tCoreProjectFindruleDao.remove(new Criterion[]{Restrictions.eq("project_id", project_id), Restrictions.eq("dataarea_id", dataarea_id), Restrictions.eq("rulestyle", rulestyle)});
         StringBuilder sb = new StringBuilder();
         List<String> list_table = JdbcTool.sql_insert_q(new TCoreProjectFindrule());
         list_table.add("id");
         String sb_sql_table = JdbcTool.sql_insert_z(list_table, "t_core_project_findrule");
         sb.append(sb_sql_table);
         TCoreProjectFindrule obj = new TCoreProjectFindrule();

         for(TCoreMaskingRuleinfo o : maskinglist) {
            obj.setId(UUID.randomUUID().toString());
            obj.setDataarea_id(dataarea_id);
            if (o.getId().equals(defaultid)) {
               obj.setDefaultrule("1");
            } else {
               obj.setDefaultrule("0");
            }

            obj.setProject_id(project_id);
            obj.setRule_id(o.getId());
            obj.setRulestyle("1");
            String value = JdbcTool.sql_insert_h(obj, list_table);
            sb.append(value);
         }

         this.tCoreProjectFindruleDao.saveAllFind(sb.deleteCharAt(sb.length() - 1));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public void deleteAllDataArea(String project_id, String dataarea_id) {
      this.tCoreProjectFindruleDao.remove(new Criterion[]{Restrictions.eq("dataarea_id", dataarea_id), Restrictions.eq("project_id", project_id), Restrictions.eq("rulestyle", "0")});
   }

   public void saveAll(String project_id) {
      try {
         List<String> l1 = new ArrayList();
         List<String> l2 = new ArrayList();
         List<String> l3 = new ArrayList();
         List<String> l4 = new ArrayList();
         List<String> l5 = new ArrayList();
         List<String> l6 = new ArrayList();
         List<TCoreProjectFindrule> fd = this.tCoreProjectFindruleDao.queryAll(new Criterion[]{Restrictions.eq("project_id", project_id), Restrictions.eq("rulestyle", "0"), Restrictions.eq("defaultrule", "1")});
         List<TCoreProjectFindrule> md = this.tCoreProjectFindruleDao.queryAll(new Criterion[]{Restrictions.eq("project_id", project_id), Restrictions.eq("rulestyle", "1"), Restrictions.eq("defaultrule", "1")});
         if (!fd.isEmpty()) {
            for(TCoreProjectFindrule a : fd) {
               l1.add(a.getRule_id());
               if (!l5.contains(a.getDataarea_id())) {
                  l5.add(a.getDataarea_id());
               }
            }
         }

         if (!md.isEmpty()) {
            for(TCoreProjectFindrule b : md) {
               l2.add(b.getRule_id());
               if (!l6.contains(b.getDataarea_id())) {
                  l6.add(b.getDataarea_id());
               }
            }
         }

         List<TCoreMaskingRuleinfo> md1 = this.tCoreMaskingRuleinfoDao.queryAll(new Criterion[]{Restrictions.eq("defaulttype", "1")});
         List<TConsoleSearchregex> fd1 = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("defaulttype", "1")});
         if (!fd1.isEmpty()) {
            for(TConsoleSearchregex c : fd1) {
               l3.add(c.getId());
            }
         }

         if (!md1.isEmpty()) {
            for(TCoreMaskingRuleinfo d : md1) {
               l4.add(d.getId());
            }
         }

         this.tCoreProjectFindruleDao.remove(new Criterion[]{Restrictions.eq("project_id", project_id)});
         List<TConsoleSearchregex> searchlist = this.tConsoleSearchregexDao.queryAll();
         List<TCoreMaskingRuleinfo> maskinglist = this.tCoreMaskingRuleinfoDao.queryAll();
         StringBuilder sb = new StringBuilder();
         List<String> list_table = JdbcTool.sql_insert_q(new TCoreProjectFindrule());
         list_table.add("id");
         String sb_sql_table = JdbcTool.sql_insert_z(list_table, "t_core_project_findrule");
         sb.append(sb_sql_table);
         TCoreProjectFindrule obj = new TCoreProjectFindrule();

         for(TConsoleSearchregex o1 : searchlist) {
            obj.setId(UUID.randomUUID().toString());
            obj.setDataarea_id(o1.getDataarea_id());
            if (!l5.isEmpty() && l5.contains(o1.getDataarea_id())) {
               if (!l1.isEmpty() && l1.contains(o1.getId())) {
                  obj.setDefaultrule("1");
               } else {
                  obj.setDefaultrule("0");
               }
            } else if (!l3.isEmpty() && l3.contains(o1.getId())) {
               obj.setDefaultrule("1");
            } else {
               obj.setDefaultrule("0");
            }

            obj.setProject_id(project_id);
            obj.setRule_id(o1.getId());
            obj.setRulestyle("0");
            String value = JdbcTool.sql_insert_h(obj, list_table);
            sb.append(value);
         }

         for(TCoreMaskingRuleinfo o : maskinglist) {
            obj.setId(UUID.randomUUID().toString());
            obj.setDataarea_id(o.getDataarea_id());
            if (!l6.isEmpty() && l6.contains(o.getDataarea_id())) {
               if (!l2.isEmpty() && l2.contains(o.getId())) {
                  obj.setDefaultrule("1");
               } else {
                  obj.setDefaultrule("0");
               }
            } else if (!l4.isEmpty() && l4.contains(o.getId())) {
               obj.setDefaultrule("1");
            } else {
               obj.setDefaultrule("0");
            }

            obj.setProject_id(project_id);
            obj.setRule_id(o.getId());
            obj.setRulestyle("1");
            String value1 = JdbcTool.sql_insert_h(obj, list_table);
            sb.append(value1);
         }

         this.tCoreProjectFindruleDao.saveAllFind(sb.deleteCharAt(sb.length() - 1));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public void deleteAll(String project_id) {
      this.tCoreProjectFindruleDao.remove(new Criterion[]{Restrictions.eq("project_id", project_id)});
   }

   public String isAll(String project_id) {
      List<TConsoleSearchregex> searchlist = this.tConsoleSearchregexDao.queryAll();
      List<TCoreMaskingRuleinfo> maskinglist = this.tCoreMaskingRuleinfoDao.queryAll();
      List<TCoreProjectFindrule> projectrule = this.tCoreProjectFindruleDao.queryAll(new Criterion[]{Restrictions.eq("project_id", project_id)});

      try {
         return searchlist.size() + maskinglist.size() == projectrule.size() ? "1" : "0";
      } catch (Exception var6) {
         return "0";
      }
   }

   public String changeDefault(TCoreProjectFindrule obj) {
      TCoreProjectFindrule o = (TCoreProjectFindrule)this.tCoreProjectFindruleDao.queryAll(new Criterion[]{Restrictions.eq("project_id", obj.getProject_id()), Restrictions.eq("rulestyle", obj.getRulestyle()), Restrictions.eq("dataarea_id", obj.getDataarea_id())}).get(0);
      o.setDefaultrule("1");
      this.tCoreProjectFindruleDao.saveOrUpdate(o);
      return o.getRule_id();
   }

   public List<DatasystemProjectdatasourceVO> queryByEditSort(String dbtype, String flag, String projectid, String userid) {
      List<DatasystemProjectdatasourceVO> list = this.tCoreProjectDatasourceDao.queryByFlagAll(flag, projectid, dbtype, userid);
      return list;
   }

   public List<DatasystemProjectdatasourceVO> queryByEditSort(String dbtype, String flag, String userid) {
      List<DatasystemProjectdatasourceVO> list = this.tCoreProjectDatasourceDao.queryByFlagAll(dbtype, flag, userid);
      return list;
   }

   public void saveAllProDataSource(String dbtype, String flag, String projectid, String userid) {
      try {
         List<String> list = this.tCoreProjectDatasourceDao.getHasTaskDataSource(flag, projectid, dbtype, userid);
         List<TCoreProjectDatasource> tpd = this.tCoreProjectDatasourceDao.queryAllProDataSource(flag, projectid, dbtype, userid);
         StringBuilder sb = new StringBuilder();
         List<String> list_table = JdbcTool.sql_insert_q(new TCoreProjectDatasource());
         list_table.add("id");
         String sb_sql_table = JdbcTool.sql_insert_z(list_table, "t_core_project_datasource");
         sb.append(sb_sql_table);

         for(TCoreProjectDatasource o : tpd) {
            if (list.isEmpty() || !list.contains(o.getSystemsource_id())) {
               o.setId(UUID.randomUUID().toString());
               String value = JdbcTool.sql_insert_h(o, list_table);
               sb.append(value);
            }
         }

         this.tCoreProjectDatasourceDao.saveAll(sb.deleteCharAt(sb.length() - 1));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public void deleteAllProDataSource(String dbtype, String flag, String projectid, String userid) {
      List<String> list = this.tCoreProjectDatasourceDao.getTaskDataSource(projectid);
      List<TCoreProjectDatasource> tpd = this.tCoreProjectDatasourceDao.queryAllProDataSource(flag, projectid, dbtype, userid);
      List<String> list1 = new ArrayList();

      for(TCoreProjectDatasource t : tpd) {
         if (list.isEmpty() || !list.contains(t.getSystemsource_id())) {
            list1.add(t.getSystemsource_id());
         }
      }

      this.tCoreProjectDatasourceDao.remove(new Criterion[]{Restrictions.in("systemsource_id", list1), Restrictions.eq("systemstyle", flag), Restrictions.eq("project_id", projectid)});
   }

   public String isChooseAll(String dbtype, String flag, String projectid, String searchval, String userid) {
      List<Map<String, Object>> isChooseAll = this.tCoreProjectDatasourceDao.isChooseAll(flag, projectid, searchval, dbtype, userid);
      List<TCoreProjectDatasource> tpd = this.tCoreProjectDatasourceDao.queryAllProDataSource(flag, projectid, dbtype, userid);
      if (!isChooseAll.isEmpty() && !tpd.isEmpty()) {
         return isChooseAll.size() == tpd.size() ? "1" : "0";
      } else {
         return "0";
      }
   }

   public List<Map<String, Object>> selectdispatch(String id) {
      List<Map<String, Object>> list = this.tCoreSchedulerRulesDao.queryDispatchNumber(id);
      return list;
   }

   public List<Map<String, Object>> selectMonitorCount(String id) {
      List<Map<String, Object>> list = this.tCoreSchedulerRulesDao.queryMonitorNumber(id);
      return list;
   }

   public List<TBaseUserproject> queryuserprobyuserid(String userid) {
      Criterion cuserid = Restrictions.eq("userid", userid);
      List<TBaseUserproject> list = this.tBaseUserprojectDao.queryAll(new Criterion[]{cuserid});
      return list;
   }

   public List<TBaseUserproject> queryuserprobyuseridproid(String userid, String proid) {
      Criterion cuserid = Restrictions.eq("userid", userid);
      Criterion cproid = Restrictions.eq("proid", proid);
      List<TBaseUserproject> list = this.tBaseUserprojectDao.queryAll(new Criterion[]{cuserid, cproid});
      return list;
   }

   public List<DataProjectVO> queryDataprojectCrudByUserid(List<String> userid) {
      return this.tCoreDataProjectDao.queryDataprojectCrudByUserid(userid);
   }

   public List<Map<String, Object>> selectDataScopeCount(String id, String edition_id) {
      List<Map<String, Object>> list = this.dataScopeDao.selectDataScopeCount(id, edition_id);
      return list;
   }

   public List<Map<String, Object>> selectSensitiveLevelCount(String id, String edition_id) {
      List<Map<String, Object>> list = this.sensitiveLevelDao.selectSensitiveLevelCount(id, edition_id);
      return list;
   }

   public List<Map<String, Object>> selectComplianceDirCount(String id) {
      List<Map<String, Object>> list = this.complianceDirectoryDao.selectComplianceDirCount(id);
      return list;
   }

   public List<Map<String, Object>> selectComplianceDirCount1(String edition_id) {
      List<Map<String, Object>> list = this.complianceDirectoryDao.selectComplianceDirCount1(edition_id);
      return list;
   }

   public List<Map<String, Object>> selectImgTaskCount(String id) {
      List<Map<String, Object>> list = this.desensitizationImgtaskDao.selectImgTaskCount(id);
      return list;
   }

   public List<Map<String, Object>> selectCodatabaseDataCount(String id) {
      List<Map<String, Object>> list = this.desensitizationSelfTaskDao.selectCodatabaseDataCount(id);
      return list;
   }

   public List<TCoreWatermarkKeyInfo> selectWatermarkKey() {
      List<TCoreWatermarkKeyInfo> list = this.tCoreWatermarkKeyInfoDao.queryAll();
      return list;
   }

   public List<Map<String, Object>> selectSelfMonitorCount(String id) {
      List<Map<String, Object>> list = this.tCoreMonitorTmporaryDao.querySelfMonitorNumber(id);
      return list;
   }

   public List<DatasystemProjectdatasourceVO> queryDatasourceByProjectId(String projectid) {
      List<DatasystemProjectdatasourceVO> list = this.tCoreProjectDatasourceDao.queryDatasourceByProjectId(projectid);
      return list;
   }

   public List<DatasystemProjectdatasourceVO> queryDataSystemByProjectIdAndDataSystemId(String projectid, String datasystemid) {
      return this.tCoreProjectDatasourceDao.queryDataSystemByProjectIdAndDataSystemId(projectid, datasystemid);
   }

   public List<DatasystemProjectdatasourceVO> queryDatasystemByProId(String projectid) {
      return this.tCoreProjectDatasourceDao.queryDatasystemByProId(projectid);
   }

   public List<DatasystemProjectdatasourceVO> queryDatasourceById(String projectid) {
      List<DatasystemProjectdatasourceVO> list = this.tCoreProjectDatasourceDao.queryDatasourceById(projectid);
      return list;
   }

   public List<TCoreProjectDatasourceVO> queryDatasourceList(String projectid) {
      return this.tCoreProjectDatasourceDao.queryDatasourceList(projectid);
   }

   public void addDataProject(TCoreDataProject projectObj, List<TCoreProjectDatasource> dataSourceIdList, List<TCoreProjectFindrule> areaAndRuleList, List<TCoreDatasourceSchema> schemalist) {
      projectObj.setId(UUID.randomUUID().toString());

      for(int i = 0; i < dataSourceIdList.size(); ++i) {
         TCoreProjectDatasource obj = new TCoreProjectDatasource();
         obj.setSystemsource_id(((TCoreProjectDatasource)dataSourceIdList.get(i)).getId());
         obj.setProject_id(projectObj.getId());
         obj.setSystemstyle(((TCoreProjectDatasource)dataSourceIdList.get(i)).getSystemstyle());
         this.tCoreProjectDatasourceDao.save(obj);
      }

      for(TCoreDatasourceSchema schema : schemalist) {
         schema.setProjectid(projectObj.getId());
         this.tCoreDataSourceSchemaDao.save(schema);
      }

      for(int i = 0; i < areaAndRuleList.size(); ++i) {
         TCoreProjectFindrule obj = new TCoreProjectFindrule();
         obj.setDataarea_id(((TCoreProjectFindrule)areaAndRuleList.get(i)).getDataarea_id());
         obj.setProject_id(projectObj.getId());
         obj.setRule_id(((TCoreProjectFindrule)areaAndRuleList.get(i)).getRule_id());
         obj.setRulestyle(((TCoreProjectFindrule)areaAndRuleList.get(i)).getRulestyle());
         obj.setDefaultrule(((TCoreProjectFindrule)areaAndRuleList.get(i)).getDefaultrule());
         this.tCoreProjectFindruleDao.save(obj);
      }

      this.tCoreDataProjectDao.save(projectObj);
   }

   public TCoreDataProjectVO getDataProjectDetail(String projectId) {
      TCoreDataProjectVO vo = new TCoreDataProjectVO();
      TCoreDataProject project = (TCoreDataProject)this.tCoreDataProjectDao.queryUnique(new Criterion[]{Restrictions.eq("id", projectId)});
      vo.setProject(project);
      List<TCoreProjectDatasource> dataSourceIdList = this.tCoreProjectDatasourceDao.queryAll(new Criterion[]{Restrictions.eq("project_id", projectId)});

      for(TCoreProjectDatasource projectDatasource : dataSourceIdList) {
         String sysname = this.tCoreProjectDatasourceDao.getSysnameByid(projectDatasource.getSystemsource_id());
         String dbtype = this.tCoreProjectDatasourceDao.getDbtypeByid(projectDatasource.getSystemsource_id());
         projectDatasource.setSysname(sysname);
         projectDatasource.setDbtype(dbtype);
      }

      vo.setDataSourceIdList(dataSourceIdList);
      List<TCoreDatasourceSchema> schemaList = this.tCoreDataSourceSchemaDao.queryAll(new Criterion[]{Restrictions.eq("projectid", projectId)});
      vo.setSchemalist(schemaList);
      List<TCoreProjectFindrule> areaAndRuleList = this.tCoreProjectFindruleDao.queryAll(new Criterion[]{Restrictions.eq("project_id", projectId)});
      vo.setAreaAndRuleList(areaAndRuleList);
      return vo;
   }

   public void updateDataProject(TCoreDataProjectVO vo) {
      TCoreDataProject project = vo.getProject();
      String id = project.getId();
      this.tCoreProjectDatasourceDao.remove(new Criterion[]{Restrictions.eq("project_id", id)});
      this.tCoreDataSourceSchemaDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
      this.tCoreProjectDataareaDao.remove(new Criterion[]{Restrictions.eq("project_id", id)});
      this.tCoreProjectFindruleDao.remove(new Criterion[]{Restrictions.eq("project_id", id)});
      List<TProEditionScope> editionscopelist = this.proEditionScopeDao.queryAll(new Criterion[]{Restrictions.eq("projectid", id)});
      this.tCoreScopeFieldDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});

      for(int i = 0; i < editionscopelist.size(); ++i) {
         this.tCoreDataScopeDao.remove(new Criterion[]{Restrictions.eq("edition_id", ((TProEditionScope)editionscopelist.get(i)).getId())});
         this.tCoreSensitiveLevelDao.remove(new Criterion[]{Restrictions.eq("edition_id", ((TProEditionScope)editionscopelist.get(i)).getId())});
      }

      this.tCoreComplianceDirectoryDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
      this.proEditionScopeDao.remove(new Criterion[]{Restrictions.eq("projectid", id)});
      List<TCoreProjectFindrule> areaAndRuleList = vo.getAreaAndRuleList();
      List<TCoreProjectDatasource> dataSourceIdList = vo.getDataSourceIdList();
      project.setUpdateuser(vo.getLoginUser().getTsysUser().getUsername());
      project.setUpdatetime(new Date());

      for(int i = 0; i < dataSourceIdList.size(); ++i) {
         TCoreProjectDatasource obj = new TCoreProjectDatasource();
         obj.setSystemsource_id(((TCoreProjectDatasource)dataSourceIdList.get(i)).getId());
         obj.setProject_id(id);
         obj.setSystemstyle(((TCoreProjectDatasource)dataSourceIdList.get(i)).getSystemstyle());
         this.tCoreProjectDatasourceDao.save(obj);
      }

      for(TCoreDatasourceSchema schema : vo.getSchemalist()) {
         schema.setProjectid(id);
         this.tCoreDataSourceSchemaDao.save(schema);
      }

      for(int i = 0; i < areaAndRuleList.size(); ++i) {
         TCoreProjectFindrule obj = new TCoreProjectFindrule();
         obj.setDataarea_id(((TCoreProjectFindrule)areaAndRuleList.get(i)).getDataarea_id());
         obj.setProject_id(id);
         obj.setRule_id(((TCoreProjectFindrule)areaAndRuleList.get(i)).getRule_id());
         obj.setRulestyle(((TCoreProjectFindrule)areaAndRuleList.get(i)).getRulestyle());
         obj.setDefaultrule(((TCoreProjectFindrule)areaAndRuleList.get(i)).getDefaultrule());
         this.tCoreProjectFindruleDao.save(obj);
      }

      this.tCoreDataProjectDao.update(project);
   }

   public String queryEdtionIdByProId(String projectid) {
      return this.tCoreDataProjectDao.queryEdtionIdByProId(projectid);
   }

   public List<Map<String, Object>> selectFindRuleById(String projectid) {
      List<Map<String, Object>> list = this.tCoreProjectFindruleDao.selectFindRuleCount(projectid);
      return list;
   }

   public boolean checkDatasystemName(String name, String projectId) {
      List<TCoreDataProject> projectList = this.tCoreDataProjectDao.queryAll(new Criterion[]{Restrictions.eq("project", name), Restrictions.ne("id", projectId)});
      return projectList.size() > 0;
   }
}
