package com.chenyang.nse.bussiness.service.info.impl;

import com.chenyang.nse.bussiness.commmon.EncodingDetect;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.core.EngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreConfigDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemengineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEngineDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreEnginefolderDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreImporttaskDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreMaskingruleDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreMaskingtaskDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSubsetcolumnsDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSubsettaskDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructureDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurespliterDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurewidthDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingFilecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingFilesystemDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingHiveDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingHivecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingRuleinfoDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTableDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreMaskingTablecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreSyncKeyindexDao;
import com.chenyang.nse.bussiness.dao.table.core.temporary.TCoreMonitorTemporaryDao;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.GetAllFoldersWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LoginWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.LogoutWebService;
import com.chenyang.nse.bussiness.engine.infa.basic.webservice.SessionBean;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.FOLDER;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.POWERMART;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.REPOSITORY;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.bakdata.MakeBakUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.isomerdata.MakeIsomerUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.maskdata.ParamBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.CommonBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.FlatFileBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.MappingPramaBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.MappletMakeDatabean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.ModifyImportFile;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.SourceBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.TargetBean;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.DateUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.InfoExecUtil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.ToObjutil;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.targetforhive.MakeTargetHiveUtil;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreConfig;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystemengine;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEnginefolder;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreImporttask;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSubsetcolumns;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSubsettask;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurespliter;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurewidth;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingFilecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingFilesystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingHive;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingHivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRuleinfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreSyncKeyindex;
import com.chenyang.nse.bussiness.entity.orm.table.core.temporary.TCoreMonitorTemporary;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.EmaskingDirection;
import com.chenyang.nse.bussiness.enumeration.EmaskingTaskType;
import com.chenyang.nse.bussiness.service.core.AllwaysMonitorService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.info.InfoService;
import com.chenyang.nse.bussiness.service.info.tool.InfoTool;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.io.PipeTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MysqlLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.SqlServerBcpTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.SybaseIQLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.TeradataLoadTableTool;
import com.chenyang.nse.bussiness.tools.jdbc.TeradataTool;
import com.chenyang.nse.bussiness.tools.net.FtpTool;
import com.chenyang.nse.bussiness.tools.net.SFTPUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@EnableAsync
@Service
@Transactional
public class InfoServiceImpl implements InfoService {
   @Autowired
   private InfoTool infoTool;
   @Autowired
   private TCoreDatasystemengineDao tCoreDatasystemengineDao;
   @Autowired
   private TCoreEngineDao tCoreEngineDao;
   @Autowired
   private EngineDao engineDao;
   @Autowired
   private TCoreMaskingruleDao tCoreMakingruleDao;
   @Autowired
   private TCoreMaskingtaskDao tCoreMaskingtaskDao;
   @Autowired
   private TCoreMaskingTableDao tCoreMaskingtableDao;
   @Autowired
   private TCoreMaskingTablecolumnDao tCoreMaskingTablecolumnDao;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TCoreEnginefolderDao tCoreEnginefolderDao;
   @Autowired
   private TCoreMaskingFilesystemDao tCoreMaskingFilesystemDao;
   @Autowired
   private TCoreFileStructureDao tCoreFileStructureDao;
   @Autowired
   private TCoreFileStructurespliterDao tCoreFileStructurespliterDao;
   @Autowired
   private TCoreFileStructurecolumnDao tCoreFileStructurecolumnDao;
   @Autowired
   private TCoreMaskingFilecolumnDao tCoreMaskingFilecolumnDao;
   @Autowired
   private TCoreFileStructurewidthDao tCoreFileStructurewidthDao;
   @Autowired
   private TCoreMonitorTemporaryDao tCoreMonitorTemporaryDao;
   @Autowired
   private ToObjutil to;
   @Autowired
   private TCoreImporttaskDao tCoreImporttaskDao;
   @Autowired
   private TCoreSubsettaskDao tCoreSubsettaskDao;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private TCoreSubsetcolumnsDao tCoreSubsetcolumnsDao;
   @Autowired
   private TCoreMaskingRuleinfoDao tCoreMaskingRuleinfoDao;
   @Autowired
   private TCoreSyncKeyindexDao tCoreSyncKeyindexDao;
   @Autowired
   private AllwaysMonitorService allwaysMonitorService;
   @Autowired
   private TCoreMaskingHiveDao tCoreMaskingHiveDao;
   @Autowired
   private TCoreMaskingHivecolumnDao tCoreMaskingHivecolumnDao;
   @Autowired
   private TCoreConfigDao tCoreConfigDao;
   private String path = "/data/infa_file/";

   public TCoreDatasystemengine getDatasystemEngine(String datasystemid, String engineid) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      List<TCoreDatasystemengine> list = this.tCoreDatasystemengineDao.queryAll(new Criterion[]{Restrictions.eq("datasystemid", datasystemid), Restrictions.eq("engineid", engineid)});
      if (list != null && list.size() > 0) {
         return (TCoreDatasystemengine)list.get(0);
      } else {
         TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
         TCoreDatasystemengine datasystemEngine = new TCoreDatasystemengine();
         datasystemEngine.setDatasystemid(datasystemid);
         datasystemEngine.setEngineid(engineid);
         datasystemEngine.setId(StringTool.getTablePrimaryKey());
         datasystemEngine.setDblinkname(datasystem.getSysname());
         this.tCoreDatasystemengineDao.save(datasystemEngine);
         datasystemEngine = (TCoreDatasystemengine)this.tCoreDatasystemengineDao.get(datasystemEngine.getId());

         try {
            if ("UTF-8".equals(datasystem.getPagecode())) {
               if (datasystem.getConnectmode().equals("0")) {
                  InfoExecUtil.createDb(engine.getPmrepexepath(), datasystem.getDbtype(), datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "UTF-8");
               } else {
                  InfoExecUtil.createDb(engine.getPmrepexepath(), "ODBC", datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "UTF-8");
               }
            } else if (datasystem.getConnectmode().equals("0")) {
               InfoExecUtil.createDb(engine.getPmrepexepath(), datasystem.getDbtype(), datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "MS936");
            } else {
               InfoExecUtil.createDb(engine.getPmrepexepath(), "ODBC", datasystem.getUsername(), "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword(), datasystem.getDblinkname(), datasystem.getDblinkname(), "MS936");
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         return datasystemEngine;
      }
   }

   public TCoreMaskingRule queryMaskingRuleById(String id) {
      TCoreMaskingRule rule = (TCoreMaskingRule)this.tCoreMakingruleDao.get(id);
      return rule;
   }

   public TCoreEnginefolder getEngineFolder(String datasourceid, String datatargetid, String engineid, String foldername) {
      List<TCoreEnginefolder> list = this.tCoreEnginefolderDao.queryAll(new Criterion[]{Restrictions.eq("datasourceid", datasourceid), Restrictions.eq("datatargetid", datatargetid), Restrictions.eq("engineid", engineid)});
      if (list != null && list.size() > 0) {
         return (TCoreEnginefolder)list.get(0);
      } else {
         TCoreEnginefolder engineFolder = new TCoreEnginefolder();
         engineFolder.setDatasourceid(datasourceid);
         engineFolder.setDatatargetid(datatargetid);
         engineFolder.setEngineid(engineid);
         engineFolder.setFoldername(foldername);
         engineFolder.setId(StringTool.getTablePrimaryKey());
         this.tCoreEnginefolderDao.save(engineFolder);
         engineFolder = (TCoreEnginefolder)this.tCoreEnginefolderDao.get(engineFolder.getId());
         TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
         Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
         InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

         try {
            if (!this.isFolderExist(engineid, engineFolder.getFoldername())) {
               try {
                  InfoExecUtil.execreatfolder(engine.getPmrepexepath(), engineFolder.getFoldername());
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         return engineFolder;
      }
   }

   public void generateMaskingTask(String maskingtableid) {
   }

   public void executeMaskingTask(String maskingtableid) {
   }

   public void generateDataCopyTask(String maskingtableid) {
   }

   public void generateDataCopyTaskMulti(String taskid) {
   }

   public List<String> getAllFolder(String engineId) {
      return null;
   }

   public boolean importMutilMapping(String taskid) {
      return false;
   }

   public boolean isEngineRun(String engineid) {
      return false;
   }

   public List<String> queryFolderList(String engineid) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      List<String> list = new ArrayList();

      try {
         String login_str = LoginWebService.returnStatus(engine);
         if (!"FAIL".equals(login_str)) {
            String fold_str = GetAllFoldersWebService.returnStatus(login_str, engine);
            LogoutWebService.returnStatus(login_str, engine);

            for(int i = 0; i < fold_str.split(",").length; ++i) {
               list.add(fold_str.split(",")[i]);
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return list;
   }

   public boolean isFolderExist(String engineid, String foldername) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         String login_str = LoginWebService.returnStatus(engine);
         if ("FAIL".equals(login_str)) {
            return true;
         } else {
            String fold_str = GetAllFoldersWebService.returnStatus(login_str, engine);
            LogoutWebService.returnStatus(login_str, engine);
            List<String> list = new ArrayList();

            for(int i = 0; i < fold_str.split(",").length; ++i) {
               list.add(fold_str.split(",")[i]);
            }

            return list.contains(foldername);
         }
      } catch (Exception e) {
         e.printStackTrace();
         return true;
      }
   }

   public boolean createFolderInEngine(String engineid, String foldername) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         String text = InfoExecUtil.execreatfolder(engine.getPmrepexepath(), foldername);
         return text.contains("successfully") || text.contains("成功");
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   public boolean isLinkExist(String engineid, String linkname) {
      return false;
   }

   public boolean createLinkInEngine(String engineid, String linkname) {
      return false;
   }

   public boolean importMapping(String taskid, String filename, String quick) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
      File file = new File(con_file);
      ModifyImportFile mi = new ModifyImportFile();

      try {
         String path = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname() + File.separator + filename + ".xml";
         System.out.println("path" + path);
         List<String> filelist = FileTool.getPathFile(path);
         InputStream is = new FileInputStream(path);
         BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
         int k = 0;
         StringBuffer tStringBuffer = new StringBuffer();
         new String("");

         String sTempOneLine;
         while((sTempOneLine = tBufferedReader.readLine()) != null) {
            ++k;
            if (k == 2) {
               tStringBuffer.append("");
            } else {
               tStringBuffer.append(sTempOneLine);
            }
         }

         ToObjutil var10000 = this.to;
         Object obj = ToObjutil.unmarshalmo("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean", tStringBuffer.toString());
         POWERMART powermart = (POWERMART)obj;
         REPOSITORY pre = (REPOSITORY)powermart.getREPOSITORY().get(0);
         FOLDER folder = (FOLDER)pre.getFOLDER().get(0);
         ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, task.getFdname());
         ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, folder.getNAME());
         ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, engine.getRepository());
         ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, pre.getNAME());
         if (!quick.equals("true")) {
            System.out.println("++++++++start+++++++++++");
            InfoExecUtil.executImport(engine.getPmrepexepath(), path, file.toString(), engine.getXmldir() + File.separator + "log.txt");
            System.out.println("++++++++end+++++++++++");
         }
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }

      return Boolean.TRUE;
   }

   public boolean importSubMapping(String taskid) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
      File file = new File(con_file);
      ModifyImportFile mi = new ModifyImportFile();

      try {
         String path = engine.getXmldir() + File.separator + task.getTaskname() + File.separator + task.getTaskname() + ".xml";
         List<String> filelist = FileTool.getPathFile(path);
         InputStream is = new FileInputStream(path);
         BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
         int k = 0;
         StringBuffer tStringBuffer = new StringBuffer();
         new String("");

         String sTempOneLine;
         while((sTempOneLine = tBufferedReader.readLine()) != null) {
            ++k;
            if (k == 2) {
               tStringBuffer.append("");
            } else {
               tStringBuffer.append(sTempOneLine);
            }
         }

         ToObjutil var10000 = this.to;
         Object obj = ToObjutil.unmarshalmo("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean", tStringBuffer.toString());
         POWERMART powermart = (POWERMART)obj;
         REPOSITORY pre = (REPOSITORY)powermart.getREPOSITORY().get(0);
         FOLDER folder = (FOLDER)pre.getFOLDER().get(0);
         ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, task.getFdname());
         ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, folder.getNAME());
         ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, engine.getRepository());
         ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, pre.getNAME());
         System.out.println("++++++++start+++++++++++");
         InfoExecUtil.executImport(engine.getPmrepexepath(), path, file.toString(), engine.getXmldir() + File.separator + "log.txt");
         System.out.println("++++++++end+++++++++++");
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }

      return Boolean.TRUE;
   }

   public boolean importimpMapping(String taskid) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreImporttask timptask = (TCoreImporttask)this.tCoreImporttaskDao.queryUnique(new Criterion[]{Restrictions.eq("taskname", task.getTaskname())});
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
      File file = new File(con_file);
      ModifyImportFile mi = new ModifyImportFile();

      try {
         String path = engine.getXmldir() + File.separator + task.getTaskname() + File.separator + timptask.getFilepath() + ".xml";
         System.out.println("path" + path);
         List<String> filelist = FileTool.getPathFile(path);
         InputStream is = new FileInputStream(path);
         BufferedReader tBufferedReader = new BufferedReader(new InputStreamReader(is));
         int k = 0;
         StringBuffer tStringBuffer = new StringBuffer();
         new String("");

         String sTempOneLine;
         while((sTempOneLine = tBufferedReader.readLine()) != null) {
            ++k;
            if (k == 2) {
               tStringBuffer.append("");
            } else {
               tStringBuffer.append(sTempOneLine);
            }
         }

         ToObjutil var10000 = this.to;
         Object obj = ToObjutil.unmarshalmo("com.chenyang.nse.bussiness.engine.infa.basic.xmlbean", tStringBuffer.toString());
         POWERMART powermart = (POWERMART)obj;
         REPOSITORY pre = (REPOSITORY)powermart.getREPOSITORY().get(0);
         FOLDER folder = (FOLDER)pre.getFOLDER().get(0);
         ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, task.getFdname());
         ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, folder.getNAME());
         ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, engine.getRepository());
         ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, pre.getNAME());
         System.out.println("++++++++start+++++++++++");
         InfoExecUtil.executImport(engine.getPmrepexepath(), path, file.toString(), engine.getXmldir() + File.separator + "log.txt");
         System.out.println("++++++++end+++++++++++");
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }

      return Boolean.TRUE;
   }

   public boolean executeMapping(String taskid) {
      return false;
   }

   public boolean executeSubMapping(String taskid) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         String text = InfoExecUtil.executWorkflow(info.getPmcmdexepath(), task.getFdname(), info.getInteservicename(), info.getDomainname(), info.getUsername(), info.getPassword(), "wf_" + task.getTaskname());
         return text.contains("successfully");
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   public Map<String, Object> executeTaskFileTODBMasking(TCoreMaskingTask task, String userid, String filesysid, long groupId, String quick) throws Exception {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      Map<String, Object> remap = new HashMap();
      if (task.getFlag().equals(EmaskingTaskType.FILE_TO_DB.getFlag())) {
         TCoreMaskingFilesystem tcoremaskingfilesystem = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.get(filesysid);
         TCoreFileStructure tcorefilestructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(tcoremaskingfilesystem.getStructureid());
         ParamBean par_bean = new ParamBean();
         SourceBean sou_bean = new SourceBean();
         TargetBean tar_bean = new TargetBean();
         FlatFileBean flatfile = new FlatFileBean();
         if ("0".equals(tcorefilestructure.getSplitertype())) {
            TCoreFileStructurespliter tcorefilestructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
            flatfile.setSkiprows(tcorefilestructure.getSkiprows());
            flatfile.setDelimited("YES");
            flatfile.setDelimiters(tcorefilestructurespliter.getDelimiters());
            flatfile.setMultidelimitersasand(tcorefilestructurespliter.getMultidelimitersasand());
            flatfile.setQuote_character(tcorefilestructurespliter.getQuotecharacter());
            flatfile.setRowdelimiter(tcorefilestructurespliter.getRowdelimiter());
            flatfile.setEscape_character(tcorefilestructurespliter.getEscapecharacter());
            flatfile.setKeepescapechar(tcorefilestructurespliter.getKeepescapechar());
            sou_bean.setFileparam("1");
         } else {
            TCoreFileStructurewidth width = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
            flatfile.setSkiprows(tcorefilestructure.getSkiprows());
            flatfile.setLinesequential(width.getLinesequential());
            flatfile.setNullchartype(width.getNullchartype());
            flatfile.setNull_character(width.getNullcharacter());
            flatfile.setRepeatable(width.getRepeatable());
            flatfile.setPadbytes(width.getPadbytes());
            flatfile.setShiftsensitivedata(width.getShiftsensitivedata());
            flatfile.setStriptrailingblanks(width.getStriptrailingblanks());
         }

         sou_bean.setFilebean(flatfile);
         List<MappletMakeDatabean> mapplet = new ArrayList();
         List<MappingPramaBean> paramList = null;
         sou_bean.setSo_ownname("");
         sou_bean.setBusinessname("");
         sou_bean.setDatabasetype("Flat File");
         sou_bean.setLinkname("");
         sou_bean.setDbdname("");
         sou_bean.setVersionnumber("1");
         sou_bean.setObjectversion("1");
         sou_bean.setDescripion("");
         sou_bean.setSourceownername("");
         TCoreMaskingTable table = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", tcoremaskingfilesystem.getMappingkey())});
         TCoreDatasystem datatarget = (TCoreDatasystem)this.tCoreDatasystemDao.get(table.getDatasystemid());
         if ("MYSQL".equals(datatarget.getDbtype())) {
            this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
            tar_bean.setLinkname(datatarget.getDblinkname());
            tar_bean.setDbdname(datatarget.getDblinkname());
         } else if ("MSSQLSERVER".equals(datatarget.getDbtype())) {
            this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
            tar_bean.setLinkname(datatarget.getDblinkname());
            tar_bean.setDbdname(datatarget.getDblinkname());
         } else if ("AS400".equals(datatarget.getDbtype())) {
            this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
            tar_bean.setLinkname(datatarget.getDblinkname());
            tar_bean.setDbdname(datatarget.getDblinkname());
         } else if ("INFORMIX".equals(datatarget.getDbtype())) {
            this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
            tar_bean.setLinkname(datatarget.getDblinkname());
            tar_bean.setDbdname(datatarget.getDblinkname());
         } else if ("SYBASE".equals(datatarget.getDbtype())) {
            this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
            tar_bean.setLinkname(datatarget.getDblinkname());
            tar_bean.setDbdname(datatarget.getDblinkname());
         } else {
            this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
            tar_bean.setLinkname(datatarget.getDblinkname());
            tar_bean.setDbdname(datatarget.getDblinkname());
         }

         tar_bean.setTar_name(table.getTablename());
         tar_bean.setBusinessname("");
         tar_bean.setConstraint("");
         tar_bean.setDatabasetype(datatarget.getDbtype());
         tar_bean.setVersionnumber("1");
         tar_bean.setObjectversion("1");
         tar_bean.setDescripion("");
         tar_bean.setTargetownername(table.getDbschema());
         tar_bean.setInserttype(task.getInserttype());
         tar_bean.setConnectmode(datatarget.getConnectmode());
         List<TCoreMaskingFilecolumn> tcoremaskingfilesystemlist = this.tCoreMaskingFilecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("filesystemid", tcoremaskingfilesystem.getId())});
         CommonBean cb = new CommonBean();
         List<String> keytype = new ArrayList();
         List<String> nameList = new ArrayList();
         List<String> typeList = new ArrayList();
         List<String> lengthList = new ArrayList();
         List<String> precisionList = new ArrayList();
         List<String> scalelist = new ArrayList();
         List<String> formatlist = new ArrayList();
         CommonBean tcb = new CommonBean();
         List<String> tkeytype = new ArrayList();
         List<String> tnameList = new ArrayList();
         List<String> ttypeList = new ArrayList();
         List<String> tlengthList = new ArrayList();
         List<String> tprecisionList = new ArrayList();
         List<String> tscalelist = new ArrayList();
         List<String> judgelist = new ArrayList();

         for(TCoreMaskingFilecolumn list : tcoremaskingfilesystemlist) {
            TCoreFileStructurecolumn ckj = (TCoreFileStructurecolumn)this.tCoreFileStructurecolumnDao.get(list.getStructurecolumnid());
            keytype.add("NOT A KEY");
            nameList.add(ckj.getColumnname());
            typeList.add(ckj.getColumntype());
            lengthList.add(ckj.getColumnaccuracy());
            scalelist.add(ckj.getColumndecimal());
            precisionList.add(ckj.getColumnaccuracy());
            if (ckj.getColumnformat() != null && !"".equals(ckj.getColumnformat())) {
               formatlist.add("F  29 " + ckj.getColumnformat());
            } else {
               formatlist.add("");
            }

            cb.setKeytype(keytype);
            cb.setLengthList(lengthList);
            cb.setNameList(nameList);
            cb.setPrecisionList(precisionList);
            cb.setScalelist(scalelist);
            cb.setTypeList(typeList);
            cb.setDateformatlist(formatlist);
            sou_bean.setCb(cb);
            TCoreMaskingTablecolumn tablecolumn = (TCoreMaskingTablecolumn)this.tCoreMaskingTablecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("mappingkey", list.getMappingkey()), Restrictions.eq("taskid", task.getId())});
            if ("1".equals(tablecolumn.getPrimarykey())) {
               tkeytype.add("PRIMARY KEY");
            } else {
               tkeytype.add("NOT A KEY");
            }

            if ("NUMBER".equalsIgnoreCase(tablecolumn.getColumntype()) && !"-127".equals(tablecolumn.getColumnscale())) {
               tablecolumn.setColumntype("number(p,s)");
            }

            tnameList.add(tablecolumn.getColumnname());
            ttypeList.add(tablecolumn.getColumntype());
            tlengthList.add(tablecolumn.getColumnlength());
            tscalelist.add(tablecolumn.getColumnscale());
            tprecisionList.add(tablecolumn.getColumnlength());
            judgelist.add(tablecolumn.getJudgenull());
            tcb.setKeytype(tkeytype);
            tcb.setLengthList(lengthList);
            tcb.setNameList(tnameList);
            tcb.setPrecisionList(tprecisionList);
            tcb.setScalelist(tscalelist);
            tcb.setTypeList(ttypeList);
            tcb.setJudgelist(judgelist);
            if (list.getRuleid() != null && !"".equals(list.getRuleid())) {
               TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", list.getRuleid())});
               if (rule != null) {
                  mapplet.add(new MappletMakeDatabean(ckj.getColumnname(), rule.getMappletname(), tablecolumn.getColumnname()));
               }
            }

            tar_bean.setCb(tcb);
         }

         par_bean.setTaskname(task.getTaskname());
         par_bean.setFoldername(task.getFdname());
         par_bean.setOwner("");
         par_bean.setGroup("");
         par_bean.setParam_path("");
         par_bean.setPower_repository_version("184.93");
         par_bean.setCodepage("UTF-8");
         par_bean.setRepository_version("184");
         String note = "";
         if (!"0".equals(tcoremaskingfilesystem.getLocation())) {
            String dir = "d" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss") + ".txt";
            TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(tcoremaskingfilesystem.getFtpid());
            if (tcoremaskingfilesystem.getLocation().equals("1")) {
               String username = datasystem.getUsername();
               String password = datasystem.getPassword();
               String host = datasystem.getDbip();
               Integer port = Integer.parseInt(datasystem.getDbport());
               boolean flag = false;
               String directory = tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag();
               String wildcard = tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote();
               flag = FtpTool.downFile(host, port, username, password, directory, wildcard, this.path + dir);
               if (!flag) {
                  return null;
               }

               note = dir;
            } else if (tcoremaskingfilesystem.getLocation().equals("2")) {
               String username = datasystem.getUsername();
               String password = datasystem.getPassword();
               String host = datasystem.getDbip();
               Integer port = Integer.parseInt(datasystem.getDbport());
               SFTPUtil sftp = new SFTPUtil(username, password, host, port);
               ResultVO resultvo = SFTPUtil.login();
               boolean b = resultvo.getResult();
               if (!b) {
                  return null;
               }

               try {
                  String directory = tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag();
                  String wildcard = tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote();
                  sftp.download(directory, wildcard, this.path + dir);
                  note = dir;
               } catch (Exception var51) {
                  return null;
               }

               sftp.logout();
            }

            tcoremaskingfilesystem.setFlag(tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag());
            tcoremaskingfilesystem.setNote(tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote());
            tcoremaskingfilesystem.setDirectory("");
            tcoremaskingfilesystem.setWildcard(dir);
         }

         sou_bean.setIsftp("0");
         sou_bean.setFtplink("");
         sou_bean.setFilepath(this.path + tcoremaskingfilesystem.getDirectory());
         sou_bean.setFiledirect("Indirect");
         File f = new File(this.path + tcoremaskingfilesystem.getDirectory());
         List<String> resultFileName = new ArrayList();
         List<String> filelist = FileTool.ergodicreg(f, resultFileName, tcoremaskingfilesystem.getWildcard());
         String dir = DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
         FileTool.createFile(this.path + tcoremaskingfilesystem.getDirectory() + File.separator + "direct" + dir + ".txt");
         sou_bean.setSo_name("file_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
         StringBuffer sb = new StringBuffer();

         for(int i = 0; i < filelist.size(); ++i) {
            sb.append((String)filelist.get(i) + "\r\n");
         }

         String sourcefilecode = tcoremaskingfilesystem.getSourcefilecode();
         sourcefilecode = this.getFileCode(filelist, sourcefilecode);
         sou_bean.getFilebean().setCodepage(sourcefilecode);
         System.out.println(">>>>>>>>>>>>end脱敏文件 的编码格式为：" + sourcefilecode + ">>>>>>>>>>>>>");

         try {
            RandomAccessFile mm = null;
            System.out.println(this.path + tcoremaskingfilesystem.getDirectory() + File.separator + "direct" + dir + ".txt");
            mm = new RandomAccessFile(this.path + tcoremaskingfilesystem.getDirectory() + File.separator + "direct" + dir + ".txt", "rw");
            mm.writeBytes(sb.toString());
            mm.close();
         } catch (Exception var50) {
            return null;
         }

         sou_bean.setFilename("direct" + dir + ".txt");
         TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
         if ("ORACLE".equals(repdata.getDbtype())) {
            par_bean.setRepository_dbtype("Oracle");
         } else if ("DB2".equals(repdata.getDbtype())) {
            par_bean.setRepository_dbtype("Db2");
         }

         par_bean.setShard("NOTSHARED");
         MakeIsomerUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList, task.getIstruncate());
         if (!quick.equals("true")) {
            this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
         }

         TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
         temporay.setGroupid(groupId);
         temporay.setCreatetime(new Date());
         temporay.setTargetname(tar_bean.getTar_name());
         temporay.setSourcename(sou_bean.getSo_name().split("_")[0]);
         temporay.setTaskid(task.getId());
         temporay.setType("文件>数据库");
         temporay.setWfname(sou_bean.getSo_name());
         this.tCoreMonitorTemporaryDao.save(temporay);
         Map<String, String> parametermap = new HashMap();
         parametermap.put("filepath", this.path);
         parametermap.put("filename", note);
         parametermap.put("type", "2");
         parametermap.put("datasystenid", tcoremaskingfilesystem.getFtpid());
         parametermap.put("netfilepath", tcoremaskingfilesystem.getDirectory());
         parametermap.put("netfilename", tcoremaskingfilesystem.getWildcard());
         if (!quick.equals("true")) {
            this.executeFileTaskMasking(task, sou_bean.getSo_name(), userid, temporay, parametermap);
         }

         remap.put("so_name", sou_bean.getSo_name());
         remap.put("temporay", temporay);
         remap.put("parametermap", parametermap);
      }

      return remap;
   }

   public boolean executeTaskFileTOFileMasking(TCoreMaskingTask task, String userid, String mappingkey, long groupId) throws Exception {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      if (task.getFlag().equals(EmaskingTaskType.FILE_TO_FILE.getFlag())) {
         CommonBean cb = new CommonBean();
         List<String> keytype = new ArrayList();
         List<String> nameList = new ArrayList();
         List<String> typeList = new ArrayList();
         List<String> lengthList = new ArrayList();
         List<String> precisionList = new ArrayList();
         List<String> scalelist = new ArrayList();
         List<String> formatlist = new ArrayList();
         CommonBean tcb = new CommonBean();
         List<String> tkeytype = new ArrayList();
         List<String> tnameList = new ArrayList();
         List<String> ttypeList = new ArrayList();
         List<String> tlengthList = new ArrayList();
         List<String> tprecisionList = new ArrayList();
         List<String> tscalelist = new ArrayList();
         List<String> tformatlist = new ArrayList();
         TCoreMaskingFilesystem sfile = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0"), Restrictions.eq("mappingkey", mappingkey)});
         TCoreMaskingFilesystem tfile = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "1"), Restrictions.eq("mappingkey", mappingkey)});
         TCoreFileStructure sscorefilestructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(sfile.getStructureid());
         TCoreFileStructure tscorefilestructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(tfile.getStructureid());
         ParamBean par_bean = new ParamBean();
         new SourceBean();
         new TargetBean();
         FlatFileBean flatfile = new FlatFileBean();
         FlatFileBean tflatfile = new FlatFileBean();
         List<MappletMakeDatabean> mapplet = new ArrayList();
         List<MappingPramaBean> paramList = null;
         SourceBean sou_bean = new SourceBean();
         sou_bean.setSo_ownname("");
         sou_bean.setBusinessname("");
         sou_bean.setDatabasetype("Flat File");
         sou_bean.setLinkname("");
         sou_bean.setDbdname("");
         sou_bean.setVersionnumber("1");
         sou_bean.setObjectversion("1");
         sou_bean.setDescripion("");
         if ("0".equals(sscorefilestructure.getSplitertype())) {
            TCoreFileStructurespliter tcorefilestructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", sscorefilestructure.getId())});
            if ("0".equalsIgnoreCase(sscorefilestructure.getCodepage())) {
               flatfile.setCodepage("utf-8");
            } else if ("1".equalsIgnoreCase(sscorefilestructure.getCodepage())) {
               flatfile.setCodepage("ms936");
            } else if ("2".equalsIgnoreCase(sscorefilestructure.getCodepage())) {
               flatfile.setCodepage("ms950");
            }

            flatfile.setSkiprows(sscorefilestructure.getSkiprows());
            flatfile.setDelimited("YES");
            flatfile.setDelimiters(tcorefilestructurespliter.getDelimiters());
            flatfile.setMultidelimitersasand(tcorefilestructurespliter.getMultidelimitersasand());
            flatfile.setQuote_character(tcorefilestructurespliter.getQuotecharacter());
            flatfile.setRowdelimiter(tcorefilestructurespliter.getRowdelimiter());
            flatfile.setEscape_character(tcorefilestructurespliter.getEscapecharacter());
            flatfile.setKeepescapechar(tcorefilestructurespliter.getKeepescapechar());
            sou_bean.setFileparam("1");
         } else {
            TCoreFileStructurewidth width = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", sscorefilestructure.getId())});
            if ("0".equalsIgnoreCase(sscorefilestructure.getCodepage())) {
               flatfile.setCodepage("utf-8");
            } else if ("1".equalsIgnoreCase(sscorefilestructure.getCodepage())) {
               flatfile.setCodepage("ms936");
            } else if ("2".equalsIgnoreCase(sscorefilestructure.getCodepage())) {
               flatfile.setCodepage("ms950");
            }

            flatfile.setSkiprows(sscorefilestructure.getSkiprows());
            flatfile.setLinesequential(width.getLinesequential());
            flatfile.setNullchartype(width.getNullchartype());
            flatfile.setNull_character(width.getNullcharacter());
            flatfile.setRepeatable(width.getRepeatable());
            flatfile.setPadbytes(width.getPadbytes());
            flatfile.setShiftsensitivedata(width.getShiftsensitivedata());
            flatfile.setStriptrailingblanks(width.getStriptrailingblanks());
         }

         sou_bean.setFilebean(flatfile);
         TargetBean tar_bean = new TargetBean();
         String tarname = tfile.getWildcard();
         tar_bean.setTar_name(tarname.split("\\.")[0] + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
         tar_bean.setBusinessname("");
         tar_bean.setDatabasetype("Flat File");
         tar_bean.setLinkname("");
         tar_bean.setDbdname("");
         tar_bean.setVersionnumber("1");
         tar_bean.setObjectversion("1");
         tar_bean.setDescripion("");
         tar_bean.setFilename(tfile.getWildcard());
         tar_bean.setFilepath(tfile.getDirectory());
         if ("0".equals(tscorefilestructure.getSplitertype())) {
            TCoreFileStructurespliter tcorefilestructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tscorefilestructure.getId())});
            if ("0".equalsIgnoreCase(tscorefilestructure.getCodepage())) {
               tflatfile.setCodepage("utf-8");
            } else if ("1".equalsIgnoreCase(tscorefilestructure.getCodepage())) {
               tflatfile.setCodepage("ms936");
            } else if ("2".equalsIgnoreCase(tscorefilestructure.getCodepage())) {
               tflatfile.setCodepage("ms950");
            }

            tflatfile.setSkiprows(tscorefilestructure.getSkiprows());
            tflatfile.setDelimited("YES");
            tflatfile.setDelimiters(tcorefilestructurespliter.getDelimiters());
            tflatfile.setMultidelimitersasand(tcorefilestructurespliter.getMultidelimitersasand());
            tflatfile.setQuote_character(tcorefilestructurespliter.getQuotecharacter());
            tflatfile.setRowdelimiter(tcorefilestructurespliter.getRowdelimiter());
            tflatfile.setEscape_character(tcorefilestructurespliter.getEscapecharacter());
            tflatfile.setKeepescapechar(tcorefilestructurespliter.getKeepescapechar());
            tar_bean.setFileparam("1");
         } else {
            TCoreFileStructurewidth width = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tscorefilestructure.getId())});
            if ("0".equalsIgnoreCase(tscorefilestructure.getCodepage())) {
               tflatfile.setCodepage("utf-8");
            } else if ("1".equalsIgnoreCase(tscorefilestructure.getCodepage())) {
               tflatfile.setCodepage("ms936");
            } else if ("2".equalsIgnoreCase(tscorefilestructure.getCodepage())) {
               tflatfile.setCodepage("ms950");
            }

            tflatfile.setSkiprows(tscorefilestructure.getSkiprows());
            tflatfile.setLinesequential(width.getLinesequential());
            tflatfile.setNullchartype(width.getNullchartype());
            tflatfile.setNull_character(width.getNullcharacter());
            tflatfile.setRepeatable(width.getRepeatable());
            tflatfile.setPadbytes(width.getPadbytes());
            tflatfile.setShiftsensitivedata(width.getShiftsensitivedata());
            tflatfile.setStriptrailingblanks(width.getStriptrailingblanks());
         }

         tar_bean.setFilebean(tflatfile);

         for(TCoreMaskingFilecolumn list : this.tCoreMaskingFilecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("filesystemid", sfile.getId())})) {
            TCoreFileStructurecolumn ckj = (TCoreFileStructurecolumn)this.tCoreFileStructurecolumnDao.get(list.getStructurecolumnid());
            TCoreMaskingFilecolumn filecolumn = (TCoreMaskingFilecolumn)this.tCoreMaskingFilecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("mappingkey", list.getMappingkey()), Restrictions.eq("datadirection", "1")});
            keytype.add("NOT A KEY");
            nameList.add(ckj.getColumnname());
            typeList.add(ckj.getColumntype());
            lengthList.add(ckj.getColumnaccuracy());
            scalelist.add(ckj.getColumndecimal());
            precisionList.add(ckj.getColumnaccuracy());
            if (ckj.getColumnformat() != null && !"".equals(ckj.getColumnformat())) {
               formatlist.add("F  29 " + ckj.getColumnformat());
               tformatlist.add("F  29 " + ckj.getColumnformat());
            } else {
               formatlist.add("");
               tformatlist.add("");
            }

            cb.setKeytype(keytype);
            cb.setLengthList(lengthList);
            cb.setNameList(nameList);
            cb.setPrecisionList(precisionList);
            cb.setScalelist(scalelist);
            cb.setTypeList(typeList);
            cb.setDateformatlist(formatlist);
            sou_bean.setCb(cb);
            TCoreMaskingFilecolumn tfilecolumn = (TCoreMaskingFilecolumn)this.tCoreMaskingFilecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("mappingkey", filecolumn.getMappingkey()), Restrictions.eq("datadirection", "1")});
            TCoreFileStructurecolumn tfcolumn = (TCoreFileStructurecolumn)this.tCoreFileStructurecolumnDao.get(tfilecolumn.getStructurecolumnid());
            tkeytype.add("NOT A KEY");
            tnameList.add(tfcolumn.getColumnname());
            ttypeList.add(tfcolumn.getColumntype());
            tlengthList.add(tfcolumn.getColumnaccuracy());
            tscalelist.add(tfcolumn.getColumndecimal());
            tprecisionList.add(tfcolumn.getColumnaccuracy());
            tcb.setKeytype(tkeytype);
            tcb.setLengthList(lengthList);
            tcb.setNameList(tnameList);
            tcb.setPrecisionList(tprecisionList);
            tcb.setScalelist(tscalelist);
            tcb.setTypeList(ttypeList);
            tcb.setDateformatlist(tformatlist);
            if (list.getRuleid() != null && !"".equals(list.getRuleid())) {
               TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", list.getRuleid())});
               if (rule != null) {
                  mapplet.add(new MappletMakeDatabean(ckj.getColumnname(), rule.getMappletname(), tfcolumn.getColumnname()));
               }
            }

            tar_bean.setCb(tcb);
         }

         par_bean.setTaskname(task.getTaskname());
         par_bean.setFoldername(task.getFdname());
         par_bean.setOwner("");
         par_bean.setGroup("");
         par_bean.setParam_path("");
         par_bean.setPower_repository_version("184.93");
         par_bean.setCodepage("UTF-8");
         par_bean.setRepository_version("184");
         String note = "";
         String dirname = DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss") + ".txt";
         if (!"0".equals(tfile.getLocation())) {
            String dir = "wd" + dirname;
            tar_bean.setFilename(dir);
            tar_bean.setFilepath(this.path);
            note = "d" + dirname;
         } else {
            tar_bean.setFilename(tfile.getWildcard());
            tar_bean.setFilepath(this.path + tfile.getDirectory());
         }

         tar_bean.setIsftp("0");
         tar_bean.setFtplink("");
         if (!"0".equals(sfile.getLocation())) {
            String dir = "d" + dirname;
            TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(sfile.getFtpid());
            if (sfile.getLocation().equals("1")) {
               String username = datasystem.getUsername();
               String password = datasystem.getPassword();
               String host = datasystem.getDbip();
               Integer port = Integer.parseInt(datasystem.getDbport());
               boolean flag = false;
               String directory = sfile.getFlag() == null ? sfile.getDirectory() : sfile.getFlag();
               String wildcard = sfile.getNote() == null ? sfile.getWildcard() : sfile.getNote();
               flag = FtpTool.downFile(host, port, username, password, directory, wildcard, this.path + dir);
               if (!flag) {
                  return false;
               }

               note = dir;
            } else if (sfile.getLocation().equals("2")) {
               String username = datasystem.getUsername();
               String password = datasystem.getPassword();
               String host = datasystem.getDbip();
               Integer port = Integer.parseInt(datasystem.getDbport());
               SFTPUtil sftp = new SFTPUtil(username, password, host, port);
               ResultVO resultvo = SFTPUtil.login();
               boolean b = resultvo.getResult();
               if (!b) {
                  return false;
               }

               try {
                  String directory = sfile.getFlag() == null ? sfile.getDirectory() : sfile.getFlag();
                  String wildcard = sfile.getNote() == null ? sfile.getWildcard() : sfile.getNote();
                  sftp.download(directory, wildcard, this.path + dir);
                  note = dir;
               } catch (Exception var52) {
                  return false;
               }

               sftp.logout();
            }

            sfile.setFlag(sfile.getFlag() == null ? sfile.getDirectory() : sfile.getFlag());
            sfile.setNote(sfile.getNote() == null ? sfile.getWildcard() : sfile.getNote());
            sfile.setDirectory("");
            sfile.setWildcard(dir);
         }

         sou_bean.setIsftp("0");
         sou_bean.setFtplink("");
         sou_bean.setFilepath(this.path + sfile.getDirectory());
         sou_bean.setFiledirect("Indirect");
         File f = new File(this.path + sfile.getDirectory());
         List<String> resultFileName = new ArrayList();
         List<String> filelist = FileTool.ergodicreg(f, resultFileName, sfile.getWildcard());
         String dir = DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
         FileTool.createFile(this.path + sfile.getDirectory() + File.separator + "direct" + dir + ".txt");
         sou_bean.setSo_name("file_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
         StringBuffer sb = new StringBuffer();

         for(int i = 0; i < filelist.size(); ++i) {
            sb.append((String)filelist.get(i) + "\r\n");
         }

         try {
            RandomAccessFile mm = null;
            mm = new RandomAccessFile(this.path + sfile.getDirectory() + File.separator + "direct" + dir + ".txt", "rw");
            mm.writeBytes(sb.toString());
            mm.close();
         } catch (Exception var51) {
            return false;
         }

         sou_bean.setFilename("direct" + dir + ".txt");
         TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
         if ("ORACLE".equals(repdata.getDbtype())) {
            par_bean.setRepository_dbtype("Oracle");
         } else if ("DB2".equals(repdata.getDbtype())) {
            par_bean.setRepository_dbtype("Db2");
         }

         par_bean.setShard("NOTSHARED");
         List<String> fmt = sou_bean.getCb().getDateformatlist();

         for(int i = 0; i < fmt.size(); ++i) {
            if (fmt.get(i) != null && !"".equals(fmt.get(i))) {
               tar_bean.setDateformateparam((String)fmt.get(i));
               break;
            }
         }

         MakeIsomerUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList);
         this.importMapping(task.getId(), sou_bean.getSo_name(), "false");
         TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
         temporay.setGroupid(groupId);
         temporay.setCreatetime(new Date());
         temporay.setTargetname(tfile.getWildcard().split("\\.")[0]);
         temporay.setSourcename(sou_bean.getSo_name().split("_")[0]);
         temporay.setTaskid(task.getId());
         temporay.setType("文件>文件");
         temporay.setWfname(sou_bean.getSo_name());
         this.tCoreMonitorTemporaryDao.save(temporay);
         Map<String, String> parametermap = new HashMap();
         parametermap.put("filepath", this.path);
         parametermap.put("filename", note);
         parametermap.put("type", "1");
         parametermap.put("datasystenid", tfile.getFtpid());
         parametermap.put("netfilepath", tfile.getDirectory());
         parametermap.put("netfilename", tfile.getWildcard());
         this.executeFileTaskMasking(task, sou_bean.getSo_name(), userid, temporay, parametermap);
      }

      return true;
   }

   public boolean executeTeradataTaskMasking(TCoreMaskingTask task, String userid, String mappingkey, long groupId) throws Exception {
      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String taskname = task.getTaskname();
      TCoreMaskingTable sTable = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0"), Restrictions.eq("mappingkey", mappingkey)});
      String tableName = sTable.getTablename();
      TCoreMaskingTable tTable = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "1"), Restrictions.eq("mappingkey", mappingkey)});
      ParamBean par_bean = new ParamBean();
      new SourceBean();
      new TargetBean();
      FlatFileBean flatfile = new FlatFileBean();
      FlatFileBean tflatfile = new FlatFileBean();
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      SourceBean sou_bean = new SourceBean();
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setDatabasetype("Flat File");
      sou_bean.setLinkname("");
      sou_bean.setDbdname("");
      sou_bean.setVersionnumber("1");
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("TERADATA");
      flatfile.setCodepage("utf-8");
      flatfile.setSkiprows("0");
      flatfile.setDelimited("YES");
      flatfile.setDelimiters(TeradataTool.STR_COL_SPLIT_PATH);
      flatfile.setMultidelimitersasand("NO");
      flatfile.setQuote_character("double");
      flatfile.setRowdelimiter("");
      flatfile.setEscape_character("");
      flatfile.setKeepescapechar("NO");
      flatfile.setNull_character("*");
      flatfile.setNullchartype("ASCII");
      flatfile.setPadbytes("1");
      sou_bean.setFileparam("1");
      sou_bean.setFilebean(flatfile);
      TargetBean tar_bean = new TargetBean();
      String tarname = "tar_" + tableName + ".pipe";
      tar_bean.setTar_name(tarname.split("\\.")[0] + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
      tar_bean.setBusinessname("");
      tar_bean.setDatabasetype("Flat File");
      tar_bean.setLinkname("");
      tar_bean.setDbdname("");
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      tar_bean.setFilename("tar_" + tableName + ".pipe");
      tar_bean.setFilepath(TeradataTool.STR_PIPEFILE_TAR_PATH + taskname + "/");
      tflatfile.setCodepage("utf-8");
      tflatfile.setSkiprows("1");
      tflatfile.setDelimited("YES");
      String loadTableColSplit = props.get("load_table_teradata_col_split").toString();
      tflatfile.setDelimiters(loadTableColSplit);
      tflatfile.setMultidelimitersasand("NO");
      tflatfile.setQuote_character("NONE");
      tflatfile.setRowdelimiter("");
      tflatfile.setEscape_character("");
      tflatfile.setKeepescapechar("NO");
      tflatfile.setNull_character("*");
      tflatfile.setNullchartype("ASCII");
      tflatfile.setPadbytes("1");
      tar_bean.setFileparam("1");
      tar_bean.setFilebean(tflatfile);
      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      List<String> formatlist = new ArrayList();
      CommonBean tcb = new CommonBean();
      List<String> tkeytype = new ArrayList();
      List<String> tnameList = new ArrayList();
      List<String> ttypeList = new ArrayList();
      List<String> tlengthList = new ArrayList();
      List<String> tprecisionList = new ArrayList();
      List<String> tscalelist = new ArrayList();
      List<String> tformatlist = new ArrayList();

      for(TCoreMaskingTablecolumn sourceTableCol : this.tCoreMaskingTablecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("tableid", sTable.getId())})) {
         keytype.add("NOT A KEY");
         nameList.add(sourceTableCol.getColumnname());
         typeList.add("string");
         String colTypeLen = TeradataTool.teradataTypeLength(sourceTableCol.getColumntype(), sourceTableCol.getColumnlength(), sourceTableCol.getColumnscale());
         lengthList.add(colTypeLen);
         scalelist.add("");
         precisionList.add(colTypeLen);
         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         cb.setDateformatlist(formatlist);
         sou_bean.setCb(cb);
         TCoreMaskingTablecolumn targetTableCol = (TCoreMaskingTablecolumn)this.tCoreMaskingTablecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("mappingkey", sourceTableCol.getMappingkey()), Restrictions.eq("datadirection", "1")});
         tkeytype.add("NOT A KEY");
         tnameList.add(targetTableCol.getColumnname());
         ttypeList.add("string");
         tlengthList.add(colTypeLen);
         tscalelist.add("");
         tprecisionList.add(colTypeLen);
         tcb.setKeytype(tkeytype);
         tcb.setLengthList(lengthList);
         tcb.setNameList(tnameList);
         tcb.setPrecisionList(tprecisionList);
         tcb.setScalelist(tscalelist);
         tcb.setTypeList(ttypeList);
         tcb.setDateformatlist(tformatlist);
         tar_bean.setCb(tcb);
         if (sourceTableCol.getRuleid() != null && !"".equals(sourceTableCol.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", sourceTableCol.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(targetTableCol.getColumnname(), rule.getMappletname(), targetTableCol.getColumnname()));
            }
         }
      }

      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      String note = "";
      tar_bean.setIsftp("0");
      tar_bean.setFtplink("");
      sou_bean.setIsftp("0");
      sou_bean.setFtplink("");
      sou_bean.setFilepath(TeradataTool.STR_PIPEFILE_PATH + taskname + "/");
      sou_bean.setFiledirect("Direct");
      File f = new File(TeradataTool.STR_PIPEFILE_PATH + taskname + "/");
      List<String> resultFileName = new ArrayList();
      List<String> filelist = FileTool.ergodicreg(f, resultFileName, tableName);
      String dir = DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
      sou_bean.setSo_name("file_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
      StringBuffer sb = new StringBuffer();

      for(int i = 0; i < filelist.size(); ++i) {
         sb.append((String)filelist.get(i) + "\r\n");
      }

      sou_bean.setFilename(tableName + ".pipe");
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");
      List<String> fmt = sou_bean.getCb().getDateformatlist();

      for(int i = 0; i < fmt.size(); ++i) {
         if (fmt.get(i) != null && !"".equals(fmt.get(i))) {
            tar_bean.setDateformateparam((String)fmt.get(i));
            break;
         }
      }

      MakeIsomerUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList);
      this.importMapping(task.getId(), sou_bean.getSo_name(), "false");
      TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
      temporay.setGroupid(groupId);
      temporay.setCreatetime(new Date());
      temporay.setTargetname(tableName);
      temporay.setSourcename(tableName);
      temporay.setTaskid(task.getId());
      temporay.setType("数据库>数据库");
      temporay.setWfname(sou_bean.getSo_name());
      this.tCoreMonitorTemporaryDao.save(temporay);
      Map<String, String> parametermap = new HashMap();
      parametermap.put("filepath", this.path);
      parametermap.put("filename", note);
      parametermap.put("type", "1");
      parametermap.put("datasystenid", tTable.getDatasystemid());
      parametermap.put("netfilepath", TeradataTool.STR_PIPEFILE_TAR_PATH + taskname + "/");
      parametermap.put("netfilename", "tar_" + tableName);
      this.executeFileTaskMasking(task, sou_bean.getSo_name(), userid, temporay, parametermap);
      return true;
   }

   public void generateDbtoDbTaskMasking(TCoreMaskingTask task, String mappingkey, String userid, String quick) throws Exception {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      List<TCoreMaskingTablecolumn> sourceColumn = new ArrayList();
      List<TCoreMaskingTable> tlist = this.tCoreMaskingtableDao.queryAll(new Criterion[]{Restrictions.eq("mappingkey", mappingkey)});
      ParamBean par_bean = new ParamBean();
      SourceBean sou_bean = new SourceBean();
      TargetBean tar_bean = new TargetBean();
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;

      for(TCoreMaskingTable table : tlist) {
         if (EmaskingDirection.DATA_SOURCE.getFlag().equals(table.getDatadirection())) {
            TCoreDatasystem datasource = (TCoreDatasystem)this.tCoreDatasystemDao.get(table.getDatasystemid());
            sou_bean = new SourceBean();
            sou_bean.setSo_name(table.getTablename());
            sou_bean.setSo_ownname("");
            sou_bean.setBusinessname("");
            sou_bean.setFiledirect("Direct");
            sou_bean.setConnectmode(datasource.getConnectmode());
            sou_bean.setDatabasetype(datasource.getDbtype());
            if ("MYSQL".equals(datasource.getDbtype())) {
               this.getDatasystemEngine(datasource.getId(), task.getEngineid());
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            } else if ("MSSQLSERVER".equals(datasource.getDbtype())) {
               this.getDatasystemEngine(datasource.getId(), task.getEngineid());
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            } else if ("AS400".equals(datasource.getDbtype())) {
               this.getDatasystemEngine(datasource.getId(), task.getEngineid());
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            } else if ("INFORMIX".equals(datasource.getDbtype())) {
               this.getDatasystemEngine(datasource.getId(), task.getEngineid());
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            } else if ("SYBASE".equals(datasource.getDbtype())) {
               this.getDatasystemEngine(datasource.getId(), task.getEngineid());
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            } else if ("SYBASE_IQ".equals(datasource.getDbtype())) {
               this.getDatasystemEngine(datasource.getId(), task.getEngineid());
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            } else {
               this.getDatasystemEngine(datasource.getId(), task.getEngineid());
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            }

            sou_bean.setObjectversion("1");
            sou_bean.setDescripion("");
            sou_bean.setSourceownername(table.getDbschema());
            sourceColumn = this.tCoreMaskingTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("tableid", table.getId())});
         }

         if (EmaskingDirection.DATA_TARGET.getFlag().equals(table.getDatadirection())) {
            TCoreDatasystem datatarget = (TCoreDatasystem)this.tCoreDatasystemDao.get(table.getDatasystemid());
            if ("MYSQL".equals(datatarget.getDbtype())) {
               this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
               tar_bean.setLinkname(datatarget.getDblinkname());
               tar_bean.setDbdname(datatarget.getDblinkname());
            } else if ("MSSQLSERVER".equals(datatarget.getDbtype())) {
               this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
               tar_bean.setLinkname(datatarget.getDblinkname());
               tar_bean.setDbdname(datatarget.getDblinkname());
            } else if ("AS400".equals(datatarget.getDbtype())) {
               this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
               tar_bean.setLinkname(datatarget.getDblinkname());
               tar_bean.setDbdname(datatarget.getDblinkname());
            } else if ("INFORMIX".equals(datatarget.getDbtype())) {
               this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
               tar_bean.setLinkname(datatarget.getDblinkname());
               tar_bean.setDbdname(datatarget.getDblinkname());
            } else if ("SYBASE".equals(datatarget.getDbtype())) {
               this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
               tar_bean.setLinkname(datatarget.getDblinkname());
               tar_bean.setDbdname(datatarget.getDblinkname());
            } else if (!"SYBASE_IQ".equals(datatarget.getDbtype())) {
               this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
               tar_bean.setLinkname(datatarget.getDblinkname());
               tar_bean.setDbdname(datatarget.getDblinkname());
            } else {
               this.getDatasystemEngine(datatarget.getId(), task.getEngineid());
               tar_bean.setLinkname(datatarget.getDblinkname());
               tar_bean.setDbdname(datatarget.getDblinkname());
               tar_bean.setTar_name(table.getTablename() + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
               System.out.println("dymstart");
               Map<String, String> lm = new HashMap();
               lm.put("user", datatarget.getUsername());
               lm.put("pwd", "1".equals(datatarget.getFlag()) ? AesTool.decrypt(datatarget.getPassword(), "ghca") : datatarget.getPassword());
               lm.put("ip", datatarget.getDbip());
               lm.put("port", datatarget.getDbport());
               lm.put("table", table.getTablename());
               lm.put("schema", table.getDbschema());
               lm.put("path", File.separator + "data" + File.separator + "infa_sybaseiq" + File.separator + task.getTaskname() + File.separator + table.getTablename() + ".sh");
               String col = "";

               for(int i = 0; i < sourceColumn.size(); ++i) {
                  if (i != sourceColumn.size() - 1) {
                     col = col + ((TCoreMaskingTablecolumn)sourceColumn.get(i)).getColumnname() + "|" + ((TCoreMaskingTablecolumn)sourceColumn.get(i)).getColumntype() + ",";
                  } else {
                     col = col + ((TCoreMaskingTablecolumn)sourceColumn.get(i)).getColumnname() + "|" + ((TCoreMaskingTablecolumn)sourceColumn.get(i)).getColumntype();
                  }
               }

               lm.put("lm", col);
               SybaseIQLoadTableTool.executeLoadTable(lm);
               System.out.println("dymend");
            }

            tar_bean.setConnectmode(datatarget.getConnectmode());
            tar_bean.setTar_name(table.getTablename());
            tar_bean.setBusinessname("");
            tar_bean.setConstraint("");
            tar_bean.setVersionnumber("1");
            tar_bean.setObjectversion("1");
            tar_bean.setDescripion("");
            tar_bean.setDatabasetype(datatarget.getDbtype());
            tar_bean.setTargetownername(table.getDbschema());
            if ("SYBASE_IQ".equals(datatarget.getDbtype())) {
               tar_bean.setFileparam("1");
               FlatFileBean flatfile = new FlatFileBean();
               if (datatarget.getPagecode().equals("GBK")) {
                  flatfile.setCodepage("MS936");
               } else {
                  flatfile.setCodepage("UTF-8");
               }

               flatfile.setSkiprows("0");
               new Properties();
               Properties var41 = PropertiesLoaderUtils.loadAllProperties("config.properties");
               flatfile.setDelimited("YES");
               flatfile.setDelimiters(var41.getProperty("load_table_col_split"));
               flatfile.setEscape_character("");
               flatfile.setKeepescapechar("NO");
               flatfile.setRowdelimiter("10");
               flatfile.setMultidelimitersasand("YES");
               flatfile.setQuote_character("NONE");
               tar_bean.setFilebean(flatfile);
               tar_bean.setInserttype(task.getInserttype());
               tar_bean.setConnectmode(datatarget.getConnectmode());
               tar_bean.setFilename(table.getTablename() + ".pipe");
               tar_bean.setFilepath(File.separator + "data" + File.separator + "infa_sybaseiq" + File.separator + task.getTaskname() + File.separator);
               CommandTool.command("mkfifo /data/infa_sybaseiq/" + task.getTaskname() + "/" + table.getTablename() + ".pipe");
            }

            if ("true".equals(task.getIsspload())) {
               tar_bean.setDatabasetype("Flat File");
               tar_bean.setFileparam("1");
               FlatFileBean flatfile = new FlatFileBean();
               if (datatarget.getPagecode().equals("GBK")) {
                  flatfile.setCodepage("MS936");
               } else {
                  flatfile.setCodepage("UTF-8");
               }

               flatfile.setSkiprows("0");
               new Properties();
               Properties var42 = PropertiesLoaderUtils.loadAllProperties("config.properties");
               flatfile.setDelimited("YES");
               flatfile.setEscape_character("");
               flatfile.setKeepescapechar("NO");
               flatfile.setRowdelimiter("10");
               flatfile.setMultidelimitersasand("YES");
               flatfile.setQuote_character("NONE");
               tar_bean.setFilebean(flatfile);
               tar_bean.setInserttype(task.getInserttype());
               tar_bean.setConnectmode(datatarget.getConnectmode());
               tar_bean.setFilename(table.getTablename() + ".pipe");
               FileTool.createFolder(File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + task.getTaskname() + File.separator);
               tar_bean.setFilepath(File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + task.getTaskname() + File.separator);
               if (datatarget.getDbtype().equals("MYSQL")) {
                  tar_bean.setSpload("mysql");
                  tar_bean.setDateformateparam("A  19 YYYY-MM-DD HH24:MI:SS");
                  flatfile.setDelimiters(var42.getProperty("mysql_load_col_split"));
                  tar_bean.setFilepath(File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + task.getTaskname() + File.separator);
                  CommandTool.command("mkfifo /data/infa_mysqlload/" + task.getTaskname() + "/" + table.getTablename() + ".pipe");
                  Map<String, String> mysqlloadparam = new HashMap();
                  mysqlloadparam.put("username", datatarget.getUsername());
                  mysqlloadparam.put("password", "1".equals(datatarget.getFlag()) ? AesTool.decrypt(datatarget.getPassword(), "ghca") : datatarget.getPassword());
                  mysqlloadparam.put("hostname", datatarget.getDbip());
                  mysqlloadparam.put("filepath", File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + task.getTaskname() + File.separator + table.getTablename() + ".pipe");
                  mysqlloadparam.put("database", table.getDbschema());
                  mysqlloadparam.put("tablename", table.getTablename());
                  mysqlloadparam.put("taskname", task.getTaskname());
                  mysqlloadparam.put("delimiter", var42.getProperty("mysql_load_col_split"));
                  MysqlLoadTableTool.executeLoadTable(mysqlloadparam);
               } else if (datatarget.getDbtype().equals("MSSQLSERVER")) {
                  tar_bean.setSpload("sqlserver");
                  tar_bean.setDateformateparam("A  19 YYYY-MM-DD HH24:MI:SS");
                  tar_bean.setFilename(table.getTablename() + ".txt");
                  flatfile.setCodepage("UTF-8");
                  flatfile.setDelimiters(var42.getProperty("bcp_table_sqlserver_col_split"));
                  flatfile.setQuote_character("none");
                  FileTool.createFolder(File.separator + "data" + File.separator + "infa_sqlserver" + File.separator + task.getTaskname() + File.separator);
                  tar_bean.setFilepath(File.separator + "data" + File.separator + "infa_sqlserver" + File.separator + task.getTaskname() + File.separator);
                  Map<String, String> bcpProperties = new HashMap();
                  bcpProperties.put("user", datatarget.getUsername());
                  bcpProperties.put("pwd", "1".equals(datatarget.getFlag()) ? AesTool.decrypt(datatarget.getPassword(), "ghca") : datatarget.getPassword());
                  bcpProperties.put("ip", datatarget.getDbip());
                  bcpProperties.put("dbschema", table.getDbschema());
                  bcpProperties.put("tablename", table.getTablename());
                  bcpProperties.put("database", datatarget.getDbservername());
                  bcpProperties.put("taskname", task.getTaskname());
                  bcpProperties.put("path", File.separator + "data" + File.separator + "infa_sqlserver" + File.separator + task.getTaskname() + File.separator + table.getTablename() + ".sh");
                  TCoreConfig tcoreConfig1 = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", datatarget.getId())});
                  SqlServerBcpTableTool.createBcpScript(bcpProperties, tcoreConfig1);
               }
            }
         }
      }

      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      CommonBean tcb = new CommonBean();
      List<String> tkeytype = new ArrayList();
      List<String> tnameList = new ArrayList();
      List<String> ttypeList = new ArrayList();
      List<String> tlengthList = new ArrayList();
      List<String> tprecisionList = new ArrayList();
      List<String> tscalelist = new ArrayList();

      for(TCoreMaskingTablecolumn column : sourceColumn) {
         if ("1".equals(column.getPrimarykey())) {
            keytype.add("PRIMARY KEY");
         } else {
            keytype.add("NOT A KEY");
         }

         if ("NUMBER".equalsIgnoreCase(column.getColumntype()) && !"-127".equals(column.getColumnscale())) {
            column.setColumntype("number(p,s)");
         }

         nameList.add(column.getColumnname());
         typeList.add(column.getColumntype());
         lengthList.add(column.getColumnlength());
         scalelist.add(column.getColumnscale());
         precisionList.add(column.getColumnlength());
         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         List<TCoreMaskingTablecolumn> targetColumnl = this.tCoreMaskingTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("mappingkey", column.getMappingkey()), Restrictions.eq("datadirection", EmaskingDirection.DATA_TARGET.getFlag())});
         TCoreMaskingTablecolumn targetColumn = (TCoreMaskingTablecolumn)targetColumnl.get(0);
         if ("1".equals(targetColumn.getPrimarykey())) {
            tkeytype.add("PRIMARY KEY");
         } else {
            tkeytype.add("NOT A KEY");
         }

         tnameList.add(targetColumn.getColumnname());
         ttypeList.add(targetColumn.getColumntype());
         tlengthList.add(targetColumn.getColumnlength());
         tscalelist.add(targetColumn.getColumnscale());
         tprecisionList.add(targetColumn.getColumnlength());
         if (column.getRuleid() != null && !"".equals(column.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", column.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(column.getColumnname(), rule.getMappletname(), targetColumn.getColumnname()));
            }
         }

         tcb.setKeytype(tkeytype);
         tcb.setLengthList(tlengthList);
         tcb.setNameList(tnameList);
         tcb.setPrecisionList(tprecisionList);
         tcb.setScalelist(tscalelist);
         tcb.setTypeList(ttypeList);
      }

      sou_bean.setCb(cb);
      tar_bean.setCb(tcb);
      tar_bean.setInserttype(task.getInserttype());
      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");
      MakeIsomerUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList, task.getIstruncate());
      this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
   }

   public void generateDbtoFileTaskMasking(TCoreMaskingTask task, String filesysid, String userid, String quick) throws Exception {
      TCoreMaskingFilesystem tcoremaskingfilesystem = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.get(filesysid);
      TCoreFileStructure tcorefilestructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(tcoremaskingfilesystem.getStructureid());
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      TCoreMaskingTable tentity = null;
      List<TCoreMaskingTable> tentityLst = this.tCoreMaskingtableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", tcoremaskingfilesystem.getMappingkey())});
      if (tentityLst.size() > 0) {
         tentity = (TCoreMaskingTable)tentityLst.get(0);
         ParamBean par_bean = new ParamBean();
         new SourceBean();
         TargetBean tar_bean = new TargetBean();
         TargetBean tar_bean_db = new TargetBean();
         ArrayList mapplet = new ArrayList();
         Object paramList = null;
         TCoreDatasystem datasource = (TCoreDatasystem)this.tCoreDatasystemDao.get(tentity.getDatasystemid());
         if ("true".equals(tcoremaskingfilesystem.getIstodatabase())) {
            TCoreDatasystem data_tar_db = (TCoreDatasystem)this.tCoreDatasystemDao.get(tcoremaskingfilesystem.getDatasystemid());
            if (!"MYSQL".equals(data_tar_db.getDbtype()) && !"MARIADB".equals(data_tar_db.getDbtype())) {
               if ("MSSQLSERVER".equals(data_tar_db.getDbtype())) {
                  this.getDatasystemEngine(datasource.getId(), task.getEngineid());
                  tar_bean_db.setLinkname(data_tar_db.getDblinkname());
                  tar_bean_db.setDbdname(data_tar_db.getDblinkname());
               } else if ("AS400".equals(data_tar_db.getDbtype())) {
                  this.getDatasystemEngine(data_tar_db.getId(), task.getEngineid());
                  tar_bean_db.setLinkname(data_tar_db.getDblinkname());
                  tar_bean_db.setDbdname(data_tar_db.getDblinkname());
               } else if ("INFORMIX".equals(data_tar_db.getDbtype())) {
                  this.getDatasystemEngine(data_tar_db.getId(), task.getEngineid());
                  tar_bean_db.setLinkname(data_tar_db.getDblinkname());
                  tar_bean_db.setDbdname(data_tar_db.getDblinkname());
               } else if ("SYBASE".equals(data_tar_db.getDbtype())) {
                  this.getDatasystemEngine(data_tar_db.getId(), task.getEngineid());
                  tar_bean_db.setLinkname(data_tar_db.getDblinkname());
                  tar_bean_db.setDbdname(data_tar_db.getDblinkname());
               } else {
                  this.getDatasystemEngine(data_tar_db.getId(), task.getEngineid());
                  tar_bean_db.setLinkname(data_tar_db.getDblinkname());
                  tar_bean_db.setDbdname(data_tar_db.getDblinkname());
               }
            } else {
               this.getDatasystemEngine(data_tar_db.getId(), task.getEngineid());
               tar_bean_db.setLinkname(data_tar_db.getDblinkname());
               tar_bean_db.setDbdname(data_tar_db.getDblinkname());
            }

            tar_bean_db.setTar_name(tentity.getTablename());
            tar_bean_db.setBusinessname("");
            tar_bean_db.setConstraint("");
            tar_bean_db.setDatabasetype(data_tar_db.getDbtype());
            tar_bean_db.setVersionnumber("1");
            tar_bean_db.setObjectversion("1");
            tar_bean_db.setDescripion("");
            tar_bean_db.setTargetownername(tcoremaskingfilesystem.getDbschema());
            tar_bean_db.setConnectmode(data_tar_db.getConnectmode());
         }

         SourceBean sou_bean = new SourceBean();
         sou_bean.setSo_name(tentity.getTablename());
         sou_bean.setSo_ownname("");
         sou_bean.setBusinessname("");
         sou_bean.setFiledirect("Direct");
         sou_bean.setDatabasetype(datasource.getDbtype());
         sou_bean.setConnectmode(datasource.getConnectmode());
         if (!"MYSQL".equals(datasource.getDbtype()) && !"MARIADB".equals(datasource.getDbtype())) {
            if ("MSSQLSERVER".equals(datasource.getDbtype())) {
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            } else if ("AS400".equals(datasource.getDbtype())) {
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            } else if ("INFORMIX".equals(datasource.getDbtype())) {
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            } else if ("SYBASE".equals(datasource.getDbtype())) {
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            } else {
               this.getDatasystemEngine(datasource.getId(), task.getEngineid());
               sou_bean.setLinkname(datasource.getDblinkname());
               sou_bean.setDbdname(datasource.getDblinkname());
            }
         } else {
            sou_bean.setLinkname(datasource.getDblinkname());
            sou_bean.setDbdname(datasource.getDblinkname());
         }

         sou_bean.setVersionnumber("1");
         sou_bean.setObjectversion("1");
         sou_bean.setDescripion("");
         sou_bean.setSourceownername(tentity.getDbschema());
         tar_bean.setTar_name(tcoremaskingfilesystem.getWildcard().split("\\.")[0] + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
         tar_bean.setBusinessname("");
         tar_bean.setConstraint("");
         tar_bean.setDatabasetype("Flat File");
         tar_bean.setVersionnumber("1");
         tar_bean.setObjectversion("1");
         tar_bean.setDescripion("");
         FlatFileBean flatfile = new FlatFileBean();
         if ("0".equalsIgnoreCase(tcorefilestructure.getCodepage())) {
            flatfile.setCodepage("utf-8");
         } else if ("1".equalsIgnoreCase(tcorefilestructure.getCodepage())) {
            flatfile.setCodepage("ms936");
         } else if ("2".equalsIgnoreCase(tcorefilestructure.getCodepage())) {
            flatfile.setCodepage("ms950");
         }

         if ("0".equals(tcorefilestructure.getSplitertype())) {
            TCoreFileStructurespliter tcorefilestructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
            flatfile.setSkiprows(tcorefilestructure.getSkiprows());
            flatfile.setDelimited("YES");
            flatfile.setDelimiters(tcorefilestructurespliter.getDelimiters());
            flatfile.setMultidelimitersasand(tcorefilestructurespliter.getMultidelimitersasand());
            flatfile.setQuote_character(tcorefilestructurespliter.getQuotecharacter());
            flatfile.setRowdelimiter(tcorefilestructurespliter.getRowdelimiter());
            flatfile.setEscape_character(tcorefilestructurespliter.getEscapecharacter());
            flatfile.setKeepescapechar(tcorefilestructurespliter.getKeepescapechar());
            tar_bean.setFileparam("1");
         } else {
            TCoreFileStructurewidth width = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
            flatfile.setSkiprows(tcorefilestructure.getSkiprows());
            flatfile.setLinesequential(width.getLinesequential());
            flatfile.setNullchartype(width.getNullchartype());
            flatfile.setNull_character(width.getNullcharacter());
            flatfile.setRepeatable(width.getRepeatable());
            flatfile.setPadbytes(width.getPadbytes());
            flatfile.setShiftsensitivedata(width.getShiftsensitivedata());
            flatfile.setStriptrailingblanks(width.getStriptrailingblanks());
            tar_bean.setFileparam("0");
         }

         tar_bean.setFilebean(flatfile);
         List<TCoreMaskingFilecolumn> tcoremaskingfilesystemlist = this.tCoreMaskingFilecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("filesystemid", tcoremaskingfilesystem.getId())});
         CommonBean cb = new CommonBean();
         List<String> keytype = new ArrayList();
         List<String> nameList = new ArrayList();
         List<String> typeList = new ArrayList();
         List<String> lengthList = new ArrayList();
         List<String> precisionList = new ArrayList();
         List<String> scalelist = new ArrayList();
         CommonBean tcb = new CommonBean();
         List<String> tkeytype = new ArrayList();
         List<String> tnameList = new ArrayList();
         List<String> ttypeList = new ArrayList();
         List<String> tlengthList = new ArrayList();
         List<String> tprecisionList = new ArrayList();
         List<String> tscalelist = new ArrayList();

         for(TCoreMaskingFilecolumn list : tcoremaskingfilesystemlist) {
            TCoreFileStructurecolumn ckj = (TCoreFileStructurecolumn)this.tCoreFileStructurecolumnDao.get(list.getStructurecolumnid());
            tnameList.add(ckj.getColumnname());
            ttypeList.add(ckj.getColumntype());
            tlengthList.add(ckj.getColumnaccuracy());
            tscalelist.add(ckj.getColumndecimal());
            tprecisionList.add(ckj.getColumnaccuracy());
            tkeytype.add("NOT A KEY");
            tcb.setKeytype(tkeytype);
            tcb.setLengthList(tlengthList);
            tcb.setNameList(tnameList);
            tcb.setPrecisionList(tprecisionList);
            tcb.setScalelist(tscalelist);
            tcb.setTypeList(ttypeList);
            tar_bean.setCb(tcb);
            TCoreMaskingTablecolumn tablecolumn = null;
            List<TCoreMaskingTablecolumn> tablecolumnLst = this.tCoreMaskingTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("mappingkey", list.getMappingkey()), Restrictions.eq("taskid", task.getId())});
            if (tablecolumnLst.size() <= 0) {
               return;
            }

            tablecolumn = (TCoreMaskingTablecolumn)tablecolumnLst.get(0);
            if ("NUMBER".equalsIgnoreCase(tablecolumn.getColumntype()) && !"-127".equals(tablecolumn.getColumnscale())) {
               tablecolumn.setColumntype("number(p,s)");
            }

            nameList.add(tablecolumn.getColumnname());
            typeList.add(tablecolumn.getColumntype());
            lengthList.add(tablecolumn.getColumnlength());
            scalelist.add(tablecolumn.getColumnscale());
            precisionList.add(tablecolumn.getColumnlength());
            if ("1".equals(tablecolumn.getPrimarykey())) {
               keytype.add("PRIMARY KEY");
            } else {
               keytype.add("NOT A KEY");
            }

            cb.setKeytype(keytype);
            cb.setLengthList(lengthList);
            cb.setNameList(nameList);
            cb.setPrecisionList(precisionList);
            cb.setScalelist(scalelist);
            cb.setTypeList(typeList);
            if (tablecolumn.getRuleid() != null && !"".equals(tablecolumn.getRuleid())) {
               TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", tablecolumn.getRuleid())});
               if (rule != null) {
                  mapplet.add(new MappletMakeDatabean(tablecolumn.getColumnname(), rule.getMappletname(), ckj.getColumnname()));
               }
            }

            sou_bean.setCb(cb);
            tar_bean_db.setCb(cb);
         }

         par_bean.setTaskname(task.getTaskname());
         par_bean.setFoldername(task.getFdname());
         par_bean.setOwner("");
         par_bean.setGroup("");
         par_bean.setParam_path("");
         par_bean.setPower_repository_version("184.93");
         par_bean.setCodepage("UTF-8");
         par_bean.setRepository_version("184");
         if (!"0".equals(tcoremaskingfilesystem.getLocation())) {
            String dir = "d" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss") + ".txt";
            tar_bean.setFilename(dir);
            tar_bean.setFilepath(this.path);
            tcoremaskingfilesystem.setNote(dir);
            this.tCoreMaskingFilesystemDao.saveOrUpdate(tcoremaskingfilesystem);
         } else {
            tar_bean.setFilename(tcoremaskingfilesystem.getWildcard());
            tar_bean.setFilepath(this.path + tcoremaskingfilesystem.getDirectory());
         }

         tar_bean.setIsftp("0");
         tar_bean.setFtplink("");
         if (tcoremaskingfilesystem.getColumnformat() != null && !"".equals(tcoremaskingfilesystem.getColumnformat())) {
            String format = "A  ";
            format = format + tcoremaskingfilesystem.getColumnformat().length() + " " + tcoremaskingfilesystem.getColumnformat();
            tar_bean.setDateformateparam(format);
         }

         TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
         if ("ORACLE".equals(repdata.getDbtype())) {
            par_bean.setRepository_dbtype("Oracle");
         } else if ("DB2".equals(repdata.getDbtype())) {
            par_bean.setRepository_dbtype("Db2");
         }

         par_bean.setShard("NOTSHARED");
         if ("true".equals(tcoremaskingfilesystem.getIstodatabase())) {
            tar_bean_db.setInserttype("insert");
            MakeBakUtil.bakMasking(par_bean, info, sou_bean, tar_bean, tar_bean_db, mapplet, (List)paramList);
         } else {
            MakeIsomerUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, (List)paramList);
         }

         this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
      }
   }

   public void generateTeradataDbtoFileTaskMasking(TCoreMaskingTask task, String filesysid, String userid, String quick) throws Exception {
      String taskname = task.getTaskname();
      TCoreMaskingFilesystem tcoremaskingfilesystem = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.get(filesysid);
      TCoreFileStructure tcorefilestructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(tcoremaskingfilesystem.getStructureid());
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      TCoreMaskingTable sTable = null;
      List<TCoreMaskingTable> tentityLst = this.tCoreMaskingtableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", tcoremaskingfilesystem.getMappingkey())});
      if (tentityLst.size() > 0) {
         sTable = (TCoreMaskingTable)tentityLst.get(0);
         String tableName = sTable.getTablename();
         ParamBean par_bean = new ParamBean();
         new SourceBean();
         TargetBean tar_bean = new TargetBean();
         new TargetBean();
         ArrayList mapplet = new ArrayList();
         Object paramList = null;
         TCoreDatasystem var10000 = (TCoreDatasystem)this.tCoreDatasystemDao.get(sTable.getDatasystemid());
         FlatFileBean sflatfile = new FlatFileBean();
         SourceBean sou_bean = new SourceBean();
         sou_bean.setSo_ownname("");
         sou_bean.setBusinessname("");
         sou_bean.setDatabasetype("Flat File");
         sou_bean.setLinkname("");
         sou_bean.setDbdname("");
         sou_bean.setVersionnumber("1");
         sou_bean.setObjectversion("1");
         sou_bean.setDescripion("TERADATA");
         sflatfile.setCodepage("utf-8");
         sflatfile.setSkiprows("1");
         sflatfile.setDelimited("YES");
         sflatfile.setDelimiters("|");
         sflatfile.setMultidelimitersasand("NO");
         sflatfile.setQuote_character("double");
         sflatfile.setRowdelimiter("");
         sflatfile.setEscape_character("");
         sflatfile.setKeepescapechar("NO");
         sflatfile.setNull_character("*");
         sflatfile.setNullchartype("ASCII");
         sflatfile.setPadbytes("1");
         sou_bean.setFileparam("1");
         sou_bean.setFilebean(sflatfile);
         sou_bean.setIsftp("0");
         sou_bean.setFtplink("");
         sou_bean.setFilepath(TeradataTool.STR_PIPEFILE_PATH + taskname + "/");
         sou_bean.setFiledirect("Direct");
         sou_bean.setSo_name(tableName);
         sou_bean.setFilename(tableName + ".pipe");
         tar_bean.setTar_name(tcoremaskingfilesystem.getWildcard().split("\\.")[0] + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
         tar_bean.setBusinessname("");
         tar_bean.setConstraint("");
         tar_bean.setDatabasetype("Flat File");
         tar_bean.setVersionnumber("1");
         tar_bean.setObjectversion("1");
         tar_bean.setDescripion("");
         FlatFileBean tflatfile = new FlatFileBean();
         if ("0".equalsIgnoreCase(tcorefilestructure.getCodepage())) {
            tflatfile.setCodepage("utf-8");
         } else if ("1".equalsIgnoreCase(tcorefilestructure.getCodepage())) {
            tflatfile.setCodepage("ms936");
         } else if ("2".equalsIgnoreCase(tcorefilestructure.getCodepage())) {
            tflatfile.setCodepage("ms950");
         }

         if ("0".equals(tcorefilestructure.getSplitertype())) {
            TCoreFileStructurespliter tcorefilestructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
            tflatfile.setSkiprows(tcorefilestructure.getSkiprows());
            tflatfile.setDelimited("YES");
            tflatfile.setDelimiters(tcorefilestructurespliter.getDelimiters());
            tflatfile.setMultidelimitersasand(tcorefilestructurespliter.getMultidelimitersasand());
            tflatfile.setQuote_character(tcorefilestructurespliter.getQuotecharacter());
            tflatfile.setRowdelimiter(tcorefilestructurespliter.getRowdelimiter());
            tflatfile.setEscape_character(tcorefilestructurespliter.getEscapecharacter());
            tflatfile.setKeepescapechar(tcorefilestructurespliter.getKeepescapechar());
            tar_bean.setFileparam("1");
         } else {
            TCoreFileStructurewidth width = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
            tflatfile.setSkiprows(tcorefilestructure.getSkiprows());
            tflatfile.setLinesequential(width.getLinesequential());
            tflatfile.setNullchartype(width.getNullchartype());
            tflatfile.setNull_character(width.getNullcharacter());
            tflatfile.setRepeatable(width.getRepeatable());
            tflatfile.setPadbytes(width.getPadbytes());
            tflatfile.setShiftsensitivedata(width.getShiftsensitivedata());
            tflatfile.setStriptrailingblanks(width.getStriptrailingblanks());
            tar_bean.setFileparam("0");
         }

         tar_bean.setFilebean(tflatfile);
         List<TCoreMaskingFilecolumn> tcoremaskingfilesystemlist = this.tCoreMaskingFilecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("filesystemid", tcoremaskingfilesystem.getId())});
         CommonBean cb = new CommonBean();
         List<String> keytype = new ArrayList();
         List<String> nameList = new ArrayList();
         List<String> typeList = new ArrayList();
         List<String> lengthList = new ArrayList();
         List<String> precisionList = new ArrayList();
         List<String> scalelist = new ArrayList();
         List<String> formatlist = new ArrayList();
         CommonBean tcb = new CommonBean();
         List<String> tkeytype = new ArrayList();
         List<String> tnameList = new ArrayList();
         List<String> ttypeList = new ArrayList();
         List<String> tlengthList = new ArrayList();
         List<String> tprecisionList = new ArrayList();
         List<String> tscalelist = new ArrayList();

         for(TCoreMaskingFilecolumn list : tcoremaskingfilesystemlist) {
            TCoreMaskingTablecolumn tablecolumn = null;
            List<TCoreMaskingTablecolumn> tablecolumnLst = this.tCoreMaskingTablecolumnDao.queryAll(new Criterion[]{Restrictions.eq("mappingkey", list.getMappingkey()), Restrictions.eq("taskid", task.getId())});
            if (tablecolumnLst.size() <= 0) {
               return;
            }

            tablecolumn = (TCoreMaskingTablecolumn)tablecolumnLst.get(0);
            if ("1".equals(tablecolumn.getPrimarykey())) {
               keytype.add("PRIMARY KEY");
            } else {
               keytype.add("NOT A KEY");
            }

            nameList.add(tablecolumn.getColumnname());
            String sColType = "string";
            String colTypeLen = TeradataTool.teradataTypeLength(tablecolumn.getColumntype(), tablecolumn.getColumnlength(), tablecolumn.getColumnscale());
            String sColScale = "";
            String dateFormat = "";
            new Properties();
            Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
            if ("date".equalsIgnoreCase(tablecolumn.getColumntype()) || "time".equalsIgnoreCase(tablecolumn.getColumntype()) || "timestamp".equalsIgnoreCase(tablecolumn.getColumntype())) {
               sColType = "datetime";
               colTypeLen = tablecolumn.getColumnlength();
               sColScale = tablecolumn.getColumntype();
               dateFormat = "F  29 " + props.getProperty("exp_timestamp_foramt");
               if ("date".equalsIgnoreCase(tablecolumn.getColumntype())) {
                  dateFormat = "F  29 " + props.getProperty("exp_date_foramt");
               }
            }

            typeList.add(sColType);
            lengthList.add(colTypeLen);
            scalelist.add(sColScale);
            precisionList.add(colTypeLen);
            formatlist.add(dateFormat);
            cb.setKeytype(keytype);
            cb.setLengthList(lengthList);
            cb.setNameList(nameList);
            cb.setPrecisionList(precisionList);
            cb.setScalelist(scalelist);
            cb.setTypeList(typeList);
            cb.setDateformatlist(formatlist);
            sou_bean.setCb(cb);
            TCoreFileStructurecolumn ckj = (TCoreFileStructurecolumn)this.tCoreFileStructurecolumnDao.get(list.getStructurecolumnid());
            tnameList.add(ckj.getColumnname());
            ttypeList.add(sColType);
            tlengthList.add(colTypeLen);
            tscalelist.add("");
            tprecisionList.add(colTypeLen);
            tkeytype.add("NOT A KEY");
            tcb.setKeytype(tkeytype);
            tcb.setLengthList(tlengthList);
            tcb.setNameList(tnameList);
            tcb.setPrecisionList(tprecisionList);
            tcb.setScalelist(tscalelist);
            tcb.setTypeList(ttypeList);
            tar_bean.setCb(tcb);
            if (tablecolumn.getRuleid() != null && !"".equals(tablecolumn.getRuleid())) {
               TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", tablecolumn.getRuleid())});
               if (rule != null) {
                  mapplet.add(new MappletMakeDatabean(tablecolumn.getColumnname(), rule.getMappletname(), ckj.getColumnname()));
               }
            }
         }

         par_bean.setTaskname(task.getTaskname());
         par_bean.setFoldername(task.getFdname());
         par_bean.setOwner("");
         par_bean.setGroup("");
         par_bean.setParam_path("");
         par_bean.setPower_repository_version("184.93");
         par_bean.setCodepage("UTF-8");
         par_bean.setRepository_version("184");
         if (!"0".equals(tcoremaskingfilesystem.getLocation())) {
            String dir = "d" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss") + ".txt";
            tar_bean.setFilename(dir);
            tar_bean.setFilepath(this.path);
            tcoremaskingfilesystem.setNote(dir);
            this.tCoreMaskingFilesystemDao.saveOrUpdate(tcoremaskingfilesystem);
         } else {
            tar_bean.setFilename(tcoremaskingfilesystem.getWildcard());
            tar_bean.setFilepath(this.path + tcoremaskingfilesystem.getDirectory());
         }

         tar_bean.setIsftp("0");
         tar_bean.setFtplink("");
         if (tcoremaskingfilesystem.getColumnformat() != null && !"".equals(tcoremaskingfilesystem.getColumnformat())) {
            String format = "A  ";
            format = format + tcoremaskingfilesystem.getColumnformat().length() + " " + tcoremaskingfilesystem.getColumnformat();
            tar_bean.setDateformateparam(format);
         }

         TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
         if ("ORACLE".equals(repdata.getDbtype())) {
            par_bean.setRepository_dbtype("Oracle");
         } else if ("DB2".equals(repdata.getDbtype())) {
            par_bean.setRepository_dbtype("Db2");
         }

         par_bean.setShard("NOTSHARED");
         MakeIsomerUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, (List)paramList);
         this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
      }
   }

   public void generateHivetoHiveTaskMasking(TCoreMaskingTask task, String mappingkey, String userid, String quick, long groupid) {
      TCoreMaskingHive shive = new TCoreMaskingHive();
      TCoreMaskingHive thive = new TCoreMaskingHive();
      List<TCoreMaskingHive> hivelist = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", mappingkey)});
      if (hivelist != null && hivelist.size() > 0) {
         for(int i = 0; i < hivelist.size(); ++i) {
            if ("1".equals(((TCoreMaskingHive)hivelist.get(i)).getDatadirection())) {
               thive = (TCoreMaskingHive)this.tCoreMaskingHiveDao.get(((TCoreMaskingHive)hivelist.get(i)).getId());
            } else {
               shive = (TCoreMaskingHive)this.tCoreMaskingHiveDao.get(((TCoreMaskingHive)hivelist.get(i)).getId());
            }
         }
      }

      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      ParamBean par_bean = new ParamBean();
      new SourceBean();
      TargetBean tar_bean = new TargetBean();
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      TCoreDatasystem thivesys = (TCoreDatasystem)this.tCoreDatasystemDao.get(thive.getDatasystemid());
      SourceBean sou_bean = new SourceBean();
      sou_bean.setSo_name(shive.getTablename());
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setFiledirect("Direct");
      sou_bean.setDatabasetype("HIVE");
      FlatFileBean sflatfile = new FlatFileBean();
      if (thivesys.getPagecode().equals("GBK")) {
         sflatfile.setCodepage("MS936");
      } else {
         sflatfile.setCodepage("UTF-8");
      }

      sflatfile.setSkiprows("0");
      sflatfile.setDelimited("YES");
      sflatfile.setDelimiters(XmlTool.getValue("sys/qr-delimiter"));
      sflatfile.setMultidelimitersasand("YES");
      sflatfile.setQuote_character(XmlTool.getValue("sys/qr-source-quotecharacter"));
      sflatfile.setRowdelimiter("0");
      sflatfile.setEscape_character("");
      sflatfile.setKeepescapechar("NO");
      sou_bean.setFilebean(sflatfile);
      sou_bean.setVersionnumber("1");
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("");
      tar_bean.setTar_name(thive.getTablename());
      tar_bean.setBusinessname("");
      tar_bean.setConstraint("");
      tar_bean.setDatabasetype("Flat File");
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      tar_bean.setLinkname(thivesys.getDblinkname());
      tar_bean.setInserttype(task.getInserttype());
      tar_bean.setTargetownername(thive.getDbschema());
      FlatFileBean flatfile = new FlatFileBean();
      if (thivesys.getPagecode().equals("GBK")) {
         flatfile.setCodepage("MS936");
      } else {
         flatfile.setCodepage("UTF-8");
      }

      flatfile.setSkiprows("0");
      flatfile.setDelimited("YES");
      flatfile.setDelimiters(XmlTool.getValue("sys/qr-delimiter"));
      flatfile.setMultidelimitersasand("YES");
      flatfile.setQuote_character(XmlTool.getValue("sys/qr-target-quotecharacter"));
      flatfile.setRowdelimiter("0");
      flatfile.setEscape_character("");
      flatfile.setKeepescapechar("NO");
      tar_bean.setFileparam("1");
      tar_bean.setFilename(thivesys.getLocaldir());
      tar_bean.setFilepath(info.getXmldir());
      tar_bean.setFilebean(flatfile);
      tar_bean.setHiveflag("0");
      System.out.println("=======HIVETOHIVE======源-----分隔符为" + sflatfile.getDelimiters() + ", 包围符为" + sflatfile.getQuote_character());
      System.out.println("=======HIVETOHIVE======目标-----分隔符为" + flatfile.getDelimiters() + ", 包围符为" + flatfile.getQuote_character());
      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      List<String> dateformatlist = new ArrayList();
      CommonBean tcb = new CommonBean();
      List<String> tkeytype = new ArrayList();
      List<String> tnameList = new ArrayList();
      List<String> ttypeList = new ArrayList();
      List<String> tlengthList = new ArrayList();
      List<String> tprecisionList = new ArrayList();
      List<String> tscalelist = new ArrayList();
      List<String> tdateformatlist = new ArrayList();

      for(TCoreMaskingHivecolumn list : this.tCoreMaskingHivecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("tableid", shive.getId())})) {
         tnameList.add(list.getColumnname());
         ttypeList.add(list.getColumntype());
         tlengthList.add(list.getColumnlength());
         tscalelist.add(list.getColumnscale());
         tprecisionList.add(list.getColumnlength());
         tkeytype.add("NOT A KEY");
         tdateformatlist.add("yyyy-mm-dd");
         tcb.setKeytype(tkeytype);
         tcb.setLengthList(tlengthList);
         tcb.setNameList(tnameList);
         tcb.setPrecisionList(tprecisionList);
         tcb.setScalelist(tscalelist);
         tcb.setTypeList(ttypeList);
         tcb.setDateformatlist(tdateformatlist);
         tar_bean.setCb(tcb);
         TCoreMaskingHivecolumn tcolumn = (TCoreMaskingHivecolumn)this.tCoreMaskingHivecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("mappingkey", list.getMappingkey()), Restrictions.eq("datadirection", "1")});
         nameList.add(tcolumn.getColumnname());
         typeList.add(tcolumn.getColumntype());
         lengthList.add(tcolumn.getColumnlength());
         scalelist.add(tcolumn.getColumnscale());
         precisionList.add(tcolumn.getColumnlength());
         dateformatlist.add("yyyy-mm-dd");
         if ("1".equals(tcolumn.getPrimarykey())) {
            keytype.add("PRIMARY KEY");
         } else {
            keytype.add("NOT A KEY");
         }

         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         cb.setDateformatlist(dateformatlist);
         if (tcolumn.getRuleid() != null && !"".equals(tcolumn.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", tcolumn.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(tcolumn.getColumnname(), rule.getMappletname(), list.getColumnname()));
            }
         }

         sou_bean.setCb(tcb);
      }

      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      tar_bean.setFilepath(info.getXmldir());
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");
      MakeTargetHiveUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList, task.getTaskname());
      this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
      TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
      temporay.setCreatetime(new Date());
      temporay.setTargetname(tar_bean.getTar_name());
      temporay.setSourcename(sou_bean.getSo_name());
      temporay.setTaskid(task.getId());
      temporay.setType("HIVE>HIVE");
      temporay.setWfname(sou_bean.getSo_name());
      temporay.setGroupid(groupid);
      this.tCoreMonitorTemporaryDao.save(temporay);
   }

   public void generateHiveToDbTaskMasking(TCoreMaskingTask task, String mappingkey, String userid, String quick, long groupid, String tdbid, String tdbschema) {
      TCoreMaskingHive shive = new TCoreMaskingHive();
      TCoreMaskingHive thive = new TCoreMaskingHive();
      List<TCoreMaskingHive> hivelist = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", mappingkey)});
      if (hivelist != null && hivelist.size() > 0) {
         for(int i = 0; i < hivelist.size(); ++i) {
            if ("1".equals(((TCoreMaskingHive)hivelist.get(i)).getDatadirection())) {
               thive = (TCoreMaskingHive)this.tCoreMaskingHiveDao.get(((TCoreMaskingHive)hivelist.get(i)).getId());
            } else {
               shive = (TCoreMaskingHive)this.tCoreMaskingHiveDao.get(((TCoreMaskingHive)hivelist.get(i)).getId());
            }
         }
      }

      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      ParamBean par_bean = new ParamBean();
      new SourceBean();
      TargetBean tar_bean = new TargetBean();
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      TCoreDatasystem thivesys = (TCoreDatasystem)this.tCoreDatasystemDao.get(tdbid);
      SourceBean sou_bean = new SourceBean();
      sou_bean.setSo_name(shive.getTablename());
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setFiledirect("Direct");
      sou_bean.setDatabasetype("HIVE");
      FlatFileBean sflatfile = new FlatFileBean();
      if (thivesys.getPagecode().equals("GBK")) {
         sflatfile.setCodepage("MS936");
      } else {
         sflatfile.setCodepage("UTF-8");
      }

      sflatfile.setSkiprows("0");
      sflatfile.setDelimited("YES");
      sflatfile.setDelimiters("|");
      sflatfile.setMultidelimitersasand("YES");
      sflatfile.setQuote_character("NONE");
      sflatfile.setRowdelimiter("0");
      sflatfile.setEscape_character("");
      sflatfile.setKeepescapechar("NO");
      sou_bean.setFilebean(sflatfile);
      sou_bean.setVersionnumber("1");
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("");
      tar_bean.setTar_name(shive.getTablename());
      tar_bean.setBusinessname("");
      tar_bean.setConstraint("");
      tar_bean.setDatabasetype("Flat File");
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      tar_bean.setLinkname(thivesys.getDblinkname());
      tar_bean.setInserttype(task.getInserttype());
      tar_bean.setTargetownername(thive.getDbschema());
      FlatFileBean flatfile = new FlatFileBean();
      if (thivesys.getPagecode().equals("GBK")) {
         flatfile.setCodepage("MS936");
      } else {
         flatfile.setCodepage("UTF-8");
      }

      flatfile.setSkiprows("0");
      tar_bean.setFileparam("1");
      tar_bean.setFilename(thivesys.getLocaldir());
      tar_bean.setFilepath(info.getXmldir());
      tar_bean.setFilebean(flatfile);
      tar_bean.setDatabasetype("Flat File");
      tar_bean.setFileparam("1");
      flatfile.setSkiprows("0");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      flatfile.setDelimited("YES");
      flatfile.setEscape_character("");
      flatfile.setKeepescapechar("NO");
      flatfile.setRowdelimiter("10");
      flatfile.setMultidelimitersasand("YES");
      flatfile.setQuote_character("NONE");
      tar_bean.setFilebean(flatfile);
      tar_bean.setInserttype(task.getInserttype());
      tar_bean.setConnectmode(thivesys.getConnectmode());
      tar_bean.setFilename(shive.getTablename() + ".pipe");
      tar_bean.setHiveflag("1");
      FileTool.createFolder(File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + task.getTaskname() + File.separator);
      tar_bean.setFilepath(File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + task.getTaskname() + File.separator);
      if (thivesys.getDbtype().equals("MYSQL")) {
         tar_bean.setSpload("mysql");
         flatfile.setDelimiters(props.getProperty("mysql_load_col_split"));
         tar_bean.setFilepath(File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + task.getTaskname() + File.separator);
         CommandTool.command("mkfifo /data/infa_mysqlload/" + task.getTaskname() + "/" + shive.getTablename() + ".pipe");
         Map<String, String> mysqlloadparam = new HashMap();
         mysqlloadparam.put("username", thivesys.getUsername());
         mysqlloadparam.put("password", "1".equals(thivesys.getFlag()) ? AesTool.decrypt(thivesys.getPassword(), "ghca") : thivesys.getPassword());
         mysqlloadparam.put("hostname", thivesys.getDbip());
         mysqlloadparam.put("filepath", File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + task.getTaskname() + File.separator + shive.getTablename() + ".pipe");
         mysqlloadparam.put("database", tdbschema);
         mysqlloadparam.put("tablename", shive.getTablename());
         mysqlloadparam.put("taskname", task.getTaskname());
         mysqlloadparam.put("delimiter", props.getProperty("mysql_load_col_split"));
         MysqlLoadTableTool.executeLoadTable(mysqlloadparam);
      }

      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      List<String> dateformatlist = new ArrayList();
      CommonBean tcb = new CommonBean();
      List<String> tkeytype = new ArrayList();
      List<String> tnameList = new ArrayList();
      List<String> ttypeList = new ArrayList();
      List<String> tlengthList = new ArrayList();
      List<String> tprecisionList = new ArrayList();
      List<String> tscalelist = new ArrayList();
      List<String> tdateformatlist = new ArrayList();

      for(TCoreMaskingHivecolumn list : this.tCoreMaskingHivecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("tableid", shive.getId())})) {
         tnameList.add(list.getColumnname());
         ttypeList.add(list.getColumntype());
         tlengthList.add(list.getColumnlength());
         tscalelist.add(list.getColumnscale());
         tprecisionList.add(list.getColumnlength());
         tkeytype.add("NOT A KEY");
         tdateformatlist.add("yyyy-mm-dd");
         tcb.setKeytype(tkeytype);
         tcb.setLengthList(tlengthList);
         tcb.setNameList(tnameList);
         tcb.setPrecisionList(tprecisionList);
         tcb.setScalelist(tscalelist);
         tcb.setTypeList(ttypeList);
         tcb.setDateformatlist(tdateformatlist);
         tar_bean.setCb(tcb);
         TCoreMaskingTablecolumn tcolumn = (TCoreMaskingTablecolumn)this.tCoreMaskingTablecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("mappingkey", list.getMappingkey()), Restrictions.eq("datadirection", "1")});
         nameList.add(tcolumn.getColumnname());
         typeList.add(tcolumn.getColumntype());
         lengthList.add(tcolumn.getColumnlength());
         scalelist.add(tcolumn.getColumnscale());
         precisionList.add(tcolumn.getColumnlength());
         dateformatlist.add("yyyy-mm-dd");
         if ("1".equals(tcolumn.getPrimarykey())) {
            keytype.add("PRIMARY KEY");
         } else {
            keytype.add("NOT A KEY");
         }

         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         cb.setDateformatlist(dateformatlist);
         if (tcolumn.getRuleid() != null && !"".equals(tcolumn.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", tcolumn.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(tcolumn.getColumnname(), rule.getMappletname(), list.getColumnname()));
            }
         }

         sou_bean.setCb(tcb);
      }

      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");
      MakeTargetHiveUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList, task.getTaskname());
      this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
      TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
      temporay.setCreatetime(new Date());
      temporay.setTargetname(tar_bean.getTar_name());
      temporay.setSourcename(sou_bean.getSo_name());
      temporay.setTaskid(task.getId());
      temporay.setType("HIVE>DB");
      temporay.setWfname(sou_bean.getSo_name());
      temporay.setGroupid(groupid);
      this.tCoreMonitorTemporaryDao.save(temporay);
   }

   public void generateHiveToFileTaskMasking(TCoreMaskingTask task, String fileid, String userid, String quick, long groupid, String dateformat) {
      TCoreMaskingFilesystem tcoremaskingfilesystem = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.get(fileid);
      new TCoreMaskingHive();
      TCoreFileStructure tcorefilestructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(tcoremaskingfilesystem.getStructureid());
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      ParamBean par_bean = new ParamBean();
      new SourceBean();
      TargetBean tar_bean = new TargetBean();
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      SourceBean sou_bean = new SourceBean();
      sou_bean.setSo_name(tcoremaskingfilesystem.getWildcard().split("\\.")[0]);
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setFiledirect("Direct");
      sou_bean.setDatabasetype("HIVE");
      FlatFileBean sflatfile = new FlatFileBean();
      if (tcorefilestructure.getCodepage().equals("0")) {
         sflatfile.setCodepage("MS936");
      } else {
         sflatfile.setCodepage("UTF-8");
      }

      sflatfile.setSkiprows("0");
      sflatfile.setDelimited("YES");
      sflatfile.setDelimiters("|");
      sflatfile.setMultidelimitersasand("YES");
      sflatfile.setQuote_character("NONE");
      sflatfile.setRowdelimiter("0");
      sflatfile.setEscape_character("");
      sflatfile.setKeepescapechar("NO");
      sou_bean.setFilebean(sflatfile);
      sou_bean.setVersionnumber("1");
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("");
      tar_bean.setTar_name(tcoremaskingfilesystem.getWildcard().split("\\.")[0] + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
      tar_bean.setBusinessname("");
      tar_bean.setConstraint("");
      tar_bean.setDatabasetype("Flat File");
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      FlatFileBean flatfile = new FlatFileBean();
      if ("0".equalsIgnoreCase(tcorefilestructure.getCodepage())) {
         flatfile.setCodepage("utf-8");
      } else if ("1".equalsIgnoreCase(tcorefilestructure.getCodepage())) {
         flatfile.setCodepage("ms936");
      } else if ("2".equalsIgnoreCase(tcorefilestructure.getCodepage())) {
         flatfile.setCodepage("ms950");
      }

      if ("0".equals(tcorefilestructure.getSplitertype())) {
         TCoreFileStructurespliter tcorefilestructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
         flatfile.setSkiprows(tcorefilestructure.getSkiprows());
         flatfile.setDelimited("YES");
         flatfile.setDelimiters(tcorefilestructurespliter.getDelimiters());
         flatfile.setMultidelimitersasand(tcorefilestructurespliter.getMultidelimitersasand());
         flatfile.setQuote_character(tcorefilestructurespliter.getQuotecharacter());
         flatfile.setRowdelimiter(tcorefilestructurespliter.getRowdelimiter());
         flatfile.setEscape_character(tcorefilestructurespliter.getEscapecharacter());
         flatfile.setKeepescapechar(tcorefilestructurespliter.getKeepescapechar());
         tar_bean.setFileparam("1");
      } else {
         TCoreFileStructurewidth width = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
         flatfile.setSkiprows(tcorefilestructure.getSkiprows());
         flatfile.setLinesequential(width.getLinesequential());
         flatfile.setNullchartype(width.getNullchartype());
         flatfile.setNull_character(width.getNullcharacter());
         flatfile.setRepeatable(width.getRepeatable());
         flatfile.setPadbytes(width.getPadbytes());
         flatfile.setShiftsensitivedata(width.getShiftsensitivedata());
         flatfile.setStriptrailingblanks(width.getStriptrailingblanks());
         tar_bean.setFileparam("0");
      }

      tar_bean.setFilebean(flatfile);
      List<TCoreMaskingFilecolumn> tcoremaskingfilesystemlist = this.tCoreMaskingFilecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("filesystemid", tcoremaskingfilesystem.getId())});
      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      List<String> formatlist = new ArrayList();
      CommonBean tcb = new CommonBean();
      List<String> tkeytype = new ArrayList();
      List<String> tnameList = new ArrayList();
      List<String> ttypeList = new ArrayList();
      List<String> tlengthList = new ArrayList();
      List<String> tprecisionList = new ArrayList();
      List<String> tscalelist = new ArrayList();
      List<String> tformatlist = new ArrayList();

      for(TCoreMaskingFilecolumn list : tcoremaskingfilesystemlist) {
         TCoreFileStructurecolumn ckj = (TCoreFileStructurecolumn)this.tCoreFileStructurecolumnDao.get(list.getStructurecolumnid());
         TCoreMaskingFilecolumn filecolumn = (TCoreMaskingFilecolumn)this.tCoreMaskingFilecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("mappingkey", list.getMappingkey()), Restrictions.eq("datadirection", "1")});
         keytype.add("NOT A KEY");
         nameList.add(ckj.getColumnname());
         typeList.add(ckj.getColumntype());
         lengthList.add(ckj.getColumnaccuracy());
         scalelist.add(ckj.getColumndecimal());
         precisionList.add(ckj.getColumnaccuracy());
         if (ckj.getColumnformat() != null && !"".equals(ckj.getColumnformat())) {
            formatlist.add(ckj.getColumnformat());
            tformatlist.add(ckj.getColumnformat());
         } else {
            formatlist.add("YYYY-MM-DD");
            tformatlist.add(dateformat);
         }

         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         cb.setDateformatlist(formatlist);
         sou_bean.setCb(cb);
         TCoreMaskingFilecolumn tfilecolumn = (TCoreMaskingFilecolumn)this.tCoreMaskingFilecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("mappingkey", filecolumn.getMappingkey()), Restrictions.eq("datadirection", "1")});
         TCoreFileStructurecolumn tfcolumn = (TCoreFileStructurecolumn)this.tCoreFileStructurecolumnDao.get(tfilecolumn.getStructurecolumnid());
         tkeytype.add("NOT A KEY");
         tnameList.add(tfcolumn.getColumnname());
         ttypeList.add(tfcolumn.getColumntype());
         tlengthList.add(tfcolumn.getColumnaccuracy());
         tscalelist.add(tfcolumn.getColumndecimal());
         tprecisionList.add(tfcolumn.getColumnaccuracy());
         tcb.setKeytype(tkeytype);
         tcb.setLengthList(lengthList);
         tcb.setNameList(tnameList);
         tcb.setPrecisionList(tprecisionList);
         tcb.setScalelist(tscalelist);
         tcb.setTypeList(ttypeList);
         tcb.setDateformatlist(tformatlist);
         if (list.getRuleid() != null && !"".equals(list.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", list.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(ckj.getColumnname(), rule.getMappletname(), tfcolumn.getColumnname()));
            }
         }

         tar_bean.setCb(tcb);
      }

      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      if (!"0".equals(tcoremaskingfilesystem.getLocation())) {
         String dir = "d" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss") + ".txt";
         tar_bean.setFilename(dir);
         tar_bean.setFilepath(this.path);
         tcoremaskingfilesystem.setNote(dir);
         this.tCoreMaskingFilesystemDao.saveOrUpdate(tcoremaskingfilesystem);
      } else {
         tar_bean.setFilename(tcoremaskingfilesystem.getWildcard());
         tar_bean.setFilepath(this.path + tcoremaskingfilesystem.getDirectory());
      }

      tar_bean.setIsftp("0");
      tar_bean.setFtplink("");
      if (tcoremaskingfilesystem.getColumnformat() != null && !"".equals(tcoremaskingfilesystem.getColumnformat())) {
         String format = "A  ";
         format = format + tcoremaskingfilesystem.getColumnformat().length() + " " + tcoremaskingfilesystem.getColumnformat();
         tar_bean.setDateformateparam(format);
      }

      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");
      MakeTargetHiveUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList, task.getTaskname());
      this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
      TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
      temporay.setCreatetime(new Date());
      temporay.setTargetname(tar_bean.getTar_name());
      temporay.setSourcename(sou_bean.getSo_name());
      temporay.setTaskid(task.getId());
      temporay.setType("HIVE>FILE");
      temporay.setWfname(sou_bean.getSo_name());
      temporay.setGroupid(groupid);
      this.tCoreMonitorTemporaryDao.save(temporay);
   }

   public void generateDbtoHiveTaskMasking(TCoreMaskingTask task, String hiveid, String userid, String quick) {
      TCoreMaskingHive hive = (TCoreMaskingHive)this.tCoreMaskingHiveDao.get(hiveid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      TCoreMaskingTable tentity = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", hive.getMappingkey())});
      ParamBean par_bean = new ParamBean();
      new SourceBean();
      TargetBean tar_bean = new TargetBean();
      TargetBean tar_bean_db = new TargetBean();
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      TCoreDatasystem datasource = (TCoreDatasystem)this.tCoreDatasystemDao.get(tentity.getDatasystemid());
      TCoreDatasystem thive = (TCoreDatasystem)this.tCoreDatasystemDao.get(hive.getDatasystemid());
      SourceBean sou_bean = new SourceBean();
      sou_bean.setSo_name(tentity.getTablename());
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setFiledirect("Direct");
      sou_bean.setDatabasetype(datasource.getDbtype());
      sou_bean.setConnectmode(datasource.getConnectmode());
      if ("MYSQL".equals(datasource.getDbtype())) {
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      } else if ("MSSQLSERVER".equals(datasource.getDbtype())) {
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      } else if ("AS400".equals(datasource.getDbtype())) {
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      } else if ("INFORMIX".equals(datasource.getDbtype())) {
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      } else if ("SYBASE".equals(datasource.getDbtype())) {
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      } else {
         this.getDatasystemEngine(datasource.getId(), task.getEngineid());
         sou_bean.setLinkname(datasource.getDblinkname());
         sou_bean.setDbdname(datasource.getDblinkname());
      }

      sou_bean.setVersionnumber("1");
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("");
      sou_bean.setSourceownername(tentity.getDbschema());
      tar_bean.setTar_name(sou_bean.getSo_name());
      tar_bean.setBusinessname("");
      tar_bean.setConstraint("");
      tar_bean.setDatabasetype("Flat File");
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      tar_bean.setLinkname(thive.getDblinkname());
      FlatFileBean flatfile = new FlatFileBean();
      flatfile.setCodepage("utf-8");
      flatfile.setSkiprows("0");
      flatfile.setDelimited("YES");
      flatfile.setDelimiters("||");
      flatfile.setMultidelimitersasand("YES");
      flatfile.setQuote_character("DOUBLE");
      flatfile.setRowdelimiter("0");
      flatfile.setEscape_character("");
      flatfile.setKeepescapechar("NO");
      tar_bean.setFileparam("1");
      tar_bean.setFilebean(flatfile);
      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      CommonBean tcb = new CommonBean();
      List<String> tkeytype = new ArrayList();
      List<String> tnameList = new ArrayList();
      List<String> ttypeList = new ArrayList();
      List<String> tlengthList = new ArrayList();
      List<String> tprecisionList = new ArrayList();
      List<String> tscalelist = new ArrayList();

      for(TCoreMaskingHivecolumn list : this.tCoreMaskingHivecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("tableid", hive.getId())})) {
         tnameList.add(list.getColumnname());
         ttypeList.add(list.getColumntype());
         tlengthList.add(list.getColumnlength());
         tscalelist.add(list.getColumnscale());
         tprecisionList.add(list.getColumnlength());
         tkeytype.add("NOT A KEY");
         tcb.setKeytype(tkeytype);
         tcb.setLengthList(tlengthList);
         tcb.setNameList(tnameList);
         tcb.setPrecisionList(tprecisionList);
         tcb.setScalelist(tscalelist);
         tcb.setTypeList(ttypeList);
         tar_bean.setCb(tcb);
         TCoreMaskingTablecolumn tablecolumn = (TCoreMaskingTablecolumn)this.tCoreMaskingTablecolumnDao.queryUnique(new Criterion[]{Restrictions.eq("mappingkey", list.getMappingkey()), Restrictions.eq("taskid", task.getId())});
         if ("NUMBER".equalsIgnoreCase(tablecolumn.getColumntype()) && !"-127".equals(tablecolumn.getColumnscale())) {
            tablecolumn.setColumntype("number(p,s)");
         }

         nameList.add(tablecolumn.getColumnname());
         typeList.add(tablecolumn.getColumntype());
         lengthList.add(tablecolumn.getColumnlength());
         scalelist.add(tablecolumn.getColumnscale());
         precisionList.add(tablecolumn.getColumnlength());
         if ("1".equals(tablecolumn.getPrimarykey())) {
            keytype.add("PRIMARY KEY");
         } else {
            keytype.add("NOT A KEY");
         }

         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         if (tablecolumn.getRuleid() != null && !"".equals(tablecolumn.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", tablecolumn.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(tablecolumn.getColumnname(), rule.getMappletname(), list.getColumnname()));
            }
         }

         sou_bean.setCb(cb);
         tar_bean_db.setCb(cb);
      }

      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      tar_bean.setFilename(thive.getLocaldir());
      tar_bean.setFilepath(info.getXmldir());
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");
      MakeTargetHiveUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList, task.getTaskname());
      this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
      TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
      temporay.setCreatetime(new Date());
      temporay.setTargetname(sou_bean.getSo_name());
      temporay.setSourcename(sou_bean.getSo_name());
      temporay.setTaskid(task.getId());
      temporay.setType("数据库>HIVE");
      temporay.setWfname(sou_bean.getSo_name());
      this.tCoreMonitorTemporaryDao.save(temporay);
   }

   public void generateTaskDataCopy(TCoreMaskingTask task) {
   }

   public void generateTaskDataGenerate(TCoreMaskingTask task) {
   }

   public void importTask(String taskid) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      if (task != null) {
         String flag = task.getFlag();
         if (flag != null && !"".equals(flag)) {
            if (flag.equals(EmaskingTaskType.DB_TO_FILE.getFlag()) || flag.equals(EmaskingTaskType.DB_TO_DB.getFlag())) {
               this.importTaskMasking(task);
            }

         }
      }
   }

   public void importTaskMasking(TCoreMaskingTask task) {
      TCoreMaskingTable table = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "1")});
      this.importMapping(task.getId(), table.getTablename(), "false");
   }

   public boolean executeTask(String taskid, String userid) {
      String ce = "";
      final Runtime rn = Runtime.getRuntime();
      final TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      if (task == null) {
         return false;
      } else {
         String flag = task.getFlag();
         if (flag != null && !"".equals(flag)) {
            long groupId = (new Date()).getTime();
            if (flag.equals(EmaskingTaskType.DB_TO_FILE.getFlag())) {
               List<TCoreMaskingFilesystem> tcoremaskingfilesystemlist = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId())});

               for(int i = 0; i < tcoremaskingfilesystemlist.size(); ++i) {
                  TCoreMaskingFilesystem tCoreMaskingFilesystem = (TCoreMaskingFilesystem)tcoremaskingfilesystemlist.get(i);
                  TCoreMaskingTable tentity = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", tCoreMaskingFilesystem.getMappingkey())});
                  TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
                  temporay.setGroupid(groupId);
                  temporay.setCreatetime(new Date());
                  temporay.setTargetname(tCoreMaskingFilesystem.getWildcard().split("\\.")[0]);
                  temporay.setSourcename(tentity.getTablename());
                  temporay.setTaskid(task.getId());
                  temporay.setType("数据库>文件");
                  temporay.setWfname(tentity.getTablename());
                  if ("true".equals(tCoreMaskingFilesystem.getIstodatabase())) {
                     Connection tconn = this.getConnectionByDataSystemId(tCoreMaskingFilesystem.getDatasystemid());
                     String ttable = tentity.getTablename();
                     String tschema = tCoreMaskingFilesystem.getDbschema();
                     System.out.println(">>>>>>>>>tschema:" + tschema + " ttable:" + ttable);
                     if (JdbcTool.isTableExisted(tconn, ttable)) {
                        JdbcTool.truncateTable(tconn, tschema, ttable);
                     }

                     JdbcTool.closeConnection(tconn);
                  }

                  this.tCoreMonitorTemporaryDao.save(temporay);
                  Map<String, String> parametermap = new HashMap();
                  parametermap.put("filepath", this.path);
                  parametermap.put("filename", tCoreMaskingFilesystem.getNote());
                  parametermap.put("type", "1");
                  parametermap.put("datasystenid", tCoreMaskingFilesystem.getFtpid());
                  parametermap.put("netfilepath", tCoreMaskingFilesystem.getDirectory());
                  parametermap.put("netfilename", tCoreMaskingFilesystem.getWildcard());
                  List<TCoreMaskingTable> slist = this.tCoreMaskingtableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")});
                  if (null != slist && slist.size() > i) {
                     TCoreMaskingTable tCoreMaskingTable = (TCoreMaskingTable)slist.get(i);
                     TCoreDatasystem sys = this.dataSystemService.queryDataSystemById(tCoreMaskingTable.getDatasystemid());
                     if (EdbType.TERADATA.getDbcode().equals(sys.getDbtype())) {
                        Map<String, String> paramMap = new HashMap();
                        paramMap.put("tablename", tCoreMaskingTable.getTablename());
                        paramMap.put("taskname", task.getTaskname());
                        TeradataTool.createTerdataPipes(paramMap);
                        TeradataTool.execTerdataExportSh(paramMap);
                     }
                  }

                  this.executeFileTaskMasking(task, tentity.getTablename(), userid, temporay, parametermap);
               }
            } else if (flag.equals(EmaskingTaskType.DB_TO_DB.getFlag())) {
               List<TCoreMaskingTable> slist = this.tCoreMaskingtableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")});
               if (null != slist && slist.size() > 0) {
                  TCoreMaskingTable tCoreMaskingTable = (TCoreMaskingTable)slist.get(0);
                  TCoreDatasystem sys = this.dataSystemService.queryDataSystemById(tCoreMaskingTable.getDatasystemid());
                  if (EdbType.TERADATA.getDbcode().equals(sys.getDbtype())) {
                     try {
                        this.executeTeradataTask(taskid, userid);
                     } catch (Exception e) {
                        e.printStackTrace();
                     }

                     return false;
                  }
               }

               List<TCoreMaskingTable> tlist = this.tCoreMaskingtableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "1")});
               final HashMap<String, TCoreMaskingTable> sourceTableMaps = new HashMap();

               for(TCoreMaskingTable tCoreMaskingTable : slist) {
                  sourceTableMaps.put(tCoreMaskingTable.getMappingkey(), tCoreMaskingTable);
               }

               Map<String, TCoreMonitorTemporary> ttMap = new HashMap();
               TCoreDatasystem datatarget = null;

               for(final TCoreMaskingTable tCoreMaskingTable : tlist) {
                  Connection tarconn = this.dataSystemService.getConnectionByDataSystemId(tCoreMaskingTable.getDatasystemid());
                  JdbcTool.delPrimaryForeignKeyAndIndex(tarconn, tCoreMaskingTable.getDbschema(), tCoreMaskingTable.getTablename());
                  JdbcTool.closeConnection(tarconn);
                  TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
                  Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
                  InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
                  TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
                  temporay.setGroupid(groupId);
                  temporay.setCreatetime(new Date());
                  temporay.setTargetname(tCoreMaskingTable.getTablename());
                  temporay.setSourcename(((TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey())).getTablename());
                  temporay.setTaskid(task.getId());
                  temporay.setType("数据库>数据库");
                  temporay.setWfname(((TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey())).getTablename());

                  try {
                     Thread.sleep(1000L);
                  } catch (InterruptedException e) {
                     e.printStackTrace();
                  }

                  SessionBean ss = this.allwaysMonitorService.getRunid(task, info, ((TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey())).getTablename());
                  temporay.setRunid(ss.getWf_run_id());
                  this.tCoreMonitorTemporaryDao.save(temporay);
                  System.out.println("getTablename:" + tCoreMaskingTable.getTablename() + " |temID:" + temporay.getId());
                  ttMap.put(tCoreMaskingTable.getTablename(), temporay);
                  datatarget = this.dataSystemService.queryDataSystemById(tCoreMaskingTable.getDatasystemid());
                  if (datatarget.getDbtype().equals("SYBASE_IQ")) {
                     CommandTool.command("mkfifo /data/infa_sybaseiq/" + task.getTaskname() + "/" + ((TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey())).getTablename() + ".pipe");
                     Thread t = new Thread() {
                        public void run() {
                           Process process = null;

                           try {
                              process = rn.exec("/data/infa_sybaseiq/" + task.getTaskname() + "/" + ((TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey())).getTablename() + ".sh /data/infa_sybaseiq/" + task.getTaskname() + "/" + ((TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey())).getTablename() + ".pipe");
                              process.waitFor();
                              process = rn.exec("rm /data/infa_sybaseiq/" + task.getTaskname() + "/" + ((TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey())).getTablename() + ".pipe");
                           } catch (Exception e) {
                              e.printStackTrace();
                           }

                        }
                     };
                     t.start();
                     this.executeSybaseIQDBTaskMasking(task, userid, tCoreMaskingTable.getMappingkey(), (TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey()), temporay, ((TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey())).getTablename().toString());
                  } else {
                     if (datatarget.getDbtype().equals("MYSQL") && "true".equals(task.getIsspload())) {
                        CommandTool.command("mkfifo /data/infa_mysqlload/" + task.getTaskname() + "/" + ((TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey())).getTablename() + ".pipe");
                        Thread t = new Thread() {
                           public void run() {
                              Process process = null;

                              try {
                                 process = rn.exec("/data/infa_mysqlload/" + task.getTaskname() + "/" + ((TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey())).getTablename() + ".sh");
                                 process.waitFor();
                                 process = rn.exec("rm /data/infa_mysqlload/" + task.getTaskname() + "/" + ((TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey())).getTablename() + ".pipe");
                              } catch (Exception e) {
                                 e.printStackTrace();
                              }

                           }
                        };
                        t.start();
                     }

                     this.executeTaskMasking(task, userid, tCoreMaskingTable.getMappingkey(), (TCoreMaskingTable)sourceTableMaps.get(tCoreMaskingTable.getMappingkey()), temporay);
                     if ("MSSQLSERVER".equals(datatarget.getDbtype()) && "true".equals(task.getIsspload())) {
                        new Properties();

                        try {
                           Properties var95 = PropertiesLoaderUtils.loadAllProperties("config.properties");
                           String errorLog = var95.get("bcp_table_sqlserver_error_log").toString();
                           CommandTool.command("chmod -R 777 /data/infa_sqlserver/");
                           System.out.println("task");
                           this.infoTool.sqlServerBcpExecute(info, task, sourceTableMaps, errorLog, tCoreMaskingTable);
                        } catch (IOException e) {
                           e.printStackTrace();
                        }
                     }
                  }
               }

               TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
               Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
               InfoProperty engineInfo = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
               this.infoTool.curTaskAllWorkflowCompleteMonitor(task, engineInfo, tlist, sourceTableMaps, userid, ttMap);
            } else if (flag.equals(EmaskingTaskType.HIVE_TO_HIVE.getFlag())) {
               List<TCoreMaskingHive> hivelist = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")});
               TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
               Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
               InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
               final String path = info.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname() + File.separator;
               Integer threadnum = Integer.parseInt(XmlTool.getValue("sys/qr-thread"));
               final String delimiter = XmlTool.getValue("sys/qr-delimiter");
               final String charset = XmlTool.getValue("sys/qr-charset");
               ExecutorService pool = Executors.newFixedThreadPool(threadnum);

               for(TCoreMonitorTemporary tCoreMonitorTemporary : this.tCoreMonitorTemporaryDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("taskid", taskid)})) {
                  CommandTool.command("mkfifo " + path + tCoreMonitorTemporary.getSourcename() + ".pipe");
                  this.executeTaskMasking(task, tCoreMonitorTemporary.getSourcename(), userid, tCoreMonitorTemporary);
               }

               for(final TCoreMaskingHive tCoreMaskingHive : hivelist) {
                  pool.execute(new Runnable() {
                     public void run() {
                        String datasystemid = tCoreMaskingHive.getDatasystemid();
                        HashMap<String, Connection> hash = new HashMap();
                        if (hash.get(datasystemid) == null) {
                           TCoreDatasystem datasystem = InfoServiceImpl.this.dataSystemService.queryDataSystemById(tCoreMaskingHive.getDatasystemid());
                           Connection conn = JdbcTool.getConnection(datasystem);
                           hash.put(datasystemid, conn);
                        }

                        PipeTool pipe = new PipeTool((Connection)hash.get(datasystemid), tCoreMaskingHive.getTablename(), path + tCoreMaskingHive.getTablename() + ".pipe", delimiter, charset);
                        pipe.writeFile();
                     }
                  });
               }

               pool.shutdown();
            } else if (flag.equals(EmaskingTaskType.HIVE_TO_DB.getFlag())) {
               List<TCoreMaskingHive> hivelist = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")});
               TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
               Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
               InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
               final String path = info.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname() + File.separator;
               Integer threadnum = Integer.parseInt(XmlTool.getValue("sys/qr-thread"));
               final String delimiter = XmlTool.getValue("sys/qr-delimiter");
               final String charset = XmlTool.getValue("sys/qr-charset");
               ExecutorService pool = Executors.newFixedThreadPool(threadnum);

               for(final TCoreMonitorTemporary tCoreMonitorTemporary : this.tCoreMonitorTemporaryDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("taskid", taskid)})) {
                  CommandTool.command("mkfifo " + path + tCoreMonitorTemporary.getSourcename() + ".pipe");
                  CommandTool.command("mkfifo /data/infa_mysqlload/" + task.getTaskname() + "/" + tCoreMonitorTemporary.getSourcename() + ".pipe");
                  Thread t = new Thread() {
                     public void run() {
                        Process process = null;

                        try {
                           process = rn.exec("/data/infa_mysqlload/" + task.getTaskname() + "/" + tCoreMonitorTemporary.getSourcename() + ".sh");
                           process.waitFor();
                           process = rn.exec("rm /data/infa_mysqlload/" + task.getTaskname() + "/" + tCoreMonitorTemporary.getSourcename() + ".pipe");
                        } catch (Exception e) {
                           e.printStackTrace();
                        }

                     }
                  };
                  t.start();
                  this.executeTaskMasking(task, tCoreMonitorTemporary.getSourcename(), userid, tCoreMonitorTemporary);
               }

               for(final TCoreMaskingHive tCoreMaskingHive : hivelist) {
                  pool.execute(new Runnable() {
                     public void run() {
                        String datasystemid = tCoreMaskingHive.getDatasystemid();
                        HashMap<String, Connection> hash = new HashMap();
                        if (hash.get(datasystemid) == null) {
                           TCoreDatasystem datasystem = InfoServiceImpl.this.dataSystemService.queryDataSystemById(tCoreMaskingHive.getDatasystemid());
                           Connection conn = JdbcTool.getConnection(datasystem);
                           hash.put(datasystemid, conn);
                        }

                        PipeTool pipe = new PipeTool((Connection)hash.get(datasystemid), tCoreMaskingHive.getTablename(), path + tCoreMaskingHive.getTablename() + ".pipe", delimiter, charset);
                        pipe.writeFile();
                     }
                  });
               }

               pool.shutdown();
            } else if (flag.equals(EmaskingTaskType.HIVE_TO_FILE.getFlag())) {
               List<TCoreMaskingHive> hivelist = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")});
               TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
               Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
               InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
               final String path = info.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname() + File.separator;
               Integer threadnum = Integer.parseInt(XmlTool.getValue("sys/qr-thread"));
               final String delimiter = XmlTool.getValue("sys/qr-delimiter");
               final String charset = XmlTool.getValue("sys/qr-charset");
               ExecutorService pool = Executors.newFixedThreadPool(threadnum);

               for(TCoreMonitorTemporary tCoreMonitorTemporary : this.tCoreMonitorTemporaryDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("taskid", taskid)})) {
                  CommandTool.command("mkfifo " + path + tCoreMonitorTemporary.getSourcename() + ".pipe");
                  this.executeTaskMasking(task, tCoreMonitorTemporary.getSourcename(), userid, tCoreMonitorTemporary);
               }

               for(final TCoreMaskingHive tCoreMaskingHive : hivelist) {
                  pool.execute(new Runnable() {
                     public void run() {
                        String datasystemid = tCoreMaskingHive.getDatasystemid();
                        HashMap<String, Connection> hash = new HashMap();
                        if (hash.get(datasystemid) == null) {
                           TCoreDatasystem datasystem = InfoServiceImpl.this.dataSystemService.queryDataSystemById(tCoreMaskingHive.getDatasystemid());
                           Connection conn = JdbcTool.getConnection(datasystem);
                           hash.put(datasystemid, conn);
                        }

                        PipeTool pipe = new PipeTool((Connection)hash.get(datasystemid), tCoreMaskingHive.getTablename(), path + tCoreMaskingHive.getTablename() + ".pipe", delimiter, charset);
                        pipe.writeFile();
                     }
                  });
               }

               pool.shutdown();
            } else if (flag.equals(EmaskingTaskType.DB_TO_HIVE.getFlag())) {
               for(TCoreMonitorTemporary tCoreMonitorTemporary : this.tCoreMonitorTemporaryDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.eq("taskid", taskid)})) {
                  this.executeTaskMasking(task, tCoreMonitorTemporary.getSourcename(), userid, tCoreMonitorTemporary);
               }
            }

            return false;
         } else {
            return false;
         }
      }
   }

   public Connection getConnectionByDataSystemId(String datasystemid) {
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
      String dbcode = datasystem.getDbtype();
      String ip = datasystem.getDbip();
      String port = datasystem.getDbport();
      String servername = datasystem.getDbservername();
      String server = datasystem.getServername();
      String url = "";
      switch (datasystem.getDbtype()) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server);
            break;
         case "TERADATA":
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername, server, datasystem.getPagecode());
            break;
         default:
            url = EdbType.getUrlByEdbcode(dbcode, ip, port, servername);
      }

      String username = datasystem.getUsername();
      String password = "1".equals(datasystem.getFlag()) ? AesTool.decrypt(datasystem.getPassword(), "ghca") : datasystem.getPassword();
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      Connection conn = JdbcTool.getConnection(driver, url, username, password);
      return conn;
   }

   public void generateTask(String taskid) {
   }

   public boolean executeFileTask(String taskid, String userid) throws Exception {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      if (task == null) {
         return false;
      } else {
         String flag = task.getFlag();
         if (flag != null && !"".equals(flag)) {
            long groupId = (new Date()).getTime();
            if (flag.equals(EmaskingTaskType.FILE_TO_DB.getFlag())) {
               TCoreMaskingFilesystem tcoremaskingfilesystem = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId())}).get(0);
               TCoreMaskingTable table = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", tcoremaskingfilesystem.getMappingkey())});
               TCoreDatasystem datatarget = (TCoreDatasystem)this.tCoreDatasystemDao.get(table.getDatasystemid());
               if (datatarget.getDbtype().equals("SYBASE_IQ")) {
                  this.executeFiletoSybaseIQ(taskid, userid, "true");
                  return false;
               }

               if (datatarget.getDbtype().equals("TERADATA")) {
                  this.executeFiletoTeradata(taskid, userid, "true");
                  return false;
               }

               if (datatarget.getDbtype().equals("MYSQL") && "true".equals(task.getIsspload())) {
                  this.executeFiletoMysqlLoad(taskid, userid, "true");
                  return false;
               }

               if (datatarget.getDbtype().equals("MSSQLSERVER") && "true".equals(task.getIsspload())) {
                  this.executeFiletoSqlServerBcp(taskid, userid, "true");
                  return false;
               }

               String quick = "true";
               List<TCoreMaskingFilesystem> tcoremaskingfilesystemlist = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId())});
               List<Map<String, Object>> lm = new ArrayList();
               List<String> l = new ArrayList();

               for(TCoreMaskingFilesystem tCoreMaskingFilesystem : tcoremaskingfilesystemlist) {
                  Map<String, Object> remap = this.executeTaskFileTODBMasking(task, userid, tCoreMaskingFilesystem.getId(), groupId, quick);
                  lm.add(remap);
                  l.add((String)remap.get("so_name") + ".xml");
               }

               if (quick.equals("true")) {
                  TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
                  Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
                  InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
                  String path = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname();
                  String xmlFileName = "newfile_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
                  this.mergeXmlExecute(path, l, xmlFileName);
                  String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
                  File file = new File(con_file);
                  ModifyImportFile mi = new ModifyImportFile();
                  ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, task.getFdname());
                  ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, task.getFdname());
                  ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, engine.getRepository());
                  ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, engine.getRepository());
                  InfoExecUtil.executImport(engine.getPmrepexepath(), path + "/" + xmlFileName + ".xml", file.toString(), engine.getXmldir() + File.separator + "log.txt");

                  for(Map<String, Object> mo : lm) {
                     this.executeFileTaskMasking(task, (String)mo.get("so_name"), userid, (TCoreMonitorTemporary)mo.get("temporay"), (Map)mo.get("parametermap"));
                  }
               }
            } else if (flag.equals(EmaskingTaskType.FILE_TO_FILE.getFlag())) {
               for(TCoreMaskingFilesystem tCoreMaskingFilesystem : this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")})) {
                  this.executeTaskFileTOFileMasking(task, userid, tCoreMaskingFilesystem.getMappingkey(), groupId);
               }
            }

            return false;
         } else {
            return false;
         }
      }
   }

   public boolean executeTeradataTask(String taskid, String userid) throws Exception {
      final TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      long groupId = (new Date()).getTime();
      List<TCoreMaskingFilesystem> tcoremaskingfilesystemlist = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")});
      List<TCoreMaskingTable> slist = this.tCoreMaskingtableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")});
      Integer threadnum = Integer.parseInt(XmlTool.getValue("sys/qr-thread"));
      ExecutorService pool = Executors.newFixedThreadPool(threadnum);
      threadnum = 60;

      for(final TCoreMaskingTable sTable : slist) {
         List<TCoreMaskingTablecolumn> sourceTableColumnlist = this.tCoreMaskingTablecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("tableid", sTable.getId())});
         List<String> nameList = new ArrayList();
         List<String> lengthList = new ArrayList();

         for(TCoreMaskingTablecolumn sourceTableCol : sourceTableColumnlist) {
            nameList.add(sourceTableCol.getColumnname());
            lengthList.add(sourceTableCol.getColumnlength());
         }

         TCoreMaskingTable tTable = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "1"), Restrictions.eq("mappingkey", sTable.getMappingkey())});
         TCoreDatasystem targetSys = (TCoreDatasystem)this.tCoreDatasystemDao.get(tTable.getDatasystemid());
         StringBuffer definesb = new StringBuffer();

         for(int i = 0; i < nameList.size(); ++i) {
            definesb.append((String)nameList.get(i) + "(varchar(" + (String)lengthList.get(i) + ")),");
         }

         Map<String, String> paramMapload = new HashMap();
         paramMapload.put("ip", targetSys.getDbip());
         paramMapload.put("port", targetSys.getDbport());
         paramMapload.put("user", targetSys.getUsername());
         paramMapload.put("pwd", "1".equals(targetSys.getFlag()) ? AesTool.decrypt(targetSys.getPassword(), "ghca") : targetSys.getPassword());
         paramMapload.put("schema", tTable.getDbschema());
         paramMapload.put("table", tTable.getTablename());
         paramMapload.put("path", TeradataTool.STR_PIPEFILE_TAR_PATH + task.getTaskname() + "/");
         paramMapload.put("define", definesb.substring(0, definesb.length() - 1));
         paramMapload.put("in_type", "1");
         String dbcode = targetSys.getDbtype();
         String servername = targetSys.getDbservername();
         String url = EdbType.getUrlByEdbcode(dbcode, targetSys.getDbip(), targetSys.getDbport(), servername, targetSys.getPagecode());
         String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
         paramMapload.put("driver", driver);
         paramMapload.put("url", url);
         paramMapload.put("create_sql", tTable.getCreate_sql());
         TeradataLoadTableTool.executeLoadTable(paramMapload);
         pool.execute(new Runnable() {
            public void run() {
               try {
                  String taskname = task.getTaskname();
                  String tableName = sTable.getTablename();
                  Map<String, String> paramMap = new HashMap();
                  paramMap.put("tablename", tableName);
                  paramMap.put("taskname", taskname);
                  TeradataTool.createTerdataPipes(paramMap);
                  TeradataTool.execTerdataExportSh(paramMap);
                  System.out.println(">>>>>>>>>>teradata fastload start");
                  Process process = Runtime.getRuntime().exec(TeradataTool.STR_PIPEFILE_TAR_PATH + task.getTaskname() + "/" + tableName + ".sh");
                  System.out.println(TeradataTool.STR_PIPEFILE_TAR_PATH + task.getTaskname() + "/" + tableName + ".sh");
                  System.out.println(">>>>>>>>>>teradata fastload end");
               } catch (Exception e) {
                  e.printStackTrace();
               }

            }
         });
         this.executeTeradataTaskMasking(task, userid, sTable.getMappingkey(), groupId);
      }

      pool.shutdown();
      return false;
   }

   public boolean executeTaskMasking(TCoreMaskingTask task, String userid, String mappingkey, TCoreMaskingTable stable, TCoreMonitorTemporary temporay) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         this.infoTool.StartWorkflow(engine, task.getFdname(), "wf_" + stable.getTablename());
      } catch (Exception e1) {
         e1.printStackTrace();
         return false;
      }

      return Boolean.TRUE;
   }

   public boolean executeTaskMasking(TCoreMaskingTask task, String name, String userid, TCoreMonitorTemporary temporay) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         InfoExecUtil.executWorkflow(engine.getPmcmdexepath(), task.getFdname(), engine.getInteservicename(), engine.getDomainname(), engine.getUsername(), engine.getPassword(), "wf_" + name);
      } catch (Exception e1) {
         e1.printStackTrace();
         return false;
      }

      this.infoTool.quartz(task, engine, name, userid, temporay);
      return Boolean.TRUE;
   }

   public boolean executeimpTask(TCoreMaskingTask task, String userid) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      TCoreImporttask timptask = (TCoreImporttask)this.tCoreImporttaskDao.queryUnique(new Criterion[]{Restrictions.eq("taskname", task.getTaskname())});

      try {
         InfoExecUtil.executWorkflow(engine.getPmcmdexepath(), task.getFdname(), engine.getInteservicename(), engine.getDomainname(), engine.getUsername(), engine.getPassword(), timptask.getWfname());
      } catch (Exception e1) {
         e1.printStackTrace();
         return false;
      }

      this.infoTool.quartzimp(task, engine, timptask, userid);
      return Boolean.TRUE;
   }

   public boolean createLinkInEngine(String engineid, String datasystemid, String linkname) {
      return false;
   }

   public boolean executeSubtask(String taskid, String userid) {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      this.importSubMapping(taskid);
      TCoreSubsettask subsetTask = (TCoreSubsettask)this.tCoreSubsettaskDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid)});
      List<TCoreSubsetcolumns> allColumns = this.tCoreSubsetcolumnsDao.querySubsetColumns(subsetTask.getSubsetid());
      Set<String> allTableNames = new HashSet();

      for(TCoreSubsetcolumns column : allColumns) {
         String tableName = column.getTablename();
         allTableNames.add(tableName);
      }

      for(String string : allTableNames) {
         Connection sc = this.dataSystemService.getConnectionByDataSystemId(subsetTask.getSourcedatasystemid());
         Connection tc = this.dataSystemService.getConnectionByDataSystemId(subsetTask.getTargetdatasystemid());
         JdbcTool.copyTable(sc, subsetTask.getSourceschema(), string, tc, subsetTask.getTargetschema(), subsetTask.getPrefix() + string);

         try {
            if (sc != null) {
               sc.close();
            }

            if (tc != null) {
               tc.close();
            }
         } catch (Exception var15) {
         }
      }

      this.executeSubMapping(subsetTask.getTaskid());
      this.infoTool.quartzsub(task, engine, task.getTaskname(), userid);
      return true;
   }

   public TCoreSyncKeyindex querySync(String taskid, String sourcename) {
      TCoreSyncKeyindex sync = (TCoreSyncKeyindex)this.tCoreSyncKeyindexDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tasktableid", sourcename)});
      return sync;
   }

   public void test() {
      System.out.println("主方法");
   }

   public boolean createFileTask(String taskid, String userid) {
      return false;
   }

   public boolean createTask(String taskid, String userid, String quick, Map<String, String> dataMap) throws Exception {
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String xmlsPath = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname();
      FileTool.delFolder(xmlsPath);
      if (task == null) {
         return false;
      } else {
         String flag = task.getFlag();
         if (flag != null && !"".equals(flag)) {
            if (flag.equals(EmaskingTaskType.DB_TO_FILE.getFlag())) {
               for(TCoreMaskingFilesystem tCoreMaskingFilesystem : this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId())})) {
                  if ("TERADATA".equals(dataMap.get("sdsdbtype"))) {
                     this.generateTeradataDbtoFileTaskMasking(task, tCoreMaskingFilesystem.getId(), userid, quick);
                  } else {
                     this.generateDbtoFileTaskMasking(task, tCoreMaskingFilesystem.getId(), userid, quick);
                  }
               }

               if (quick.equals("true")) {
                  this.mergeXml(xmlsPath, task.getTaskname());
                  String path = xmlsPath + File.separator + task.getTaskname() + ".xml";
                  String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
                  File file = new File(con_file);
                  InfoExecUtil.executImport(engine.getPmrepexepath(), path, file.toString(), engine.getXmldir() + File.separator + "log.txt");
               }
            } else if (flag.equals(EmaskingTaskType.DB_TO_DB.getFlag())) {
               for(TCoreMaskingTable tCoreMaskingTable : this.tCoreMaskingtableDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "1")})) {
                  this.generateDbtoDbTaskMasking(task, tCoreMaskingTable.getMappingkey(), userid, quick);
               }

               if (quick.equals("true")) {
                  this.mergeXml(xmlsPath, task.getTaskname());
                  String path = xmlsPath + File.separator + task.getTaskname() + ".xml";
                  String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
                  File file = new File(con_file);
                  InfoExecUtil.executImport(engine.getPmrepexepath(), path, file.toString(), engine.getXmldir() + File.separator + "log.txt");
               }
            } else if (flag.equals(EmaskingTaskType.HIVE_TO_HIVE.getFlag())) {
               List<TCoreMaskingHive> hivelist = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")});
               InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
               this.tCoreMonitorTemporaryDao.remove(new Criterion[]{Restrictions.eq("taskid", task.getId())});
               long groupid = (new Date()).getTime();

               for(TCoreMaskingHive tCoreMaskingHive : hivelist) {
                  this.generateHivetoHiveTaskMasking(task, tCoreMaskingHive.getMappingkey(), userid, "fasle", groupid);
               }
            } else if (flag.equals(EmaskingTaskType.HIVE_TO_DB.getFlag())) {
               List<TCoreMaskingHive> hivelist = this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("datadirection", "0")});
               String tdbid = (String)dataMap.get("tdsdbid");
               String tdbschema = (String)dataMap.get("tdsdbschema");
               InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
               this.tCoreMonitorTemporaryDao.remove(new Criterion[]{Restrictions.eq("taskid", task.getId())});
               long groupid = (new Date()).getTime();

               for(TCoreMaskingHive tCoreMaskingHive : hivelist) {
                  this.generateHiveToDbTaskMasking(task, tCoreMaskingHive.getMappingkey(), userid, "fasle", groupid, tdbid, tdbschema);
               }
            } else if (flag.equals(EmaskingTaskType.HIVE_TO_FILE.getFlag())) {
               List<TCoreMaskingFilesystem> tcoremaskingfilesystemlist = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId())});
               String dateformat = (String)dataMap.get("createstructure[columnformat]");
               InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
               this.tCoreMonitorTemporaryDao.remove(new Criterion[]{Restrictions.eq("taskid", task.getId())});
               long groupid = (new Date()).getTime();

               for(TCoreMaskingFilesystem tCoreMaskingFilesystem : tcoremaskingfilesystemlist) {
                  this.generateHiveToFileTaskMasking(task, tCoreMaskingFilesystem.getId(), userid, "false", groupid, dateformat);
               }
            } else if (flag.equals(EmaskingTaskType.DB_TO_HIVE.getFlag())) {
               for(TCoreMaskingHive hive : this.tCoreMaskingHiveDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId())})) {
                  this.generateDbtoHiveTaskMasking(task, hive.getId(), userid, quick);
               }
            }

            return false;
         } else {
            return false;
         }
      }
   }

   public void mergeXml(String filePath, String xmlFileName) {
      try {
         List<String> l = new ArrayList();
         File f = new File(filePath);
         if (!f.exists()) {
            return;
         }

         File[] fa = f.listFiles();

         for(int i = 0; i < fa.length; ++i) {
            File fs = fa[i];
            if (!fs.isDirectory()) {
               String fileName = fs.getName();
               String extension = fileName.substring(fileName.lastIndexOf("."));
               String noextension = fileName.substring(0, fileName.lastIndexOf("."));
               if (extension.equals(".xml") && !(noextension + extension).equals(xmlFileName + ".xml")) {
                  l.add(fs.getName());
               }
            }
         }

         this.mergeXmlExecute(filePath, l, xmlFileName);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public void mergeXmlExecute(String path, List<String> l, String xmlFileName) {
      try {
         if (l.size() != 0) {
            File xf = new File(path + "/" + xmlFileName + ".xml");
            if (!xf.exists()) {
               xf.createNewFile();
            }

            StringBuffer xmlstring = new StringBuffer();
            if (l.size() == 1) {
               File xmlf = new File(path + "/" + (String)l.get(0));
               InputStreamReader read = new InputStreamReader(new FileInputStream(xmlf), "UTF-8");
               BufferedReader bufferedReader = new BufferedReader(read);
               String lineTxt = null;

               while((lineTxt = bufferedReader.readLine()) != null) {
                  xmlstring.append(lineTxt + "\n");
               }
            } else {
               for(int i = 0; i < l.size(); ++i) {
                  if (i == 0) {
                     File xmlf = new File(path + "/" + (String)l.get(i));
                     System.out.println(path + "/" + (String)l.get(i));
                     boolean isWrite = true;
                     InputStreamReader read = new InputStreamReader(new FileInputStream(xmlf), "UTF-8");
                     BufferedReader bufferedReader = new BufferedReader(read);
                     String lineTxt = null;

                     while((lineTxt = bufferedReader.readLine()) != null && !lineTxt.replaceAll(" ", "").substring(0, 8).equals("</FOLDER")) {
                        xmlstring.append(lineTxt + "\n");
                     }

                     read.close();
                  } else if (i == l.size() - 1) {
                     File xmlf = new File(path + "/" + (String)l.get(i));
                     boolean isWrite = false;
                     InputStreamReader read = new InputStreamReader(new FileInputStream(xmlf), "UTF-8");
                     BufferedReader bufferedReader = new BufferedReader(read);
                     String lineTxt = null;

                     while((lineTxt = bufferedReader.readLine()) != null) {
                        if (isWrite) {
                           xmlstring.append(lineTxt + "\n");
                        }

                        if (lineTxt.replaceAll(" ", "").substring(0, 7).equals("<FOLDER")) {
                           isWrite = true;
                        }
                     }

                     read.close();
                  } else {
                     File xmlf = new File(path + "/" + (String)l.get(i));
                     boolean isWrite = false;
                     InputStreamReader read = new InputStreamReader(new FileInputStream(xmlf), "UTF-8");
                     BufferedReader bufferedReader = new BufferedReader(read);
                     String lineTxt = null;

                     while((lineTxt = bufferedReader.readLine()) != null) {
                        if (lineTxt.replaceAll(" ", "").substring(0, 8).equals("</FOLDER")) {
                           isWrite = false;
                        }

                        if (isWrite) {
                           xmlstring.append(lineTxt + "\n");
                        }

                        if (lineTxt.replaceAll(" ", "").substring(0, 7).equals("<FOLDER")) {
                           isWrite = true;
                        }
                     }

                     read.close();
                  }
               }
            }

            FileOutputStream writerStream = new FileOutputStream(path + "/" + xmlFileName + ".xml");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(writerStream, "UTF-8"));
            writer.write(xmlstring.toString());
            writer.flush();
            writer.close();
         }
      } catch (Exception var12) {
      }

   }

   public void controlTask(String taskid, String userid) throws Exception {
      this.infoTool.control(taskid, userid);
   }

   public boolean executeFileTaskMasking(TCoreMaskingTask task, String name, String userid, TCoreMonitorTemporary temporay, Map<String, String> parametermap) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         this.infoTool.StartWorkflow(engine, task.getFdname(), "wf_" + name);
      } catch (Exception e1) {
         e1.printStackTrace();
         return false;
      }

      this.infoTool.quartzFileTask(task, engine, name, userid, temporay, parametermap);
      return Boolean.TRUE;
   }

   public boolean executeFiletoSybaseIQ(String taskid, String userid, String quick) throws Exception {
      final Runtime rn = Runtime.getRuntime();
      final TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String xmlsPath = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname();
      FileTool.delFolder(xmlsPath);
      if (task == null) {
         return false;
      } else {
         String flag = task.getFlag();
         if (flag != null && !"".equals(flag)) {
            long groupId = (new Date()).getTime();
            List<TCoreMaskingFilesystem> tcoremaskingfilesystemlist = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId())});
            List<Map<String, Object>> lm = new ArrayList();
            List<String> l = new ArrayList();

            for(TCoreMaskingFilesystem tCoreMaskingFilesystem : tcoremaskingfilesystemlist) {
               Map<String, Object> remap = this.generateFileToSybaseIQTaskMasking(task, userid, tCoreMaskingFilesystem.getId(), groupId, quick);
               lm.add(remap);
               l.add((String)remap.get("so_name") + ".xml");
            }

            if (quick.equals("true")) {
               String path = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname();
               String xmlFileName = "newfile_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
               this.mergeXmlExecute(path, l, xmlFileName);
               String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
               File file = new File(con_file);
               ModifyImportFile mi = new ModifyImportFile();
               ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, task.getFdname());
               ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, task.getFdname());
               ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, engine.getRepository());
               ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, engine.getRepository());
               InfoExecUtil.executImport(engine.getPmrepexepath(), path + "/" + xmlFileName + ".xml", file.toString(), engine.getXmldir() + File.separator + "log.txt");
            }

            for(final Map<String, Object> mo : lm) {
               CommandTool.command("mkfifo /data/infa_sybaseiq/" + task.getTaskname() + "/" + mo.get("table") + ".pipe");
               Thread t = new Thread() {
                  public void run() {
                     Process process = null;

                     try {
                        process = rn.exec("/data/infa_sybaseiq/" + task.getTaskname() + "/" + mo.get("table") + ".sh /data/infa_sybaseiq/" + task.getTaskname() + "/" + mo.get("table") + ".pipe");
                        process.waitFor();
                        process = rn.exec("rm /data/infa_sybaseiq/" + task.getTaskname() + "/" + mo.get("table") + ".pipe");
                     } catch (Exception e) {
                        e.printStackTrace();
                     }

                  }
               };
               t.start();
               this.executeSybaseIQTaskMasking(task, (String)mo.get("so_name"), userid, (TCoreMonitorTemporary)mo.get("temporay"), (Map)mo.get("parametermap"), mo.get("table").toString());
            }

            return false;
         } else {
            return false;
         }
      }
   }

   public Map<String, Object> generateFileToSybaseIQTaskMasking(TCoreMaskingTask task, String userid, String filesysid, long groupId, String quick) throws Exception {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      Map<String, Object> remap = new HashMap();
      TCoreMaskingFilesystem tcoremaskingfilesystem = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.get(filesysid);
      TCoreFileStructure tcorefilestructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(tcoremaskingfilesystem.getStructureid());
      ParamBean par_bean = new ParamBean();
      SourceBean sou_bean = new SourceBean();
      TargetBean tar_bean = new TargetBean();
      FlatFileBean flatfile = new FlatFileBean();
      FlatFileBean tflatfile = new FlatFileBean();
      if ("0".equals(tcorefilestructure.getSplitertype())) {
         TCoreFileStructurespliter tcorefilestructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
         flatfile.setSkiprows(tcorefilestructure.getSkiprows());
         flatfile.setDelimited("YES");
         flatfile.setDelimiters(tcorefilestructurespliter.getDelimiters());
         flatfile.setMultidelimitersasand(tcorefilestructurespliter.getMultidelimitersasand());
         flatfile.setQuote_character(tcorefilestructurespliter.getQuotecharacter());
         flatfile.setRowdelimiter(tcorefilestructurespliter.getRowdelimiter());
         flatfile.setEscape_character(tcorefilestructurespliter.getEscapecharacter());
         flatfile.setKeepescapechar(tcorefilestructurespliter.getKeepescapechar());
         sou_bean.setFileparam("1");
      } else {
         TCoreFileStructurewidth width = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
         flatfile.setSkiprows(tcorefilestructure.getSkiprows());
         flatfile.setLinesequential(width.getLinesequential());
         flatfile.setNullchartype(width.getNullchartype());
         flatfile.setNull_character(width.getNullcharacter());
         flatfile.setRepeatable(width.getRepeatable());
         flatfile.setPadbytes(width.getPadbytes());
         flatfile.setShiftsensitivedata(width.getShiftsensitivedata());
         flatfile.setStriptrailingblanks(width.getStriptrailingblanks());
      }

      sou_bean.setFilebean(flatfile);
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setDatabasetype("Flat File");
      sou_bean.setLinkname("");
      sou_bean.setDbdname("");
      sou_bean.setVersionnumber("1");
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("");
      sou_bean.setSourceownername("");
      TCoreMaskingTable table = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", tcoremaskingfilesystem.getMappingkey())});
      TCoreDatasystem datatarget = (TCoreDatasystem)this.tCoreDatasystemDao.get(table.getDatasystemid());
      tar_bean.setTar_name(table.getTablename());
      tar_bean.setBusinessname("");
      tar_bean.setConstraint("");
      tar_bean.setDatabasetype("Flat File");
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      tar_bean.setTargetownername(table.getDbschema());
      tar_bean.setInserttype(task.getInserttype());
      tar_bean.setConnectmode(datatarget.getConnectmode());
      tar_bean.setFilecommand("");
      if (datatarget.getPagecode().equals("GBK")) {
         tflatfile.setCodepage("MS936");
      } else {
         tflatfile.setCodepage("UTF-8");
      }

      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      tflatfile.setSkiprows("0");
      tflatfile.setDelimited("YES");
      tflatfile.setDelimiters(props.getProperty("load_table_col_split"));
      tflatfile.setMultidelimitersasand("YES");
      tflatfile.setQuote_character("NONE");
      tflatfile.setRowdelimiter("10");
      tflatfile.setEscape_character("");
      tflatfile.setKeepescapechar("NO");
      tar_bean.setFilebean(tflatfile);
      tar_bean.setFileparam("1");
      List<TCoreMaskingFilecolumn> tcoremaskingfilesystemlist = this.tCoreMaskingFilecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("filesystemid", tcoremaskingfilesystem.getId())});
      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      List<String> formatlist = new ArrayList();

      for(TCoreMaskingFilecolumn list : tcoremaskingfilesystemlist) {
         TCoreFileStructurecolumn ckj = (TCoreFileStructurecolumn)this.tCoreFileStructurecolumnDao.get(list.getStructurecolumnid());
         keytype.add("NOT A KEY");
         nameList.add(ckj.getColumnname());
         typeList.add(ckj.getColumntype());
         lengthList.add(ckj.getColumnaccuracy());
         scalelist.add(ckj.getColumndecimal());
         precisionList.add(ckj.getColumnaccuracy());
         if (ckj.getColumnformat() != null && !"".equals(ckj.getColumnformat())) {
            formatlist.add("F  29 " + ckj.getColumnformat());
         } else {
            formatlist.add("");
         }

         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         cb.setDateformatlist(formatlist);
         sou_bean.setCb(cb);
         if (ckj.getColumnformat() != null && !"".equals(ckj.getColumnformat())) {
            formatlist.add("A  19 mm/dd/yyyy hh24:mi:ss");
         } else {
            formatlist.add("");
         }

         cb.setDateformatlist(formatlist);
         if (list.getRuleid() != null && !"".equals(list.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", list.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(ckj.getColumnname(), rule.getMappletname(), ckj.getColumnname()));
            }
         }

         tar_bean.setCb(cb);
      }

      List<String> fmt = sou_bean.getCb().getDateformatlist();

      for(int i = 0; i < fmt.size(); ++i) {
         if (fmt.get(i) != null && !"".equals(fmt.get(i))) {
            tar_bean.setDateformateparam("A  19 mm/dd/yyyy hh24:mi:ss");
            break;
         }
      }

      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      Map<String, String> loadmap = new HashMap();
      loadmap.put("user", datatarget.getUsername());
      loadmap.put("pwd", "1".equals(datatarget.getFlag()) ? AesTool.decrypt(datatarget.getPassword(), "ghca") : datatarget.getPassword());
      loadmap.put("ip", datatarget.getDbip());
      loadmap.put("port", datatarget.getDbport());
      loadmap.put("table", table.getTablename());
      loadmap.put("schema", table.getDbschema());
      loadmap.put("path", "/data/infa_sybaseiq/" + task.getTaskname() + "/" + table.getTablename() + ".sh");
      StringBuffer muliticolname = new StringBuffer();

      for(int i = 0; i < nameList.size(); ++i) {
         muliticolname.append((String)nameList.get(i) + "|" + (String)typeList.get(i) + ",");
      }

      loadmap.put("lm", muliticolname.substring(0, muliticolname.length() - 1));
      SybaseIQLoadTableTool.executeLoadTable(loadmap);
      tar_bean.setFilename(table.getTablename() + ".pipe");
      tar_bean.setFilepath("/data/infa_sybaseiq/" + task.getTaskname() + "/");
      String note = "";
      if (!"0".equals(tcoremaskingfilesystem.getLocation())) {
         String dir = "d" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss") + ".txt";
         TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(tcoremaskingfilesystem.getFtpid());
         if (tcoremaskingfilesystem.getLocation().equals("1")) {
            String username = datasystem.getUsername();
            String password = datasystem.getPassword();
            String host = datasystem.getDbip();
            Integer port = Integer.parseInt(datasystem.getDbport());
            boolean flag = false;
            String directory = tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag();
            String wildcard = tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote();
            flag = FtpTool.downFile(host, port, username, password, directory, wildcard, this.path + dir);
            if (!flag) {
               return null;
            }

            note = dir;
         } else if (tcoremaskingfilesystem.getLocation().equals("2")) {
            String username = datasystem.getUsername();
            String password = datasystem.getPassword();
            String host = datasystem.getDbip();
            Integer port = Integer.parseInt(datasystem.getDbport());
            SFTPUtil sftp = new SFTPUtil(username, password, host, port);
            ResultVO resultvo = SFTPUtil.login();
            boolean b = resultvo.getResult();
            if (!b) {
               return null;
            }

            try {
               String directory = tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag();
               String wildcard = tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote();
               sftp.download(directory, wildcard, this.path + dir);
               note = dir;
            } catch (Exception var48) {
               return null;
            }

            sftp.logout();
         }

         tcoremaskingfilesystem.setFlag(tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag());
         tcoremaskingfilesystem.setNote(tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote());
         tcoremaskingfilesystem.setDirectory("");
         tcoremaskingfilesystem.setWildcard(dir);
      }

      sou_bean.setIsftp("0");
      sou_bean.setFtplink("");
      sou_bean.setFilepath(this.path + tcoremaskingfilesystem.getDirectory());
      sou_bean.setFiledirect("Indirect");
      File f = new File(this.path + tcoremaskingfilesystem.getDirectory());
      List<String> resultFileName = new ArrayList();
      List<String> filelist = FileTool.ergodicreg(f, resultFileName, tcoremaskingfilesystem.getWildcard());
      String dir = DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
      FileTool.createFile(this.path + tcoremaskingfilesystem.getDirectory() + File.separator + "direct" + dir + ".txt");
      sou_bean.setSo_name("file_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
      StringBuffer sb = new StringBuffer();

      for(int i = 0; i < filelist.size(); ++i) {
         sb.append((String)filelist.get(i) + "\r\n");
      }

      String sourcefilecode = tcoremaskingfilesystem.getSourcefilecode();
      sourcefilecode = this.getFileCode(filelist, sourcefilecode);
      sou_bean.getFilebean().setCodepage(sourcefilecode);
      System.out.println(">>>>>>>>>>>>end脱敏文件 的编码格式为：" + sourcefilecode + ">>>>>>>>>>>>>");

      try {
         RandomAccessFile mm = null;
         mm = new RandomAccessFile(this.path + tcoremaskingfilesystem.getDirectory() + File.separator + "direct" + dir + ".txt", "rw");
         mm.writeBytes(sb.toString());
         mm.close();
      } catch (Exception var47) {
         return null;
      }

      sou_bean.setFilename("direct" + dir + ".txt");
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");
      MakeIsomerUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList, task.getIstruncate());
      if (!quick.equals("true")) {
         this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
      }

      TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
      temporay.setGroupid(groupId);
      temporay.setCreatetime(new Date());
      temporay.setTargetname(tar_bean.getTar_name());
      temporay.setSourcename(sou_bean.getSo_name().split("_")[0]);
      temporay.setTaskid(task.getId());
      temporay.setType("文件>数据库");
      temporay.setWfname(sou_bean.getSo_name());
      this.tCoreMonitorTemporaryDao.save(temporay);
      Map<String, String> parametermap = new HashMap();
      parametermap.put("filepath", this.path);
      parametermap.put("filename", note);
      parametermap.put("type", "2");
      parametermap.put("datasystenid", tcoremaskingfilesystem.getFtpid());
      parametermap.put("netfilepath", tcoremaskingfilesystem.getDirectory());
      parametermap.put("netfilename", tcoremaskingfilesystem.getWildcard());
      remap.put("so_name", sou_bean.getSo_name());
      remap.put("temporay", temporay);
      remap.put("parametermap", parametermap);
      remap.put("table", table.getTablename());
      return remap;
   }

   public boolean executeSybaseIQTaskMasking(TCoreMaskingTask task, String name, String userid, TCoreMonitorTemporary temporay, Map<String, String> parametermap, String tablename) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         this.infoTool.StartWorkflow(engine, task.getFdname(), "wf_" + name);
      } catch (Exception e1) {
         e1.printStackTrace();
         return false;
      }

      this.infoTool.quartzFileTask(task, engine, name, userid, temporay, parametermap);
      return Boolean.TRUE;
   }

   public boolean executeTeradataTaskMasking(TCoreMaskingTask task, String name, String userid, TCoreMonitorTemporary temporay, Map<String, String> parametermap, String tablename) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         this.infoTool.StartWorkflow(engine, task.getFdname(), "wf_" + name);
      } catch (Exception e1) {
         e1.printStackTrace();
         return false;
      }

      this.infoTool.quartzFileTask(task, engine, name, userid, temporay, parametermap);
      return Boolean.TRUE;
   }

   public boolean executeSybaseIQDBTaskMasking(TCoreMaskingTask task, String userid, String mappingkey, TCoreMaskingTable stable, TCoreMonitorTemporary temporay, String tablename) {
      System.out.println("in InfoServiceImpl.executeSybaseIQDBTaskMasking " + tablename);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         InfoExecUtil.executeSybaseIQWorkflow(engine.getPmcmdexepath(), task.getFdname(), engine.getInteservicename(), engine.getDomainname(), engine.getUsername(), engine.getPassword(), "wf_" + stable.getTablename(), tablename, task);
      } catch (Exception e1) {
         e1.printStackTrace();
         return false;
      }

      return Boolean.TRUE;
   }

   public boolean executeFiletoTeradata(String taskid, String userid, String quick) throws Exception {
      final Runtime rn = Runtime.getRuntime();
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String xmlsPath = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname();
      FileTool.delFolder(xmlsPath);
      if (task == null) {
         return false;
      } else {
         String flag = task.getFlag();
         if (flag != null && !"".equals(flag)) {
            long groupId = (new Date()).getTime();
            List<TCoreMaskingFilesystem> tcoremaskingfilesystemlist = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId())});
            List<Map<String, Object>> lm = new ArrayList();
            List<String> l = new ArrayList();

            for(TCoreMaskingFilesystem tCoreMaskingFilesystem : tcoremaskingfilesystemlist) {
               Map<String, Object> remap = this.generateFileToTeradataTaskMasking(task, userid, tCoreMaskingFilesystem.getId(), groupId, quick);
               lm.add(remap);
               l.add((String)remap.get("so_name") + ".xml");
               if (!remap.get("create_table").equals("success")) {
                  return false;
               }
            }

            if (quick.equals("true")) {
               String path = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname();
               String xmlFileName = "newfile_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
               this.mergeXmlExecute(path, l, xmlFileName);
               String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
               File file = new File(con_file);
               ModifyImportFile mi = new ModifyImportFile();
               ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, task.getFdname());
               ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, task.getFdname());
               ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, engine.getRepository());
               ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, engine.getRepository());
               InfoExecUtil.executImport(engine.getPmrepexepath(), path + "/" + xmlFileName + ".xml", file.toString(), engine.getXmldir() + File.separator + "log.txt");
            }

            for(final Map<String, Object> mo : lm) {
               CommandTool.command("rm " + mo.get("path").toString() + "tar_" + mo.get("table") + ".pipe");
               CommandTool.command("mkfifo " + mo.get("path") + "tar_" + mo.get("table") + ".pipe");
               System.out.println("mkfifo " + mo.get("path") + "tar_" + mo.get("table") + ".pipe");
               Thread t = new Thread() {
                  public void run() {
                     Process process = null;

                     try {
                        process = rn.exec(mo.get("path").toString() + mo.get("table").toString() + ".sh");
                        process.waitFor();
                     } catch (Exception e) {
                        e.printStackTrace();
                     }

                  }
               };
               t.start();
               this.executeTeradataTaskMasking(task, (String)mo.get("so_name"), userid, (TCoreMonitorTemporary)mo.get("temporay"), (Map)mo.get("parametermap"), mo.get("table").toString());
            }

            return false;
         } else {
            return false;
         }
      }
   }

   public Map<String, Object> generateFileToTeradataTaskMasking(TCoreMaskingTask task, String userid, String filesysid, long groupId, String quick) throws Exception {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      Map<String, Object> remap = new HashMap();
      TCoreMaskingFilesystem tcoremaskingfilesystem = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.get(filesysid);
      TCoreFileStructure tcorefilestructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(tcoremaskingfilesystem.getStructureid());
      ParamBean par_bean = new ParamBean();
      SourceBean sou_bean = new SourceBean();
      TargetBean tar_bean = new TargetBean();
      FlatFileBean flatfile = new FlatFileBean();
      FlatFileBean tflatfile = new FlatFileBean();
      if ("0".equals(tcorefilestructure.getSplitertype())) {
         TCoreFileStructurespliter tcorefilestructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
         flatfile.setSkiprows(tcorefilestructure.getSkiprows());
         flatfile.setDelimited("YES");
         flatfile.setDelimiters(tcorefilestructurespliter.getDelimiters());
         flatfile.setMultidelimitersasand(tcorefilestructurespliter.getMultidelimitersasand());
         flatfile.setQuote_character(tcorefilestructurespliter.getQuotecharacter());
         flatfile.setRowdelimiter(tcorefilestructurespliter.getRowdelimiter());
         flatfile.setEscape_character(tcorefilestructurespliter.getEscapecharacter());
         flatfile.setKeepescapechar(tcorefilestructurespliter.getKeepescapechar());
         sou_bean.setFileparam("1");
      } else {
         TCoreFileStructurewidth width = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
         flatfile.setSkiprows(tcorefilestructure.getSkiprows());
         flatfile.setLinesequential(width.getLinesequential());
         flatfile.setNullchartype(width.getNullchartype());
         flatfile.setNull_character(width.getNullcharacter());
         flatfile.setRepeatable(width.getRepeatable());
         flatfile.setPadbytes(width.getPadbytes());
         flatfile.setShiftsensitivedata(width.getShiftsensitivedata());
         flatfile.setStriptrailingblanks(width.getStriptrailingblanks());
      }

      sou_bean.setFilebean(flatfile);
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setDatabasetype("Flat File");
      sou_bean.setLinkname("");
      sou_bean.setDbdname("");
      sou_bean.setVersionnumber("1");
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("");
      sou_bean.setSourceownername("");
      TCoreMaskingTable table = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", tcoremaskingfilesystem.getMappingkey())});
      TCoreDatasystem datatarget = (TCoreDatasystem)this.tCoreDatasystemDao.get(table.getDatasystemid());
      tar_bean.setTar_name(table.getTablename());
      tar_bean.setBusinessname("");
      tar_bean.setConstraint("");
      tar_bean.setDatabasetype("Flat File");
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      tar_bean.setTargetownername(table.getDbschema());
      tar_bean.setInserttype(task.getInserttype());
      tar_bean.setConnectmode(datatarget.getConnectmode());
      tar_bean.setFilecommand("");
      if (datatarget.getPagecode().equals("GBK")) {
         tflatfile.setCodepage("MS936");
      } else {
         tflatfile.setCodepage("UTF-8");
      }

      new Properties();
      Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      tflatfile.setSkiprows("0");
      tflatfile.setDelimited("YES");
      tflatfile.setDelimiters(props.getProperty("load_table_teradata_col_split"));
      tflatfile.setMultidelimitersasand("YES");
      tflatfile.setQuote_character("NONE");
      tflatfile.setRowdelimiter("10");
      tflatfile.setEscape_character("");
      tflatfile.setKeepescapechar("NO");
      tar_bean.setFilebean(tflatfile);
      tar_bean.setFileparam("1");
      List<TCoreMaskingFilecolumn> tcoremaskingfilesystemlist = this.tCoreMaskingFilecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("filesystemid", tcoremaskingfilesystem.getId())});
      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      List<String> formatlist = new ArrayList();

      for(TCoreMaskingFilecolumn list : tcoremaskingfilesystemlist) {
         TCoreFileStructurecolumn ckj = (TCoreFileStructurecolumn)this.tCoreFileStructurecolumnDao.get(list.getStructurecolumnid());
         keytype.add("NOT A KEY");
         nameList.add(ckj.getColumnname());
         typeList.add(ckj.getColumntype());
         lengthList.add(ckj.getColumnaccuracy());
         scalelist.add(ckj.getColumndecimal());
         precisionList.add(ckj.getColumnaccuracy());
         if (ckj.getColumnformat() != null && !"".equals(ckj.getColumnformat())) {
            formatlist.add("F  29 " + ckj.getColumnformat());
         } else {
            formatlist.add("");
         }

         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         cb.setDateformatlist(formatlist);
         if (list.getRuleid() != null && !"".equals(list.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", list.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(ckj.getColumnname(), rule.getMappletname(), ckj.getColumnname()));
            }
         }

         sou_bean.setCb(cb);
         tar_bean.setCb(cb);
      }

      List<String> fmt = sou_bean.getCb().getDateformatlist();

      for(int i = 0; i < fmt.size(); ++i) {
         if (fmt.get(i) != null && !"".equals(fmt.get(i))) {
            tar_bean.setDateformateparam("A  19 YYYY-MM-DD HH24:MI:SS");
            break;
         }
      }

      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      Map<String, String> loadmap = new HashMap();
      loadmap.put("user", datatarget.getUsername());
      loadmap.put("pwd", "1".equals(datatarget.getFlag()) ? AesTool.decrypt(datatarget.getPassword(), "ghca") : datatarget.getPassword());
      loadmap.put("ip", datatarget.getDbip());
      loadmap.put("port", datatarget.getDbport());
      loadmap.put("table", table.getTablename());
      loadmap.put("schema", table.getDbschema());
      String dbcode = datatarget.getDbtype();
      String servername = datatarget.getDbservername();
      String url = EdbType.getUrlByEdbcode(dbcode, datatarget.getDbip(), datatarget.getDbport(), servername, datatarget.getPagecode());
      String driver = EdbType.getEdbTypeByDbcode(dbcode).getDbdriver();
      loadmap.put("driver", driver);
      loadmap.put("url", url);
      loadmap.put("path", "/data/infa_teradata/" + task.getTaskname() + "/");
      StringBuffer muliticolname = new StringBuffer();
      StringBuffer definesb = new StringBuffer();

      for(int i = 0; i < nameList.size(); ++i) {
         muliticolname.append((String)nameList.get(i) + "|" + (String)typeList.get(i) + ",");
         definesb.append((String)nameList.get(i) + "(varchar(" + (String)lengthList.get(i) + ")),");
      }

      loadmap.put("lm", muliticolname.substring(0, muliticolname.length() - 1));
      loadmap.put("define", definesb.substring(0, definesb.length() - 1));
      loadmap.put("in_type", "1");
      loadmap.put("create_sql", table.getCreate_sql());
      System.out.println("create_sql:" + table.getNote());
      boolean is_create = TeradataLoadTableTool.executeLoadTable(loadmap);
      System.out.println("define" + (String)loadmap.get("define"));
      tar_bean.setFilename("tar_" + table.getTablename() + ".pipe");
      tar_bean.setFilepath("/data/infa_teradata/" + task.getTaskname() + "/");
      String note = "";
      if (!"0".equals(tcoremaskingfilesystem.getLocation())) {
         String dir = "d" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss") + ".txt";
         TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(tcoremaskingfilesystem.getFtpid());
         if (tcoremaskingfilesystem.getLocation().equals("1")) {
            String username = datasystem.getUsername();
            String password = datasystem.getPassword();
            String host = datasystem.getDbip();
            Integer port = Integer.parseInt(datasystem.getDbport());
            boolean flag = false;
            String directory = tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag();
            String wildcard = tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote();
            flag = FtpTool.downFile(host, port, username, password, directory, wildcard, this.path + dir);
            if (!flag) {
               return null;
            }

            note = dir;
         } else if (tcoremaskingfilesystem.getLocation().equals("2")) {
            String username = datasystem.getUsername();
            String password = datasystem.getPassword();
            String host = datasystem.getDbip();
            Integer port = Integer.parseInt(datasystem.getDbport());
            SFTPUtil sftp = new SFTPUtil(username, password, host, port);
            ResultVO resultvo = SFTPUtil.login();
            boolean b = resultvo.getResult();
            if (!b) {
               return null;
            }

            try {
               String directory = tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag();
               String wildcard = tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote();
               sftp.download(directory, wildcard, this.path + dir);
               note = dir;
            } catch (Exception var54) {
               return null;
            }

            sftp.logout();
         }

         tcoremaskingfilesystem.setFlag(tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag());
         tcoremaskingfilesystem.setNote(tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote());
         tcoremaskingfilesystem.setDirectory("");
         tcoremaskingfilesystem.setWildcard(dir);
      }

      sou_bean.setIsftp("0");
      sou_bean.setFtplink("");
      sou_bean.setFilepath(this.path + tcoremaskingfilesystem.getDirectory());
      sou_bean.setFiledirect("Indirect");
      File f = new File(this.path + tcoremaskingfilesystem.getDirectory());
      List<String> resultFileName = new ArrayList();
      List<String> filelist = FileTool.ergodicreg(f, resultFileName, tcoremaskingfilesystem.getWildcard());
      String dir = DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
      FileTool.createFile(this.path + tcoremaskingfilesystem.getDirectory() + File.separator + "direct" + dir + ".txt");
      sou_bean.setSo_name("file_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
      StringBuffer sb = new StringBuffer();

      for(int i = 0; i < filelist.size(); ++i) {
         sb.append((String)filelist.get(i) + "\r\n");
      }

      String sourcefilecode = tcoremaskingfilesystem.getSourcefilecode();
      if ("-1".equals(sourcefilecode)) {
         String curWorkFlowFileWriterCode = "utf-8";
         if (null != filelist && filelist.size() > 0) {
            String firstFilePath = (String)filelist.get(0);
            curWorkFlowFileWriterCode = EncodingDetect.getJavaEncode(firstFilePath);
            curWorkFlowFileWriterCode = FileTool.fileCodeToPowercenterCode(curWorkFlowFileWriterCode);
            System.out.println(">>>>>>>>>>>>脱敏文件:" + firstFilePath + " 的编码格式为：" + curWorkFlowFileWriterCode);
            sourcefilecode = curWorkFlowFileWriterCode;
         }
      }

      sou_bean.getFilebean().setCodepage(sourcefilecode);
      System.out.println(">>>>>>>>>>>>end脱敏文件 的编码格式为：" + sourcefilecode + ">>>>>>>>>>>>>");

      try {
         RandomAccessFile mm = null;
         mm = new RandomAccessFile(this.path + tcoremaskingfilesystem.getDirectory() + File.separator + "direct" + dir + ".txt", "rw");
         mm.writeBytes(sb.toString());
         mm.close();
      } catch (Exception var53) {
         return null;
      }

      sou_bean.setFilename("direct" + dir + ".txt");
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");
      MakeIsomerUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList, task.getIstruncate());
      if (!quick.equals("true")) {
         this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
      }

      TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
      temporay.setGroupid(groupId);
      temporay.setCreatetime(new Date());
      temporay.setTargetname(tar_bean.getTar_name());
      temporay.setSourcename(sou_bean.getSo_name().split("_")[0]);
      temporay.setTaskid(task.getId());
      temporay.setType("文件>数据库");
      temporay.setWfname(sou_bean.getSo_name());
      this.tCoreMonitorTemporaryDao.save(temporay);
      Map<String, String> parametermap = new HashMap();
      parametermap.put("filepath", this.path);
      parametermap.put("filename", note);
      parametermap.put("type", "2");
      parametermap.put("datasystenid", tcoremaskingfilesystem.getFtpid());
      parametermap.put("netfilepath", tcoremaskingfilesystem.getDirectory());
      parametermap.put("netfilename", tcoremaskingfilesystem.getWildcard());
      remap.put("so_name", sou_bean.getSo_name());
      remap.put("temporay", temporay);
      remap.put("parametermap", parametermap);
      remap.put("table", table.getTablename());
      remap.put("path", "/data/infa_teradata/" + task.getTaskname() + "/");
      if (is_create) {
         remap.put("create_table", "success");
      } else {
         remap.put("create_table", "falid");
      }

      return remap;
   }

   private Map<String, Object> generateFileToMysqlLoadTaskMasking(TCoreMaskingTask task, String userid, String id, long groupId, String quick) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      Map<String, Object> remap = new HashMap();
      TCoreMaskingFilesystem tcoremaskingfilesystem = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.get(id);
      TCoreFileStructure tcorefilestructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(tcoremaskingfilesystem.getStructureid());
      ParamBean par_bean = new ParamBean();
      SourceBean sou_bean = new SourceBean();
      TargetBean tar_bean = new TargetBean();
      FlatFileBean flatfile = new FlatFileBean();
      FlatFileBean tflatfile = new FlatFileBean();
      if ("0".equals(tcorefilestructure.getSplitertype())) {
         TCoreFileStructurespliter tcorefilestructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
         flatfile.setSkiprows(tcorefilestructure.getSkiprows());
         flatfile.setDelimited("YES");
         flatfile.setDelimiters(tcorefilestructurespliter.getDelimiters());
         flatfile.setMultidelimitersasand(tcorefilestructurespliter.getMultidelimitersasand());
         flatfile.setQuote_character(tcorefilestructurespliter.getQuotecharacter());
         flatfile.setRowdelimiter(tcorefilestructurespliter.getRowdelimiter());
         flatfile.setEscape_character(tcorefilestructurespliter.getEscapecharacter());
         flatfile.setKeepescapechar(tcorefilestructurespliter.getKeepescapechar());
         sou_bean.setFileparam("1");
      } else {
         TCoreFileStructurewidth width = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
         flatfile.setSkiprows(tcorefilestructure.getSkiprows());
         flatfile.setLinesequential(width.getLinesequential());
         flatfile.setNullchartype(width.getNullchartype());
         flatfile.setNull_character(width.getNullcharacter());
         flatfile.setRepeatable(width.getRepeatable());
         flatfile.setPadbytes(width.getPadbytes());
         flatfile.setShiftsensitivedata(width.getShiftsensitivedata());
         flatfile.setStriptrailingblanks(width.getStriptrailingblanks());
      }

      sou_bean.setFilebean(flatfile);
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setDatabasetype("Flat File");
      sou_bean.setLinkname("");
      sou_bean.setDbdname("");
      sou_bean.setVersionnumber("1");
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("");
      sou_bean.setSourceownername("");
      TCoreMaskingTable table = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", tcoremaskingfilesystem.getMappingkey())});
      TCoreDatasystem datatarget = (TCoreDatasystem)this.tCoreDatasystemDao.get(table.getDatasystemid());
      tar_bean.setTar_name(table.getTablename());
      tar_bean.setBusinessname("");
      tar_bean.setConstraint("");
      tar_bean.setDatabasetype("Flat File");
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      tar_bean.setTargetownername(table.getDbschema());
      tar_bean.setInserttype(task.getInserttype());
      tar_bean.setConnectmode(datatarget.getConnectmode());
      tar_bean.setFilecommand("");
      if (datatarget.getPagecode().equals("GBK")) {
         tflatfile.setCodepage("MS936");
      } else {
         tflatfile.setCodepage("UTF-8");
      }

      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e1) {
         e1.printStackTrace();
      }

      tflatfile.setSkiprows("0");
      tflatfile.setDelimited("YES");
      tflatfile.setDelimiters(props.getProperty("mysql_load_col_split"));
      tflatfile.setMultidelimitersasand("YES");
      tflatfile.setQuote_character("NONE");
      tflatfile.setRowdelimiter("10");
      tflatfile.setEscape_character("");
      tflatfile.setKeepescapechar("NO");
      tar_bean.setFilebean(tflatfile);
      tar_bean.setFileparam("1");
      List<TCoreMaskingFilecolumn> tcoremaskingfilesystemlist = this.tCoreMaskingFilecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("filesystemid", tcoremaskingfilesystem.getId())});
      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      List<String> formatlist = new ArrayList();

      for(TCoreMaskingFilecolumn list : tcoremaskingfilesystemlist) {
         TCoreFileStructurecolumn ckj = (TCoreFileStructurecolumn)this.tCoreFileStructurecolumnDao.get(list.getStructurecolumnid());
         keytype.add("NOT A KEY");
         nameList.add(ckj.getColumnname());
         typeList.add(ckj.getColumntype());
         lengthList.add(ckj.getColumnaccuracy());
         scalelist.add(ckj.getColumndecimal());
         precisionList.add(ckj.getColumnaccuracy());
         if (ckj.getColumnformat() != null && !"".equals(ckj.getColumnformat())) {
            formatlist.add("F  29 " + ckj.getColumnformat());
         } else {
            formatlist.add("");
         }

         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         cb.setDateformatlist(formatlist);
         sou_bean.setCb(cb);
         if (ckj.getColumnformat() != null && !"".equals(ckj.getColumnformat())) {
            formatlist.add("A  19 mm/dd/yyyy hh24:mi:ss");
         } else {
            formatlist.add("");
         }

         cb.setDateformatlist(formatlist);
         if (list.getRuleid() != null && !"".equals(list.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", list.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(ckj.getColumnname(), rule.getMappletname(), ckj.getColumnname()));
            }
         }

         tar_bean.setCb(cb);
      }

      List<String> fmt = sou_bean.getCb().getDateformatlist();

      for(int i = 0; i < fmt.size(); ++i) {
         if (fmt.get(i) != null && !"".equals(fmt.get(i))) {
            tar_bean.setDateformateparam("A  19 YYYY-MM-DD HH24:MI:SS");
            break;
         }
      }

      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      Map<String, String> mysqlloadparam = new HashMap();
      mysqlloadparam.put("username", datatarget.getUsername());
      mysqlloadparam.put("password", "1".equals(datatarget.getFlag()) ? AesTool.decrypt(datatarget.getPassword(), "ghca") : datatarget.getPassword());
      mysqlloadparam.put("hostname", datatarget.getDbip());
      mysqlloadparam.put("filepath", File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + task.getTaskname() + File.separator + table.getTablename() + ".pipe");
      mysqlloadparam.put("database", table.getDbschema());
      mysqlloadparam.put("tablename", table.getTablename());
      mysqlloadparam.put("taskname", task.getTaskname());
      mysqlloadparam.put("delimiter", props.getProperty("mysql_load_col_split"));
      MysqlLoadTableTool.executeLoadTable(mysqlloadparam);
      tar_bean.setFilename(table.getTablename() + ".pipe");
      FileTool.createFolder(File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + task.getTaskname() + File.separator);
      tar_bean.setFilepath(File.separator + "data" + File.separator + "infa_mysqlload" + File.separator + task.getTaskname() + File.separator);
      String note = "";
      if (!"0".equals(tcoremaskingfilesystem.getLocation())) {
         String dir = "d" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss") + ".txt";
         TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(tcoremaskingfilesystem.getFtpid());
         if (tcoremaskingfilesystem.getLocation().equals("1")) {
            String username = datasystem.getUsername();
            String password = datasystem.getPassword();
            String host = datasystem.getDbip();
            Integer port = Integer.parseInt(datasystem.getDbport());
            boolean flag = false;
            String directory = tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag();
            String wildcard = tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote();
            flag = FtpTool.downFile(host, port, username, password, directory, wildcard, this.path + dir);
            if (!flag) {
               return null;
            }

            note = dir;
         } else if (tcoremaskingfilesystem.getLocation().equals("2")) {
            String username = datasystem.getUsername();
            String password = datasystem.getPassword();
            String host = datasystem.getDbip();
            Integer port = Integer.parseInt(datasystem.getDbport());
            SFTPUtil sftp = new SFTPUtil(username, password, host, port);
            ResultVO resultvo = SFTPUtil.login();
            boolean b = resultvo.getResult();
            if (!b) {
               return null;
            }

            try {
               String directory = tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag();
               String wildcard = tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote();
               sftp.download(directory, wildcard, this.path + dir);
               note = dir;
            } catch (Exception var48) {
               return null;
            }

            sftp.logout();
         }

         tcoremaskingfilesystem.setFlag(tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag());
         tcoremaskingfilesystem.setNote(tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote());
         tcoremaskingfilesystem.setDirectory("");
         tcoremaskingfilesystem.setWildcard(dir);
      }

      sou_bean.setIsftp("0");
      sou_bean.setFtplink("");
      sou_bean.setFilepath(this.path + tcoremaskingfilesystem.getDirectory());
      sou_bean.setFiledirect("Indirect");
      File f = new File(this.path + tcoremaskingfilesystem.getDirectory());
      List<String> resultFileName = new ArrayList();
      List<String> filelist = FileTool.ergodicreg(f, resultFileName, tcoremaskingfilesystem.getWildcard());
      String dir = DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
      FileTool.createFile(this.path + tcoremaskingfilesystem.getDirectory() + File.separator + "direct" + dir + ".txt");
      sou_bean.setSo_name("file_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
      StringBuffer sb = new StringBuffer();

      for(int i = 0; i < filelist.size(); ++i) {
         sb.append((String)filelist.get(i) + "\r\n");
      }

      String sourcefilecode = tcoremaskingfilesystem.getSourcefilecode();
      sourcefilecode = this.getFileCode(filelist, sourcefilecode);
      sou_bean.getFilebean().setCodepage(sourcefilecode);
      System.out.println(">>>>>>>>>>>>end脱敏文件 的编码格式为：" + sourcefilecode + ">>>>>>>>>>>>>");

      try {
         RandomAccessFile mm = null;
         mm = new RandomAccessFile(this.path + tcoremaskingfilesystem.getDirectory() + File.separator + "direct" + dir + ".txt", "rw");
         mm.writeBytes(sb.toString());
         mm.close();
      } catch (Exception var47) {
         return null;
      }

      sou_bean.setFilename("direct" + dir + ".txt");
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");

      try {
         MakeIsomerUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList, task.getIstruncate());
      } catch (Exception e) {
         e.printStackTrace();
      }

      if (!quick.equals("true")) {
         this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
      }

      TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
      temporay.setGroupid(groupId);
      temporay.setCreatetime(new Date());
      temporay.setTargetname(tar_bean.getTar_name());
      temporay.setSourcename(sou_bean.getSo_name().split("_")[0]);
      temporay.setTaskid(task.getId());
      temporay.setType("文件>数据库");
      temporay.setWfname(sou_bean.getSo_name());
      this.tCoreMonitorTemporaryDao.save(temporay);
      Map<String, String> parametermap = new HashMap();
      parametermap.put("filepath", this.path);
      parametermap.put("filename", note);
      parametermap.put("type", "2");
      parametermap.put("datasystenid", tcoremaskingfilesystem.getFtpid());
      parametermap.put("netfilepath", tcoremaskingfilesystem.getDirectory());
      parametermap.put("netfilename", tcoremaskingfilesystem.getWildcard());
      remap.put("so_name", sou_bean.getSo_name());
      remap.put("temporay", temporay);
      remap.put("parametermap", parametermap);
      remap.put("table", table.getTablename());
      return remap;
   }

   public boolean executeFiletoMysqlLoad(String taskid, String userid, String quick) throws Exception {
      final Runtime rn = Runtime.getRuntime();
      final TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String xmlsPath = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname();
      FileTool.delFolder(xmlsPath);
      if (task == null) {
         return false;
      } else {
         String flag = task.getFlag();
         if (flag != null && !"".equals(flag)) {
            long groupId = (new Date()).getTime();
            List<TCoreMaskingFilesystem> tcoremaskingfilesystemlist = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId())});
            List<Map<String, Object>> lm = new ArrayList();
            List<String> l = new ArrayList();

            for(TCoreMaskingFilesystem tCoreMaskingFilesystem : tcoremaskingfilesystemlist) {
               Map<String, Object> remap = this.generateFileToMysqlLoadTaskMasking(task, userid, tCoreMaskingFilesystem.getId(), groupId, quick);
               lm.add(remap);
               l.add((String)remap.get("so_name") + ".xml");
            }

            if (quick.equals("true")) {
               String path = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname();
               String xmlFileName = "newfile_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
               this.mergeXmlExecute(path, l, xmlFileName);
               String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
               File file = new File(con_file);
               ModifyImportFile mi = new ModifyImportFile();
               ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, task.getFdname());
               ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, task.getFdname());
               ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, engine.getRepository());
               ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, engine.getRepository());
               InfoExecUtil.executImport(engine.getPmrepexepath(), path + "/" + xmlFileName + ".xml", file.toString(), engine.getXmldir() + File.separator + "log.txt");
            }

            for(final Map<String, Object> mo : lm) {
               CommandTool.command("mkfifo /data/infa_mysqlload/" + task.getTaskname() + "/" + mo.get("table") + ".pipe");
               Thread t = new Thread() {
                  public void run() {
                     Process process = null;

                     try {
                        process = rn.exec("/data/infa_mysqlload/" + task.getTaskname() + "/" + mo.get("table") + ".sh");
                        process.waitFor();
                     } catch (Exception e) {
                        e.printStackTrace();
                     }

                  }
               };
               t.start();
               this.executeFileTaskMasking(task, (String)mo.get("so_name"), userid, (TCoreMonitorTemporary)mo.get("temporay"), (Map)mo.get("parametermap"));
            }

            return false;
         } else {
            return false;
         }
      }
   }

   public boolean executeFiletoSqlServerBcp(String taskid, String userid, String quick) throws Exception {
      Runtime rn = Runtime.getRuntime();
      TCoreMaskingTask task = (TCoreMaskingTask)this.tCoreMaskingtaskDao.get(taskid);
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      String xmlsPath = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname();
      FileTool.delFolder(xmlsPath);
      if (task == null) {
         return false;
      } else {
         String flag = task.getFlag();
         if (flag != null && !"".equals(flag)) {
            long groupId = (new Date()).getTime();
            List<TCoreMaskingFilesystem> tcoremaskingfilesystemlist = this.tCoreMaskingFilesystemDao.queryAll(new Criterion[]{Restrictions.eq("taskid", task.getId())});
            List<Map<String, Object>> lm = new ArrayList();
            List<String> l = new ArrayList();

            for(TCoreMaskingFilesystem tCoreMaskingFilesystem : tcoremaskingfilesystemlist) {
               Map<String, Object> remap = this.generateFileToSqlServerBcpTaskMasking(task, userid, tCoreMaskingFilesystem.getId(), groupId, quick);
               lm.add(remap);
               l.add((String)remap.get("so_name") + ".xml");
            }

            if (quick.equals("true")) {
               String path = engine.getXmldir() + File.separator + "masking_task" + File.separator + task.getTaskname();
               String xmlFileName = "newfile_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
               this.mergeXmlExecute(path, l, xmlFileName);
               String con_file = InfoServiceImpl.class.getResource("/").getPath().replaceAll("%20", " ") + "infofile" + File.separator + "con_import.xml";
               File file = new File(con_file);
               ModifyImportFile mi = new ModifyImportFile();
               ModifyImportFile.updateConfigFileXML("TARGETFOLDERNAME", file, task.getFdname());
               ModifyImportFile.updateConfigFileXML("SOURCEFOLDERNAME", file, task.getFdname());
               ModifyImportFile.updateConfigFileXML("TARGETREPOSITORYNAME", file, engine.getRepository());
               ModifyImportFile.updateConfigFileXML("SOURCEREPOSITORYNAME", file, engine.getRepository());
               InfoExecUtil.executImport(engine.getPmrepexepath(), path + "/" + xmlFileName + ".xml", file.toString(), engine.getXmldir() + File.separator + "log.txt");
            }

            for(Map<String, Object> mo : lm) {
               System.out.println("sqlserver-bcp 表：" + (String)mo.get("so_name") + "开始!");
               this.executeSqlServerFileTaskMasking(task, (String)mo.get("so_name"), userid, (TCoreMonitorTemporary)mo.get("temporay"), (Map)mo.get("parametermap"));
               System.out.println("sqlserver-bcp 表：" + (String)mo.get("so_name") + "结束!");
            }

            return false;
         } else {
            return false;
         }
      }
   }

   private Map<String, Object> generateFileToSqlServerBcpTaskMasking(TCoreMaskingTask task, String userid, String id, long groupId, String quick) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty info = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);
      Map<String, Object> remap = new HashMap();
      TCoreMaskingFilesystem tcoremaskingfilesystem = (TCoreMaskingFilesystem)this.tCoreMaskingFilesystemDao.get(id);
      TCoreFileStructure tcorefilestructure = (TCoreFileStructure)this.tCoreFileStructureDao.get(tcoremaskingfilesystem.getStructureid());
      ParamBean par_bean = new ParamBean();
      SourceBean sou_bean = new SourceBean();
      TargetBean tar_bean = new TargetBean();
      FlatFileBean flatfile = new FlatFileBean();
      FlatFileBean tflatfile = new FlatFileBean();
      if ("0".equals(tcorefilestructure.getSplitertype())) {
         TCoreFileStructurespliter tcorefilestructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
         flatfile.setSkiprows(tcorefilestructure.getSkiprows());
         flatfile.setDelimited("YES");
         flatfile.setDelimiters(tcorefilestructurespliter.getDelimiters());
         flatfile.setMultidelimitersasand(tcorefilestructurespliter.getMultidelimitersasand());
         flatfile.setQuote_character(tcorefilestructurespliter.getQuotecharacter());
         flatfile.setRowdelimiter(tcorefilestructurespliter.getRowdelimiter());
         flatfile.setEscape_character(tcorefilestructurespliter.getEscapecharacter());
         flatfile.setKeepescapechar(tcorefilestructurespliter.getKeepescapechar());
         sou_bean.setFileparam("1");
      } else {
         TCoreFileStructurewidth width = (TCoreFileStructurewidth)this.tCoreFileStructurewidthDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", tcorefilestructure.getId())});
         flatfile.setSkiprows(tcorefilestructure.getSkiprows());
         flatfile.setLinesequential(width.getLinesequential());
         flatfile.setNullchartype(width.getNullchartype());
         flatfile.setNull_character(width.getNullcharacter());
         flatfile.setRepeatable(width.getRepeatable());
         flatfile.setPadbytes(width.getPadbytes());
         flatfile.setShiftsensitivedata(width.getShiftsensitivedata());
         flatfile.setStriptrailingblanks(width.getStriptrailingblanks());
      }

      sou_bean.setFilebean(flatfile);
      List<MappletMakeDatabean> mapplet = new ArrayList();
      List<MappingPramaBean> paramList = null;
      sou_bean.setSo_ownname("");
      sou_bean.setBusinessname("");
      sou_bean.setDatabasetype("Flat File");
      sou_bean.setLinkname("");
      sou_bean.setDbdname("");
      sou_bean.setVersionnumber("1");
      sou_bean.setObjectversion("1");
      sou_bean.setDescripion("");
      sou_bean.setSourceownername("");
      TCoreMaskingTable table = (TCoreMaskingTable)this.tCoreMaskingtableDao.queryUnique(new Criterion[]{Restrictions.eq("taskid", task.getId()), Restrictions.eq("mappingkey", tcoremaskingfilesystem.getMappingkey())});
      TCoreDatasystem datatarget = (TCoreDatasystem)this.tCoreDatasystemDao.get(table.getDatasystemid());
      tar_bean.setTar_name(table.getTablename());
      tar_bean.setBusinessname("");
      tar_bean.setConstraint("");
      tar_bean.setDatabasetype("Flat File");
      tar_bean.setVersionnumber("1");
      tar_bean.setObjectversion("1");
      tar_bean.setDescripion("");
      tar_bean.setTargetownername(table.getDbschema());
      tar_bean.setInserttype(task.getInserttype());
      tar_bean.setConnectmode(datatarget.getConnectmode());
      tar_bean.setFilecommand("");
      tflatfile.setCodepage("UTF-8");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e1) {
         e1.printStackTrace();
      }

      tflatfile.setSkiprows("0");
      tflatfile.setDelimited("YES");
      tflatfile.setDelimiters(props.getProperty("bcp_table_sqlserver_col_split"));
      tflatfile.setMultidelimitersasand("YES");
      tflatfile.setQuote_character("none");
      tflatfile.setRowdelimiter("10");
      tflatfile.setEscape_character("");
      tflatfile.setKeepescapechar("NO");
      tar_bean.setFilebean(tflatfile);
      tar_bean.setFileparam("1");
      List<TCoreMaskingFilecolumn> tcoremaskingfilesystemlist = this.tCoreMaskingFilecolumnDao.queryAll(Order.asc("columnindex"), new Criterion[]{Restrictions.eq("filesystemid", tcoremaskingfilesystem.getId())});
      CommonBean cb = new CommonBean();
      List<String> keytype = new ArrayList();
      List<String> nameList = new ArrayList();
      List<String> typeList = new ArrayList();
      List<String> lengthList = new ArrayList();
      List<String> precisionList = new ArrayList();
      List<String> scalelist = new ArrayList();
      List<String> formatlist = new ArrayList();

      for(TCoreMaskingFilecolumn list : tcoremaskingfilesystemlist) {
         TCoreFileStructurecolumn ckj = (TCoreFileStructurecolumn)this.tCoreFileStructurecolumnDao.get(list.getStructurecolumnid());
         keytype.add("NOT A KEY");
         nameList.add(ckj.getColumnname());
         typeList.add(ckj.getColumntype());
         lengthList.add(ckj.getColumnaccuracy());
         scalelist.add(ckj.getColumndecimal());
         precisionList.add(ckj.getColumnaccuracy());
         if (ckj.getColumnformat() != null && !"".equals(ckj.getColumnformat())) {
            formatlist.add("F  29 " + ckj.getColumnformat());
         } else {
            formatlist.add("");
         }

         cb.setKeytype(keytype);
         cb.setLengthList(lengthList);
         cb.setNameList(nameList);
         cb.setPrecisionList(precisionList);
         cb.setScalelist(scalelist);
         cb.setTypeList(typeList);
         cb.setDateformatlist(formatlist);
         sou_bean.setCb(cb);
         if (ckj.getColumnformat() != null && !"".equals(ckj.getColumnformat())) {
            formatlist.add("A  19 YYYY-MM-DD HH24:MI:SS");
         } else {
            formatlist.add("");
         }

         cb.setDateformatlist(formatlist);
         if (list.getRuleid() != null && !"".equals(list.getRuleid())) {
            TCoreMaskingRuleinfo rule = (TCoreMaskingRuleinfo)this.tCoreMaskingRuleinfoDao.queryUnique(new Criterion[]{Restrictions.eq("ruleid", list.getRuleid())});
            if (rule != null) {
               mapplet.add(new MappletMakeDatabean(ckj.getColumnname(), rule.getMappletname(), ckj.getColumnname()));
            }
         }

         tar_bean.setCb(cb);
      }

      List<String> fmt = sou_bean.getCb().getDateformatlist();

      for(int i = 0; i < fmt.size(); ++i) {
         if (fmt.get(i) != null && !"".equals(fmt.get(i))) {
            tar_bean.setDateformateparam("A  19 YYYY-MM-DD HH24:MI:SS");
            break;
         }
      }

      par_bean.setTaskname(task.getTaskname());
      par_bean.setFoldername(task.getFdname());
      par_bean.setOwner("");
      par_bean.setGroup("");
      par_bean.setParam_path("");
      par_bean.setPower_repository_version("184.93");
      par_bean.setCodepage("UTF-8");
      par_bean.setRepository_version("184");
      Map<String, String> bcpProperties = new HashMap();
      bcpProperties.put("user", datatarget.getUsername());
      bcpProperties.put("pwd", "1".equals(datatarget.getFlag()) ? AesTool.decrypt(datatarget.getPassword(), "ghca") : datatarget.getPassword());
      bcpProperties.put("ip", datatarget.getDbip());
      bcpProperties.put("dbschema", table.getDbschema());
      bcpProperties.put("tablename", table.getTablename());
      bcpProperties.put("database", datatarget.getDbservername());
      bcpProperties.put("taskname", task.getTaskname());
      bcpProperties.put("path", File.separator + "data" + File.separator + "infa_sqlserver" + File.separator + task.getTaskname() + File.separator + table.getTablename() + ".sh");
      TCoreConfig tcoreConfig1 = (TCoreConfig)this.tCoreConfigDao.queryUnique(new Criterion[]{Restrictions.eq("datasystemid", datatarget.getId())});
      SqlServerBcpTableTool.createBcpScript(bcpProperties, tcoreConfig1);
      tar_bean.setFilename(table.getTablename() + ".txt");
      FileTool.createFolder(File.separator + "data" + File.separator + "infa_sqlserver" + File.separator + task.getTaskname() + File.separator);
      tar_bean.setFilepath(File.separator + "data" + File.separator + "infa_sqlserver" + File.separator + task.getTaskname() + File.separator);
      String note = "";
      if (!"0".equals(tcoremaskingfilesystem.getLocation())) {
         String dir = "d" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss") + ".txt";
         TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(tcoremaskingfilesystem.getFtpid());
         if (tcoremaskingfilesystem.getLocation().equals("1")) {
            String username = datasystem.getUsername();
            String password = datasystem.getPassword();
            String host = datasystem.getDbip();
            Integer port = Integer.parseInt(datasystem.getDbport());
            boolean flag = false;
            String directory = tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag();
            String wildcard = tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote();
            flag = FtpTool.downFile(host, port, username, password, directory, wildcard, this.path + dir);
            if (!flag) {
               return null;
            }

            note = dir;
         } else if (tcoremaskingfilesystem.getLocation().equals("2")) {
            String username = datasystem.getUsername();
            String password = datasystem.getPassword();
            String host = datasystem.getDbip();
            Integer port = Integer.parseInt(datasystem.getDbport());
            SFTPUtil sftp = new SFTPUtil(username, password, host, port);
            ResultVO resultvo = SFTPUtil.login();
            boolean b = resultvo.getResult();
            if (!b) {
               return null;
            }

            try {
               String directory = tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag();
               String wildcard = tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote();
               sftp.download(directory, wildcard, this.path + dir);
               note = dir;
            } catch (Exception var49) {
               return null;
            }

            sftp.logout();
         }

         tcoremaskingfilesystem.setFlag(tcoremaskingfilesystem.getFlag() == null ? tcoremaskingfilesystem.getDirectory() : tcoremaskingfilesystem.getFlag());
         tcoremaskingfilesystem.setNote(tcoremaskingfilesystem.getNote() == null ? tcoremaskingfilesystem.getWildcard() : tcoremaskingfilesystem.getNote());
         tcoremaskingfilesystem.setDirectory("");
         tcoremaskingfilesystem.setWildcard(dir);
      }

      sou_bean.setIsftp("0");
      sou_bean.setFtplink("");
      sou_bean.setFilepath(this.path + tcoremaskingfilesystem.getDirectory());
      sou_bean.setFiledirect("Indirect");
      File f = new File(this.path + tcoremaskingfilesystem.getDirectory());
      List<String> resultFileName = new ArrayList();
      List<String> filelist = FileTool.ergodicreg(f, resultFileName, tcoremaskingfilesystem.getWildcard());
      String dir = DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss");
      FileTool.createFile(this.path + tcoremaskingfilesystem.getDirectory() + File.separator + "direct" + dir + ".txt");
      sou_bean.setSo_name("file_" + DateUtil.convertDateToString(new Date(), "YYYYMMDDHHmmss"));
      StringBuffer sb = new StringBuffer();

      for(int i = 0; i < filelist.size(); ++i) {
         sb.append((String)filelist.get(i) + "\r\n");
      }

      String sourcefilecode = tcoremaskingfilesystem.getSourcefilecode();
      sourcefilecode = this.getFileCode(filelist, sourcefilecode);
      sou_bean.getFilebean().setCodepage(sourcefilecode);

      try {
         RandomAccessFile mm = null;
         mm = new RandomAccessFile(this.path + tcoremaskingfilesystem.getDirectory() + File.separator + "direct" + dir + ".txt", "rw");
         mm.writeBytes(sb.toString());
         mm.close();
      } catch (Exception var48) {
         return null;
      }

      sou_bean.setFilename("direct" + dir + ".txt");
      TCoreDatasystem repdata = (TCoreDatasystem)this.tCoreDatasystemDao.get(info.getDatasystemid());
      if ("ORACLE".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Oracle");
      } else if ("DB2".equals(repdata.getDbtype())) {
         par_bean.setRepository_dbtype("Db2");
      }

      par_bean.setShard("NOTSHARED");

      try {
         MakeIsomerUtil.isomerMasking(par_bean, info, sou_bean, tar_bean, mapplet, paramList, task.getIstruncate());
      } catch (Exception e) {
         e.printStackTrace();
      }

      if (!quick.equals("true")) {
         this.importMapping(task.getId(), sou_bean.getSo_name(), quick);
      }

      TCoreMonitorTemporary temporay = new TCoreMonitorTemporary();
      temporay.setGroupid(groupId);
      temporay.setCreatetime(new Date());
      temporay.setTargetname(tar_bean.getTar_name());
      temporay.setSourcename(sou_bean.getSo_name().split("_")[0]);
      temporay.setTaskid(task.getId());
      temporay.setType("文件>数据库");
      temporay.setWfname(sou_bean.getSo_name());
      this.tCoreMonitorTemporaryDao.save(temporay);
      Map<String, String> parametermap = new HashMap();
      parametermap.put("filepath", this.path);
      parametermap.put("filename", note);
      parametermap.put("type", "2");
      parametermap.put("datasystenid", tcoremaskingfilesystem.getFtpid());
      parametermap.put("netfilepath", tcoremaskingfilesystem.getDirectory());
      parametermap.put("netfilename", tcoremaskingfilesystem.getWildcard());
      remap.put("so_name", sou_bean.getSo_name());
      remap.put("temporay", temporay);
      remap.put("parametermap", parametermap);
      remap.put("table", table.getTablename());
      return remap;
   }

   public boolean executeSqlServerFileTaskMasking(TCoreMaskingTask task, String name, String userid, TCoreMonitorTemporary temporay, Map<String, String> parametermap) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(task.getEngineid());
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         this.infoTool.StartWorkflow(engine, task.getFdname(), "wf_" + name);
      } catch (Exception e1) {
         e1.printStackTrace();
         return false;
      }

      this.infoTool.quartzSqlServerFileTask(task, engine, name, userid, temporay, parametermap);
      return Boolean.TRUE;
   }

   public String getFileCode(List<String> filelist, String sourcefilecode) {
      if ("-1".equals(sourcefilecode)) {
         String curWorkFlowFileWriterCode = "utf-8";
         if (null != filelist && filelist.size() > 0) {
            String firstFilePath = (String)filelist.get(0);
            curWorkFlowFileWriterCode = EncodingDetect.getJavaEncode(firstFilePath);
            curWorkFlowFileWriterCode = FileTool.fileCodeToPowercenterCode(curWorkFlowFileWriterCode);
            sourcefilecode = curWorkFlowFileWriterCode;
            System.out.println(">>>>>>>>>>>>脱敏文件:" + firstFilePath + " 的编码格式为：" + curWorkFlowFileWriterCode);
         }
      }

      return sourcefilecode;
   }

   public boolean deleteFolderInEngine(String engineid, String foldername) {
      TCoreEngine tengine = (TCoreEngine)this.tCoreEngineDao.get(engineid);
      Map<String, Object> map = this.engineDao.queryEnginePropertyKeyValue(tengine.getId());
      InfoProperty engine = (InfoProperty)ObjectTool.getObjectByMap(InfoProperty.class, map);

      try {
         String text = InfoExecUtil.exedelfolder(engine.getPmrepexepath(), foldername);
         return text.contains("successfully") || text.contains("成功");
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }
}
