package com.chenyang.nse.bussiness.service.webApi.business;

import com.chenyang.nse.bussiness.entity.webApi.ApiCode;
import com.chenyang.nse.bussiness.entity.webApi.Msg;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task implements Callable<Msg> {
   private static final Logger LOGGER = LoggerFactory.getLogger(Task.class);
   private TaskContext ctx;

   public Task(TaskContext ctx) {
      this.ctx = ctx;
   }

   public Msg call() throws Exception {
      try {
         for(TaskData taskData : this.ctx.datas) {
            String key = this.getKey(taskData.id);
            if (key == null || key.length() == 0) {
               this.ctx.countDownAll();
               Msg var28 = Msg.error(ApiCode.decFailed, String.format("没有为%s配置加密规则", taskData.id));
               return var28;
            }

            String[] values = taskData.values;
            int end = taskData.from + taskData.size;

            for(int i = 0; i < end; ++i) {
               String value = values[i];
               String[] strs = key.split(":");
               String tkey = strs[0];
               String type = strs[1];
               String isLike = strs[2];
               String keepfirst = strs[3];
               String encdigit = strs[4];
               String twoindex = strs[5];
               if (this.ctx.type == 0) {
                  values[i] = EncProvider.encryptEcb(type, tkey, value, isLike, keepfirst, encdigit, twoindex);
               } else {
                  values[i] = EncProvider.decryptEcb(type, tkey, value, isLike, keepfirst, encdigit, twoindex);
               }
            }
         }

         Msg var26 = Msg.succed(null);
         return var26;
      } catch (Exception e) {
         this.ctx.countDownAll();
         LOGGER.error(e.getMessage(), e);
         Msg ex = Msg.error(ApiCode.other, e.getMessage());
         return ex;
      } finally {
         try {
            this.ctx.countDown();
         } catch (Exception ex) {
            ex.printStackTrace();
         }

      }
   }

   private String getKey(String id) {
      return id != null && id.length() != 0 ? SecretKeyCache.instance().getKey(id) : null;
   }
}
