package com.chenyang.nse.bussiness.tools.datatime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTime1Tool {
   public static String format = "yyyy-MM-dd HH:mm:ss";
   public static String format01 = "MM/dd/yyyy hh:mm:ss.SSSa";
   public static String format02 = "dd-MM-yyyy HH:mm:ss";
   public static String format03 = "EEEE dd MMMM, yyyy HH:mm:ssa";
   public static String format04 = "MM/dd/yyyy HH:mm ZZZZ";
   public static String format05 = "MM/dd/yyyy HH:mm Z";

   public static String getSysDateString() {
      return getDateString(new Date());
   }

   public static String getDateString(Date date) {
      return formatDateTime(date, (String)null);
   }

   public static String formatDateTime(Date date, String fm) {
      DateTime dt = new DateTime(date);
      return fm != null && !"".equals(fm) ? dt.toString(fm) : dt.toString(format);
   }

   public static long dateBetween(Date start, Date end) {
      long l = end.getTime() - start.getTime();
      return l;
   }

   public static Date getFirstDayOfYear(Date date) {
      DateTime dt = new DateTime(date);
      Calendar cd = Calendar.getInstance();
      cd.clear();
      cd.set(1, dt.getYear());
      return cd.getTime();
   }

   public static Date getLastDayOfYear(Date date) {
      DateTime dt = new DateTime(date);
      date = getFirstDayOfYear(dt.plusYears(1).toDate());
      dt = new DateTime(date);
      DateTime d = dt.minusMillis(1);
      return d.toDate();
   }

   public static Date getFirstDayOfMonth(Date date) {
      DateTime dt = new DateTime(date);
      Calendar cd = Calendar.getInstance();
      cd.clear();
      cd.set(1, dt.getYear());
      cd.set(2, dt.getMonthOfYear() - 1);
      return cd.getTime();
   }

   public static Date getLastDayOfMonth(Date date) {
      DateTime dt = new DateTime(date);
      date = getFirstDayOfMonth(dt.plusMonths(1).toDate());
      dt = new DateTime(date);
      return dt.minusMillis(1).toDate();
   }

   public static Date getFirstDayOfWeek(Date date) {
      DateTime dt = new DateTime(date);
      dt = dt.minusDays(dt.getDayOfWeek() - 1);
      Calendar cd = Calendar.getInstance();
      cd.clear();
      cd.set(1, dt.getYear());
      cd.set(2, dt.getMonthOfYear() - 1);
      cd.set(5, dt.getDayOfMonth());
      return cd.getTime();
   }

   public static Date getLastDayOfWeek(Date date) {
      date = getFirstDayOfWeek(date);
      DateTime dt = new DateTime(date);
      dt = dt.plusWeeks(1).minusMillis(1);
      return dt.toDate();
   }

   public static Date parseDateTime(String date, String fm) {
      DateTimeFormatter dtf = null;
      if (fm == null || "".equals(fm)) {
         dtf = DateTimeFormat.forPattern(format);
      }

      dtf = DateTimeFormat.forPattern(fm);
      DateTime dt = DateTime.parse(date, dtf);
      return dt.toDate();
   }

   public static Date beforeYears(Date date, int n) {
      DateTime dt = new DateTime(date);
      return dt.minusYears(n).toDate();
   }

   public static Date afterYears(Date date, int n) {
      DateTime dt = new DateTime(date);
      return dt.plusYears(n).toDate();
   }

   public static Date beforeMonths(Date date, int n) {
      DateTime dt = new DateTime(date);
      return dt.minusMonths(n).toDate();
   }

   public static Date afterMonths(Date date, int n) {
      DateTime dt = new DateTime(date);
      return dt.plusMonths(n).toDate();
   }

   public static Date beforeWeeks(Date date, int n) {
      DateTime dt = new DateTime(date);
      return dt.minusWeeks(n).toDate();
   }

   public static Date afterWeeks(Date date, int n) {
      DateTime dt = new DateTime(date);
      return dt.plusWeeks(n).toDate();
   }

   public static Date beforeDays(Date date, int n) {
      DateTime dt = new DateTime(date);
      return dt.minusDays(n).toDate();
   }

   public static Date afterDays(Date date, int n) {
      DateTime dt = new DateTime(date);
      return dt.plusDays(n).toDate();
   }

   public static Date dayOfStart(Date date) {
      DateTime dt = new DateTime(date);
      Calendar cd = Calendar.getInstance();
      cd.clear();
      cd.set(1, dt.getYear());
      cd.set(2, dt.getMonthOfYear() - 1);
      cd.set(5, dt.getDayOfMonth());
      return cd.getTime();
   }

   public static Date dayOfEnd(Date date) {
      date = dayOfStart(date);
      date = afterDays(date, 1);
      DateTime dt = new DateTime(date);
      DateTime d = dt.minusMillis(1);
      return d.toDate();
   }

   public static long dataBetween(Date startdate, Date endtdate) {
      long start = startdate.getTime();
      long end = endtdate.getTime();
      return (end - start) / 1000L;
   }

   public static Date getSysTimeDate(String fm) {
      if (fm == null || "".equals(fm)) {
         fm = format;
      }

      SimpleDateFormat sdf = new SimpleDateFormat(fm);
      Date sysdate = new Date();

      try {
         sysdate = sdf.parse(getSysTime(fm));
      } catch (ParseException e) {
         e.printStackTrace();
      }

      return sysdate;
   }

   public static String getSysTime(String fm) {
      Date sysdate = new Date();
      String dateStr = formatDate(sysdate, format);
      return dateStr;
   }

   public static String formatDate(Date date, String fm) {
      if (fm == null || "".equals(fm)) {
         fm = format;
      }

      String result = "";
      SimpleDateFormat sdf = new SimpleDateFormat(fm);
      if (date != null) {
         result = sdf.format(date);
      }

      return result;
   }

   public static String formatDuring(long mss) {
      long days = mss / 86400000L;
      long hours = mss % 86400000L / 3600000L;
      long minutes = mss % 3600000L / 60000L;
      long seconds = mss % 60000L / 1000L;
      long ns = mss % 60000L % 1000L;
      String minutes_sh = minutes != 0L ? minutes + "分" : "";
      String seconds_sh = seconds != 0L ? seconds + "秒" : "";
      return minutes_sh + seconds_sh + ns + "毫秒";
   }
}
