package com.chenyang.nse.bussiness.tools.dmp;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MultipleDmpDpGenerateTool {
   public static final int arraySize = 1024;
   public static final int INT_READ_LINE_CNT = 10000;
   public static final int headGarbageData = 4096;
   public static final String STR_DATA_SEPARATOR = "#_#";

   private static List<Integer> parsingDataByLine(List<String> colTypeList, String lineStr) {
      String doubleQuotation = "\"";
      List<Integer> lineIntList = new ArrayList();
      List<Integer> lineAllIntList = new ArrayList();
      List<Integer> intColList = null;

      try {
         String[] lineStrArr = lineStr.split("#_#", -1);

         for(int i = 0; i < colTypeList.size(); ++i) {
            String colType = (String)colTypeList.get(i);
            String curColVal = lineStrArr[i];
            if (!"".equals(curColVal) && null != curColVal) {
               curColVal = curColVal.replace(doubleQuotation, "");
               List<Integer> var13 = new ArrayList();
               if (!colType.equalsIgnoreCase("VARCHAR2") && !colType.equalsIgnoreCase("CHAR")) {
                  if (!colType.equalsIgnoreCase("NVARCHAR2") && !colType.equalsIgnoreCase("NCHAR")) {
                     if (!colType.equals("NUMBER") && !colType.equalsIgnoreCase("float")) {
                        if (colType.equals("DATE")) {
                           var13 = dateToDmpBtyeArr(curColVal);
                        } else if (colType.equalsIgnoreCase("TIMESTAMP")) {
                           var13 = timestampToDmpBtyeArr(curColVal);
                        } else if (colType.equalsIgnoreCase("LONG")) {
                           var13 = longToDmpBtyeArr(curColVal);
                        }
                     } else {
                        var13 = numberToDmpBtyeArr(curColVal);
                     }
                  } else {
                     var13 = nGbkToDmpBtyeArr(curColVal);
                  }
               } else {
                  var13 = gbkToDmpBtyeArr(curColVal);
               }

               if (0 == ((List)var13).size()) {
                  lineIntList.add(255);
               } else {
                  lineIntList.add(((List)var13).size());
               }

               lineIntList.addAll((Collection)var13);
            } else {
               lineIntList.add(255);
            }
         }

         int tailNullColCnt = 0;

         for(int i = lineIntList.size() - 1; i >= 0; --i) {
            Integer colIntData = (Integer)lineIntList.get(i);
            if (255 != colIntData) {
               break;
            }

            lineIntList.remove(i);
            ++tailNullColCnt;
         }

         if (colTypeList.contains("LONG")) {
            lineAllIntList.add(12);
         } else {
            lineAllIntList.add(60);
            int lineIntCodeCnt = 4 + lineIntList.size();

            String strHex;
            for(strHex = Integer.toHexString(lineIntCodeCnt); strHex.length() < 4; strHex = "0" + strHex) {
            }

            int lineCodeCnt1 = binary16_10(strHex.substring(0, 2));
            int lineCodeCnt2 = binary16_10(strHex.substring(2));
            lineAllIntList.add(lineCodeCnt1);
            lineAllIntList.add(lineCodeCnt2);
         }

         lineAllIntList.add(colTypeList.size() - tailNullColCnt);
         lineAllIntList.addAll(lineIntList);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return lineAllIntList;
   }

   private static List<Integer> gbkToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      byte[] bs = null;

      try {
         char[] chars = colValStr.toCharArray();
         bs = colValStr.getBytes("gbk");

         for(int i = 0; i < bs.length; ++i) {
            intColLst.add(bs[i] & 255);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> nGbkToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      byte[] bs = null;
      char[] charArray = colValStr.toCharArray();

      try {
         for(char c : charArray) {
            if (c >= 913 && c <= '￥') {
               bs = colValStr.getBytes("utf-16");

               for(int i = 0; i < bs.length; ++i) {
                  intColLst.add(bs[i] & 255);
               }

               intColLst.remove(0);
               intColLst.remove(0);
               break;
            }

            if (c >= 0 && c <= 255) {
               bs = colValStr.getBytes("gbk");

               for(int i = 0; i < bs.length; ++i) {
                  intColLst.add(0);
                  intColLst.add(bs[i] & 255);
               }
               break;
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> numberToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      Boolean positiveFlg = false;
      String intpart = "";

      try {
         if (-1 == colValStr.indexOf("-")) {
            positiveFlg = true;
         } else {
            colValStr = colValStr.replace("-", "");
         }

         if (positiveFlg) {
            if ("0".equals(colValStr)) {
               intColLst.add(128);
            } else if ("".equals(colValStr)) {
               intColLst.add(30);
            } else {
               List<Integer> positiveLst = new ArrayList();
               List<Integer> decimalList = new ArrayList();
               String[] numberStrArr = colValStr.split("\\.");
               intpart = numberStrArr[0];
               if ("0".equals(intpart)) {
                  positiveLst.add(192);
               } else {
                  if (0 != intpart.length() % 2) {
                     intpart = "0" + intpart;
                  }

                  char[] positiveCharArr = intpart.toCharArray();
                  int idx = positiveCharArr.length / 2 - 1;
                  int prefixNum = 193 + idx;
                  positiveLst.add(prefixNum);

                  for(int i = 0; i < positiveCharArr.length; i += 2) {
                     positiveLst.add(Integer.valueOf(positiveCharArr[i] + "" + positiveCharArr[i + 1]) + 1);
                  }
               }

               if (numberStrArr.length < 2 || Integer.valueOf(numberStrArr[1]) == 0) {
                  while(1 == (Integer)positiveLst.get(positiveLst.size() - 1)) {
                     positiveLst.remove(positiveLst.size() - 1);
                  }
               }

               intColLst.addAll(positiveLst);
               if (numberStrArr.length > 1) {
                  String decimal = numberStrArr[1];
                  if (0 != Integer.valueOf(decimal)) {
                     if (0 != decimal.length() % 2) {
                        decimal = decimal + "0";
                     }

                     char[] decimalCharArr = decimal.toCharArray();

                     for(int i = 0; i < decimalCharArr.length; i += 2) {
                        decimalList.add(Integer.valueOf(decimalCharArr[i] + "" + decimalCharArr[i + 1]) + 1);
                     }

                     intColLst.addAll(decimalList);
                  }
               }
            }
         } else {
            List<Integer> positiveLst = new ArrayList();
            List<Integer> decimalList = new ArrayList();
            String[] numberStrArr = colValStr.split("\\.");
            intpart = numberStrArr[0];
            if ("0".equals(intpart)) {
               positiveLst.add(63);
            } else {
               if (0 != intpart.length() % 2) {
                  intpart = "0" + intpart;
               }

               char[] positiveCharArr = intpart.toCharArray();
               int idx = positiveCharArr.length / 2 - 1;
               int prefixNum = 62 - idx;
               positiveLst.add(prefixNum);

               for(int i = 0; i < positiveCharArr.length; i += 2) {
                  positiveLst.add(101 - Integer.valueOf(positiveCharArr[i] + "" + positiveCharArr[i + 1]));
               }

               if (numberStrArr.length < 2 || Integer.valueOf(numberStrArr[1]) == 0) {
                  while(101 == (Integer)positiveLst.get(positiveLst.size() - 1)) {
                     positiveLst.remove(positiveLst.size() - 1);
                  }
               }

               intColLst.addAll(positiveLst);
            }

            if (numberStrArr.length > 1) {
               String decimal = numberStrArr[1];
               if (0 != Integer.valueOf(decimal)) {
                  if (0 != decimal.length() % 2) {
                     decimal = decimal + "0";
                  }

                  char[] decimalCharArr = decimal.toCharArray();

                  for(int i = 0; i < decimalCharArr.length; i += 2) {
                     decimalList.add(101 - Integer.valueOf(decimalCharArr[i] + "" + decimalCharArr[i + 1]));
                  }

                  intColLst.addAll(decimalList);
               }
            }

            intColLst.add(102);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> longToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      Boolean positiveFlg = false;
      Boolean isSingle = false;
      if (0 == colValStr.indexOf("-")) {
         colValStr = colValStr.replaceFirst("-", "");
      } else {
         positiveFlg = true;
      }

      int longNum = Integer.parseInt(colValStr);
      if (longNum < 10) {
         isSingle = true;
      }

      if (!positiveFlg) {
         intColLst.add(45);
      }

      if (isSingle) {
         intColLst.add(longNum + 48);
      } else if (longNum < 100) {
         intColLst.add(longNum / 10 + 48);
         intColLst.add(longNum % 10 + 48);
      } else {
         intColLst.add(longNum / 100 + 48);
         intColLst.add(longNum / 10 % 10 + 48);
         intColLst.add(longNum % 10 + 48);
      }

      return intColLst;
   }

   private static List<Integer> dateToDmpBtyeArr(String colValStr) {
      List<Integer> intColLst = new ArrayList();
      Calendar calendar = Calendar.getInstance();
      String datefmt = "yyyy-MM-dd HH:mm:ss";
      SimpleDateFormat sdf = new SimpleDateFormat(datefmt);

      try {
         Date colDate = sdf.parse(colValStr);
         calendar.setTime(colDate);
         int year = calendar.get(1);
         int month = calendar.get(2) + 1;
         int date = calendar.get(5);
         int hour24 = calendar.get(11);
         int minute = calendar.get(12);
         int second = calendar.get(13);
         String year1 = String.valueOf(year).substring(0, 2);
         String year2 = String.valueOf(year).substring(2, 4);
         intColLst.add(Integer.valueOf(year1) + 100);
         intColLst.add(Integer.valueOf(year2) + 100);
         intColLst.add(month);
         intColLst.add(date);
         intColLst.add(hour24 + 1);
         intColLst.add(minute + 1);
         intColLst.add(second + 1);
      } catch (ParseException e) {
         e.printStackTrace();
      }

      return intColLst;
   }

   private static List<Integer> timestampToDmpBtyeArr(String colValStr) {
      List<Integer> timestampIntList = new ArrayList();
      new Timestamp(System.currentTimeMillis());
      String timestampPartOfMS = "";
      String timestampPartOfDate = "";
      if (StringUtils.isNotBlank(colValStr)) {
         String[] timestampArr = colValStr.split("\\.");
         timestampPartOfDate = timestampArr[0];
         timestampIntList = dateToDmpBtyeArr(timestampPartOfDate);
         if (timestampArr.length > 1) {
            timestampPartOfMS = timestampArr[1];
            String strHex = Integer.toHexString(Integer.valueOf(timestampPartOfMS));
            if (strHex.length() % 2 != 0) {
               strHex = "0" + strHex;
            }

            char[] strHexArr = strHex.toCharArray();

            for(int i = 0; i < strHexArr.length; i += 2) {
               timestampIntList.add(Integer.valueOf(strHexArr[i] + "" + strHexArr[i + 1], 16));
            }
         }
      }

      return timestampIntList;
   }

   private static int binary16_10(String str) {
      return Integer.parseInt(str, 16);
   }

   public static void prasingDataByTableName(List<String> dmpFileNameList, String taskname, List<String> tablenameList, String tarDmpPath) {
      if (null != tablenameList && null != dmpFileNameList && dmpFileNameList.size() != 0) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         List<String> tardmpFilePathList = new ArrayList();

         for(int i = 0; i < dmpFileNameList.size(); ++i) {
            tardmpFilePathList.add(((String)dmpFileNameList.get(i)).substring(((String)dmpFileNameList.get(i)).lastIndexOf("/") + 1, ((String)dmpFileNameList.get(i)).length()));
         }

         new String();
         Map<String, String> tablenameHexStrMap = new HashMap();

         for(int i = 0; i < tablenameList.size(); ++i) {
            String maskTableName = (String)tablenameList.get(i);
            String tablenameHexStr = tableName2HexStr((String)tablenameList.get(i));
            tablenameHexStrMap.put(tablenameHexStr, maskTableName);
         }

         Map<String, List<String>> colTypeListMap = getTypeNameListByTableName(dmpFileNameList, tablenameList);
         String dataStartMark = "";

         try {
            String path = props.getProperty("dmp_exp_table_file_path");
            int dmpFileListIndex = 0;
            String dmpFileName = (String)dmpFileNameList.get(dmpFileListIndex);
            File f = new File(dmpFileName);
            int len = (int)f.length();
            byte[] btyebufArr = new byte[1024];
            byte[] impBtyeArr = new byte[2048];
            String nextDmpStartMark = "0";
            int impBtyebufArrIndex = 0;
            Map<Integer, byte[]> headDataMap = new HashMap();
            Integer headDataIndex = 0;
            byte[] headData = new byte[4096];

            for(int i = 0; i < dmpFileNameList.size(); ++i) {
               StreamFileReader fisHead = new StreamFileReader((String)dmpFileNameList.get(headDataIndex), 4096);
               fisHead.read();
               headData = fisHead.getArray();
               headDataMap.put(headDataIndex, headData);
               headDataIndex = headDataIndex + 1;
            }

            StreamFileReader fis = new StreamFileReader(dmpFileName, 1024);
            int curDmpFileByteLen = (int)f.length();
            int curDmpFileByteIndex = 0;
            new StringBuffer();
            new StringBuffer();
            boolean issys = false;
            int lineStartIndex = 0;
            String lastbuf16 = "";
            int i = 0;
            fis.read();
            btyebufArr = fis.getArray();
            int btyebufArrIndex = 0;
            String finishFlg = "0";
            String createTableStartMark = "0";
            String createTableEndMark = "0";
            new StringBuffer();
            String createTableStartFlg = "0";
            String isMatchTable = "0";
            String buf16Str6 = "";
            String findTableNameStr = "";
            String invalidDmpFlg = "0";
            String nextDmpStartMonitorData = "0";
            int colCnt = 0;
            int curLineColCnt = 0;
            int curLineReadedColCnt = 0;
            int tarFileSize = 0;
            byte[] byteCache = new byte[1024];
            int tarFileIndex = 0;
            String var75 = tarDmpPath + "/" + (String)tardmpFilePathList.get(tarFileIndex);
            if (tablenameList.size() == 0) {
               InputStream input = null;
               OutputStream output = null;

               for(int j = 0; j < dmpFileNameList.size(); ++j) {
                  input = new FileInputStream((String)dmpFileNameList.get(j));
                  output = new FileOutputStream(tarDmpPath + (String)tardmpFilePathList.get(j));
                  byte[] buf = new byte[1024];

                  int bytesRead;
                  while((bytesRead = input.read(buf)) > 0) {
                     output.write(buf, 0, bytesRead);
                  }
               }

               input.close();
               output.close();
               return;
            }

            FileOutputStream fileOutputStream = new FileOutputStream(var75);
            String curImpTableName = "";
            String curTableDataInsertFinishFlg = "0";
            List<String> colTypeList = null;

            while(i < len) {
               if (btyebufArrIndex >= 1024) {
                  fis.read();
                  btyebufArr = fis.getArray();
                  btyebufArrIndex = 0;
               }

               byte bufbyte = btyebufArr[btyebufArrIndex];
               String buf10 = toInt(bufbyte);
               String buf16 = toHex(bufbyte);
               if ("1".equals(nextDmpStartMark)) {
                  if ("3030303A3030".equals(buf16Str6) && "0".equals(nextDmpStartMonitorData)) {
                     nextDmpStartMonitorData = "1";
                  }

                  if ("1".equals(nextDmpStartMonitorData) && !buf16.equals("00") && lastbuf16.equals("00")) {
                     String nextbuf16 = DmpCommonTool.toHex(btyebufArr[btyebufArrIndex + 1]);
                     String next2buf16 = DmpCommonTool.toHex(btyebufArr[btyebufArrIndex + 2]);
                     String next3buf16 = DmpCommonTool.toHex(btyebufArr[btyebufArrIndex + 3]);
                     if ("4B".equals(buf16) && "47".equals(nextbuf16) && "43".equals(next2buf16) && "80".equals(next3buf16)) {
                        invalidDmpFlg = "1";
                     } else {
                        nextDmpStartMark = "0";
                     }
                  }
               }

               buf16Str6 = buf16Str6 + buf16;
               if (buf16Str6.length() > 12) {
                  buf16Str6 = buf16Str6.substring(2);
               }

               if ("3C524F575345".equals(buf16Str6) && "0".equals(createTableStartFlg) && "0".equals(createTableStartMark)) {
                  createTableStartFlg = "1";
               }

               if ("1".equals(createTableStartFlg) && "0".equals(createTableStartMark) && "3C4E414D453E".equals(buf16Str6)) {
                  createTableStartMark = "1";
               }

               if ("1".equals(createTableStartMark) && "0".equals(isMatchTable)) {
                  if (!"3C".equals(buf16)) {
                     findTableNameStr = findTableNameStr + buf16;
                  } else {
                     findTableNameStr = findTableNameStr.substring(2);
                     if (tablenameHexStrMap.containsKey(findTableNameStr)) {
                        isMatchTable = "1";
                        curImpTableName = (String)tablenameHexStrMap.get(findTableNameStr.toString());
                        colTypeList = (List)colTypeListMap.get(curImpTableName);
                        if (colTypeList.contains("LONG")) {
                           dataStartMark = "0C";
                        } else {
                           dataStartMark = "3C";
                        }
                     } else {
                        createTableStartFlg = "0";
                        createTableStartMark = "0";
                     }

                     findTableNameStr = "";
                  }
               }

               if (!"1".equals(isMatchTable)) {
                  impBtyeArr[impBtyebufArrIndex] = bufbyte;
                  ++impBtyebufArrIndex;
               } else {
                  if ("3C2F524F5753".equals(buf16Str6) && "0".equals(createTableEndMark)) {
                     createTableEndMark = "1";
                  }

                  if ("1".equals(createTableEndMark) && !issys && dataStartMark.equals(buf16)) {
                     issys = true;
                     createTableEndMark = "0";
                  }

                  if (!issys) {
                     impBtyeArr[impBtyebufArrIndex] = bufbyte;
                     ++impBtyebufArrIndex;
                  } else if ("0".equals(curTableDataInsertFinishFlg)) {
                     ArrayList<Integer> tableDataList = new ArrayList();
                     String tarDmpPipePath = props.getProperty("dmp_imp_table_file_path");
                     String tarPipePathStr = tarDmpPipePath + "/" + taskname + "/" + curImpTableName + ".pipe";
                     byte[] impBtyeArr2 = Arrays.copyOf(impBtyeArr, impBtyebufArrIndex);
                     fileOutputStream.write(impBtyeArr2);
                     tarFileSize += impBtyeArr2.length;
                     impBtyeArr = new byte[1024];
                     impBtyebufArrIndex = 0;

                     try {
                        InputStreamReader fr = new InputStreamReader(new FileInputStream(tarPipePathStr), "UTF-8");
                        BufferedReader bf = new BufferedReader(fr);

                        String lineStr;
                        for(int lineCnt = 0; (lineStr = bf.readLine()) != null; createTableStartMark = "0") {
                           ++lineCnt;
                           List<Integer> lineIntList = parsingDataByLine(colTypeList, lineStr);
                           tableDataList.addAll(lineIntList);
                           if (0 == lineCnt % 1024) {
                              byte[] impDataBtyeArr = new byte[tableDataList.size()];
                              int otherDataSize = 0;
                              if (len - tarFileSize < tableDataList.size()) {
                                 impDataBtyeArr = new byte[len - tarFileSize];
                                 otherDataSize = len - tarFileSize;
                              }

                              int i2 = 0;

                              for(int tIdx = 0; tIdx < tableDataList.size(); ++tIdx) {
                                 impDataBtyeArr[i2] = (byte)((Integer)tableDataList.get(tIdx) & 255);
                                 ++i2;
                                 ++tarFileSize;
                                 if (tarFileSize == len) {
                                    fileOutputStream.write(impDataBtyeArr);
                                    i2 = 0;
                                    dmpFileListIndex = tarFileIndex++;
                                    if (tarFileIndex == 1) {
                                       InputStream input = null;
                                       OutputStream output = null;
                                       input = new FileInputStream((String)dmpFileNameList.get(tarFileIndex));
                                       output = new FileOutputStream(tarDmpPath + "/" + (String)tardmpFilePathList.get(tarFileIndex));
                                       byte[] buf = new byte[1024];

                                       int bytesRead;
                                       while((bytesRead = input.read(buf)) > 0) {
                                          output.write(buf, 0, bytesRead);
                                       }

                                       input.close();
                                       output.close();
                                       dmpFileListIndex = tarFileIndex++;
                                    }

                                    fileOutputStream = new FileOutputStream(tarDmpPath + "/" + (String)tardmpFilePathList.get(tarFileIndex));
                                    tarFileSize = 0;
                                    fileOutputStream.write((byte[])headDataMap.get(tarFileIndex));
                                    tarFileSize += 4096;
                                    impDataBtyeArr = new byte[tableDataList.size() - otherDataSize];
                                    invalidDmpFlg = "1";
                                 }
                              }

                              fileOutputStream.write(impDataBtyeArr);
                              tableDataList = new ArrayList();
                              i2 = 0;
                           }

                           createTableStartFlg = "0";
                        }

                        tableDataList.add(0);
                        tableDataList.add(0);
                        byte[] impDataBtyeArr = new byte[tableDataList.size()];

                        for(int tIdx = 0; tIdx < tableDataList.size(); ++tIdx) {
                           impDataBtyeArr[tIdx] = (byte)((Integer)tableDataList.get(tIdx) & 255);
                        }

                        fileOutputStream.write(impDataBtyeArr);
                        tarFileSize += impDataBtyeArr.length;
                        bf.close();
                        fr.close();
                     } catch (IOException e) {
                        e.printStackTrace();
                     }

                     curTableDataInsertFinishFlg = "1";
                  } else if (buf16.equals("00") && lastbuf16.equals("00") && i > 4096) {
                     issys = false;
                     isMatchTable = "0";
                     curTableDataInsertFinishFlg = "0";
                  }
               }

               lastbuf16 = buf16;
               ++i;
               ++btyebufArrIndex;
               if (btyebufArrIndex >= 1024) {
                  byte[] impBtyeArr2 = Arrays.copyOf(impBtyeArr, impBtyebufArrIndex);
                  fileOutputStream.write(impBtyeArr2);
                  tarFileSize += impBtyeArr2.length;
                  impBtyeArr = new byte[1024];
                  int otherDataSize = 0;
                  if (len - tarFileSize < 1024) {
                     impBtyeArr = new byte[len - tarFileSize];
                     otherDataSize = len - tarFileSize;
                  }

                  if (tarFileSize == len) {
                     fileOutputStream.write(impBtyeArr);
                     dmpFileListIndex = tarFileIndex++;
                     if (tarFileIndex == dmpFileNameList.size()) {
                        break;
                     }

                     fileOutputStream = new FileOutputStream(tarDmpPath + (String)tardmpFilePathList.get(tarFileIndex));
                     tarFileSize = 0;
                     impBtyeArr = new byte[1024 - otherDataSize];
                     invalidDmpFlg = "1";
                  }

                  impBtyebufArrIndex = 0;
                  fis.read();
                  btyebufArr = fis.getArray();
                  btyebufArrIndex = 0;
               }

               if (i == len && "1".equals(invalidDmpFlg)) {
                  ++dmpFileListIndex;
                  if (dmpFileListIndex >= dmpFileNameList.size()) {
                     return;
                  }

                  dmpFileName = (String)dmpFileNameList.get(dmpFileListIndex);
                  f = new File(dmpFileName);
                  fis = new StreamFileReader(dmpFileName, 1024);
                  if (dmpFileNameList.size() - 1 == tarFileIndex) {
                     len = (int)f.length();
                  }

                  i = 0;
                  fis.read();
                  btyebufArr = fis.getArray();
                  btyebufArrIndex = 0;
                  fileOutputStream.flush();
                  nextDmpStartMark = "1";
                  invalidDmpFlg = "0";
                  nextDmpStartMonitorData = "0";
               }
            }

            Arrays.copyOf(impBtyeArr, impBtyebufArrIndex);
            fileOutputStream.flush();
            fileOutputStream.close();
         } catch (Exception e) {
            e.printStackTrace();
         }

      }
   }

   private static String tableName2HexStr(String tablename) {
      byte[] tablenameByteArr = tablename.getBytes();
      StringBuffer tableNameHexBuf = new StringBuffer();

      for(int i = 0; i < tablenameByteArr.length; ++i) {
         byte tablenameByte = tablenameByteArr[i];
         String tablenameHexStr = toHex(tablenameByte);
         tableNameHexBuf.append(tablenameHexStr);
      }

      return tableNameHexBuf.toString();
   }

   private static String toHex(byte b) {
      int i = b & 255;
      String s = "";
      if (null != Integer.toHexString(i)) {
         s = Integer.toHexString(i).toUpperCase();
         if (s.length() == 1) {
            s = '0' + s;
         }
      } else {
         System.out.println("btye is:" + b + ":toHex 方法：十进制数转换为十六进制字符串时返回了NULL!");
      }

      return s;
   }

   private static Map<String, List<String>> getTypeNameListByTableName(List<String> dmpFileNameList, List<String> tablenameList) {
      Map<String, List<String>> typeNameLstMap = new HashMap();
      if (null != tablenameList && tablenameList.size() != 0) {
         for(int i = 0; i < tablenameList.size(); ++i) {
            String tmpTableName = (String)tablenameList.get(i);
            if (StringUtils.isNotBlank(tmpTableName)) {
               typeNameLstMap.put(tmpTableName, null);
            }

            TableStructureInfo createTableStructureInfo = getTableStructureInfo(dmpFileNameList, tmpTableName);
            String tName = createTableStructureInfo.getTablename();
            if (tmpTableName.equalsIgnoreCase(tName)) {
               List<String> typeNameLst = new ArrayList();
               List<ColumnInfoVO> columnInfoList = createTableStructureInfo.getColInfoLst();

               for(int j = 0; j < columnInfoList.size(); ++j) {
                  typeNameLst.add(((ColumnInfoVO)columnInfoList.get(j)).getTypename());
               }

               typeNameLstMap.put(tName, typeNameLst);
            }
         }

         return typeNameLstMap;
      } else {
         return typeNameLstMap;
      }
   }

   private static TableStructureInfo getTableStructureInfo(List<String> dmpFilePathList, String tableName) {
      TableStructureInfo tableStructureInfo = null;
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();

      try {
         for(int i = 0; i < dmpFilePathList.size(); ++i) {
            String dmpFilePath = (String)dmpFilePathList.get(i);
            FileReader fr = new FileReader(dmpFilePath);
            DmpBufferedReader reader = new DmpBufferedReader(fr);
            String line = "";
            int createTableSqlLineCnt = 0;
            StringBuffer createTableSqlStrBuffer = new StringBuffer();

            while((line = reader.ReadLine()) != null) {
               line = new String(line.getBytes("ISO-8859-1"), "GBK");
               int rowsetIndex = line.indexOf("<ROWSET>");
               if (rowsetIndex >= 0) {
                  createTableSqlLineCnt = 3;
                  createTableSqlStrBuffer = new StringBuffer();
               }

               if (createTableSqlLineCnt > 0) {
                  createTableSqlStrBuffer.append(line);
                  if (1 == createTableSqlLineCnt) {
                     String createTableSqlStr = createTableSqlStrBuffer.toString();
                     int createTableSqlStrStartIndex = createTableSqlStr.indexOf("<ROWSET>");
                     int createTableSqlStrEndIndex = createTableSqlStr.indexOf("</ROWSET>") + "</ROWSET>".length();
                     createTableSqlStr = createTableSqlStr.substring(createTableSqlStrStartIndex, createTableSqlStrEndIndex);
                     int tableNameStartIndex = createTableSqlStr.indexOf("<NAME>") + 6;
                     int tableNameEndIndex = createTableSqlStr.indexOf("</NAME>");
                     String tableNameStr = createTableSqlStr.substring(tableNameStartIndex, tableNameEndIndex);
                     if (tableName.equals(tableNameStr)) {
                        tableStructureInfo = readStringXml(createTableSqlStr);
                        break;
                     }
                  }

                  --createTableSqlLineCnt;
               }
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return tableStructureInfo;
   }

   private static List<TableStructureInfo> createTableSql(String dmpFilePath) {
      List<TableStructureInfo> tableStructureList = new ArrayList();
      List<String> createTableSqlList = new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();
      new ArrayList();

      try {
         File file = new File(dmpFilePath);
         BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
         String sourceFileEncoding = "UTF-8";
         BufferedReader reader = new BufferedReader(new InputStreamReader(fis), 10000);
         String line = "";
         int lineNum = 0;
         int createTableSqlLineCnt = 0;
         StringBuffer createTableSqlStrBuffer = new StringBuffer();

         while((line = reader.readLine()) != null) {
            ++lineNum;
            line = new String(line.getBytes("ISO-8859-1"), "GBK");
            if (null != line) {
               int rowsetIndex = line.indexOf("<ROWSET>");
               if (rowsetIndex >= 0) {
                  createTableSqlLineCnt = 3;
                  createTableSqlStrBuffer = new StringBuffer();
               }

               if (createTableSqlLineCnt > 0) {
                  createTableSqlStrBuffer.append(line);
                  if (1 == createTableSqlLineCnt) {
                     String createTableSqlStr = createTableSqlStrBuffer.toString();
                     int createTableSqlStrStartIndex = createTableSqlStr.indexOf("<ROWSET>");
                     int createTableSqlStrEndIndex = createTableSqlStr.indexOf("</ROWSET>") + "</ROWSET>".length();
                     createTableSqlStr = createTableSqlStr.substring(createTableSqlStrStartIndex, createTableSqlStrEndIndex);
                     createTableSqlList.add(createTableSqlStr);
                  }

                  --createTableSqlLineCnt;
               }
            }
         }

         if (createTableSqlList.size() > 0) {
            createTableSqlList.remove(createTableSqlList.size() - 1);
         }

         for(int i = 0; i < createTableSqlList.size(); ++i) {
            String xmlStr = (String)createTableSqlList.get(i);
            TableStructureInfo tableStructureInfo = readStringXml(xmlStr);
            tableStructureList.add(tableStructureInfo);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return tableStructureList;
   }

   public static TableStructureInfo readStringXml(String xmlStr) {
      Document doc = null;
      TableStructureInfo tableStructureInfo = new TableStructureInfo();

      try {
         doc = DocumentHelper.parseText(xmlStr);
         Element root = doc.getRootElement();
         Element row = root.element("ROW");
         Element strmtable_t = row.element("STRMTABLE_T");
         Element ownernameElt = strmtable_t.element("OWNER_NAME");
         Element tablenameElt = strmtable_t.element("NAME");
         String tablename = tablenameElt.getText();
         Element col_list = strmtable_t.element("COL_LIST");
         List<Element> colList = col_list.elements("COL_LIST_ITEM");
         tableStructureInfo.setOwnername(ownernameElt.getText());
         tableStructureInfo.setTablename(tablename);
         List<ColumnInfoVO> columnInfoLst = new ArrayList();
         if (null != colList && colList.size() > 0) {
            for(int i = 0; i < colList.size(); ++i) {
               Element colItem = (Element)colList.get(i);
               String columnname = colItem.element("NAME").getText();
               String not_null = colItem.element("NOT_NULL").getText();
               String type_num = colItem.element("TYPE_NUM").getText();
               String length = colItem.element("LENGTH").getText();
               String charlength = colItem.element("CHARLENGTH").getText();
               String scale = "";
               String typename = "";
               if ("1".equals(type_num)) {
                  if (length.equals(charlength)) {
                     typename = "VARCHAR2";
                  } else {
                     typename = "NVARCHAR2";
                  }
               } else if ("96".equals(type_num)) {
                  if (length.equals(charlength)) {
                     typename = "CHAR";
                  } else {
                     typename = "NCHAR";
                  }
               } else if ("2".equals(type_num)) {
                  typename = "NUMBER";
               } else if ("12".equals(type_num)) {
                  typename = "DATE";
               } else if ("180".equals(type_num)) {
                  typename = "TIMESTAMP";
               } else if ("8".equals(type_num)) {
                  typename = "LONG";
               }

               if (!"NUMBER".equals(typename) && !"TIMESTAMP".equals(typename)) {
                  if ("NVARCHAR2".equals(typename) || "NCHAR".equals(typename)) {
                     length = charlength;
                  }
               } else {
                  if (null != colItem.element("SCALE")) {
                     scale = colItem.element("SCALE").getText();
                  }

                  if (null != colItem.element("PRECISION_NUM")) {
                     length = colItem.element("PRECISION_NUM").getText();
                  } else {
                     length = "38";
                  }
               }

               ColumnInfoVO columnInfo = new ColumnInfoVO();
               columnInfo.setTablename(tablename);
               columnInfo.setColumnname(columnname);
               columnInfo.setTypename(typename);
               columnInfo.setColumnsize(length == null ? "" : length);
               columnInfo.setDecimaldigits(scale == null ? "" : scale);
               columnInfo.setMaskingruleid("");
               columnInfo.setMaskingrulename("");
               columnInfo.setRegextype("");
               columnInfo.setTargettypename("");
               columnInfo.setRemarks("");
               columnInfoLst.add(columnInfo);
            }
         }

         tableStructureInfo.setColInfoLst(columnInfoLst);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return tableStructureInfo;
   }

   private static String toInt(byte b) {
      int i = b & 255;
      String s = "";
      s = s + i;
      return s;
   }

   public static void main(String[] args) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String dmppath = props.getProperty("dmp_file_path");
      List<String> dmpFileNameList = new ArrayList();

      for(int i = 0; i < 3; ++i) {
         String numStr = String.format("%02d", i + 1);
         String dmpFilePath = "TESTDP_" + numStr + ".DMP";
         dmpFileNameList.add(dmppath + dmpFilePath);
      }

      List<String> tablenameList = new ArrayList();
      tablenameList.add("IP_INVPTY101");
      tablenameList.add("IP_INVPTY102");
      tablenameList.add("IP_INVPTY103");
      tablenameList.add("IP_INVPTY104");
      String tarPipePath = props.getProperty("dmp_exp_table_file_path");
      prasingDataByTableName(dmpFileNameList, "191016140654_dmp2dmptest3", tablenameList, tarPipePath);
   }

   public static void test(String str) {
      String[] strArr = str.split(",");
      List<Integer> intColList = new ArrayList();

      for(int i = 0; i < strArr.length; ++i) {
         int int10 = binary16_10(strArr[i]);
         intColList.add(int10);
      }

      String reStr = stringToGbk(intColList);
      System.out.println("reStr:" + reStr);
   }

   private static String stringToGbk(List<Integer> intColLst) {
      String result = "";

      try {
         byte[] byteArr = new byte[intColLst.size()];

         for(int i = 0; i < intColLst.size(); ++i) {
            byteArr[i] = (byte)((Integer)intColLst.get(i) & 255);
         }

         result = new String(byteArr, "gbk");
      } catch (UnsupportedEncodingException e) {
         e.printStackTrace();
      }

      return result;
   }
}
