package com.chenyang.nse.bussiness.tools.encryption;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class EncUtils {
   public static String strColumnSize(String Dbtype, String columnType, String columnSize, String isLike, String primaryKeyFlag, String encType) {
      if (columnSize != null && columnSize.length() > 0) {
         try {
            int size = Integer.parseInt(columnSize);
            return getEncodeLen(encType, size, isLike) + "";
         } catch (Exception var7) {
            return defColumnSize(Dbtype, columnType, columnSize, isLike, primaryKeyFlag);
         }
      } else {
         return defColumnSize(Dbtype, columnType, columnSize, isLike, primaryKeyFlag);
      }
   }

   public static String defColumnSize(String Dbtype, String columnType, String columnSize, String isLike, String primaryKeyFlag) {
      if (!"VARCHAR2".equalsIgnoreCase(columnType) && !"varchar".equalsIgnoreCase(columnType) && !"varcharbyte".equalsIgnoreCase(columnType)) {
         if ("char".equalsIgnoreCase(columnType)) {
            if (EdbType.ORACLE.toString().equals(Dbtype)) {
               columnSize = "2000";
            } else {
               columnSize = "255";
            }
         }
      } else if (StringUtils.isNotBlank(columnSize)) {
         if ("1".equals(isLike)) {
            if (Integer.parseInt(columnSize) < 155) {
               columnSize = String.valueOf(Integer.parseInt(columnSize) * 33);
            } else {
               columnSize = "5115";
            }
         } else if (Integer.parseInt(columnSize) < 155) {
            columnSize = String.valueOf(Integer.parseInt(columnSize) * 33);
         } else {
            columnSize = "5000";
         }
      }

      if (null != columnType && columnType.toLowerCase().contains("text")) {
         columnSize = "";
      }

      if ((EdbType.MYSQL.toString().equals(Dbtype) || EdbType.OCEANBASE.toString().equals(Dbtype) || EdbType.MARIADB.toString().equals(Dbtype)) && StringUtils.isNotBlank(columnSize) && Integer.parseInt(columnSize) > 1000 && "1".equals(primaryKeyFlag)) {
         columnSize = "1000";
      }

      return columnSize;
   }

   static int getEncodeLen(String encType, int srcSize, String isLike) throws Exception {
      if (srcSize <= 0) {
         throw new IllegalArgumentException("srcSize");
      } else {
         String key = EncProvider.generateKey(encType);
         StringBuilder proto = new StringBuilder();

         for(int i = 0; i < srcSize; ++i) {
            proto.append("张");
         }

         String enc = EncProvider.encryptEcb(encType, key, proto.toString(), isLike, (String)null, (String)null, (String)null);
         int max = -1;

         try {
            Properties properties = PropertiesLoaderUtils.loadAllProperties("config.properties");
            String property = properties.getProperty("encryption.field.max");
            if (property != null && property.length() > 0) {
               max = Integer.valueOf(property.trim());
            }
         } catch (Exception e) {
            e.printStackTrace();
         }

         int calcLen = enc.getBytes().length;
         if (max != -1) {
            return calcLen > max ? max : calcLen;
         } else {
            return calcLen;
         }
      }
   }

   public static Boolean compareStringEq(String value1, String value2) {
      if (value1 == null) {
         return value2 == null ? true : false;
      } else if (value2 == null) {
         return false;
      } else {
         value1 = value1.trim();
         value2 = value2.trim();
         return value1.equals(value2);
      }
   }

   public static void main(String[] args) throws Exception {
      String key = EncProvider.generateKey("SM4");
      byte[] proto = new byte[30];
      proto[0] = 97;
      proto[29] = 98;
      String enc = EncProvider.encryptEcb("SM4", key, new String("ababababababababababababababab"), "0", (String)null, (String)null, (String)null);
      System.out.println(enc.getBytes().length);
      System.out.println(getEncodeLen("SM4", 30, "0"));
   }
}
