package com.chenyang.nse.bussiness.tools.licensekey;

import com.esotericsoftware.minlog.Log;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import org.apache.commons.collections.map.HashedMap;

public class LicenseKeyTool {
   public static Map<String, String> map = new HashedMap();

   public static ResultVO verifyproperties(TBaseUser tBaseUser) throws ClassNotFoundException, IOException, SQLException, ParseException {
      ResultVO resultVO = new ResultVO();
      new HashMap();
      resultVO.setResult(true);
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String isNeedLicenseKey = props.getProperty("isNeedLicenseKey");
      if ("1".equals(isNeedLicenseKey)) {
         String url = props.getProperty("licensedir");
         File file = new File(url + "/gtconfig.dat");
         if (file.exists()) {
            FileReader fileReader = new FileReader(file);
            BufferedReader bfReader = new BufferedReader(fileReader);
            StringBuffer stringBuffer = new StringBuffer();

            String line;
            while((line = bfReader.readLine()) != null) {
               stringBuffer.append(line);
            }

            fileReader.close();
            bfReader.close();
            resultVO = checkKey(stringBuffer.toString());
         } else {
            resultVO.setResult(false);
            resultVO.setMessage("缺少LICENCE KEY文件");
            resultVO.setResponse(RespHelper.createResp(false, "LGS_ERR_001", MesUtil.getMsg("LGS_ERR_001", new String[0])));
            map.put("flag", "0");
            map.put("msg", MesUtil.getMsg("LGS_ERR_001", new String[0]));
         }
      }

      return resultVO;
   }

   private static ResultVO checkKey(String licensekey) throws ParseException, SocketException {
      ResultVO resultVO = new ResultVO();
      if (licensekey != null && !licensekey.equals("")) {
         String password = "ghca";
         String licensekeyAfter = AesTool.decrypt(licensekey, password);
         if (licensekeyAfter == null) {
            resultVO.setMessage("密钥不正确");
            resultVO.setResult(false);
            resultVO.setResponse(RespHelper.createResp(false, "LGS_ERR_004", MesUtil.getMsg("LGS_ERR_004", new String[0])));
            map.put("flag", "0");
            map.put("msg", MesUtil.getMsg("LGS_ERR_004", new String[0]));
            return resultVO;
         } else {
            String[] licensekeyMessage = licensekeyAfter.split(",");
            String licname = licensekeyMessage[0];
            String licUUid = licensekeyMessage[1];
            String licInfoMac = licensekeyMessage[2];
            String startDatelicensekey = licensekeyMessage[3];
            String endDatelicensekey = licensekeyMessage[4];
            String projectNum = licensekeyMessage[5];
            map.put("licname", licname);
            map.put("licInfoIp", licUUid);
            map.put("licInfoMac", licInfoMac);
            map.put("startDatelicensekey", startDatelicensekey);
            map.put("endDatelicensekey", endDatelicensekey);
            map.put("projectNum", projectNum);
            Log.info("校验的证书是不是失效--UUID");
            List<String> linuxLocalUUID = getLinuxLocalUUID();
            String mac = getLocalMacLiunx();
            boolean b = false;
            Log.info("校验的证书是不是失效--linuxLocalUUID" + linuxLocalUUID);
            boolean matchMac = Arrays.stream(mac.split(",")).anyMatch(licInfoMac::equalsIgnoreCase);
            boolean matchIp = linuxLocalUUID.stream().anyMatch(licUUid::equalsIgnoreCase);
            b = matchMac && matchIp;
            if (!b) {
               resultVO.setMessage("uuid有误");
               resultVO.setResult(false);
               resultVO.setResponse(RespHelper.createResp(false, "LGS_ERR_002", MesUtil.getMsg("LGS_ERR_002", new String[0])));
               map.put("flag", "0");
               map.put("msg", MesUtil.getMsg("LGS_ERR_002", new String[0]));
               return resultVO;
            } else {
               SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
               Date date = new Date();
               Date startDate = sdf.parse(startDatelicensekey);
               Date endDate = sdf.parse(endDatelicensekey);
               int dayMis = 86400000;
               long startDateMis = startDate.getTime();
               long endDateMis = endDate.getTime() + (long)dayMis - 1L;
               long curDateMis = date.getTime();
               if (startDateMis <= curDateMis && curDateMis <= endDateMis) {
                  resultVO.setMessage("在有效期间");
                  resultVO.setResult(true);
                  map.put("flag", "1");
                  map.put("msg", MesUtil.getMsg("LGS_001", new String[0]));
                  return resultVO;
               } else {
                  resultVO.setMessage("您的用户秘钥已过期");
                  resultVO.setResult(false);
                  resultVO.setResponse(RespHelper.createResp(false, "LGS_ERR_003", MesUtil.getMsg("LGS_ERR_003", new String[0])));
                  map.put("flag", "0");
                  map.put("msg", MesUtil.getMsg("LGS_ERR_003", new String[0]));
                  return resultVO;
               }
            }
         }
      } else {
         resultVO.setMessage("密钥为空");
         resultVO.setResult(false);
         resultVO.setResponse(RespHelper.createResp(false, "LGS_ERR_004", MesUtil.getMsg("LGS_ERR_004", new String[0])));
         map.put("flag", "0");
         map.put("msg", MesUtil.getMsg("LGS_ERR_001", new String[0]));
         return resultVO;
      }
   }

   /**
    * 获取本机器的ip地址
    * @return list
    */
   public static List<String> getLinuxLocalUUID() {
      List<String> resultList = new ArrayList<>();
      String os = System.getProperty("os.name").toLowerCase();
      System.out.println("os.name:" + os);
      if (os.contains("mac")) {
         // macOS 获取本地IP
         try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
               NetworkInterface ni = interfaces.nextElement();
               if (!ni.getName().contains("lo") && !ni.getName().contains("docker")) {
                  Enumeration<InetAddress> addresses = ni.getInetAddresses();
                  while (addresses.hasMoreElements()) {
                     InetAddress addr = addresses.nextElement();
                     if (!addr.isLoopbackAddress() && addr instanceof java.net.Inet4Address) {
                        resultList.add(addr.getHostAddress());
                     }
                  }
               }
            }
         } catch (SocketException e) {
            Log.info("获取mac本地IP失败: " + e.getMessage());
         }
      } else {
         // Linux 获取UUID
         String device = "";
         try {
            Process process = Runtime.getRuntime().exec("blkid " + device);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line;
            while ((line = reader.readLine()) != null) {
               String[] ac = line.split(" ");
               if (ac.length > 1) {
                  String uuid = ac[1];
                  String[] uuids = uuid.split("\"");
                  if (uuids.length > 1) {
                     String uuidr = uuids[1];
                     resultList.add(uuidr);
                  }
               }
            }
            reader.close();
         } catch (IOException e) {
            Log.info("Linux获取ip" + e.getMessage());
         }
      }
      return resultList;
   }

   /**
    * 获取本机MAC地址
    * @return list
    * @throws SocketException
    */
   public static String getLocalMacLiunx() throws SocketException {
      String mac = "";
      Set<String> macSet = new HashSet<>();
      try {
         Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
         while (networks.hasMoreElements()) {
            NetworkInterface network = networks.nextElement();
            if (!network.isLoopback() && network.getHardwareAddress() != null) {
               byte[] macBytes = network.getHardwareAddress();
               StringBuilder sb = new StringBuilder();
               for (int i = 0; i < macBytes.length; i++) {
                  sb.append(String.format("%02x", macBytes[i]));
                  if (i < macBytes.length - 1) {
                     sb.append(":");
                  }
               }
               System.out.println("["+sb.toString()+"]");
               macSet.add(sb.toString());
            }
         }
      } catch (SocketException e) {
         System.out.println("获取MAC地址失败: " + e.getMessage());
      }
      mac = String.join(",", macSet);
      System.out.println("本机MAC地址为:\n" + mac);
      return mac;
   }
//   public static String getLocalMacLiunx() throws SocketException {
//      String mac = "";
//
//      try {
//         Process p = (new ProcessBuilder(new String[]{"ifconfig"})).start();
//         BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
//
//         String line;
//         while((line = br.readLine()) != null) {
//            Pattern pat = Pattern.compile("\\b\\w+:\\w+:\\w+:\\w+:\\w+:\\w+\\b");
//            Matcher mat = pat.matcher(line);
//            if (mat.find()) {
//               mac = mat.group(0);
//            }
//         }
//
//         br.close();
//      } catch (IOException var6) {
//      }
//
//      System.out.println("本机MAC地址为:\n" + mac);
//      return mac;
//   }

   public static void main(String[] args) {
//      String content = "有效期1个月,10.10.200.24,fe:fc:fe:21:01:2d,2024-12-11,2025-01-11,5";
      String content = "有效期12个月,172.19.1.167,bc:d0:74:a5:4d:b7,2024-12-11,2025-12-11,100";
      String password = "ghca";
      System.out.println("加密之前：" + content);
      String encrypt = AesTool.encrypt(content, password);
      System.out.println("加密后的内容：" + encrypt);
      String decrypt = AesTool.decrypt(encrypt, password);
      System.out.println("解密后的内容：" + new String(decrypt));

//      List<String> linuxLocalUUID = getLinuxLocalUUID();
//        System.out.println(linuxLocalUUID);
//       try {
//           String localMacLiunx = getLocalMacLiunx();
//           System.out.println(localMacLiunx);
//       } catch (SocketException e) {
//           throw new RuntimeException(e);
//       }
   }
}
