package com.chenyang.nse.bussiness.tools.logger.auditlog;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.graylog2.syslog4j.server.SyslogServer;
import org.graylog2.syslog4j.server.SyslogServerConfigIF;
import org.graylog2.syslog4j.server.SyslogServerEventIF;
import org.graylog2.syslog4j.server.SyslogServerIF;
import org.graylog2.syslog4j.server.SyslogServerSessionEventHandlerIF;
import org.graylog2.syslog4j.server.impl.net.udp.UDPNetSyslogServerConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class AuditLogService {
   protected static ApplicationContext applicationContext;
   private static Properties props = new Properties();
   private static String filepath = "";
   private static String appAlertInterface = "";
   private static String HOST = "192.168.2.232";
   private static Integer PORT = 32376;
   private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
   private static FileOutputStream outputStream = null;

   private void receiveSyslogMessage() {
      SyslogServerIF server = SyslogServer.getInstance("udp");
      UDPNetSyslogServerConfig udpConfig = (UDPNetSyslogServerConfig)server.getConfig();
      udpConfig.setMaxMessageSize(10240);
      SyslogServerConfigIF config = server.getConfig();
      config.setHost(HOST);
      config.setPort(PORT);
      config.addEventHandler(new SyslogServerSessionEventHandlerIF() {
         private String syslog;

         public Object sessionOpened(SyslogServerIF syslogServerIf, SocketAddress socketAddress) {
            return null;
         }

         public void event(Object o, SyslogServerIF syslogServerIf, SocketAddress socketAddress, SyslogServerEventIF syslogServerEventIf) {
            String sendvalue = "{\"from\": \"" + socketAddress.toString().replace("/", "").split("\\:")[0] + "\",\"hostname\":\"" + syslogServerEventIf.getHost() + "\",\"oTime\":\"" + new Date() + "\"," + syslogServerEventIf.getMessage().replace(syslogServerEventIf.getHost(), "\"message\":") + "}\n";
            File file = new File(AuditLogService.filepath + File.separator + "syslog4audit" + File.separator + AuditLogService.SIMPLE_DATE_FORMAT.format(new Date()) + ".txt");
            this.setSyslog(sendvalue);

            try {
               System.out.println(this.getSyslog());
            } catch (UnsupportedEncodingException var21) {
               System.err.println("UnsupportedEncodingException");
            }

            if (!file.exists()) {
               try {
                  file.getParentFile().mkdirs();
                  file.createNewFile();
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }

            try {
               AuditLogService.outputStream = new FileOutputStream(file, true);
               AuditLogService.outputStream.write(sendvalue.getBytes());
            } catch (Exception e) {
               e.printStackTrace();
            } finally {
               try {
                  AuditLogService.outputStream.close();
               } catch (IOException e) {
                  e.printStackTrace();
               }

            }

         }

         public String getSyslog() throws UnsupportedEncodingException {
            return new String(this.syslog.getBytes(), StandardCharsets.UTF_8);
         }

         public void setSyslog(String syslog) {
            this.syslog = syslog;
         }

         public void exception(Object o, SyslogServerIF syslogServerIf, SocketAddress socketAddress, Exception e) {
         }

         public void sessionClosed(Object o, SyslogServerIF syslogServerIf, SocketAddress socketAddress, boolean b) {
         }

         public void initialize(SyslogServerIF syslogServerIf) {
         }

         public void destroy(SyslogServerIF syslogServerIf) {
         }
      });
      SyslogServer.getThreadedInstance("udp");
   }

   public static void main(String[] args) throws InterruptedException {
      (new AuditLogService()).receiveSyslogMessage();
   }

   public static void execute() throws InterruptedException {
      (new AuditLogService()).receiveSyslogMessage();
   }

   static {
      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         filepath = props.getProperty("syslog4auditserverlogpath");
         appAlertInterface = props.getProperty("app_alert_interface");
         HOST = props.getProperty("s4aServerHost");
         PORT = Integer.parseInt(props.getProperty("s4aServerPost"));
      } catch (IOException e) {
         e.printStackTrace();
      }

   }
}
