package com.chenyang.nse.bussiness.tools.net;

import java.net.SocketAddress;
import org.graylog2.syslog4j.server.SyslogServer;
import org.graylog2.syslog4j.server.SyslogServerConfigIF;
import org.graylog2.syslog4j.server.SyslogServerEventIF;
import org.graylog2.syslog4j.server.SyslogServerIF;
import org.graylog2.syslog4j.server.SyslogServerSessionEventHandlerIF;
import org.springframework.boot.ApplicationArguments;

public class MySyslogServer {
   private static final int PORT = 32376;

   public static void startSyslogServer() throws InterruptedException {
      SyslogServerIF server = SyslogServer.getInstance("udp");
      SyslogServerConfigIF config = server.getConfig();
      config.setPort(32376);
      config.addEventHandler(new SyslogServerSessionEventHandlerIF() {
         public Object sessionOpened(SyslogServerIF syslogServerIF, SocketAddress socketAddress) {
            System.out.println("sessionOpened");
            return null;
         }

         public void event(Object o, SyslogServerIF syslogServerIF, SocketAddress socketAddress, SyslogServerEventIF syslogServerEventIF) {
            System.out.println("receive from:" + socketAddress + "\tmessage" + syslogServerEventIF.getMessage());
         }

         public void exception(Object o, SyslogServerIF syslogServerIF, SocketAddress socketAddress, Exception e) {
            System.out.println("exception");
         }

         public void sessionClosed(Object o, SyslogServerIF syslogServerIF, SocketAddress socketAddress, boolean b) {
            System.out.println("sessionClosed");
         }

         public void initialize(SyslogServerIF syslogServerIF) {
            System.out.println("initialize");
         }

         public void destroy(SyslogServerIF syslogServerIF) {
            System.out.println("destroy");
         }
      });
      SyslogServer.getThreadedInstance("udp");
   }

   public static void main(String[] args) throws InterruptedException {
      startSyslogServer();
   }

   public void run(ApplicationArguments args) throws Exception {
      System.out.println("启动审计日志服务器start");
      startSyslogServer();
      System.out.println("启动审计日志服务器end");
   }
}
