package com.chenyang.nse.bussiness.tools.quartz;

import com.chenyang.nse.bussiness.job.TaskScheduleModel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class CronUtils {
   private static final SimpleDateFormat sdf = new SimpleDateFormat("ss mm HH dd MM ?");

   public static String formatDateByPattern(Date date) {
      String formatTimeStr = null;
      if (Objects.nonNull(date)) {
         formatTimeStr = sdf.format(date);
      }

      return formatTimeStr;
   }

   public static String getCron(Date date) {
      return formatDateByPattern(date);
   }

   public static String createCronExpression(TaskScheduleModel taskScheduleModel) {
      StringBuffer cronExp = new StringBuffer("");
      if (null == taskScheduleModel.getJobType()) {
         System.out.println("执行周期未配置");
      }

      if (null != taskScheduleModel.getSecond() && null != taskScheduleModel.getMinute() && null != taskScheduleModel.getHour()) {
         cronExp.append(taskScheduleModel.getSecond()).append(" ");
         cronExp.append(taskScheduleModel.getMinute()).append(" ");
         cronExp.append(taskScheduleModel.getHour()).append(" ");
         if (taskScheduleModel.getJobType() == 1) {
            cronExp.append("* ");
            cronExp.append("* ");
            cronExp.append("?");
         } else if (taskScheduleModel.getJobType() == 3) {
            cronExp.append("? ");
            cronExp.append("* ");
            Integer[] weeks = taskScheduleModel.getDayOfWeeks();

            for(int i = 0; i < weeks.length; ++i) {
               if (i == 0) {
                  cronExp.append(weeks[i]);
               } else {
                  cronExp.append(",").append(weeks[i]);
               }
            }
         } else if (taskScheduleModel.getJobType() == 2) {
            Integer[] days = taskScheduleModel.getDayOfMonths();

            for(int i = 0; i < days.length; ++i) {
               if (i == 0) {
                  cronExp.append(days[i]);
               } else {
                  cronExp.append(",").append(days[i]);
               }
            }

            cronExp.append(" * ");
            cronExp.append("?");
         }
      } else {
         System.out.println("时或分或秒参数未配置");
      }

      return cronExp.toString();
   }

   public static String createDescription(TaskScheduleModel taskScheduleModel) {
      StringBuffer description = new StringBuffer("");
      if (null != taskScheduleModel.getSecond() && null != taskScheduleModel.getMinute() && null != taskScheduleModel.getHour()) {
         if (taskScheduleModel.getJobType() == 1) {
            description.append("每天");
            description.append(taskScheduleModel.getHour()).append("时");
            description.append(taskScheduleModel.getMinute()).append("分");
            description.append(taskScheduleModel.getSecond()).append("秒");
            description.append("执行");
         } else if (taskScheduleModel.getJobType() == 3) {
            if (taskScheduleModel.getDayOfWeeks() != null && taskScheduleModel.getDayOfWeeks().length > 0) {
               String days = "";
               Integer[] var3 = taskScheduleModel.getDayOfWeeks();
               int var4 = var3.length;

               for(int var5 = 0; var5 < var4; ++var5) {
                  int i = var3[var5];
                  days = days + "周" + i;
               }

               description.append("每周的").append(days).append(" ");
            }

            if (null != taskScheduleModel.getSecond() && null != taskScheduleModel.getMinute() && null != taskScheduleModel.getHour()) {
               description.append(",");
               description.append(taskScheduleModel.getHour()).append("时");
               description.append(taskScheduleModel.getMinute()).append("分");
               description.append(taskScheduleModel.getSecond()).append("秒");
            }

            description.append("执行");
         } else if (taskScheduleModel.getJobType() == 2) {
            if (taskScheduleModel.getDayOfMonths() != null && taskScheduleModel.getDayOfMonths().length > 0) {
               String days = "";
               Integer[] var8 = taskScheduleModel.getDayOfMonths();
               int var9 = var8.length;

               for(int var10 = 0; var10 < var9; ++var10) {
                  int i = var8[var10];
                  days = days + i + "号";
               }

               description.append("每月的").append(days).append(" ");
            }

            description.append(taskScheduleModel.getHour()).append("时");
            description.append(taskScheduleModel.getMinute()).append("分");
            description.append(taskScheduleModel.getSecond()).append("秒");
            description.append("执行");
         }
      }

      return description.toString();
   }
}
